/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.files.request;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.files.BFS;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UploadBlobFile
extends Request {
    private RandomAccessFile file = null;
    private String blobPath;
    private long fileSize;

    public UploadBlobFile(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
        this.setChunkedInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TableDescriptor table = TableDescriptor.get(this.getNodeID());
        int fieldId = 0;
        byte[] digest = null;
        this.fileSize = 0L;
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.fileSize = in.getLong();
                    break;
                }
                case 3: {
                    digest = in.getRaw();
                    break;
                }
                case 4: {
                    fieldId = in.getInt();
                }
            }
        }
        FieldDescriptor field = table.getExistingFieldDescriptor(fieldId);
        BFS.checkBlobFSField(table, field);
        this.blobPath = field.getBlobFS() + ":/" + BFS.getFullTempPath(table, field, digest);
        File fixedFile = new File(Core.blobfs.resolvePath(this.blobPath + ".blob"));
        if (fixedFile.exists()) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0443\u0436\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430");
        }
        File filePath = new File(Core.blobfs.resolvePath(this.blobPath));
        this.file = new RandomAccessFile(filePath, "rw");
        try {
            this.file.setLength(this.fileSize);
            this.processChunkedInput();
        }
        finally {
            this.file.close();
        }
    }

    private void getLog(StringBuilder msg) throws IOException {
        msg.append("\u0444\u0430\u0439\u043b ").append(this.blobPath).append(" \u0440\u0430\u0437\u043c\u0435\u0440 ").append(this.fileSize).append(" \u0442\u0435\u043a\u0443\u0449\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f ").append(this.file.getFilePointer());
    }

    @Override
    protected void processInputChunk(byte[] chunk) throws Throwable {
        TaggedReader in = new TaggedReader(chunk);
        long offset = 0L;
        this.file.seek(offset);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 7: {
                    offset = in.getLong();
                    this.file.seek(offset);
                    if (this.file.getFilePointer() != offset) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f ").append(offset);
                        this.getLog(msg);
                        throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430").detail(msg.toString());
                    }
                    byte[] fileChunk = in.getRaw(6);
                    if (offset + (long)fileChunk.length > this.fileSize) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0444\u0430\u0439\u043b\u0430 \u0441 ").append(offset).append(" \u043f\u043e ").append(offset + (long)fileChunk.length);
                        this.getLog(msg);
                        throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430").detail(msg.toString());
                    }
                    this.file.write(fileChunk);
                }
            }
        }
    }
}

