/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleDoubleMap;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.AbstractStatement;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.FetchHint;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlBatchParamList;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.NodeRecordChanges;
import inform.agent.mtd.NodeRecordIntf;
import inform.agent.mtd.SearchMetatreeNodeData;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.mtd.request.GetNodeContent;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.SSDataHost;
import inform.common.Base64BinString;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

public class MetadataNodeReader {
    public static final String MTD_TREE = "MTD_TREE";
    public static final String MTD_TREE_LOG = "MTD_TREE_LOG";
    public static final String MTD_CONF_NODES = "MTD_CONF_NODES";
    public static final String MTD_CONF = "MTD_CONF";
    public static final String MTD_AGENTS = "MTD_AGENTS";
    public static final String MTD_LOCKS = "MTD_LOCKS";
    public static final String MTD_TICKETS = "MTD_TICKETS";
    public static final String MTD_PERSISTENT_SESSIONS = "MTD_PERSISTENT_SESSIONS";
    private static final String pfxMtd = Ini.MetabaseScheme.isEmpty() ? "" : Ini.MetabaseScheme + ".";
    private static final String pfxMtdLog = Ini.MetabaseLogScheme.isEmpty() ? pfxMtd : Ini.MetabaseLogScheme + ".";
    public static final String mtdTreeTableName = pfxMtd + "MTD_TREE";
    public static final String mtdTreeLogTableName = pfxMtdLog + "MTD_TREE_LOG";
    public static final String mtdConfNodesTableName = pfxMtd + "MTD_CONF_NODES";
    public static final String mtdConfTableName = pfxMtd + "MTD_CONF";
    public static final String mtdAgentsTableName = pfxMtd + "MTD_AGENTS";
    public static final String mtdLocksTableName = pfxMtd + "MTD_LOCKS";
    public static final String mtdTicketsTableName = pfxMtd + "MTD_TICKETS";
    public static final String mtdPersistentSessionsTableName = pfxMtd + "MTD_PERSISTENT_SESSIONS";
    public static final String fieldId = "ID";
    public static final String fieldParentId = "PARENT_ID";
    public static final String fieldNodeType = "NODE_TYPE";
    public static final String fieldNodeName = "NODE_NAME";
    public static final String fieldIdentName = "IDENT_NAME";
    public static final String fieldNodeDescription = "NODE_DESCRIPTION";
    public static final String fieldOwnerId = "OWNER_ID";
    public static final String fieldOrderNo = "ORDER_NO";
    public static final String fieldCreationTime = "CREATION_TIME";
    public static final String fieldModificationAttributeTime = "MOD_ATTRS_TIME";
    public static final String fieldModificationContentTime = "MOD_CONTENT_TIME";
    public static final String fieldModificationUserId = "MOD_USER_ID";
    public static final String fieldUserId = "USER_ID";
    public static final String fieldAttributesB64 = "ATTRS_B64";
    public static final String fieldApplicationTime = "APP_TIME";
    public static final String fieldApplicationId = "APP_ID";
    public static final String fieldSessionId = "SESSION_ID";
    public static final String fieldRawContent = "RAW_CONTENT";
    public static final String fieldDslContent = "DSL_CONTENT";
    public static final String fieldNodeId = "NODE_ID";
    public static final String fieldOpTime = "OP_TIME";
    public static final String fieldOpCode = "OP_CODE";
    public static final String fieldContentAttrB64 = "CNT_ATTR_B64";
    public static final String fieldReplId = "REPL_ID";
    public static final String fieldReplNodeId = "REPL_NODE_ID";
    private static final String historyFieldId = "ID";
    private static final String historyAliasId = "HISTORY_ID";
    private static final String historyFieldOpCode = "OP_CODE";
    private static final String historyFieldOpTime = "OP_TIME";
    private static final String historyFieldNodeId = "NODE_ID";
    private static final String historyFieldEntryComment = "ENTRY_COMMENT";
    public static final String confFieldId = "ID";
    public static final String confFieldUserId = "CONF_USER";
    public static final String confFieldName = "CONF_NAME";
    public static final String confFieldNodeId = "NODE_ID";
    public static final String confFieldType = "CONF_TYPE";
    public static final String confFieldContent = "CONF_CONTENT";
    public static final String agentFieldID = "ID";
    public static final String agentFieldServerID = "SERVER_ID";
    public static final String agentFieldAgentID = "AGENT_ID";
    public static final String agentFieldAgentName = "AGENT_NAME";
    public static final String agentFieldHostName = "HOST_NAME";
    public static final String agentFieldAgentPID = "PID";
    public static final String agentFieldWorkerID = "WORKER_ID";
    public static final String agentFieldAgentVersion = "AGENT_VERSION";
    public static final String agentFieldConnected = "CONNECTED";
    public static final String agentFieldActivity = "ACTIVITY";
    public static final String ticketFieldID = "ID";
    public static final String ticketFieldIPAddress = "IP_ADDRESS";
    public static final String ticketFieldOpCode = "OP_CODE";
    public static final String ticketFieldNodeID = "NODE_ID";
    public static final String ticketFieldUserID = "USER_ID";
    public static final String ticketFieldSessionID = "SESSION_ID";
    public static final String ticketFieldCreationTime = "CREATION_TIME";
    public static final String ticketFieldKey = "KEY";
    public static final String lockFieldID = "ID";
    public static final String lockFieldAppID = "APP_ID";
    public static final String lockFieldLockType = "LOCK_TYPE";
    public static final String lockFieldNodeID = "NODE_ID";
    public static final String lockFieldRecordID = "RECORD_ID";
    public static final String lockFieldUserID = "USER_ID";
    public static final String lockFieldSessionID = "SESSION_ID";
    public static final String lockFieldCreationTime = "CREATION_TIME";
    public static final String persistentSessionFieldID = "ID";
    public static final String persistentSessionFieldUserID = "USER_ID";
    public static final String persistentSessionFieldHash1 = "HASH1";
    public static final String persistentSessionFieldCreationTime = "CREATION_TIME";
    public static final String persistentSessionFieldLastLoginTime = "LAST_LOGIN_TIME";
    public static final String persistentSessionFieldLastUserAgent = "LAST_USER_AGENT";
    public static final String selectLocks = "select L.APP_ID,L.LOCK_TYPE,L.NODE_ID,L.RECORD_ID,L.USER_ID,L.SESSION_ID from " + mtdLocksTableName + " L";
    private static final String nodeRecordSqlAttributeFields = "ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,MOD_USER_ID,ATTRS_B64,APP_TIME,APP_ID,SESSION_ID,CNT_ATTR_B64,REPL_ID,REPL_NODE_ID";
    private static final String historySqlAttributeFields = "NODE_ID as ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,MOD_USER_ID,ATTRS_B64,REPL_ID,REPL_NODE_ID,SESSION_ID";
    private static final String selectNodeChildrenIdsSql = "select ID from " + mtdTreeTableName + " MT where MT.PARENT_ID=? and MT.ID!=0 order by ORDER_NO,ID";
    private static final String selectNodeAttributesSql = "select ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,MOD_USER_ID,ATTRS_B64,APP_TIME,APP_ID,SESSION_ID,CNT_ATTR_B64,REPL_ID,REPL_NODE_ID from " + mtdTreeTableName;
    private static final String orderBySql = " order by PARENT_ID,ORDER_NO";
    private static final String reloadNodeAttributesSql = selectNodeAttributesSql + " order by PARENT_ID,ORDER_NO";
    private static final String selectNodeSql = "select ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,MOD_USER_ID,ATTRS_B64,APP_TIME,APP_ID,SESSION_ID,CNT_ATTR_B64,REPL_ID,REPL_NODE_ID,RAW_CONTENT,DSL_CONTENT from " + mtdTreeTableName;
    private static final String selectNodeEntrySql = "select ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,MOD_USER_ID,ATTRS_B64,APP_TIME,APP_ID,SESSION_ID,CNT_ATTR_B64,REPL_ID,REPL_NODE_ID,RAW_CONTENT,DSL_CONTENT from " + mtdTreeTableName + " MT where MT.ID=?";
    private static final String selectTheNodeAttributesSql = selectNodeAttributesSql + " MT where MT.ID=?";
    private static final String needReloadNodeSql = "select ID from " + mtdTreeTableName + " MT where MT.ID=? AND (MT.PARENT_ID<>? OR MT.NODE_NAME<>? OR MT.IDENT_NAME<>? OR MT.NODE_DESCRIPTION<>? OR MT.OWNER_ID<>? OR MT.ORDER_NO<>? OR MT.MOD_ATTRS_TIME<>? OR MT.MOD_CONTENT_TIME<>? OR MT.MOD_USER_ID<>? OR MT.ATTRS_B64<>? OR MT.APP_ID<>? OR MT.SESSION_ID<>?)";
    private static final String selectSyncNodeAttributesSql = selectNodeAttributesSql + " MT where (MT.CREATION_TIME>? or MT.MOD_ATTRS_TIME>? or MT.MOD_CONTENT_TIME>?) and MT.APP_ID<>? and MT.NODE_TYPE<>16 order by PARENT_ID,ORDER_NO";
    private static final String selectSyncNodeAttributesSqlForNode = selectNodeAttributesSql + " MT where (MT.CREATION_TIME>? or MT.MOD_ATTRS_TIME>? or MT.MOD_CONTENT_TIME>?) and MT.APP_ID<>? and MT.ID=?";
    private static final String selectSyncNodeAttributesSqlForUser = selectNodeAttributesSql + " MT where (MT.CREATION_TIME>? or MT.MOD_ATTRS_TIME>? or MT.MOD_CONTENT_TIME>?) and MT.APP_ID<>? and MT.NODE_NAME=? and MT.NODE_TYPE=3";
    private static final String createNodeSql = "insert into " + mtdTreeTableName;
    private static final String nodeRecordSqlAttributeFieldsMT = "MT.ID as ID,MT.PARENT_ID as PARENT_ID,MT.NODE_TYPE as NODE_TYPE,MT.NODE_NAME as NODE_NAME,MT.IDENT_NAME as IDENT_NAME,MT.NODE_DESCRIPTION as NODE_DESCRIPTION,MT.OWNER_ID as OWNER_ID,MT.ORDER_NO as ORDER_NO,MT.CREATION_TIME as CREATION_TIME,MT.MOD_ATTRS_TIME as MOD_ATTRS_TIME,MT.MOD_CONTENT_TIME as MOD_CONTENT_TIME,MT.MOD_USER_ID as MOD_USER_ID,MT.ATTRS_B64 as ATTRS_B64,MT.APP_TIME as APP_TIME,MT.APP_ID as APP_ID,MT.SESSION_ID as SESSION_ID, MT.REPL_ID as REPL_ID,MT.REPL_NODE_ID as REPL_NODE_ID";
    private static final String nodeRecordSqlAllFieldsMT = "MT.ID as ID,MT.PARENT_ID as PARENT_ID,MT.NODE_TYPE as NODE_TYPE,MT.NODE_NAME as NODE_NAME,MT.IDENT_NAME as IDENT_NAME,MT.NODE_DESCRIPTION as NODE_DESCRIPTION,MT.OWNER_ID as OWNER_ID,MT.ORDER_NO as ORDER_NO,MT.CREATION_TIME as CREATION_TIME,MT.MOD_ATTRS_TIME as MOD_ATTRS_TIME,MT.MOD_CONTENT_TIME as MOD_CONTENT_TIME,MT.MOD_USER_ID as MOD_USER_ID,MT.ATTRS_B64 as ATTRS_B64,MT.APP_TIME as APP_TIME,MT.APP_ID as APP_ID,MT.SESSION_ID as SESSION_ID, MT.REPL_ID as REPL_ID,MT.REPL_NODE_ID as REPL_NODE_ID,MT.RAW_CONTENT as RAW_CONTENT,MT.DSL_CONTENT as DSL_CONTENT";
    private static final String selectNodeSqlMT = "select MT.ID as ID,MT.PARENT_ID as PARENT_ID,MT.NODE_TYPE as NODE_TYPE,MT.NODE_NAME as NODE_NAME,MT.IDENT_NAME as IDENT_NAME,MT.NODE_DESCRIPTION as NODE_DESCRIPTION,MT.OWNER_ID as OWNER_ID,MT.ORDER_NO as ORDER_NO,MT.CREATION_TIME as CREATION_TIME,MT.MOD_ATTRS_TIME as MOD_ATTRS_TIME,MT.MOD_CONTENT_TIME as MOD_CONTENT_TIME,MT.MOD_USER_ID as MOD_USER_ID,MT.ATTRS_B64 as ATTRS_B64,MT.APP_TIME as APP_TIME,MT.APP_ID as APP_ID,MT.SESSION_ID as SESSION_ID, MT.REPL_ID as REPL_ID,MT.REPL_NODE_ID as REPL_NODE_ID,MT.RAW_CONTENT as RAW_CONTENT,MT.DSL_CONTENT as DSL_CONTENT from " + mtdTreeTableName + " MT";
    private static final String updateNodeAttrTimeSql = "update " + mtdTreeTableName + " set MOD_ATTRS_TIME=? where ID=?";
    private static final String createContentAttrSql = "update " + mtdTreeTableName + " set CNT_ATTR_B64=? where ID=? and (MOD_CONTENT_TIME=? or (?=0 and MOD_CONTENT_TIME is null))";
    public double id;
    public double parentId;
    public int type;
    public String name;
    public String identName;
    public String description;
    public double ownerId;
    public int orderNo;
    public double creationTime;
    public double modificationAttributeTime;
    public double modificationContentTime;
    public double modificationUserId;
    public byte[] attributesContent;
    public double applicationTime;
    public double applicationId;
    public double sessionId;
    public byte[] content;
    public String dslContent;
    public double replId;
    public double replNodeId;
    private static final String WHERE = " where";
    private static final String AND = " AND";

    public TaggedReader newContentReader() {
        if (this.content == null) {
            return null;
        }
        return new TaggedReader(new ByteArrayInputStream(this.content), this.content.length);
    }

    public TaggedReader newAttributeReader() {
        if (this.attributesContent == null) {
            return null;
        }
        return new TaggedReader(new ByteArrayInputStream(this.attributesContent), this.attributesContent.length);
    }

    public static void loadNodeRecord(ResultSet resultSet, FieldsIndexes fidxs, NodeRecord record) throws SQLException {
        record.setId(resultSet.getDouble(fidxs.id));
        record.setParentId(resultSet.getDouble(fidxs.parentId));
        int typeId = resultSet.getInt(fidxs.nodeType);
        record.setType(typeId);
        record.setName(resultSet.getString(fidxs.nodeName));
        record.setIdentName(resultSet.getString(fidxs.identName));
        record.setDescription(resultSet.getString(fidxs.nodeDescription));
        record.setOwnerId(resultSet.getDouble(fidxs.ownerId));
        record.setOrderNo(resultSet.getInt(fidxs.orderNo));
        Timestamp time = resultSet.getTimestamp(fidxs.creationTime);
        if (resultSet.wasNull() || time == null) {
            record.setCreationTime(0L);
        } else {
            record.setCreationTime(time.getTime());
        }
        time = resultSet.getTimestamp(fidxs.modificationAttributeTime);
        if (resultSet.wasNull() || time == null) {
            record.setModificationAttributeTime(0L);
        } else {
            record.setModificationAttributeTime(time.getTime());
        }
        time = resultSet.getTimestamp(fidxs.modificationContentTime);
        if (resultSet.wasNull() || time == null) {
            record.setModificationContentTime(0L);
        } else {
            record.setModificationContentTime(time.getTime());
        }
        record.setModificationUserId(resultSet.getDouble(fidxs.modificationUserId));
        time = resultSet.getTimestamp(fidxs.applicationTime);
        if (resultSet.wasNull() || time == null) {
            record.setApplicationTime(0L);
        } else {
            record.setApplicationTime(time.getTime());
        }
        record.setApplicationId(resultSet.getDouble(fidxs.applicationId));
        record.setSessionId(resultSet.getDouble(fidxs.sessionId));
        record.setRawAttributes(Base64BinString.Decode(resultSet.getString(fidxs.attributesB64)));
        record.setContentAttr(Base64BinString.Decode(resultSet.getString(fidxs.contentAttrB64)));
        double replId = resultSet.getDouble(fidxs.replId);
        if (!resultSet.wasNull()) {
            record.setReplId(replId);
        }
        double replNodeId = resultSet.getDouble(fidxs.replNodeId);
        if (!resultSet.wasNull()) {
            record.setReplNodeId(replNodeId);
        }
    }

    public static void loadNodeRecord(ResultSet resultSet, NodeRecord record) throws SQLException {
        FieldsIndexes fidxs = new FieldsIndexes(resultSet);
        MetadataNodeReader.loadNodeRecord(resultSet, fidxs, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadNodeRecord(SSContext ssContext, DatabaseConnection connection, double nodeId, NodeRecord record) throws SQLException, InformException {
        record.clear();
        try (PreparedStatement statement = connection.prepareStatement("loadNodeRecord", selectTheNodeAttributesSql);){
            statement.setDouble(1, nodeId);
            try (ResultSet resultSet = statement.executeQuery(ssContext);){
                if (resultSet.next()) {
                    MetadataNodeReader.loadNodeRecord(resultSet, record);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static void loadNodeRecordTime(ResultSet resultSet, NodeRecord record) throws SQLException {
        record.setId(resultSet.getDouble(resultSet.findColumn("ID")));
        Timestamp time = resultSet.getTimestamp(resultSet.findColumn("CREATION_TIME"));
        if (resultSet.wasNull() || time == null) {
            record.setCreationTime(0L);
        } else {
            record.setCreationTime(time.getTime());
        }
        time = resultSet.getTimestamp(resultSet.findColumn(fieldModificationAttributeTime));
        if (resultSet.wasNull() || time == null) {
            record.setModificationAttributeTime(0L);
        } else {
            record.setModificationAttributeTime(time.getTime());
        }
        time = resultSet.getTimestamp(resultSet.findColumn(fieldModificationContentTime));
        if (resultSet.wasNull() || time == null) {
            record.setModificationContentTime(0L);
        } else {
            record.setModificationContentTime(time.getTime());
        }
    }

    public static void loadNodeRecordExceptTime(ResultSet resultSet, NodeRecord record) throws SQLException {
        record.setParentId(resultSet.getDouble(resultSet.findColumn(fieldParentId)));
        int typeId = resultSet.getInt(resultSet.findColumn(fieldNodeType));
        record.setType(typeId);
        record.setName(resultSet.getString(resultSet.findColumn(fieldNodeName)));
        record.setIdentName(resultSet.getString(resultSet.findColumn(fieldIdentName)));
        record.setDescription(resultSet.getString(resultSet.findColumn(fieldNodeDescription)));
        record.setOwnerId(resultSet.getDouble(resultSet.findColumn(fieldOwnerId)));
        record.setOrderNo(resultSet.getInt(resultSet.findColumn(fieldOrderNo)));
        record.setModificationUserId(resultSet.getDouble(resultSet.findColumn(fieldModificationUserId)));
        Timestamp time = resultSet.getTimestamp(resultSet.findColumn(fieldApplicationTime));
        if (resultSet.wasNull() || time == null) {
            record.setApplicationTime(0L);
        } else {
            record.setApplicationTime(time.getTime());
        }
        record.setApplicationId(resultSet.getDouble(resultSet.findColumn("APP_ID")));
        record.setSessionId(resultSet.getDouble(resultSet.findColumn("SESSION_ID")));
        record.setRawAttributes(Base64BinString.Decode(resultSet.getString(resultSet.findColumn(fieldAttributesB64))));
        record.setContentAttr(Base64BinString.Decode(resultSet.getString(resultSet.findColumn(fieldContentAttrB64))));
    }

    public static MetadataNodeReader createNode(double nodeId, ResultSet resultSet) throws SQLException, IOException {
        return MetadataNodeReader.createNode(nodeId, resultSet, true);
    }

    public static MetadataNodeReader createNode(double nodeId, ResultSet resultSet, boolean withContent) throws SQLException, IOException {
        MetadataNodeReader node = new MetadataNodeReader();
        node.id = nodeId;
        node.parentId = resultSet.getDouble(resultSet.findColumn(fieldParentId));
        node.type = resultSet.getInt(resultSet.findColumn(fieldNodeType));
        node.name = resultSet.getString(resultSet.findColumn(fieldNodeName));
        node.identName = resultSet.getString(resultSet.findColumn(fieldIdentName));
        node.description = resultSet.getString(resultSet.findColumn(fieldNodeDescription));
        node.ownerId = resultSet.getDouble(resultSet.findColumn(fieldOwnerId));
        node.orderNo = resultSet.getInt(resultSet.findColumn(fieldOrderNo));
        Timestamp time = resultSet.getTimestamp(resultSet.findColumn("CREATION_TIME"));
        if (time != null) {
            node.creationTime = DateTime.fromUnixTime(time.getTime());
        }
        if ((time = resultSet.getTimestamp(resultSet.findColumn(fieldModificationAttributeTime))) != null) {
            node.modificationAttributeTime = DateTime.fromUnixTime(time.getTime());
        }
        if ((time = resultSet.getTimestamp(resultSet.findColumn(fieldModificationContentTime))) != null) {
            node.modificationContentTime = DateTime.fromUnixTime(time.getTime());
        }
        node.modificationUserId = resultSet.getDouble(resultSet.findColumn(fieldModificationUserId));
        String attrB64 = resultSet.getString(resultSet.findColumn(fieldAttributesB64));
        node.attributesContent = Base64BinString.Decode(attrB64);
        time = resultSet.getTimestamp(resultSet.findColumn(fieldApplicationTime));
        if (time != null) {
            node.applicationTime = DateTime.fromUnixTime(time.getTime());
        }
        node.applicationId = resultSet.getDouble(resultSet.findColumn("APP_ID"));
        node.sessionId = resultSet.getDouble(resultSet.findColumn("SESSION_ID"));
        node.content = resultSet.getBlobBytes(resultSet.findColumn(fieldRawContent));
        node.dslContent = resultSet.getString(resultSet.findColumn(fieldDslContent));
        node.replId = resultSet.getDouble(resultSet.findColumn(fieldReplId));
        node.replNodeId = resultSet.getDouble(resultSet.findColumn(fieldReplNodeId));
        return node;
    }

    public static MetadataNodeReader createNode(ResultSet resultSet) throws SQLException, IOException {
        return MetadataNodeReader.createNode(resultSet.getDouble(resultSet.findColumn("ID")), resultSet, true);
    }

    public static MetadataNodeReader createNode(ResultSet resultSet, boolean withContent) throws SQLException, InformException {
        try {
            return MetadataNodeReader.createNode(resultSet.getDouble(resultSet.findColumn("ID")), resultSet, false);
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needReloadNode(SSContext ssContext, DatabaseConnection connection, NodeRecord record) throws InformException, SQLException {
        try (PreparedStatement statement = connection.prepareStatement("needReloadNode", needReloadNodeSql);){
            boolean bl;
            statement.setDouble(1, record.getId());
            statement.setDouble(2, record.getParentId());
            statement.setString(2, record.getName());
            statement.setString(3, record.getIdentName());
            statement.setString(4, record.getDescription());
            statement.setDouble(5, record.getOwnerId());
            statement.setInt(6, record.getOrderNo());
            statement.setTimestamp(7, new Timestamp(record.getModificationAttributeTime()));
            statement.setTimestamp(8, new Timestamp(record.getModificationContentTime()));
            statement.setDouble(9, record.getModificationUserId());
            statement.setString(10, Base64BinString.Encode(record.getRawAttributes()));
            statement.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
            statement.setDouble(12, record.getApplicationId());
            statement.setDouble(13, record.getSessionId());
            ResultSet resultSet = statement.executeQuery(ssContext);
            try {
                bl = !resultSet.next();
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] getNodeChildrenIds(SSContext ssContext, DatabaseConnection connection, double nodeId) throws InformException, SQLException {
        statement.setDouble(1, nodeId);
        try (PreparedStatement statement = connection.prepareStatement("getNodeChildrenIds", selectNodeChildrenIdsSql);){
            int count;
            double[] ids;
            ResultSet resultSet;
            block13: {
                block12: {
                    double[] dArray;
                    resultSet = statement.executeQuery(ssContext);
                    try {
                        ids = new double[32];
                        count = 0;
                        while (resultSet.next()) {
                            if (count >= ids.length) {
                                ids = Arrays.copyOf(ids, ids.length + 32);
                            }
                            double childId = resultSet.getDouble(1);
                            ids[count++] = childId;
                        }
                        if (count != 0) break block12;
                        dArray = Empty.doubleArray;
                    }
                    catch (Throwable throwable) {
                        resultSet.close();
                        throw throwable;
                    }
                    resultSet.close();
                    return dArray;
                }
                if (count != ids.length) break block13;
                double[] dArray = ids;
                resultSet.close();
                return dArray;
            }
            double[] dArray = Arrays.copyOf(ids, count);
            resultSet.close();
            return dArray;
        }
    }

    public static ClosableResult getReloadNodesResultSet(SSContext ssContext, DatabaseConnection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("getReloadNodesResultSet", reloadNodeAttributesSql);
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    public static ClosableResult getSyncNodesResultSet(SSContext ssContext, DatabaseConnection connection, Timestamp time, double applicationId) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("getSyncNodesResultSet", selectSyncNodeAttributesSql);
        statement.setTimestamp(1, time);
        statement.setTimestamp(2, time);
        statement.setTimestamp(3, time);
        statement.setDouble(4, applicationId);
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    public static ClosableResult syncNodeResultSet(SSContext ssContext, double nodeId, DatabaseConnection connection, double time, double applicationId) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("syncNodeResultSet", selectSyncNodeAttributesSqlForNode);
        statement.setDateTime(1, time);
        statement.setDateTime(2, time);
        statement.setDateTime(3, time);
        statement.setDouble(4, applicationId);
        statement.setDouble(5, nodeId);
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    public static ClosableResult syncUserResultSet(SSContext ssContext, String login, DatabaseConnection connection, double time, double applicationId) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("syncUserResultSet", selectSyncNodeAttributesSqlForUser);
        statement.setDateTime(1, time);
        statement.setDateTime(2, time);
        statement.setDateTime(3, time);
        statement.setDouble(4, applicationId);
        statement.setString(5, login);
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    private static void appendEqualOrInToSql(StringBuilder sql, int paramCount) {
        if (paramCount == 1) {
            sql.append("=?");
        } else {
            sql.append(" in (");
            int separator = 32;
            for (int i = 0; i < paramCount; ++i) {
                sql.append((char)separator).append('?');
                separator = 44;
            }
            sql.append(')');
        }
    }

    public static ClosableResult getResultSetForJobs(SSContext ssContext, DatabaseConnection connection, double[] parents, String[] parentIdents) throws SQLException, InformException {
        StringBuilder sql = new StringBuilder();
        sql.append(selectNodeSqlMT);
        StringBuilder parentWhere = null;
        if (parentIdents != null && parentIdents.length != 0) {
            sql.append(" left outer join ").append(mtdTreeTableName).append(" P on P.").append("ID").append("=MT.").append(fieldParentId);
            parentWhere = new StringBuilder();
            parentWhere.append("P.").append(fieldIdentName);
            MetadataNodeReader.appendEqualOrInToSql(parentWhere, parentIdents.length);
        }
        if (parents != null && parents.length != 0) {
            if (parentWhere == null) {
                parentWhere = new StringBuilder();
            } else {
                parentWhere.append(" or ");
            }
            parentWhere.append(" MT.").append(fieldParentId);
            MetadataNodeReader.appendEqualOrInToSql(parentWhere, parents.length);
        }
        sql.append(" where ");
        if (parentWhere != null) {
            sql.append('(').append((CharSequence)parentWhere).append(") and ");
        }
        sql.append(" MT.").append(fieldNodeType).append("=?").append(" and MT.").append(fieldParentId).append("!=?");
        PreparedStatement statement = connection.prepareStatement("getResultSetForJobs", sql.toString());
        int paramIndex = 0;
        if (parentIdents != null) {
            for (String ident : parentIdents) {
                statement.setString(++paramIndex, ident);
            }
        }
        if (parents != null) {
            for (double parentId : parents) {
                statement.setDouble(++paramIndex, parentId);
            }
        }
        statement.setInt(++paramIndex, 51);
        statement.setDouble(++paramIndex, 1.0);
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    public static ClosableResult getResultSetForTypedNode(SSContext ssContext, int[] nodeTypes, DatabaseConnection connection, boolean includeTrash) throws InformException, SQLException {
        if (nodeTypes.length == 0) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(selectNodeSql).append(" MT where");
        if (nodeTypes.length == 1) {
            sql.append(" MT.").append(fieldNodeType).append("=?");
        } else {
            sql.append(" MT.").append(fieldNodeType).append(" in (");
            int separator = 32;
            for (int nodeType : nodeTypes) {
                sql.append((char)separator).append('?');
                separator = 44;
            }
            sql.append(')');
        }
        if (!includeTrash) {
            sql.append(" and MT.").append(fieldParentId).append("!=?");
        }
        PreparedStatement statement = connection.prepareStatement("getResultSetForTypedNode", sql.toString());
        for (int i = 0; i < nodeTypes.length; ++i) {
            statement.setDouble(i + 1, nodeTypes[i]);
        }
        if (!includeTrash) {
            statement.setDouble(nodeTypes.length + 1, 1.0);
        }
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillNodePathInfo(SSContext ssContext, DoubleDoubleMap nodes, DoubleHash<Children> children, DatabaseConnection connection) throws InformException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("ID").append(", ").append(fieldParentId).append(" from ").append(mtdTreeTableName).append(" MT");
        try (PreparedStatement statement = connection.prepareStatement("fillNodePathInfo", sql.toString());
             ResultSet resultSet = statement.executeQuery(ssContext);){
            while (resultSet.next()) {
                double nodeId = resultSet.getDouble(1);
                double parentId = resultSet.getDouble(2);
                nodes.put(nodeId, parentId);
                if (children == null) continue;
                Children list = children.get(parentId);
                if (list == null) {
                    list = new Children(parentId);
                    children.add(list);
                }
                list.add(nodeId);
            }
        }
    }

    public static ClosableResult getResultSetForSearch(SSContext ssContext, SearchMetatreeNodeData data, DatabaseConnection connection) throws InformException, SQLException {
        int i;
        int paramCount = 1000;
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("ID").append(',').append(fieldParentId).append(',').append(fieldNodeName);
        if (data.needContent) {
            sql.append(',').append(fieldAttributesB64).append(',').append(fieldRawContent);
        }
        sql.append(" from ").append(mtdTreeTableName).append(" MT");
        String where = WHERE;
        if (data.hasName) {
            if (data.strict) {
                sql.append(where).append('(').append(" MT.").append(fieldNodeName).append(" = ?");
                --paramCount;
                sql.append(" or ").append(" MT.").append(fieldIdentName).append(" = ?");
                --paramCount;
                sql.append(" or ").append(" MT.").append(fieldNodeDescription).append(" = ?");
                sql.append(')');
                --paramCount;
                where = AND;
            } else {
                sql.append(where).append('(').append(" UPPER(MT.").append(fieldNodeName).append(") LIKE ?");
                --paramCount;
                sql.append(" or ").append(" UPPER(MT.").append(fieldIdentName).append(") LIKE ?");
                --paramCount;
                sql.append(" or ").append(" UPPER(MT.").append(fieldNodeDescription).append(") LIKE ?");
                sql.append(')');
                --paramCount;
                where = AND;
            }
        }
        if (data.hasTypes) {
            sql.append(where).append(" MT.").append(fieldNodeType);
            if (data.nodeTypes.length == 1) {
                sql.append("=?");
                --paramCount;
            } else {
                sql.append(" in (");
                int separator = 32;
                for (int i2 = 0; i2 < data.nodeTypes.length; ++i2) {
                    sql.append((char)separator).append('?');
                    separator = 44;
                    --paramCount;
                }
                sql.append(')');
            }
            where = AND;
        }
        if (data.dateMask != 0) {
            sql.append(where).append(" (");
            boolean appended = false;
            if ((data.dateMask & 1) != 0) {
                sql.append("(");
                if (data.hasBeginCreationTime) {
                    sql.append("MT.").append("CREATION_TIME").append(">=?");
                    --paramCount;
                }
                if (data.hasEndCreationTime) {
                    if (data.hasBeginCreationTime) {
                        sql.append("AND ");
                    }
                    sql.append("MT.").append("CREATION_TIME").append("<=?");
                    --paramCount;
                }
                sql.append(")");
                appended = true;
            }
            if ((data.dateMask & 4) != 0) {
                if (appended) {
                    sql.append(" OR ");
                }
                sql.append("(");
                if (data.hasBeginAttrTime) {
                    sql.append("MT.").append(fieldModificationAttributeTime).append(">=?");
                    --paramCount;
                }
                if (data.hasEndAttrTime) {
                    if (data.hasBeginAttrTime) {
                        sql.append("AND ");
                    }
                    sql.append("MT.").append(fieldModificationAttributeTime).append("<=?");
                    --paramCount;
                }
                sql.append(")");
                appended = true;
            }
            if ((data.dateMask & 2) != 0) {
                if (appended) {
                    sql.append(" OR ");
                }
                sql.append("(");
                if (data.hasBeginModifyTime) {
                    sql.append("MT.").append(fieldModificationContentTime).append(">=?");
                    --paramCount;
                }
                if (data.hasEndModifyTime) {
                    if (data.hasBeginModifyTime) {
                        sql.append("AND ");
                    }
                    sql.append("MT.").append(fieldModificationContentTime).append("<=?");
                    --paramCount;
                }
                sql.append(")");
            }
            sql.append(")");
            where = AND;
        }
        int sliceIndex = 0;
        int sliceCount = 0;
        if (data.nodeSlice != null && data.sliceCount > 0) {
            sql.append(where).append(" MT.").append("ID").append(" in (");
            int sep = 32;
            for (int i3 = sliceIndex = data.nodeSlice.size() - data.sliceCount; i3 < data.nodeSlice.size() && sliceCount < paramCount; ++i3, ++sliceCount) {
                sql.append((char)sep).append('?');
                sep = 44;
            }
            sql.append(')');
            where = AND;
        }
        sql.append(" order by ").append(fieldParentId).append(",").append(fieldOrderNo);
        PreparedStatement statement = connection.prepareStatement("getResultSetForSearch", sql.toString(), FetchHint.BLOBS);
        int position = 0;
        if (data.hasName) {
            if (data.strict) {
                statement.setString(++position, data.name);
                statement.setString(++position, data.name);
                statement.setString(++position, data.name);
            } else {
                statement.setString(++position, "%" + data.name + "%");
                statement.setString(++position, "%" + data.name + "%");
                statement.setString(++position, "%" + data.name + "%");
            }
        }
        if (data.hasTypes) {
            for (i = 0; i < data.nodeTypes.length; ++i) {
                statement.setDouble(++position, data.nodeTypes[i]);
            }
        }
        if (data.hasBeginCreationTime) {
            statement.setDateTime(++position, data.beginDate);
        }
        if (data.hasEndCreationTime) {
            statement.setDateTime(++position, data.endDate);
        }
        if (data.hasBeginAttrTime) {
            statement.setDateTime(++position, data.beginDate);
        }
        if (data.hasEndAttrTime) {
            statement.setDateTime(++position, data.endDate);
        }
        if (data.hasBeginModifyTime) {
            statement.setDateTime(++position, data.beginDate);
        }
        if (data.hasEndModifyTime) {
            statement.setDateTime(++position, data.endDate);
        }
        if (data.nodeSlice != null && data.sliceCount > 0 && sliceCount > 0) {
            for (i = 0; i < sliceCount; ++i) {
                statement.setDouble(++position, data.nodeSlice.get(sliceIndex++));
            }
            data.sliceCount -= sliceCount;
        }
        return new ClosableResult(statement, statement.executeQuery(ssContext));
    }

    public static MetadataNodeReader createNode(SSContext ssContext, double nodeId, DatabaseConnection connection) throws InformException {
        return MetadataNodeReader.createNode(ssContext, nodeId, connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataNodeReader createNode(SSContext ssContext, double nodeId, DatabaseConnection connection, boolean withContent) throws InformException {
        MetadataNodeReader node = null;
        try {
            ClosableResult resultSet = MetadataNodeReader.getResultSetForNode(ssContext, nodeId, connection);
            if (resultSet == null) {
                return null;
            }
            try {
                node = MetadataNodeReader.createNode(nodeId, resultSet.getResultSet(), withContent);
            }
            finally {
                resultSet.close();
            }
        }
        catch (IOException | SQLException ex) {
            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0443\u0437\u043b\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445", ex);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClosableResult getHistoryEntryResultSet(SSContext ssContext, double nodeId, double historyId, DatabaseConnection connection) throws InformException, SQLException {
        Object sql = historyId == 0.0 ? selectNodeEntrySql : "select NODE_ID as ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,MOD_USER_ID,ATTRS_B64,REPL_ID,REPL_NODE_ID,SESSION_ID,RAW_CONTENT,DSL_CONTENT, null as APP_ID, null as APP_TIME, null as CNT_ATTR_B64 from " + mtdTreeLogTableName + " H where H.ID=?";
        PreparedStatement statement = connection.prepareStatement("getHistoryEntryResultSet", (String)sql);
        if (historyId == 0.0) {
            statement.setDouble(1, nodeId);
        } else {
            statement.setDouble(1, historyId);
        }
        ResultSet resultSet = null;
        try {
            try {
                resultSet = statement.executeQuery(ssContext);
                if (!resultSet.next()) {
                    resultSet.close();
                    resultSet = null;
                }
            }
            catch (SQLException e) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable t) {
                        Core.logger.error(null, t);
                    }
                }
                resultSet = null;
                throw e;
            }
        }
        finally {
            if (resultSet == null) {
                statement.close();
            }
        }
        if (resultSet == null) {
            return null;
        }
        return new ClosableResult(statement, resultSet);
    }

    public static ClosableResult getResultSetForNode(SSContext ssContext, double nodeId, DatabaseConnection connection) throws InformException, SQLException {
        return MetadataNodeReader.getResultSetForNode(ssContext, nodeId, connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockContentBarrier(SSContext ssContext, double nodeId, long contentStamp, DatabaseConnection connection) throws SQLException {
        if (contentStamp == 0L) {
            return;
        }
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(fieldModificationContentTime).append(',').append(fieldNodeName).append(" from ").append(mtdTreeTableName).append(" where ").append("ID").append("=?");
        caps.addSelectForUpdate(sql);
        try (PreparedStatement statement = connection.prepareStatement("lockContentBarrier", "select MOD_CONTENT_TIME,NODE_NAME from " + mtdTreeTableName + " where ID=?");){
            statement.setDouble(1, nodeId);
            try (ResultSet resultSet = statement.executeQuery(ssContext);){
                Timestamp t;
                long stamp;
                if (!resultSet.next()) {
                    MtdEngine.throwError(nodeId, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                long l = stamp = (t = resultSet.getTimestamp(1)) == null ? 0L : t.getTime();
                if ((stamp /= 1000L) != (contentStamp /= 1000L)) {
                    String name = resultSet.getString(2);
                    if (name == null) {
                        name = "";
                    }
                    throw new InformException("\u0423\u0437\u0435\u043b \"" + name + "\" [" + NumberConverter.doubleToString(nodeId) + "] \u0443\u0436\u0435 \u0437\u0430\u043f\u0438\u0441\u0430\u043d \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClosableResult getResultSetForNode(SSContext ssContext, double nodeId, DatabaseConnection connection, boolean fetch) throws InformException, SQLException {
        PreparedStatement statement = connection.prepareStatement("getResultSetForNode", selectNodeSql + " where ID=?");
        statement.setDouble(1, nodeId);
        ResultSet resultSet = null;
        try {
            try {
                resultSet = statement.executeQuery(ssContext);
                if (fetch && !resultSet.next()) {
                    resultSet.close();
                    resultSet = null;
                }
            }
            catch (SQLException e) {
                resultSet = null;
                throw e;
            }
        }
        finally {
            if (resultSet == null) {
                statement.close();
            }
        }
        if (resultSet == null) {
            return null;
        }
        return new ClosableResult(statement, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNodeTypeId(SSContext ssContext, double nodeId, SSDataHost dataHost) throws InformException, SQLException, InterruptedException {
        DatabaseConnection connection = dataHost.getDatabaseManager().getConnection(2.0, "MetadataNodeReader::getNodeTypeId");
        statement.setDouble(1, nodeId);
        try (PreparedStatement statement = connection.prepareStatement("getNodeTypeId", "select NODE_TYPE from " + mtdTreeTableName + " where ID=?");){
            int n;
            block16: {
                ResultSet resultSet;
                block14: {
                    int n2;
                    block15: {
                        dataHost.idle();
                        resultSet = null;
                        try {
                            try {
                                resultSet = statement.executeQuery(ssContext);
                            }
                            catch (SQLException ex) {
                                Core.logger.error(null, ex);
                                int n3 = 0;
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                statement.close();
                                return n3;
                            }
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            throw throwable;
                        }
                        dataHost.idle();
                        if (resultSet.next()) break block14;
                        n2 = 0;
                        if (resultSet == null) break block15;
                        resultSet.close();
                    }
                    return n2;
                }
                n = resultSet.getInt(1);
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return n;
        }
    }

    public static double extractRefNode(byte[] attributes) throws IOException, TaggedReaderException {
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(attributes), attributes.length);
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 24: {
                    return in.getDouble();
                }
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getValidNodes(SSContext ssContext, Iterator<Cursor.Double> nodes, Connector metabase, DoubleList validNodes) throws SQLException {
        if (!nodes.hasNext()) {
            return;
        }
        int maxExptInList = 1000;
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("ID").append(" from ").append(mtdTreeTableName).append(" where ").append("ID").append(" in(");
        double[] ids = new double[1000];
        int comma = 32;
        for (int count = 0; count < 1000 && nodes.hasNext(); ++count) {
            sql.append((char)comma).append('?');
            comma = 44;
            ids[count] = nodes.next().value;
        }
        sql.append(')');
        PreparedStatement statement = metabase.connection().prepareStatement("getValidNodes", sql.toString());
        for (int i = count - 1; i >= 0; --i) {
            double id = ids[i];
            if (id > 0.0 && id < 1.0E-222) {
                id = -1.0;
            }
            statement.setDouble(i + 1, id);
        }
        try (ResultSet resultSet = statement.executeQuery(ssContext);){
            while (resultSet.next()) {
                validNodes.add(resultSet.getDouble(1));
            }
        }
        finally {
            statement.close();
        }
    }

    public static void getValidNodes(SSContext ssContext, DoubleSet nodes, Connector metabase, DoubleList validNodes) throws InformException, InterruptedException, SQLException {
        if (nodes.empty()) {
            return;
        }
        Iterator<Cursor.Double> iter = nodes.iterator();
        while (iter.hasNext()) {
            MetadataNodeReader.getValidNodes(ssContext, iter, metabase, validNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getValidNodesFiltered(SSContext ssContext, Iterator<Cursor.Double> nodes, BitSet types, Connector metabase, Collection<NodeAndType> out) throws InformException, InterruptedException, SQLException {
        int count;
        if (!nodes.hasNext()) {
            return;
        }
        int maxExptInList = 1000;
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("ID").append(", ").append(fieldNodeType).append(" from ").append(mtdTreeTableName);
        sql.append(" where ").append("ID").append(" in (");
        double[] ids = new double[1000];
        int comma = 32;
        for (count = 0; count < 1000 && nodes.hasNext(); ++count) {
            sql.append((char)comma).append('?');
            comma = 44;
            ids[count] = nodes.next().value;
        }
        sql.append(")");
        sql.append(" and ").append(fieldNodeType).append(" in (");
        comma = 32;
        for (int t = types.length() - 1; t >= 0; --t) {
            if (!types.get(t)) continue;
            sql.append((char)comma).append('?');
            comma = 44;
        }
        sql.append(")");
        PreparedStatement statement = metabase.connection().prepareStatement("getValidNodesFiltered", sql.toString());
        for (int i = count - 1; i >= 0; --i) {
            statement.setDouble(i + 1, ids[i]);
        }
        for (int t = types.length() - 1; t >= 0; --t) {
            if (!types.get(t)) continue;
            statement.setInt(++count, t);
        }
        try (ResultSet rs = statement.executeQuery(ssContext);){
            while (rs.next()) {
                out.add(new NodeAndType(rs.getDouble(1), rs.getInt(2)));
            }
        }
        finally {
            statement.close();
        }
    }

    public static void getValidNodesFiltered(SSContext ssContext, DoubleSet nodes, BitSet types, Connector metabase, Collection<NodeAndType> out) throws InformException, InterruptedException, SQLException {
        if (nodes.empty()) {
            return;
        }
        Iterator<Cursor.Double> iter = nodes.iterator();
        while (iter.hasNext()) {
            MetadataNodeReader.getValidNodesFiltered(ssContext, iter, types, metabase, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NodeHistoryEntry> getNodeHistory(SSContext ssContext, double nodeId, Timestamp startDate, Timestamp endDate, boolean includeAttrChange, int numRec, Iterable<? extends Cursor.Integer> operations, Iterable<? extends Cursor.Integer> nodeTypes, Iterable<? extends Cursor.Double> users, boolean inUsersView) throws IOException, SQLException, InformException {
        ArrayList<NodeHistoryEntry> history = new ArrayList<NodeHistoryEntry>();
        try (DatabaseConnection conn = DatabaseDescriptor.getMetabase().connectPrivileged("MetadataNodeReader::getNodeHistory");){
            double pinId = 0.0;
            String sql = MetadataNodeReader.createHistorySQL(nodeId, pinId, startDate, endDate, includeAttrChange, numRec, operations, nodeTypes, users);
            try (PreparedStatement stmt = conn.prepareStatement("inform.agent.mtd.MetadataNodeReader.getNodeHistory()", sql);){
                int i = 1;
                if (startDate.getTime() > 0L) {
                    stmt.setTimestamp(i++, startDate);
                }
                if (endDate.getTime() > 0L) {
                    stmt.setTimestamp(i++, endDate);
                }
                for (Cursor.Integer integer : operations) {
                    stmt.setInt(i++, integer.value);
                }
                for (Cursor.Integer integer : nodeTypes) {
                    stmt.setInt(i++, integer.value);
                }
                for (Cursor.Double double_ : users) {
                    stmt.setDouble(i++, double_.value);
                }
                if (nodeId != 0.0) {
                    stmt.setDouble(i++, nodeId);
                }
                if (pinId != 0.0) {
                    stmt.setDouble(i++, pinId);
                }
                try (ResultSet result = stmt.executeQuery(ssContext);){
                    if (numRec <= 0) {
                        numRec = Integer.MAX_VALUE;
                    }
                    double d = -1.0;
                    double prevUser = -1.0;
                    while (result.next() && numRec-- > 0) {
                        String dsl;
                        int col = 1;
                        NodeHistoryEntry entry = new NodeHistoryEntry();
                        entry.replId = -1.0;
                        entry.modUserId = -1.0;
                        entry.id = result.getDouble(col++);
                        entry.nodeId = result.getDouble(col++);
                        entry.date = result.getTimestamp(col++);
                        entry.user = result.getDouble(col++);
                        entry.operation = result.getInt(col++);
                        entry.nodeType = result.getInt(col++);
                        entry.nodeName = result.getString(col++);
                        entry.parentId = result.getDouble(col++);
                        entry.comment = result.getString(col++);
                        double tmp = result.getDouble(col++);
                        if (!result.wasNull()) {
                            entry.replId = tmp;
                        }
                        tmp = result.getDouble(col++);
                        if (!result.wasNull()) {
                            entry.modUserId = tmp;
                        }
                        entry.modContentTime = result.getTimestamp(col++);
                        byte[] attrs = Base64BinString.Decode(result.getString(col++));
                        entry.nodeContentKind = (dsl = result.getString(col++)) == null ? GetNodeContent.Kind.Binary.toInt() : GetNodeContent.Kind.Text.toInt();
                        ByteArrayInputStream is = new ByteArrayInputStream(attrs);
                        TaggedReader reader = new TaggedReader(is, attrs.length);
                        while (reader.getNextTag() != 0) {
                            if (reader.getCurrentTag() != 2) continue;
                            entry.acl = reader.getRaw();
                        }
                        entry.blobSize = result.getInt(col++);
                        int tmpInt = result.getInt(col);
                        if (!result.wasNull() && tmpInt != 0) {
                            entry.blobSize = tmpInt;
                        }
                        if (inUsersView) {
                            if (entry.nodeId != d || nodeId != 0.0 || entry.user != prevUser || entry.parentId == 1.0 && entry.operation == 2) {
                                history.add(entry);
                                d = entry.nodeId;
                                prevUser = entry.user;
                                continue;
                            }
                            boolean needAdd = true;
                            for (int j = 0; j < history.size(); ++j) {
                                if (history.get((int)j).nodeId != entry.nodeId || history.get((int)j).user != entry.user) continue;
                                needAdd = false;
                                break;
                            }
                            if (!needAdd) continue;
                            history.add(entry);
                            d = entry.nodeId;
                            prevUser = entry.user;
                            continue;
                        }
                        if (entry.nodeId == d && nodeId == 0.0 && entry.user == prevUser && (entry.parentId != 1.0 || entry.operation != 2)) continue;
                        history.add(entry);
                        d = entry.nodeId;
                        prevUser = entry.user;
                    }
                }
            }
        }
        return history;
    }

    private static String createHistorySQL(double nodeId, double pinId, Timestamp startDate, Timestamp endDate, boolean includeAttrChange, int numRec, Iterable<? extends Cursor.Integer> operations, Iterable<? extends Cursor.Integer> nodeTypes, Iterable<? extends Cursor.Double> users) {
        StringBuilder sql = new StringBuilder();
        StringBuilder whereClause = new StringBuilder();
        StringBuilder fieldsList = new StringBuilder();
        if (startDate.getTime() > 0L) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append(" OP_TIME >= ?");
        }
        if (endDate.getTime() > 0L) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append(" OP_TIME <= ?");
        }
        StringBuilder tmp = new StringBuilder();
        String delim = "";
        for (Cursor.Integer integer : operations) {
            tmp.append(delim).append("?");
            delim = ", ";
        }
        if (tmp.length() > 0) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append(" OP_CODE in (").append(tmp.toString()).append(")");
        }
        tmp = new StringBuilder();
        delim = "";
        for (Cursor.Integer integer : nodeTypes) {
            tmp.append(delim).append("?");
            delim = ", ";
        }
        if (tmp.length() > 0) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append(" NODE_TYPE in (").append(tmp.toString()).append(")");
        }
        tmp = new StringBuilder();
        delim = "";
        for (Cursor.Double double_ : users) {
            tmp.append(delim).append("?");
            delim = ", ";
        }
        if (tmp.length() > 0) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append(" USER_ID in (").append(tmp.toString()).append(")");
        }
        if (nodeId != 0.0) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append("NODE_ID = ?");
        }
        if (pinId != 0.0) {
            whereClause.append(whereClause.length() > 0 ? " and " : " ").append("ID = ?");
        }
        DatabaseCaps caps = DatabaseType.getMetabaseType().caps();
        fieldsList.append(" ID, ").append(mtdTreeLogTableName);
        fieldsList.append(".NODE_ID, OP_TIME, USER_ID, OP_CODE, NODE_TYPE, NODE_NAME, PARENT_ID, ENTRY_COMMENT, REPL_ID, MOD_USER_ID, MOD_CONTENT_TIME, ATTRS_B64");
        fieldsList.append(", ").append(fieldDslContent).append(", ").append(caps.blobLengthFunction).append("(").append(fieldRawContent).append("), ").append(caps.blobLengthFunction).append("(").append(fieldDslContent).append(")");
        sql.append(" select ");
        if (numRec > 0) {
            caps.fetchLimitBeginning(numRec, sql);
        }
        if (nodeId == 0.0) {
            sql.append((CharSequence)fieldsList).append(" from ").append(mtdTreeLogTableName).append(" where ");
            sql.append((CharSequence)whereClause).append(" order by NODE_ID, OP_TIME desc, OP_CODE desc, ID desc");
        } else {
            sql.append(" ").append((CharSequence)fieldsList).append(" from ").append(mtdTreeLogTableName);
            sql.append(" where ").append((CharSequence)whereClause).append(" order by OP_TIME desc, OP_CODE desc, ID desc");
        }
        if (numRec > 0) {
            sql = caps.fetchLimitEnding(numRec, sql);
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkHistoryPreviousEntry(SSContext context, Node.ModifyNodeArg arg, Node node) throws SQLException {
        if (!node.isNodeAttrChanged(512)) {
            return;
        }
        Connector connector = arg.connector;
        DatabaseConnection connection = connector.connection();
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append(fieldModificationContentTime).append(',');
        sql.append(fieldModificationUserId);
        sql.append(" from ").append(mtdTreeTableName);
        sql.append(" where ").append("ID").append("=?");
        boolean existEntry = false;
        double modificationUserId = 0.0;
        Timestamp modificationContentTime = new Timestamp(0L);
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            statement.setDouble(1, node.getId());
            ResultSet resultSet = statement.executeQuery(context);
            if (resultSet.next()) {
                modificationContentTime = resultSet.getTimestamp(1);
                modificationUserId = resultSet.getAsDouble(2);
                existEntry = true;
            }
        }
        if (!existEntry) {
            return;
        }
        sql = new StringBuilder();
        DatabaseCaps caps = DatabaseType.getMetabaseType().caps();
        sql.append("select ");
        caps.fetchLimitBeginning(1, sql);
        sql.append(fieldModificationContentTime).append(',');
        sql.append(fieldModificationUserId);
        sql.append(" from ").append(mtdTreeLogTableName);
        sql.append(" where ").append("NODE_ID").append("=?");
        sql.append(" and ").append("OP_CODE").append(" in (?,?)");
        sql.append(" order by OP_TIME desc, ID desc");
        sql = caps.fetchLimitEnding(1, sql);
        existEntry = false;
        statement = connection.prepareStatement(sql.toString());
        try {
            statement.setDouble(1, node.getId());
            statement.setInt(2, 1);
            statement.setInt(3, 4);
            try (ResultSet resultSet = statement.executeQuery(context);){
                Timestamp timestamp;
                if (resultSet.next() && (timestamp = resultSet.getTimestamp(1)) != null && modificationContentTime != null && modificationContentTime.equals(timestamp) && modificationUserId == resultSet.getAsDouble(2)) {
                    existEntry = true;
                }
            }
        }
        finally {
            statement.close();
        }
        if (existEntry) {
            return;
        }
        MtdEngine.registerMtdOperation(context, connection, node.getId(), arg.userId, arg.sessionId, "auto recovery", 4, true, node.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNodes(SSContext context, Node.ModifyNodeArg arg) throws SQLException, InformException {
        Connector connector = arg.connector;
        DatabaseConnection connection = connector.connection();
        for (Node node : arg.modifiedNodes) {
            int updateCount;
            NodeChanges changes = new NodeChanges();
            node.getNodeChanges(changes);
            if (node.isNodeAttrChanged(512)) {
                String dslContent = node.getModifiedDslContent();
                if (dslContent != null) {
                    changes.putNullBlob(fieldRawContent);
                    changes.putString(fieldDslContent, dslContent);
                } else {
                    byte[] content = node.getModifiedContent();
                    if (content != null) {
                        changes.putBlob(fieldRawContent, node.getModifiedContent());
                    }
                    changes.putNullString(fieldDslContent);
                }
            }
            if (Ini.ReadonlyMode) {
                if (node.getType() == 16) break;
                throw new InformException("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
            }
            if (changes.isEmpty()) continue;
            changes.setApplicationId(Core.getApplicationId());
            changes.setApplicationTime(System.currentTimeMillis());
            node.setReplId(arg.replId);
            changes.setReplId(arg.replId);
            changes.setReplNodeId(arg.replNodeId);
            MetadataNodeReader.checkHistoryPreviousEntry(context, arg, node);
            StringBuilder sql = new StringBuilder();
            sql.append("update ").append(mtdTreeTableName).append(" set");
            int sep = 32;
            Iterator<NodeRecordChanges.Modification> itch = changes.iterator();
            while (itch.hasNext()) {
                NodeRecordChanges.Modification modification = itch.next();
                sql.append((char)sep).append(modification.field).append("=?");
                sep = 44;
            }
            sql.append(" where ").append("ID").append("=?");
            if (arg.contentStamp != 0L) {
                sql.append(" and ").append(fieldModificationContentTime).append("=?");
            }
            try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
                int paramIndex = changes.applyTo(1, statement);
                statement.setDouble(paramIndex++, node.getId());
                if (arg.contentStamp != 0L) {
                    statement.setTimestamp(paramIndex, new Timestamp(arg.contentStamp));
                }
                updateCount = statement.executeUpdate(context);
            }
            if (updateCount == 0) {
                long existingStamp = 0L;
                double userId = 0.0;
                sql = new StringBuilder();
                sql.append("select MT.").append(fieldModificationUserId).append(", MT.").append(fieldModificationContentTime).append(" from ").append(mtdTreeTableName).append(" MT where MT.").append("ID").append("=?");
                statement = connection.prepareStatement(sql.toString());
                try {
                    statement.setDouble(1, node.getId());
                    try (ResultSet resultSet = statement.executeQuery(context);){
                        if (resultSet.next()) {
                            Timestamp timestamp;
                            userId = resultSet.getAsDouble(1);
                            if (resultSet.wasNull()) {
                                userId = 0.0;
                            }
                            if ((timestamp = resultSet.getTimestamp(2)) != null) {
                                existingStamp = timestamp.getTime();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
                finally {
                    statement.close();
                }
                StringBuilder msg = new StringBuilder();
                msg.append("\n\n\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c: ");
                MtdEngine.appendUserNameForLog(msg, userId);
                msg.append("\n").append("\u0412\u0440\u0435\u043c\u044f: ");
                msg.append(DateTime.unixTimeToReadableString(existingStamp));
                msg.append("\n\u041f\u0435\u0440\u0432\u043e\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: ");
                msg.append(DateTime.unixTimeToReadableString(arg.contentStamp));
                StringBuilder detail = new StringBuilder();
                detail.append("\n\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c: ");
                MtdEngine.appendUserNameForLog(detail, userId);
                detail.append("\n").append("existingStamp: ");
                detail.append(existingStamp);
                detail.append(" contentStamp: ");
                detail.append(arg.contentStamp);
                detail.append(" session: ");
                detail.append(NumberConverter.doubleToString(arg.sessionId));
                if (arg.contentStamp != 0L) {
                    throw new InformException("\u0423\u0437\u0435\u043b \"" + node.getName() + "\" [" + NumberConverter.doubleToString(node.getId()) + "] \u0443\u0436\u0435 \u0437\u0430\u043f\u0438\u0441\u0430\u043d \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c" + msg.toString()).detail(detail.toString()).detail("Modified by ApplicationID " + NumberConverter.doubleToString(node.getApplicationId()) + ", SessionID " + NumberConverter.doubleToString(node.getSessionId()));
                }
                throw new InformException("\u0423\u0437\u0435\u043b \"" + node.getName() + "\" [" + NumberConverter.doubleToString(node.getId()) + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0434\u0435\u0440\u0435\u0432\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445").detail(detail.toString());
            }
            String comment = arg.auditComment;
            if (node.isNodeChangeMask(16) && Strings.isVoid(comment)) {
                comment = "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0443\u0437\u043b\u0430";
            }
            MtdEngine.registerMtdOperation(context, connection, node.getId(), arg.userId, arg.sessionId, comment, node.isNodeAttrChanged(512) ? 4 : 2, node.isNodeAttrChanged(512), node.getType());
        }
        if (!Ini.ReadonlyMode && !arg.modifiedParents.empty()) {
            double[] modpar = arg.modifiedParents.toArray();
            if (modpar.length > 1) {
                Arrays.sort(modpar);
            }
            try (AbstractStatement ps = null;){
                for (Object parentId : (NodeChanges)modpar) {
                    Node node;
                    long modificationTime = System.currentTimeMillis();
                    if (arg.modifiedNodes.get((double)parentId) == null) {
                        if (ps == null) {
                            ps = connection.prepareStatement(updateNodeAttrTimeSql);
                        }
                        ((PreparedStatement)ps).setDateTime(1, DateTime.fromUnixTime(modificationTime));
                        ((PreparedStatement)ps).setDouble(2, (double)parentId);
                        ((PreparedStatement)ps).executeUpdate(context);
                    }
                    if ((node = MtdEngine.getNode((double)parentId)) == null) continue;
                    node.setModificationAttributeTime(modificationTime);
                }
            }
        }
        connector.commit();
        for (Node node : arg.modifiedNodes) {
            AuditJournal journal;
            if (!node.isNodeAttrChanged(16384) || !(journal = new AuditJournal(AuditJournal.Journal.EVENTS)).isEnabled()) continue;
            AuditJournal.EventParams params = new AuditJournal.EventParams();
            params.userId = arg.userId;
            params.loginId = arg.sessionId;
            params.startTime = params.stopTime = System.currentTimeMillis();
            params.code = node.isAuditEvents() ? 1 : 2;
            params.nodeId = node.getId();
            journal.registrateEvent(context, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createNode(SSContext ssContext, Connector connector, Node node, String comment) throws InformException, SQLException {
        NodeChanges changes = new NodeChanges();
        node.getCreationChanges(changes);
        changes.setApplicationId(Core.getApplicationId());
        changes.setApplicationTime(System.currentTimeMillis());
        StringBuilder fields = new StringBuilder();
        StringBuilder values = new StringBuilder();
        fields.append("ID");
        values.append('?');
        Iterator<NodeRecordChanges.Modification> itch = changes.iterator();
        while (itch.hasNext()) {
            NodeRecordChanges.Modification modification = itch.next();
            fields.append(',').append(modification.field);
            values.append(",?");
        }
        StringBuilder sql = new StringBuilder();
        sql.append(createNodeSql).append(" (").append(fields.toString()).append(") VALUES (").append((CharSequence)values).append(')');
        DatabaseConnection connection = connector.connection();
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            statement.setDouble(1, node.getId());
            changes.applyTo(2, statement);
            statement.executeUpdate(ssContext);
        }
        MtdEngine.registerMtdOperation(ssContext, connection, node.getId(), node.getModificationUserId(), node.getSessionId(), comment, 1, node.isNodeAttrChanged(512), node.getType());
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNodeTransact(SSContext ssContext, NodeChanges changes, double nodeId, double userId, double sessionId, String comment, int nodeType, DatabaseConnection connection) throws InformException, SQLException {
        changes.setApplicationId(Core.getApplicationId());
        changes.setApplicationTime(System.currentTimeMillis());
        StringBuilder fields = new StringBuilder();
        StringBuilder values = new StringBuilder();
        int separator = 32;
        Iterator<NodeRecordChanges.Modification> itch = changes.iterator();
        while (itch.hasNext()) {
            NodeRecordChanges.Modification modification = itch.next();
            fields.append((char)separator).append(modification.field);
            values.append((char)separator).append('?');
            separator = 44;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(createNodeSql).append(" (").append(fields.toString()).append(") VALUES (").append((CharSequence)values).append(')');
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            changes.applyTo(1, statement);
            statement.executeUpdate(ssContext);
        }
        MtdEngine.registerMtdOperation(ssContext, connection, nodeId, userId, sessionId, comment, 1, changes.isContentChanged, nodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNodeTransact(SSContext ssContext, NodeChanges changes, double nodeId, double userId, double sessionId, String comment, int nodeType, DatabaseConnection connection) throws InformException, SQLException {
        changes.setApplicationId(Core.getApplicationId());
        changes.setApplicationTime(System.currentTimeMillis());
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(mtdTreeTableName).append(" set");
        int sep = 32;
        Iterator<NodeRecordChanges.Modification> itch = changes.iterator();
        while (itch.hasNext()) {
            NodeRecordChanges.Modification modification = itch.next();
            sql.append((char)sep).append(modification.field).append("=?");
            sep = 44;
        }
        sql.append(" where ").append("ID").append("=?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            int paramIndex = changes.applyTo(1, statement);
            statement.setDouble(paramIndex, nodeId);
            statement.executeUpdate(ssContext);
        }
        MtdEngine.registerMtdOperation(ssContext, connection, nodeId, userId, sessionId, comment, changes.isContentChanged ? 4 : 2, changes.isContentChanged, nodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rawDeleteNodesTransact(SSContext ssContext, double userId, double[] nodeIds, int count, DatabaseConnection connection, SSContext context) throws SQLException, IOException, InformException {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(fieldParentId).append(',').append(fieldAttributesB64).append(',').append("ID").append(" from ").append(mtdTreeTableName).append(" where ").append("ID");
        if (count == 1) {
            selectSql.append("=?");
        } else {
            selectSql.append(" in (?");
            for (int i = 1; i < count; ++i) {
                selectSql.append(",?");
            }
            selectSql.append(')');
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(mtdTreeTableName).append(" set ").append(fieldParentId).append("=?,").append(fieldAttributesB64).append("=?").append(" where ").append("ID").append("=?");
        SqlCommandBatch command = new SqlCommandBatch();
        command.setSql(updateSql.toString(), 3);
        try (PreparedStatement select = connection.prepareStatement(selectSql.toString());){
            for (int i = 0; i < count; ++i) {
                select.setDouble(i + 1, nodeIds[i]);
            }
            try (ResultSet resultSet = select.executeQuery(ssContext);){
                while (resultSet.next()) {
                    double parentId = resultSet.getDouble(1);
                    byte[] attr = Base64BinString.Decode(resultSet.getString(2));
                    double nodeId = resultSet.getDouble(3);
                    double[] undeleteInfo = new double[]{parentId, userId};
                    ByteArrayOutputStream newAttr = new ByteArrayOutputStream(attr.length + 2 + 8 + 8);
                    newAttr.write(attr);
                    TaggedWriter out = new TaggedWriter(newAttr);
                    out.putRaw(15, LittleEndian.doubleArrayToBinary(undeleteInfo));
                    out.flush();
                    command.addBatch(connection, context);
                    command.getParameters().setInteger(0, 1);
                    command.getParameters().setString(1, Base64BinString.Encode(newAttr.toByteArray()));
                    command.getParameters().setDouble(2, nodeId);
                }
            }
            command.execute(connection, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNodeExists(SSContext ssContext, double nodeId, DatabaseConnection connection) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("ID").append(" from ").append(mtdTreeTableName).append(" where ").append("ID").append("=?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            boolean bl;
            statement.setDouble(1, nodeId);
            ResultSet resultSet = statement.executeQuery(ssContext);
            try {
                bl = resultSet.next();
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return bl;
        }
    }

    public static void createContentAttributes(Iterable<Node> nodes, DatabaseConnection connection, SSContext context) throws SQLException {
        SqlCommandBatch command = new SqlCommandBatch();
        command.setSql(createContentAttrSql, 4);
        for (Node node : nodes) {
            if (!node.needCreateContentAttr()) continue;
            SqlBatchParamList params = command.addBatch(connection, context);
            long mct = node.getModificationContentTime();
            String contentAttr = Base64BinString.Encode(node.createContentAttr());
            params.setString(0, contentAttr);
            params.setDouble(1, node.getId());
            params.setTimestamp(2, mct);
            params.setDouble(3, mct);
        }
        command.flush(connection, true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAgentApplication(DatabaseConnection connection, double applicationId) throws SQLException {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        String sql = "insert into " + mtdAgentsTableName + " (ID, SERVER_ID, AGENT_ID, AGENT_NAME, HOST_NAME, PID, WORKER_ID, AGENT_VERSION, CONNECTED, ACTIVITY) values(?, ?, ?, ?, ?, ?, ?, ?, " + caps.currentDateTime() + ", " + caps.currentDateTime() + ")";
        try (PreparedStatement statement = connection.prepareStatement("MetadataNodeReader.createAgentApplication", sql);){
            String version = AgentJARVersion.MAJOR + "." + AgentJARVersion.MINOR + "." + AgentJARVersion.RELEASE;
            if (Ini.DebugVersion) {
                version = version + " debug";
            }
            int index = 0;
            statement.setDouble(++index, applicationId);
            statement.setString(++index, Ini.ServerID);
            statement.setString(++index, Ini.AgentID);
            statement.setString(++index, Ini.AgentName);
            statement.setString(++index, Core.getHostName());
            statement.setDouble(++index, Ini.ProcessID);
            statement.setDouble(++index, Ini.WorkerID);
            statement.setString(++index, version);
            statement.executeUpdate(connection.getSSContext());
        }
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAgentApplication(DatabaseConnection connection, double applicationId) throws SQLException {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        String sql = "delete from " + mtdAgentsTableName + " where ID=?";
        try (PreparedStatement statement = connection.prepareStatement("MetadataNodeReader.deleteAgentApplication", sql);){
            statement.setDouble(1, applicationId);
            statement.executeUpdate(connection.getSSContext());
        }
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteObsoleteAgentApplications(DatabaseConnection connection, double applicationId) {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(mtdAgentsTableName).append(" where ");
        if (applicationId != 0.0) {
            sql.append("ID").append("<>? and ");
        }
        caps.daysBetween(sql, caps.currentDateTime(), agentFieldActivity);
        sql.append(">?");
        try {
            try (PreparedStatement statement = connection.prepareStatement("MetadataNodeReader.deleteObsoleteAgentApplications", sql.toString());){
                int index = 0;
                if (applicationId != 0.0) {
                    statement.setDouble(++index, applicationId);
                }
                statement.setDouble(++index, 0.008333333333333333);
                statement.executeUpdate(connection.getSSContext());
            }
            connection.commit();
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAgentApplicationActivity(DatabaseConnection connection, double applicationId) {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        String sql = "update " + mtdAgentsTableName + " set ACTIVITY=" + caps.currentDateTime() + " where ID = ?";
        try {
            int updateCount;
            try (PreparedStatement statement = connection.prepareStatement("MetadataNodeReader.updateAgentApplicationActivity", sql);){
                statement.setDouble(1, applicationId);
                updateCount = statement.executeUpdate(connection.getSSContext());
            }
            if (updateCount == 0) {
                MetadataNodeReader.createAgentApplication(connection, applicationId);
            }
            connection.commit();
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revokeReplica(SSContext ssContext, double replicaId, double hostNodeId, double hostSessionId) throws SQLException, IOException, InformException, InterruptedException {
        PreparedStatement statement;
        StringBuilder sql;
        DatabaseConnection connection;
        boolean existEntry = false;
        double fldId = 0.0;
        String comment = null;
        DoubleHash<RevokeReplicaParams> nodesParams = new DoubleHash<RevokeReplicaParams>();
        try (Connector.Metabase connector = new Connector.Metabase();){
            connection = connector.connection();
            sql = new StringBuilder();
            sql.append("select ");
            sql.append("ID");
            sql.append(", ").append("NODE_ID");
            sql.append(", ").append(historyFieldEntryComment);
            sql.append(" from ").append(mtdTreeLogTableName);
            sql.append(" where ").append(fieldReplId).append("=?");
            sql.append(" order by ").append("ID").append(" desc");
            statement = connection.prepareStatement("Replications.revokePex select #1", sql.toString());
            try {
                statement.setDouble(1, replicaId);
                ResultSet resultSet = statement.executeQuery(ssContext);
                while (resultSet.next()) {
                    fldId = resultSet.getDouble(1);
                    double nodeId = resultSet.getDouble(2);
                    comment = resultSet.getString(3);
                    if (nodeId > 0.0 && nodesParams.get(nodeId) == null) {
                        RevokeReplicaParams params = new RevokeReplicaParams();
                        params.nodeId = nodeId;
                        params.fieldId = fldId;
                        params.comment = comment;
                        nodesParams.add(params);
                    }
                    existEntry = true;
                }
            }
            finally {
                statement.close();
            }
        }
        if (!existEntry || nodesParams.empty()) {
            return;
        }
        for (RevokeReplicaParams par : nodesParams) {
            existEntry = false;
            String nodeName = "";
            String attrsStr = null;
            double parentId = -1.0;
            byte[] content = Empty.byteArray;
            int code = 0;
            double modContentTime = 0.0;
            double modAttrsTime = 0.0;
            double modUserId = 0.0;
            int nodeType = -1;
            connector = new Connector.Metabase();
            try {
                connection = connector.connection();
                sql = new StringBuilder();
                sql.append("select ");
                sql.append(fieldParentId);
                sql.append(", ").append(fieldNodeName);
                sql.append(", ").append(fieldRawContent);
                sql.append(", ").append("OP_CODE");
                sql.append(", ").append(fieldAttributesB64);
                sql.append(", ").append(fieldModificationContentTime);
                sql.append(", ").append(fieldModificationUserId);
                sql.append(", ").append(fieldModificationAttributeTime);
                sql.append(", ").append(fieldNodeType);
                sql.append(" from ").append(mtdTreeLogTableName);
                sql.append(" where ").append("ID").append("<?");
                sql.append(" and ").append("NODE_ID").append("=?");
                sql.append(" and (").append(fieldReplId).append(" is null or ").append(fieldReplId).append("<>?)");
                sql.append(" order by ").append("ID").append(" desc");
                statement = connection.prepareStatement("Replications.revokePex select #2", sql.toString());
                try {
                    statement.setDouble(1, par.fieldId);
                    statement.setDouble(2, par.nodeId);
                    statement.setDouble(3, replicaId);
                    ResultSet resultSet = statement.executeQuery(ssContext);
                    if (resultSet.next()) {
                        int i = 1;
                        parentId = resultSet.getDouble(i++);
                        nodeName = resultSet.getString(i++);
                        content = resultSet.getBlobBytes(i++);
                        code = resultSet.getInt(i++);
                        attrsStr = resultSet.getString(i++);
                        modContentTime = resultSet.getDateTime(i++);
                        modUserId = resultSet.getDouble(i++);
                        modAttrsTime = resultSet.getDateTime(i++);
                        nodeType = resultSet.getAsInteger(i++);
                        existEntry = true;
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                connector.close();
            }
            if (content == null) {
                content = Empty.byteArray;
            }
            boolean createdInPex = false;
            if (!existEntry && nodeType != 1 && nodeType != 6 && nodeType != 7 && nodeType != 8) {
                String oldName = MetadataNodeReader.revokePex_createdInPex(ssContext, par.fieldId, par.nodeId);
                if (Strings.isVoid(oldName)) continue;
                createdInPex = true;
                parentId = 1.0;
                nodeName = oldName;
            }
            if (code != 4 && !createdInPex) {
                connector = new Connector.Metabase();
                try {
                    connection = connector.connection();
                    sql = new StringBuilder();
                    sql.append("select ");
                    sql.append(fieldRawContent);
                    sql.append(", ").append(fieldModificationContentTime);
                    sql.append(", ").append(fieldModificationUserId);
                    sql.append(" from ").append(mtdTreeLogTableName);
                    sql.append(" where ").append("ID").append("<?");
                    sql.append(" and ").append("NODE_ID").append("=?");
                    sql.append(" and (").append(fieldReplId).append(" is null or ").append(fieldReplId).append("<>?)");
                    sql.append(" and ").append("OP_CODE").append("=?");
                    sql.append(" order by ").append("ID").append(" desc");
                    statement = connection.prepareStatement("Replications.revokePex select #3", sql.toString());
                    try {
                        statement.setDouble(1, par.fieldId);
                        statement.setDouble(2, par.nodeId);
                        statement.setDouble(3, replicaId);
                        statement.setInt(4, 4);
                        ResultSet resultSet = statement.executeQuery(ssContext);
                        if (resultSet.next()) {
                            int i = 1;
                            content = resultSet.getBlobBytes(i++);
                            modContentTime = resultSet.getDateTime(i++);
                            modUserId = resultSet.getDouble(i++);
                        }
                    }
                    finally {
                        statement.close();
                    }
                }
                finally {
                    connector.close();
                }
            }
            if (content == null) {
                content = Empty.byteArray;
            }
            connector = new Connector.Metabase();
            try {
                connection = connector.connection();
                sql = new StringBuilder();
                sql.append("update ").append(mtdTreeTableName);
                sql.append(" set ");
                sql.append(fieldParentId).append("=?,");
                sql.append(fieldNodeName).append("=?,");
                sql.append(fieldRawContent).append("=?,");
                sql.append(fieldAttributesB64).append("=?,");
                sql.append(fieldModificationContentTime).append("=?,");
                sql.append(fieldModificationUserId).append("=?,");
                sql.append(fieldModificationAttributeTime).append("=?,");
                sql.append(fieldContentAttrB64).append("=?,");
                sql.append(fieldReplId).append("=? ");
                sql.append(" where ").append("ID").append("=?");
                byte[] ca = nodeType == 12 ? TableNode.generateContentAttr(par.nodeId, modContentTime, content) : null;
                String ca64 = null;
                if (ca != null) {
                    ca64 = Base64BinString.Encode(ca);
                }
                statement = connection.prepareStatement("Replications.revokePex update", sql.toString());
                try {
                    int i = 1;
                    statement.setDouble(i++, parentId);
                    statement.setString(i++, nodeName);
                    statement.setBlob(i++, content);
                    statement.setString(i++, attrsStr);
                    statement.setDateTime(i++, modContentTime);
                    statement.setDouble(i++, modUserId);
                    statement.setDateTime(i++, modAttrsTime);
                    if (Strings.isVoid(ca64)) {
                        statement.setNull(i++, SqlDataType.STRING);
                    } else {
                        statement.setString(i++, ca64);
                    }
                    statement.setNull(i++, SqlDataType.DOUBLE);
                    statement.setDouble(i++, par.nodeId);
                    statement.executeUpdate(null);
                }
                finally {
                    statement.close();
                }
                Object commentStr = Strings.isVoid(par.comment) ? "\u041e\u0442\u043c\u0435\u043d\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438" : "\u041e\u0442\u043c\u0435\u043d\u0430 \"" + par.comment + "\"";
                MtdEngine.registerMtdOperation(null, connection, par.nodeId, hostNodeId, hostSessionId, (String)commentStr, 4, true, 0);
                connection.commit();
                try (ClosableResult closableResult = MetadataNodeReader.getResultSetForNode(null, par.nodeId, connection, false);){
                    MtdEngine.sync(closableResult, System.currentTimeMillis(), MtdEngine.getMtdCache());
                    connection.commit();
                }
            }
            finally {
                connector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String revokePex_createdInPex(SSContext ssContext, double fldId, double nodeId) throws SQLException {
        try (Connector.Metabase connector = new Connector.Metabase();){
            DatabaseConnection connection = connector.connection();
            StringBuilder sql = new StringBuilder();
            sql.append("select ");
            sql.append(fieldNodeName);
            sql.append(" from ").append(mtdTreeLogTableName);
            sql.append(" where ").append("ID").append("<?");
            sql.append(" and ").append("NODE_ID").append("=?");
            sql.append(" and ").append("OP_CODE").append("=?");
            sql.append(" order by ").append("ID").append(" desc");
            try (PreparedStatement statement = connection.prepareStatement("Replications.revokePex createdInPex", sql.toString());){
                statement.setDouble(1, fldId);
                statement.setDouble(2, nodeId);
                statement.setInt(3, 1);
                ResultSet resultSet = statement.executeQuery(ssContext);
                if (resultSet.next()) {
                    String string = resultSet.getString(1);
                    return string;
                }
            }
        }
        return null;
    }

    public static class ConfNode {
        public double id;
        public double userId;
        public String name;
        public byte[] content;

        public ConfNode(double userId, String name) {
            this.id = Core.generateId();
            this.userId = userId;
            this.name = name;
            this.content = Empty.byteArray;
        }

        public ConfNode(double id, double userId, String name) {
            this.id = id;
            this.userId = userId;
            this.name = name;
            this.content = Empty.byteArray;
        }

        public ConfNode(double id, byte[] content) {
            this.id = id;
            this.name = null;
            this.content = content == null ? Empty.byteArray : content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfNode(double id, DatabaseConnection connection) throws SQLException {
            try (PreparedStatement statement = connection.prepareStatement("ConfNode.ConfNode(id):", "select CONF_USER, CONF_CONTENT from " + mtdConfNodesTableName + " where ID=?");){
                statement.setDouble(1, id);
                try (ResultSet resultSet = statement.executeQuery(null);){
                    this.id = id;
                    if (resultSet.next()) {
                        this.userId = resultSet.getAsDouble(1);
                        this.content = resultSet.getBlobBytes(2);
                        if (resultSet.wasNull() || this.content == null) {
                            this.content = Empty.byteArray;
                        }
                    } else {
                        this.content = Empty.byteArray;
                    }
                }
            }
            connection.commit();
        }

        public void create(DatabaseConnection connection) throws SQLException {
            try (PreparedStatement statement = connection.prepareStatement("ConfNode.create", "insert into " + mtdConfNodesTableName + " (ID, CONF_USER, CONF_NAME) values (?,?,?)");){
                statement.setDouble(1, this.id);
                statement.setDouble(2, this.userId);
                statement.setString(3, this.name);
                statement.executeUpdate(null);
            }
            connection.commit();
        }

        public void update(DatabaseConnection connection) throws SQLException {
            try (PreparedStatement statement = connection.prepareStatement("ConfNode.update", "update " + mtdConfNodesTableName + " set CONF_CONTENT=? where ID = ?");){
                if (this.content == null) {
                    this.content = Empty.byteArray;
                }
                statement.setBlob(1, this.content);
                statement.setDouble(2, this.id);
                statement.executeUpdate(null);
            }
            connection.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ArrayList<ConfNode> selectUserConf(double userId, DatabaseConnection connection) throws SQLException {
            ArrayList<ConfNode> confNodes = new ArrayList<ConfNode>();
            try (PreparedStatement statement = connection.prepareStatement("ConfNode.selectUserConf", "select ID, CONF_NAME from " + mtdConfNodesTableName + " where CONF_USER=? order by id asc");){
                statement.setDouble(1, userId);
                try (ResultSet resultSet = statement.executeQuery(null);){
                    while (resultSet.next()) {
                        confNodes.add(new ConfNode(resultSet.getAsDouble(1), userId, resultSet.getString(2)));
                    }
                }
            }
            connection.commit();
            return confNodes;
        }
    }

    public static class NodeChanges
    extends NodeRecordChanges
    implements NodeRecordIntf {
        public boolean isContentChanged = false;

        @Override
        public void setContentAttr(byte[] extAttr) throws InformException {
            this.putString(MetadataNodeReader.fieldContentAttrB64, Base64BinString.Encode(extAttr));
        }

        @Override
        public void setRawAttributes(byte[] rawAttributes) throws InformException {
            this.putString(MetadataNodeReader.fieldAttributesB64, Base64BinString.Encode(rawAttributes));
        }

        @Override
        public void setApplicationId(double applicationId) {
            this.putDouble("APP_ID", applicationId);
        }

        @Override
        public void setApplicationTime(long applicationTime) {
            this.putTimeStamp(MetadataNodeReader.fieldApplicationTime, applicationTime);
        }

        @Override
        public void setCreationTime(long creationTime) {
            this.putTimeStamp("CREATION_TIME", creationTime);
        }

        @Override
        public void setDescription(String description) {
            this.putString(MetadataNodeReader.fieldNodeDescription, description);
        }

        @Override
        public void setIdentName(String identName) {
            this.putString(MetadataNodeReader.fieldIdentName, identName);
        }

        @Override
        public void setModificationAttributeTime(long modificationAttributeTime) {
            this.putTimeStamp(MetadataNodeReader.fieldModificationAttributeTime, modificationAttributeTime);
        }

        @Override
        public void setSessionId(double sessionId) {
            this.putDouble("SESSION_ID", sessionId);
        }

        @Override
        public void setModificationContentTime(long modificationContentTime) {
            this.putTimeStamp(MetadataNodeReader.fieldModificationContentTime, modificationContentTime);
        }

        @Override
        public void setModificationUserId(double modificationUserId) {
            this.putDouble(MetadataNodeReader.fieldModificationUserId, modificationUserId);
        }

        @Override
        public void setName(String name) {
            this.putString(MetadataNodeReader.fieldNodeName, name);
        }

        @Override
        public void setOrderNo(int orderNo) {
            this.putInt(MetadataNodeReader.fieldOrderNo, orderNo);
        }

        @Override
        public void setOwnerId(double ownerId) {
            this.putDouble(MetadataNodeReader.fieldOwnerId, ownerId);
        }

        @Override
        public void setParentId(double parentId) {
            this.putDouble(MetadataNodeReader.fieldParentId, parentId);
        }

        @Override
        public void setType(int type) {
            this.putInt(MetadataNodeReader.fieldNodeType, type);
        }

        public void setId(double id) {
            this.putDouble("ID", id);
        }

        public void setContent(byte[] content) {
            this.putBlob(MetadataNodeReader.fieldRawContent, content);
            this.putNullString(MetadataNodeReader.fieldDslContent);
            this.isContentChanged = true;
        }

        public void setDslContent(String dslContent) {
            this.putNullBlob(MetadataNodeReader.fieldRawContent);
            this.putString(MetadataNodeReader.fieldDslContent, dslContent);
            this.isContentChanged = true;
        }

        @Override
        public void setReplId(double replId) {
            this.putNullDouble(MetadataNodeReader.fieldReplId, replId);
        }

        @Override
        public void setReplNodeId(double replNodeId) {
            this.putNullDouble(MetadataNodeReader.fieldReplNodeId, replNodeId);
        }

        @Override
        public void clear() {
            super.clear();
            this.isContentChanged = false;
        }
    }

    public static class NodeAndType {
        public final double nodeId;
        public final int typeId;

        public NodeAndType(double nodeId, int typeId) {
            this.nodeId = nodeId;
            this.typeId = typeId;
        }
    }

    public static class Children
    extends DoubleList
    implements DoubleHash.Entry {
        public final double id;

        public Children(double id) {
            super(1);
            this.id = id;
        }

        @Override
        public double key() {
            return this.id;
        }
    }

    public static class FieldsIndexes {
        private final int id;
        private final int parentId;
        private final int nodeType;
        private final int nodeName;
        private final int identName;
        private final int nodeDescription;
        private final int ownerId;
        private final int orderNo;
        private final int creationTime;
        private final int modificationAttributeTime;
        private final int modificationContentTime;
        private final int modificationUserId;
        private final int applicationTime;
        private final int applicationId;
        private final int sessionId;
        private final int attributesB64;
        private final int contentAttrB64;
        private final int replId;
        private final int replNodeId;

        public FieldsIndexes(ResultSet resultSet) throws SQLException {
            this.id = resultSet.findColumn("ID");
            this.parentId = resultSet.findColumn(MetadataNodeReader.fieldParentId);
            this.nodeType = resultSet.findColumn(MetadataNodeReader.fieldNodeType);
            this.nodeName = resultSet.findColumn(MetadataNodeReader.fieldNodeName);
            this.identName = resultSet.findColumn(MetadataNodeReader.fieldIdentName);
            this.nodeDescription = resultSet.findColumn(MetadataNodeReader.fieldNodeDescription);
            this.ownerId = resultSet.findColumn(MetadataNodeReader.fieldOwnerId);
            this.orderNo = resultSet.findColumn(MetadataNodeReader.fieldOrderNo);
            this.creationTime = resultSet.findColumn("CREATION_TIME");
            this.modificationAttributeTime = resultSet.findColumn(MetadataNodeReader.fieldModificationAttributeTime);
            this.modificationContentTime = resultSet.findColumn(MetadataNodeReader.fieldModificationContentTime);
            this.modificationUserId = resultSet.findColumn(MetadataNodeReader.fieldModificationUserId);
            this.applicationTime = resultSet.findColumn(MetadataNodeReader.fieldApplicationTime);
            this.applicationId = resultSet.findColumn("APP_ID");
            this.sessionId = resultSet.findColumn("SESSION_ID");
            this.attributesB64 = resultSet.findColumn(MetadataNodeReader.fieldAttributesB64);
            this.contentAttrB64 = resultSet.findColumn(MetadataNodeReader.fieldContentAttrB64);
            this.replId = resultSet.findColumn(MetadataNodeReader.fieldReplId);
            this.replNodeId = resultSet.findColumn(MetadataNodeReader.fieldReplNodeId);
        }
    }

    private static class RevokeReplicaParams
    implements DoubleHash.Entry {
        public double nodeId;
        public double fieldId;
        public String comment;

        private RevokeReplicaParams() {
        }

        @Override
        public double key() {
            return this.nodeId;
        }
    }

    public static class NodeHistoryEntry {
        public double id;
        public double nodeId;
        public double parentId;
        public Timestamp date;
        public double user;
        public int operation;
        public int nodeType;
        public int nodeContentKind;
        public String nodeName;
        public String comment;
        public double replId;
        public double modUserId;
        public Timestamp modContentTime;
        public byte[] acl;
        public int blobSize;
    }
}

