/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.agent.mtd.NodeLock;
import inform.agent.net.Client;
import java.util.HashMap;

public class NodeLockList {
    private final NodeLock key = new NodeLock();
    private HashMap<NodeLock, NodeLock> hashmap = new HashMap();

    public synchronized Client getClient(NodeLock lock) {
        if ((lock = this.hashmap.get(lock)) != null) {
            return lock.client;
        }
        return null;
    }

    public synchronized boolean lock(NodeLock lock) {
        if (this.hashmap.containsKey(lock)) {
            return false;
        }
        this.hashmap.put(lock, lock);
        return true;
    }

    public synchronized void lockChecked(NodeLock lock) {
        NodeLock prevLock = this.hashmap.get(lock);
        if (prevLock != null) {
            prevLock.throwError();
        }
        this.hashmap.put(lock, lock);
    }

    public synchronized NodeLock lockSilent(NodeLock lock) {
        NodeLock prevLock = this.hashmap.get(lock);
        if (prevLock != null) {
            return prevLock;
        }
        this.hashmap.put(lock, lock);
        return null;
    }

    public synchronized void unlock(NodeLock lock) {
        this.hashmap.remove(lock);
    }

    public synchronized void unlockAll(Client client) {
        NodeLock[] locks = new NodeLock[this.hashmap.size()];
        int count = 0;
        for (NodeLock lock : this.hashmap.keySet()) {
            if (lock.client != client) continue;
            locks[count++] = lock;
        }
        for (int i = 0; i < count; ++i) {
            this.hashmap.remove(locks[i]);
        }
    }

    public synchronized boolean isLocked(double nodeId, double lockId) {
        this.key.lockId = lockId;
        this.key.nodeId = nodeId;
        return this.hashmap.containsKey(this.key);
    }
}

