/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeRecordChanges {
    private final ArrayList<Modification> fields = new ArrayList();
    private ArrayList<Modification> blobs = null;

    public Iterator<Modification> iterator() {
        if (this.blobs != null) {
            for (Modification m : this.blobs) {
                this.fields.add(m);
            }
            this.blobs = null;
        }
        return this.fields.iterator();
    }

    public int applyTo(int paramIndex, PreparedStatement statement) throws SQLException {
        assert (this.blobs == null);
        Iterator<Modification> p = this.iterator();
        while (p.hasNext()) {
            Modification modification = p.next();
            modification.value.applyTo(paramIndex, statement);
            ++paramIndex;
        }
        return paramIndex;
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void putInt(String field, int value) {
        this.fields.add(new Modification(field, new SqlParameter().setInteger(value)));
    }

    public void putDouble(String field, double value) {
        this.fields.add(new Modification(field, new SqlParameter().setDouble(value)));
    }

    public void putNullDouble(String field, double value) {
        if (value == 0.0) {
            this.fields.add(new Modification(field, new SqlParameter().setNull(SqlDataType.DOUBLE)));
        } else {
            this.fields.add(new Modification(field, new SqlParameter().setDouble(value)));
        }
    }

    public void putTimeStamp(String field, long value) {
        this.fields.add(new Modification(field, new SqlParameter().setTimestamp(value)));
    }

    public void putString(String field, String value) {
        this.fields.add(new Modification(field, new SqlParameter().setString(value)));
    }

    public void putNullString(String field) {
        this.fields.add(new Modification(field, new SqlParameter().setNull(SqlDataType.STRING)));
    }

    public void putBlob(String field, byte[] value) {
        if (this.blobs == null) {
            this.blobs = new ArrayList();
        }
        this.blobs.add(new Modification(field, new SqlParameter().setBlob(value)));
    }

    public void putNullBlob(String field) {
        this.fields.add(new Modification(field, new SqlParameter().setNull(SqlDataType.BLOB)));
    }

    public void clear() {
        this.fields.clear();
        this.blobs = null;
    }

    public static class Modification {
        public String field;
        public SqlParameter value;

        public Modification(String field, SqlParameter value) {
            this.field = field;
            this.value = value;
        }
    }
}

