/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.agent.Core;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.net.ClientLoginInfo;
import java.sql.SQLException;

public class PersistentSessionEngine {
    public static final int SESSION_MAX_LIFETIME_SECONDS = 34560000;
    private static final String COMMA = ", ";
    private static final String SELECT_USER_ID_HASH_SQL = "SELECT USER_ID, HASH1 FROM " + MetadataNodeReader.mtdPersistentSessionsTableName + " WHERE ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPersistentSession(ClientLoginInfo loginInfo, String userAgent) {
        Connector.Metabase connector = new Connector.Metabase();
        boolean ok = false;
        try {
            ok = PersistentSessionEngine.doInitPersistentSession(connector.connection(), loginInfo, userAgent);
        }
        catch (Throwable e) {
            Object[] formatArgs = new String[]{loginInfo.userName, userAgent, e.toString()};
            Core.logger.error("Couldn't initiate persistent session for {} ({}): {}", formatArgs);
        }
        finally {
            try {
                connector.close();
            }
            catch (SQLException e) {
                Core.logger.error("Couldn't close connector while init persistent session for {} ({})", loginInfo.userName, userAgent);
            }
        }
        if (!ok) {
            Core.logger.error("Couldn't initiate persistent session for {} ({})", loginInfo.userName, userAgent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static UserNode syncLoginInfoAndGetUserNode(ClientLoginInfo loginInfo) {
        UserNode userNode;
        block11: {
            assert (loginInfo.persistentSessionId != 0.0);
            Connector.Metabase connector = new Connector.Metabase();
            userNode = null;
            userNode = PersistentSessionEngine.doSyncLoginInfoAndGetUserNode(connector.connection(), loginInfo);
            try {
                connector.close();
            }
            catch (SQLException e) {
                Object[] formatArgs = new String[]{Double.toString(loginInfo.persistentSessionId), Double.toString(loginInfo.userId), e.toString()};
                Core.logger.error("Error closing connector while sync LoginInfo with PersistentSession {}, user {}: {}", formatArgs);
            }
            break block11;
            catch (Throwable e) {
                Object[] formatArgs;
                try {
                    formatArgs = new String[]{Double.toString(loginInfo.persistentSessionId), Double.toString(loginInfo.userId), e.toString()};
                    Core.logger.error("Error while sync LoginInfo with PersistentSession {}, user {}: {}", formatArgs);
                }
                catch (Throwable throwable) {
                    try {
                        connector.close();
                    }
                    catch (SQLException e2) {
                        Object[] formatArgs2 = new String[]{Double.toString(loginInfo.persistentSessionId), Double.toString(loginInfo.userId), e2.toString()};
                        Core.logger.error("Error closing connector while sync LoginInfo with PersistentSession {}, user {}: {}", formatArgs2);
                    }
                    throw throwable;
                }
                try {
                    connector.close();
                }
                catch (SQLException e3) {
                    formatArgs = new String[]{Double.toString(loginInfo.persistentSessionId), Double.toString(loginInfo.userId), e3.toString()};
                    Core.logger.error("Error closing connector while sync LoginInfo with PersistentSession {}, user {}: {}", formatArgs);
                }
            }
        }
        return userNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserNode doSyncLoginInfoAndGetUserNode(DatabaseConnection connection, ClientLoginInfo loginInfo) throws SQLException {
        UserNode userNode;
        block7: {
            userNode = null;
            try (PreparedStatement statement = connection.prepareStatement("PersistentSessionEngine.Select", SELECT_USER_ID_HASH_SQL);){
                statement.setDouble(1, loginInfo.persistentSessionId);
                ResultSet resultSet = statement.executeQuery(connection.getSSContext());
                if (!resultSet.next()) break block7;
                try {
                    loginInfo.userId = resultSet.getAsDouble(1);
                    loginInfo.persistentSessionH1 = resultSet.getBlobBytes(2);
                    userNode = MtdEngine.getUserNode(loginInfo.userId);
                    if (null == userNode) {
                        throw new SQLException("Sync LoginInfo With PersistentSession failed, no userNode with id " + loginInfo.userId);
                    }
                    loginInfo.userName = userNode.getName();
                }
                finally {
                    resultSet.close();
                }
            }
        }
        return userNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doInitPersistentSession(DatabaseConnection connection, ClientLoginInfo loginInfo, String userAgent) throws SQLException {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(MetadataNodeReader.mtdPersistentSessionsTableName).append(" (").append("ID").append(COMMA).append("USER_ID").append(COMMA).append("HASH1").append(COMMA).append("CREATION_TIME").append(COMMA).append("LAST_LOGIN_TIME").append(COMMA).append("LAST_USER_AGENT").append(") VALUES (?, ?, ?").append(COMMA).append(caps.currentDateTime()).append(COMMA).append(caps.currentDateTime()).append(COMMA).append("?)");
        try (PreparedStatement statement = connection.prepareStatement("PersistentSessionEngine.insertLock", sql.toString());){
            statement.setDouble(1, loginInfo.persistentSessionId);
            statement.setDouble(2, loginInfo.userId);
            statement.setBlob(3, loginInfo.persistentSessionH1);
            statement.setString(4, PersistentSessionEngine.ensureUserAgentLength(userAgent));
            try {
                statement.executeUpdate(connection.getSSContext());
                connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                Core.logger.error(null, e);
                try {
                    connection.rollback();
                }
                catch (Throwable t) {
                    Core.logger.error(null, t);
                }
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void updatePersistentSessionOnLogin(double sessionId, String userAgent) {
        boolean ok;
        block11: {
            Connector.Metabase connector = new Connector.Metabase();
            ok = false;
            ok = PersistentSessionEngine.doUpdatePersistentSessionOnLogin(connector.connection(), sessionId, userAgent);
            try {
                connector.close();
            }
            catch (SQLException e) {
                Object[] formatArgs = new String[]{Double.toString(sessionId), userAgent, e.toString()};
                Core.logger.error("Couldn't close connector while updating persistent session on login {} ({}): {}", formatArgs);
            }
            break block11;
            catch (Throwable e) {
                Object[] formatArgs;
                try {
                    formatArgs = new String[]{Double.toString(sessionId), userAgent, e.toString()};
                    Core.logger.error("Couldn't update persistent session on login {} ({}): {}", formatArgs);
                }
                catch (Throwable throwable) {
                    try {
                        connector.close();
                    }
                    catch (SQLException e2) {
                        Object[] formatArgs2 = new String[]{Double.toString(sessionId), userAgent, e2.toString()};
                        Core.logger.error("Couldn't close connector while updating persistent session on login {} ({}): {}", formatArgs2);
                    }
                    throw throwable;
                }
                try {
                    connector.close();
                }
                catch (SQLException e3) {
                    formatArgs = new String[]{Double.toString(sessionId), userAgent, e3.toString()};
                    Core.logger.error("Couldn't close connector while updating persistent session on login {} ({}): {}", formatArgs);
                }
            }
        }
        if (!ok) {
            Core.logger.error("Couldn't update persistent session on login {} ({})", Double.toString(sessionId), userAgent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doUpdatePersistentSessionOnLogin(DatabaseConnection connection, double sessionId, String userAgent) throws SQLException {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(MetadataNodeReader.mtdPersistentSessionsTableName).append(" SET ").append("LAST_LOGIN_TIME").append('=').append(caps.currentDateTime()).append(COMMA).append("LAST_USER_AGENT").append('=').append('?').append(" WHERE ").append("ID").append("=?");
        try (PreparedStatement statement = connection.prepareStatement("PersistentSessionEngine.UpdateLock", sql.toString());){
            statement.setString(1, PersistentSessionEngine.ensureUserAgentLength(userAgent));
            statement.setDouble(2, sessionId);
            try {
                statement.executeUpdate(connection.getSSContext());
                connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                Core.logger.error(null, e);
                try {
                    connection.rollback();
                }
                catch (Throwable t) {
                    Core.logger.error(null, t);
                }
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePersistentSession(double sessionId) {
        Connector.Metabase connector = new Connector.Metabase();
        boolean ok = false;
        try {
            ok = PersistentSessionEngine.doRemovePersistentSession(connector.connection(), sessionId);
        }
        catch (SQLException e) {
            Core.logger.error("Couldn't remove persistent session for {} ", e.getMessage());
        }
        finally {
            try {
                connector.close();
            }
            catch (SQLException e) {
                Core.logger.error("Error closing connector while removing persistent session for {} ", Double.toString(sessionId));
            }
        }
        if (!ok) {
            Core.logger.error("Couldn't remove persistent session for {} ", Double.toString(sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doRemovePersistentSession(DatabaseConnection connection, double sessionId) throws SQLException {
        DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(MetadataNodeReader.mtdPersistentSessionsTableName).append(" WHERE ").append("ID").append("=?");
        try (PreparedStatement statement = connection.prepareStatement("PersistentSessionEngine.UpdateLock", sql.toString());){
            statement.setDouble(1, sessionId);
            try {
                statement.executeUpdate(connection.getSSContext());
                connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                Core.logger.error(null, e);
                try {
                    connection.rollback();
                }
                catch (Throwable t) {
                    Core.logger.error(null, t);
                }
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    private static String ensureUserAgentLength(String userAgent) {
        if (userAgent.length() <= 512) {
            return userAgent;
        }
        return userAgent.substring(0, 512);
    }
}

