/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.SystemTable;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.scripts.SSContext;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;

public class RolesTable
extends SystemTable {
    private final FieldDescriptor[] fields = new FieldDescriptor[2];
    private FieldDescriptor primaryKey = null;
    private SqlParameter[] values = null;
    public static final int rtfUserId = 0;
    public static final int rtfRoleId = 1;
    public static final int rtfCount = 2;
    private static final SystemTable.SystemFieldDesc[] RTF_DESC = new SystemTable.SystemFieldDesc[]{new SystemTable.SystemFieldDesc("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", keyTypes), new SystemTable.SystemFieldDesc("\u0420\u043e\u043b\u044c", metaTypes)};

    public RolesTable() throws IOException {
        this(((ServerNode)MtdEngine.getValidNode(2.0)).descriptor(), true);
    }

    public RolesTable(boolean throwExceptions) throws IOException {
        this(((ServerNode)MtdEngine.getValidNode(2.0)).descriptor(), throwExceptions);
    }

    public RolesTable(ServerNode.Descriptor descriptor) throws IOException {
        this(descriptor, true);
    }

    public RolesTable(ServerNode.Descriptor descriptor, boolean throwExceptions) throws IOException {
        int rtf;
        assert (RTF_DESC.length == 2);
        byte[] content = descriptor.rolesTable;
        if (content == null || content.length == 0) {
            return;
        }
        TaggedReader in = new TaggedReader(content);
        BitSet loadedRtf = new BitSet();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    double tableId = in.getNodeID();
                    if (tableId == 0.0) {
                        return;
                    }
                    this.table = TableDescriptor.getIfExists(tableId);
                    if (this.table != null) break;
                    if (throwExceptions) {
                        throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 [" + (long)tableId + "]");
                    }
                    return;
                }
                case 2: {
                    if (this.table == null) {
                        return;
                    }
                    rtf = in.getInt();
                    loadedRtf.set(rtf);
                    if (rtf < 0 || this.fields.length <= rtf) break;
                    int fieldId = in.getInt(3);
                    this.fields[rtf] = this.table.getFieldDescriptor(fieldId);
                    break;
                }
                case 4: {
                    this.enabled = in.getBoolean();
                }
            }
        }
        for (rtf = 0; rtf < this.fields.length; ++rtf) {
            FieldDescriptor field = this.fields[rtf];
            SystemTable.SystemFieldDesc d = RTF_DESC[rtf];
            if (field == null) {
                TableDescriptor t = this.table;
                this.table = null;
                if (throwExceptions) {
                    if (loadedRtf.get(rtf)) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0440\u043e\u043b\u0435\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + d.name + " (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + t.toString() + ")");
                    }
                    throw new InformException("\u0412 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0440\u043e\u043b\u0435\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + d.name + " (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + t.toString() + ")");
                }
                return;
            }
            if (d.isValid(field.getType().toInt())) continue;
            TableDescriptor t = this.table;
            this.table = null;
            if (throwExceptions) {
                throw new InformException("\u041f\u043e\u043b\u0435 " + field.getCaption() + "(" + d.name + ") \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0440\u043e\u043b\u0435\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f (\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + t.toString() + ")");
            }
            return;
        }
        this.primaryKey = this.table.getRecordIdField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] select(SSContext ssContext, double userId) throws SQLException {
        if (!this.enabled() || userId == 0.0) {
            return null;
        }
        DoubleSet values = null;
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ");
        sql.append(this.fields[1]);
        sql.append(" from ").appendFull(this.table);
        sql.append(" where ").append(this.fields[0]).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(null, "RolesTable.select by userId");){
            try (PreparedStatement statement = connection.prepareStatement("RolesTable.select by userId", sql.toString());){
                statement.setDouble(1, userId);
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    while (fetch.next()) {
                        double roleId = fetch.getAsDouble(1);
                        if (values == null) {
                            values = new DoubleSet();
                        }
                        values.add(roleId);
                    }
                }
            }
            connection.commit();
        }
        return values == null ? Empty.doubleArray : values.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SSContext ssContext, ServerSideHost ssHost, DatabaseConnection connection, double userId, double[] roles, double[] ids) throws SQLException {
        SqlStringBuilder deleteSql = new SqlStringBuilder();
        deleteSql.append("delete from ").appendFull(this.table).append(" where ").append(this.fields[0]).append("=?");
        SqlStringBuilder insertSql = null;
        if (roles.length != 0) {
            insertSql = new SqlStringBuilder();
            insertSql.append("insert into ").appendFull(this.table).append('(');
            if (this.primaryKey != null) {
                insertSql.append(this.primaryKey).append(", ");
            }
            insertSql.append(this.fields[0]).append(", ").append(this.fields[1]).append(") values (");
            if (this.primaryKey != null) {
                insertSql.append("?,");
            }
            insertSql.append("?,?)");
        }
        try (PreparedStatement deleteStatement = connection.prepareStatement("RolesTable.update delete", deleteSql.toString());){
            deleteStatement.setQueryTimeout();
            deleteStatement.setTableDesc(this.table);
            deleteStatement.setDouble(1, userId);
            deleteStatement.executeUpdate(ssContext);
        }
        if (roles.length == 0) {
            return;
        }
        try (PreparedStatement insertStatement = connection.prepareStatement("RolesTable.update insert", insertSql.toString());){
            deleteStatement.setQueryTimeout();
            for (int i = 0; i < roles.length; ++i) {
                if (i != 0) {
                    insertStatement.addBatch();
                }
                int index = 0;
                if (this.primaryKey != null) {
                    insertStatement.setDouble(++index, ids[index]);
                }
                insertStatement.setDouble(++index, userId);
                insertStatement.setDouble(++index, roles[index]);
            }
            deleteStatement.executeUpdate(ssContext);
        }
    }

    public FieldDescriptor field(int rtf) {
        return this.fields[rtf];
    }

    public FieldDescriptor primaryKey() {
        return this.primaryKey;
    }
}

