/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyInt;
import java.io.IOException;

public class DConstraints
extends DObject {
    public final DPropertyInt minWidth = new DPropertyInt(this, "minWidth", 32768, 0);
    public final DPropertyInt minHeight = new DPropertyInt(this, "minHeight", 32768, 0);
    public final DPropertyInt maxWidth = new DPropertyInt(this, "maxWidth", 32768, 0);
    public final DPropertyInt maxHeight = new DPropertyInt(this, "maxHeight", 32768, 0);

    public DConstraints(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public boolean isDefault() {
        for (DProperty property : this.properties) {
            if (!(property instanceof DPropertyInt) || ((DPropertyInt)property).value == 0) continue;
            return false;
        }
        return this.checkPropOptions(2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        in.checkCurrentTag(10, 16);
        byte[] content = in.getRaw();
        int offset = 0;
        this.maxWidth.setValue(LittleEndian.getInt(content, offset));
        this.maxHeight.setValue(LittleEndian.getInt(content, offset += 4));
        this.minWidth.setValue(LittleEndian.getInt(content, offset += 4));
        this.minHeight.setValue(LittleEndian.getInt(content, offset += 4));
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        int offset = 0;
        byte[] raw = new byte[16];
        LittleEndian.setInteger(this.maxWidth.value, raw, offset);
        LittleEndian.setInteger(this.maxHeight.value, raw, offset += 4);
        LittleEndian.setInteger(this.minWidth.value, raw, offset += 4);
        LittleEndian.setInteger(this.minHeight.value, raw, offset += 4);
        out.putRaw(tag, raw, 16);
    }
}

