/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.agent.mtd.obj.DColors;
import inform.agent.mtd.obj.DComponent;
import inform.agent.mtd.obj.DConstraints;
import inform.agent.mtd.obj.DControls;
import inform.agent.mtd.obj.DFont;
import inform.agent.mtd.obj.DMargins;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyAction;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DRanking;
import java.util.ArrayList;

public abstract class DControl
extends DComponent {
    protected DControl parent = null;
    protected final DPropertyAction action = new DPropertyAction(this, "action");
    protected DControls children = new DControls(this, "children");
    protected final DPropertyInt x = new DPropertyInt(this, "x", 32768);
    protected final DPropertyInt y = new DPropertyInt(this, "y", 32896);
    protected final DPropertyInt width = new DPropertyInt(this, "width", 32768);
    protected final DPropertyInt height = new DPropertyInt(this, "height", 32896);
    protected final DPropertyEnum color = new DPropertyEnum(this, "color", 49154, 0x1FFFFFFF, DColors.VALUES, DColors.NAMES);
    protected final DPropertyBool parentColor = new DPropertyBool(this, "parentColor", 4098, false);
    protected final DConstraints constraints = new DConstraints(this, "constraints");
    protected final DFont font = new DFont(this, "font");
    protected final DPropertyBool parentFont = new DPropertyBool(this, "parentFont", 4102, false);
    protected final DMargins margins = new DMargins(this, "margins");
    protected final DPropertyBool alignWithMargins = new DPropertyBool(this, "alignWithMargins", 8194, false);
    protected final DRanking ranking = new DRanking(this, "ranking");

    public DControl() {
        super(true);
        this.font.setStorableBy(this.parentFont, false);
        this.parentFont.value = true;
        this.margins.setStorableBy(this.alignWithMargins, true);
    }

    public DControl parent() {
        return this.parent;
    }

    public void setParent(DControl parent) {
        if (this.parent == parent) {
            return;
        }
        DControl oldParent = this.parent;
        this.parent = parent;
        if (oldParent != null) {
            oldParent.children.remove(this);
        }
        if (this.parent != null) {
            this.parent.children.add(this);
        }
        this.color.setStorableBy(this.parentColor, false);
        this.font.setStorableBy(this.parentFont, false);
    }

    @Override
    public ArrayList<DComponent> getChildren() {
        return new ArrayList<DComponent>(this.children.getComponents());
    }

    public void getPublicIds(ArrayList<DProperty> publicIds) {
        if (!this.scriptName.isEmpty()) {
            publicIds.add(this);
        }
        for (DProperty property : this.children.properties) {
            if (!(property instanceof DControl)) continue;
            ((DControl)property).getPublicIds(publicIds);
        }
    }
}

