/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyRaw;
import inform.agent.mtd.obj.DPropertyString;
import java.io.IOException;

public class DParametersSchemeAction
extends DArray {
    public DParametersSchemeAction(DProperty object) {
        super(object, "schemeActionParameters", 2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DParameterSchemeAction item = new DParameterSchemeAction(this);
        item.loadTaggedContent(in);
        this.properties.add(item);
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DParameterSchemeAction)) continue;
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter subOut = new TaggedWriter(data);
            DParameterSchemeAction schemeAction = (DParameterSchemeAction)p;
            schemeAction.storeTaggedContent(subOut);
            subOut.flush();
            if (data.size() == 0) continue;
            out.putRaw(60, data);
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DParameterSchemeAction item = new DParameterSchemeAction(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DParametersSchemeAction.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DParametersSchemeAction)source).properties) {
                if (!DParametersSchemeAction.checkAssignType(sourceProperty, DParameterSchemeAction.class)) continue;
                DParameterSchemeAction sourceSa = (DParameterSchemeAction)sourceProperty;
                DParameterSchemeAction sa = new DParameterSchemeAction(this);
                sa.assign(sourceSa);
                this.properties.add(sa);
            }
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DParameterSchemeAction(this);
    }

    public static class DParameterSchemeAction
    extends DObject {
        protected final DPropertyRaw action = new DPropertyRaw(this, "actionID");
        protected final DPropertyString name = new DPropertyString(this, "name", 0x200002);
        protected final DPropertyString hint = new DPropertyString(this, "hint", 0x200002);
        protected final DPropertyString caption = new DPropertyString(this, "caption", 0x200002);
        protected final DPropertyInt datasource = new DPropertyInt(this, "datasourceID", 32770);
        protected final DPropertyDouble binding = new DPropertyDouble(this, "bindingNodeID", 2);
        protected final DPropertyBool automaticMode = new DPropertyBool(this, "automaticMode", 32770);
        protected final DPropertyInt id = new DPropertyInt(this, "id", 32770);

        public DParameterSchemeAction(DProperty object) {
            super(object, null, 32);
        }

        @Override
        public void loadTaggedContent(TaggedReader in) throws IOException {
            int tag;
            block10: while ((tag = in.getNextTag()) != 0) {
                switch (tag) {
                    case 61: {
                        this.name.loadTaggedContent(in);
                        continue block10;
                    }
                    case 62: {
                        this.datasource.loadTaggedContent(in);
                        continue block10;
                    }
                    case 63: {
                        this.binding.loadTaggedContent(in);
                        continue block10;
                    }
                    case 64: {
                        this.automaticMode.loadTaggedContent(in);
                        continue block10;
                    }
                    case 65: {
                        this.id.loadTaggedContent(in);
                        continue block10;
                    }
                    case 67: {
                        this.hint.loadTaggedContent(in);
                        continue block10;
                    }
                    case 68: {
                        this.caption.loadTaggedContent(in);
                        continue block10;
                    }
                    case 66: {
                        this.action.loadTaggedContent(in);
                        continue block10;
                    }
                }
            }
        }

        @Override
        public void storeTaggedContent(TaggedWriter out) throws IOException {
            this.name.storeTaggedContentAs(61, out);
            this.hint.storeTaggedContentAs(67, out);
            this.caption.storeTaggedContentAs(68, out);
            this.datasource.storeTaggedContentAs(62, out);
            this.binding.storeTaggedContentAs(63, out);
            this.automaticMode.storeTaggedContentAs(64, out);
            this.id.storeTaggedContentAs(65, out);
            this.action.storeTaggedContentAs(66, out);
        }
    }
}

