/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.DateTime;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyValues;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DPropertyDateTime
extends DPropertyDouble {
    public DPropertyDateTime(DProperty object, String name, int propOptions) {
        super(object, name, propOptions);
    }

    public DPropertyDateTime(DProperty object, String name, int propOptions, double defaultValue) {
        super(object, name, propOptions, defaultValue);
    }

    @Override
    public void loadScriptValue(Object obj) {
        if (obj instanceof String) {
            String stringValue = (String)obj;
            SimpleDateFormat format = DPropertyValues.createFormat(stringValue);
            ParsePosition position = new ParsePosition(0);
            Date date = format.parse(stringValue, position);
            if (position.getIndex() != 0) {
                this.value = DateTime.fromUnixTime(date.getTime());
            }
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyDateTime.addComma(DPropertyDateTime.addComment(DPropertyDateTime.addTextShiftLn(textOptions, out, level).append(this.name).append(": ").append('\"').append(DPropertyValues.createFormat(this.value).format(ValueCaster.toDate(this.value))).append('\"'), this.getComment()), needComma);
        return 1;
    }
}

