/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.obj.DActualPoint;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyMetadataNode;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.search.DSearchEntries;
import inform.agent.mtd.obj.search.DSearchEntryDatabaseOptions;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public abstract class DSearchEntry
extends DObject {
    public static final String[] KIND_NAMES = new String[]{"table", "union", "directory", "error", "none", "search"};
    public static final String[] JOIN_TYPE = new String[]{"inner", "leftOuter"};
    protected double tableId = 0.0;
    protected final DSearchEntry parent;
    protected final DPropertyInt entryId = new DPropertyInt(this, "entryId", 32768);
    protected final DPropertyMetadataNode node = new DPropertyMetadataNode(this, "node");
    protected final DPropertyString scriptName = new DPropertyString(this, "name", 0x200002);
    protected final DPropertyString description = new DPropertyString(this, "description", 0x200002);
    protected final DPropertyBool excludeUnusedFields = new DPropertyBool(this, "excludeUnusedFields", 4098);
    protected final DPropertyBool excludable = new DPropertyBool(this, "excludable", 8194, true);
    protected final DPropertyBool excludableByCondition = new DPropertyBool(this, "excludableByCondition", 8194, true);
    protected final DSearchEntryDatabaseOptions databaseOptions = new DSearchEntryDatabaseOptions(this, "databaseOptions");
    protected final DActualPoint actualPoint = new DActualPoint(this, "actualPoint");
    protected final DSearchEntries entries = new DSearchEntries((DProperty)this, "children", false);

    public DSearchEntry(DProperty object, String name) {
        super(object, name, 0);
        this.parent = null;
        this.tableId = this.tableId;
    }

    public DSearchEntry(DProperty object, DSearchEntry parent, int entryId, double tableId) {
        super(object, null, 32);
        this.parent = parent;
        this.tableId = tableId;
        this.node.setValue(tableId);
        this.entryId.setValue(entryId);
    }

    public DSearchEntry(DProperty object, DSearchEntry parent, int entryId, double tableId, double searchId) {
        super(object, null, 32);
        this.parent = parent;
        this.tableId = tableId;
        this.node.setValue(searchId == 0.0 ? tableId : searchId);
        this.entryId.setValue(entryId);
    }

    public abstract int entryKind();

    public void updateTableId() {
        if (this.node.getValue() == 0.0) {
            return;
        }
        Node node = MtdEngine.getValidNode(this.node.getValue());
        if (node.getType() == 12) {
            this.tableId = this.node.getValue();
        } else {
            try {
                this.tableId = SqlGenerator.extractRootTabled(MtdEngine.getNodeContent(this.node.getValue()));
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }
    }

    public DSearchEntry findEntry(int entryId) {
        return this.entryId.getValue() == entryId ? this : this.entries.findEntry(entryId);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 2: {
                break;
            }
            case 4: {
                this.description.loadTaggedContent(in);
                break;
            }
            case 17: {
                TaggedReader stream = in.getSubStreamReader();
                block13: while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            this.databaseOptions.oracle.joinType.loadTaggedContent(in);
                            continue block13;
                        }
                        case 2: {
                            this.databaseOptions.oracle.index.loadTaggedContent(in);
                            continue block13;
                        }
                    }
                    this.databaseOptions.addUnhandled().loadTaggedContent(in);
                }
                break;
            }
            case 11: {
                this.excludableByCondition.loadTaggedContent(in);
                break;
            }
            case 14: {
                this.excludeUnusedFields.loadTaggedContent(in);
                break;
            }
            case 15: {
                this.excludable.loadTaggedContent(in);
                break;
            }
            case 12: {
                this.actualPoint.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            default: {
                this.addUnhandled().loadTaggedContent(in);
            }
        }
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        if (obj.has(this.node.getPropName(), null)) {
            this.node.loadScriptValue(obj.get(this.node.getPropName(), null));
            this.updateTableId();
        }
        super.loadScriptContent(obj);
    }

    protected void storeEntryTags(TaggedWriter out) throws IOException {
        this.entries.store(out);
    }

    protected void storeReturnedFields(TaggedWriter out) throws IOException {
    }

    protected final void store(TaggedWriter out) throws IOException {
        int kind = this.entryKind();
        byte[] raw = new byte[8];
        LittleEndian.setInteger(this.entryId.getValue(), raw, 0);
        LittleEndian.setInteger(kind, raw, 4);
        out.putRaw(1, raw);
        this.node.storeTaggedContentAs(151, out);
        this.description.storeTaggedContentAs(4, out);
        this.storeEntryTags(out);
        this.databaseOptions.storeTaggedContentAsNonEmptyStream(17, out);
        TableDescriptor table = TableDescriptor.getIfExists(this.tableId);
        if (table != null && table.isHasPeriodicStorage()) {
            this.actualPoint.storeTaggedContentAsNonEmptyStream(12, out);
        }
        this.storeReturnedFields(out);
        this.excludeUnusedFields.storeTaggedContentAs(14, out);
        this.excludable.storeTaggedContentAs(15, out);
        this.excludableByCondition.storeTaggedContentAs(11, out);
        out.putEmpty(2);
    }

    protected final void storeAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.store(stream);
        stream.flush();
        out.putEmpty(tag);
        out.putRaw(202, data.internalBuffer(), data.size());
    }
}

