/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyValue;
import inform.agent.mtd.obj.search.DPropertySearchEntry;
import inform.agent.mtd.obj.search.DPropertySearchField;
import inform.agent.mtd.obj.search.DSearchEntry;
import inform.agent.mtd.obj.search.DSearchEntryHolder;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchFieldBind
extends DSearchEntryHolder {
    protected boolean ingnored = true;
    protected final DPropertySearchField field = new DPropertySearchField((DProperty)this, "field", 0, this.entry);
    protected final DPropertySearchField parameterBind = new DPropertySearchField((DProperty)this, "parameterBind", 32770, DPropertySearchField.Kind.Parameter);
    protected final DPropertySearchEntry entryBind = new DPropertySearchEntry(this, "entryBind", 2);
    protected final DPropertySearchField fieldBind = new DPropertySearchField((DProperty)this, "fieldBind", 2, this.entryBind);
    protected final DPropertyValue value = new DPropertyValue(this, "value", 0);

    public DSearchFieldBind(DProperty object, DSearchEntry entry) {
        super(object, null, 32, entry);
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        if (obj.has(this.field.getPropName(), null)) {
            FieldDescriptor field;
            int fieldId = ValueCaster.toInt(obj.get(this.field.getPropName(), null));
            TableDescriptor table = TableDescriptor.getIfExists(this.field.entry.tableId);
            if (table != null && (field = table.getFieldDescriptor(fieldId)) != null) {
                this.value.setDataType(field.getType());
            }
        }
        super.loadScriptContent(obj);
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        this.field.storeTaggedContentAs(1, out);
        if (this.parameterBind.getValue() != 0) {
            this.parameterBind.storeTaggedContentAs(2, out);
        } else if (this.fieldBind.getValue() != 0) {
            this.fieldBind.storeTaggedContentAs(4, out);
            this.entryBind.storeTaggedContentAs(12, out);
        } else {
            switch (this.value.getType()) {
                case Integer: {
                    out.putInt32(7, ValueCaster.toInt(this.value.getValue()));
                    break;
                }
                case Double: {
                    out.putDouble(8, ValueCaster.toDouble(this.value.getValue()));
                    break;
                }
                case Date: {
                    out.putDouble(10, ValueCaster.toDouble(this.value.getValue()));
                    break;
                }
                case String: {
                    out.putString(9, ValueCaster.toString(this.value.getValue()));
                    break;
                }
                default: {
                    out.putEmpty(11);
                }
            }
        }
    }
}

