/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.NodeStatus;
import java.sql.SQLException;

public class CreateUser
extends Request {
    public CreateUser(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        UsersTable usersTable;
        TaggedReader in = this.createRequestContentReader();
        double parentId = 0.0;
        String name = "";
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 3: {
                    parentId = in.getDouble();
                    break;
                }
                case 4: 
                case 33: {
                    name = in.getAnsi();
                }
            }
        }
        if (name.isEmpty()) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        }
        double nodeId = Core.generateId();
        RequestResult result = new RequestResult(this);
        TaggedWriter out = result.getWriter();
        if (MtdEngine.serverNode().descriptor().useUsersTable && (usersTable = new UsersTable()).enabled()) {
            usersTable.insertUser(this.ssContext, this, nodeId, name, parentId);
            out.putDouble(1, nodeId);
            result.sendResult();
            return;
        }
        if (nodeId != 0.0 && MtdEngine.getNode(nodeId) != null) {
            throw new InformException("\u0423\u0437\u0435\u043b \u0441 \u0442\u0430\u043a\u0438\u043c id \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        if (parentId == 0.0) {
            parentId = this.getRootNodeID();
        }
        BasicNode parentNode = MtdEngine.getValidTranslatedNode(parentId);
        this.checkNodeAccess(parentNode, 0x10000000, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0437\u043b\u0430");
        try (Connector.Metabase connector = new Connector.Metabase();){
            name = parentNode.getNewChildName(connector, name);
            parentId = parentNode.getId();
            NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
            record.setId(nodeId);
            record.setParentId(parentId);
            record.setType(3);
            record.setDescription("");
            record.setOwnerId(this.getUserID());
            record.setModificationUserId(this.getUserID());
            record.setSessionId(this.getSessionID());
            record.setCreationTime(System.currentTimeMillis());
            record.setOrderNo(parentNode.getNewOrderNo(connector));
            Node node = MtdCache.createNodeInstance(record);
            assert (node != null);
            Node.CreationArg arg = new Node.CreationArg();
            arg.name = name;
            node.afterCreateNew(arg);
            node.setModificationAttributeTime(System.currentTimeMillis());
            out.putDouble(1, node.getId());
            try {
                MtdEngine.createNewNode(null, connector, node, null);
            }
            catch (SQLException ex) {
                throw InformException.wrap(ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0443\u0437\u043b\u0430");
            }
        }
        result.sendResult();
    }
}

