/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.ConstantsNode;
import java.io.IOException;

public class GetActualConstantsForAccount
extends Request {
    public GetActualConstantsForAccount(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    public static byte[] getActualConstants(double nodeId, ServerSideHost host) throws InformException, IOException, TaggedReaderException {
        if (nodeId == 0.0) {
            nodeId = host.security().id;
        } else {
            BasicNode node = MtdEngine.getTranslatedNode(nodeId);
            if (node != null && node.getType() == 53) {
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                TaggedWriter out = new TaggedWriter(result);
                IntegerSet complete = new IntegerSet();
                TaggedReader reader = new TaggedReader(node.getContent());
                TaggedReader in = null;
                while (reader.next()) {
                    if (reader.getCurrentTag() != 26) continue;
                    in = reader.getStreamReader();
                    break;
                }
                if (in != null) {
                    while (in.next()) {
                        int constId = in.getInt(19);
                        complete.add(constId);
                        out.putInt32(19, constId);
                        in.transferTag(out);
                    }
                }
                ConstantsNode.getActualContstants(out, complete);
                out.flush();
                return result.toByteArray();
            }
        }
        AccountNode accountNode = MtdEngine.getValidAccountNode(nodeId);
        return accountNode.getActualConstants();
    }

    @Override
    public void execute() throws Throwable {
        double nodeId = this.getNodeID();
        this.sendResult(GetActualConstantsForAccount.getActualConstants(nodeId, this));
    }
}

