/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;

public class GetConfiguration
extends Request {
    public static final int TAG_CONF_TYPE = 1;
    private int confType = 0;

    public GetConfiguration(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    void parseRequestParams() throws Throwable {
        TaggedReader reader = this.createRequestContentReader();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.confType = reader.getInt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        byte[] confContent = null;
        try (Connector.Metabase db = new Connector.Metabase();){
            this.parseRequestParams();
            double nodeId = this.rq.nodeId;
            double userId = this.getUserID();
            try (PreparedStatement stmt = db.connection().prepareStatement("GetConfiguration", "SELECT id, conf_content FROM " + MetadataNodeReader.mtdConfTableName + " WHERE conf_user=? AND node_id=? AND conf_type=?");){
                stmt.setDouble(1, userId);
                stmt.setDouble(2, nodeId);
                stmt.setInt(3, this.confType);
                try (ResultSet rs = stmt.executeQuery(null);){
                    if (rs.next()) {
                        double recId = rs.getDouble(1);
                        confContent = rs.getBlobBytes(2);
                    }
                }
            }
        }
        if (confContent != null) {
            this.sendResult(confContent);
        }
    }
}

