/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.GetNodeContent;
import inform.common.Empty;
import java.util.zip.Adler32;

public class GetMultipleNodeContents
extends Request {
    private static final int GMNC_KIND_CONTENT = 1;
    private static final int GMNC_KIND_CONTENT_IF_MODIFIED = 2;
    private static final int GMNC_KIND_CONF = 3;
    private static final int GMNC_KIND_NODE_INFO = 4;
    private static final int TAG_GMNC_KIND = 1;
    private static final int TAG_GMNC_TRANSLATE = 2;
    private static final int TAG_GMNC_CONTENT_ADLER32 = 3;
    private static final int TAG_GMNC_CONTENT_SIZE = 4;
    private static final int TAG_GMNC_NODE_ID = 5;
    private static final int TAG_GMNC_RESULT_NODE_ID = 1;
    private static final int TAG_GMNC_RESULT_CONTENT_UNCHANGED = 2;
    private static final int TAG_GMNC_RESULT_CONTENT = 3;
    private static final int TAG_GMNC_RESULT_CONTENT_TIME = 4;
    private static final int TAG_GMNC_RESULT_NODE_INFO_ID = 5;
    private static final int TAG_GMNC_RESULT_NODE_INFO = 6;
    private static final int TAG_GMNC_RESULT_ERROR_TEXT = 7;
    private static final int TAG_GMNC_RESULT_ERROR_DETAILING = 8;
    private static final int TAG_GMNC_RESULT_TRANSLATED_NODE_ID = 9;
    private static final int TAG_GMNC_RESULT_REAL_NODE_ID = 10;
    private final boolean typedContent;
    private int kind = 0;
    private double nodeId = 0.0;
    private boolean translate = false;
    private long clientAdler32 = 0L;
    private int clientSize = 0;
    private Connector.Metabase connector = null;
    private final RequestResult requestResult;
    private final TaggedWriter out;

    public GetMultipleNodeContents(RequestHeader rq, boolean typedContent) {
        super(rq, RequestDuration.NORMAL);
        this.typedContent = typedContent;
        this.requestResult = new RequestResult(this, 8192);
        this.out = this.requestResult.getWriter();
    }

    void returnContentUnchanged(long contentTime) throws Exception {
        if (this.typedContent && this.translate) {
            this.out.putDouble(9, this.nodeId);
        } else {
            this.out.putDouble(1, this.nodeId);
        }
        if (contentTime != 0L) {
            this.out.putInt64(4, contentTime);
        }
        this.out.putEmpty(2);
        this.requestResult.sendChunk();
    }

    void returnContent(double realNodeId, byte[] content, long contentTime) throws Exception {
        if (this.typedContent && this.translate) {
            this.out.putDouble(9, this.nodeId);
        } else {
            this.out.putDouble(1, this.nodeId);
        }
        if (this.nodeId != realNodeId) {
            this.out.putDouble(10, realNodeId);
        }
        if (contentTime != 0L) {
            this.out.putInt64(4, contentTime);
        }
        this.out.putRaw(3, content);
        this.requestResult.sendChunk();
    }

    void sendContentError(String message, String detailing) throws Exception {
        if (this.typedContent && this.translate) {
            this.out.putDouble(9, this.nodeId);
        } else {
            this.out.putDouble(1, this.nodeId);
        }
        this.out.putString(7, message);
        this.out.putString(8, detailing);
        this.requestResult.sendChunk();
    }

    private void returnNodeInfo(BasicNode node) throws Exception {
        if (this.connector == null) {
            this.connector = new Connector.Metabase();
            this.connector.markAsReadonly();
        }
        ByteArrayOutputStream resultNodeInfo = new ByteArrayOutputStream();
        TaggedWriter outNodeInfo = new TaggedWriter(resultNodeInfo);
        Node.NodeInfoArg arg = new Node.NodeInfoArg(this.connector, this.security(), null, outNodeInfo);
        arg.options = 0;
        node.getNodeInfo(arg);
        outNodeInfo.flush();
        this.out.putDouble(5, this.nodeId);
        this.out.putRaw(6, resultNodeInfo);
        this.requestResult.sendChunk();
    }

    private void sendContent() throws Exception {
        BasicNode node = MtdEngine.getValidNode(this.nodeId).getRealNode();
        this.checkAccess(node, this.translate ? 0x8000000 : Integer.MIN_VALUE);
        if (node.getType() != 0) {
            BasicNode.NodeContent nodeContent = node.getNodeContent(0.0, true);
            if (this.translate) {
                this.returnContent(node.getId(), GetNodeContent.translateContent(this, nodeContent.content, true), nodeContent.lastContentTime);
            } else if (nodeContent.dslContent != null) {
                MtdEngine.throwDetailError("\u041d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0437\u043b\u0430 \u0432 \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442", node.getId());
            } else {
                this.returnContent(node.getId(), nodeContent.content, nodeContent.lastContentTime);
            }
        }
        this.returnNodeInfo(node);
    }

    private void sendNodeInfo() throws Exception {
        BasicNode node = MtdEngine.getValidNode(this.nodeId).getRealNode();
        this.returnNodeInfo(node);
    }

    private void sendContentIfModified() throws Exception {
        BasicNode node = MtdEngine.getValidNode(this.nodeId).getRealNode();
        this.checkAccess(node, this.translate ? 0x8000000 : Integer.MIN_VALUE);
        if (node.getType() == 0) {
            this.returnContentUnchanged(0L);
        } else {
            boolean modified;
            BasicNode.NodeContent nodeContent = node.getNodeContent(0.0, true);
            byte[] content = Empty.byteArray;
            if (this.translate) {
                content = GetNodeContent.translateContent(this, nodeContent.content, true);
            } else if (nodeContent.dslContent != null) {
                MtdEngine.throwDetailError("\u041d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0437\u043b\u0430 \u0432 \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442", node.getId());
            } else {
                content = nodeContent.content;
            }
            boolean bl = modified = content.length != this.clientSize;
            if (!modified) {
                Adler32 crc = new Adler32();
                crc.update(content, 0, content.length);
                boolean bl2 = modified = this.clientAdler32 != crc.getValue();
            }
            if (modified) {
                this.returnContent(node.getId(), content, nodeContent.lastContentTime);
            } else {
                this.returnContentUnchanged(nodeContent.lastContentTime);
            }
        }
    }

    private void sendConf() throws Exception {
        if (this.connector == null) {
            this.connector = new Connector.Metabase();
            this.connector.markAsReadonly();
        }
        MetadataNodeReader.ConfNode conf = new MetadataNodeReader.ConfNode(this.nodeId, this.connector.connection());
        this.connector.commit();
        this.returnContent(this.nodeId, conf.content, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        try {
            boolean interrupted = false;
            TaggedReader in = this.createRequestContentReader();
            while (in.next()) {
                if (interrupted) {
                    break;
                }
                switch (in.getCurrentTag()) {
                    case 1: {
                        this.kind = in.getInt();
                        this.nodeId = 0.0;
                        this.translate = false;
                        this.clientAdler32 = 0L;
                        this.clientSize = 0;
                        break;
                    }
                    case 2: {
                        this.translate = true;
                        break;
                    }
                    case 3: {
                        this.clientAdler32 = (long)in.getInt() & 0xFFFFFFFFL;
                        break;
                    }
                    case 4: {
                        this.clientSize = in.getInt();
                        break;
                    }
                    case 5: {
                        this.nodeId = in.getDouble();
                        try {
                            switch (this.kind) {
                                case 1: {
                                    this.sendContent();
                                    break;
                                }
                                case 2: {
                                    this.sendContentIfModified();
                                    break;
                                }
                                case 3: {
                                    this.sendConf();
                                    break;
                                }
                                case 4: {
                                    this.sendNodeInfo();
                                }
                            }
                        }
                        catch (Throwable ex) {
                            Core.logger.error(null, ex);
                            Request.AnalyzeThrowable analyze = new Request.AnalyzeThrowable();
                            interrupted = this.analyzeThrowable(ex, analyze);
                            this.sendContentError(analyze.message, analyze.detailing);
                        }
                        this.kind = 0;
                        this.nodeId = 0.0;
                        this.translate = false;
                        this.clientAdler32 = 0L;
                        this.clientSize = 0;
                    }
                }
            }
        }
        finally {
            if (this.connector != null) {
                this.connector.close();
            }
        }
    }
}

