/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.LittleEndian;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.request.NodeDependeceEngine;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;

public class GetNodesDependency
extends Request {
    public static final int TAG_DEP_NODE_LIST = 1;
    public static final int TAG_DEP_DEPENDENCY_LIST = 2;
    public static final int TAG_DEP_TYPE_SET = 3;
    public static final int TAG_DEP_DATABASE_NODES = 4;
    public static final int TAG_DEP_NODE = 5;
    public static final int TAG_DEP_CONFIGURATION = 6;

    public GetNodesDependency(RequestHeader rq) {
        super(rq, RequestDuration.LONG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        this.putRequestStateCaption("\u041f\u043e\u0438\u0441\u043a \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439 \u0443\u0437\u043b\u043e\u0432");
        BitSet types = null;
        double[] nodes = null;
        TaggedReader in = this.createRequestContentReader();
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    nodes = LittleEndian.toDoubleArray(in.getRaw());
                    break;
                }
                case 3: {
                    int[] list;
                    types = new BitSet(128);
                    for (int t : list = LittleEndian.toIntArray(in.getRaw())) {
                        types.set(t);
                    }
                    break;
                }
            }
        }
        DoubleSet set = new DoubleSet();
        double nodeId = this.getNodeID();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try (Connector.Metabase connector = new Connector.Metabase("rq:GetNodesDependency");){
            ArrayList<MetadataNodeReader.NodeAndType> validNodes;
            this.putRequestStateInstruction("\u041f\u043e\u0438\u0441\u043a \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0435\u0439 \u0434\u043b\u044f \u0443\u0437\u043b\u043e\u0432...");
            if (nodeId != 0.0) {
                NodeDependeceEngine.getNodeDependencies(nodeId, set);
            } else if (nodes != null && nodes.length > 0) {
                for (double id : nodes) {
                    this.idle();
                    NodeDependeceEngine.getNodeDependencies(id, set);
                }
            }
            this.putRequestStateInstruction("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0443\u0437\u043b\u043e\u0432...");
            if (types == null) {
                validNodes = new DoubleList(1);
                MetadataNodeReader.getValidNodes(null, set, (Connector)connector, validNodes);
                out.putRaw(2, LittleEndian.doubleArrayToBinary(((DoubleList)((Object)validNodes)).internalArray(), ((DoubleList)((Object)validNodes)).size()));
            } else {
                validNodes = new ArrayList();
                MetadataNodeReader.getValidNodesFiltered(null, set, types, (Connector)connector, validNodes);
                ByteBuffer deps = ByteBuffer.allocate(validNodes.size() * 8).order(ByteOrder.LITTLE_ENDIAN);
                ByteBuffer dbnodes = ByteBuffer.allocate(validNodes.size() * 8).order(ByteOrder.LITTLE_ENDIAN);
                for (MetadataNodeReader.NodeAndType nt : validNodes) {
                    deps.putDouble(nt.nodeId);
                    if (nt.typeId != 10) continue;
                    dbnodes.putDouble(nt.nodeId);
                }
                deps.flip();
                out.putRaw(2, deps.array(), deps.limit());
                dbnodes.flip();
                out.putRaw(4, dbnodes.array(), dbnodes.limit());
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

