/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.net.Security;

public class GetValHistory
extends Request {
    private static final int TAG_VHISTORY_TABLE_ID = 1;
    private static final int TAG_VHISTORY_REC_ID = 2;
    private static final int TAG_VHISTORY_FIELD_ID = 3;
    private static final int TAG_VHISTORY_OPERATION = 4;
    private static final int TAG_VHISTORY_OPERATION_TIME = 5;
    private static final int TAG_VHISTORY_USER = 6;
    private static final int TAG_VHISTORY_NUM_VAL = 7;
    private static final int TAG_VHISTORY_STR_VAL = 8;
    private static final int TAG_VHISTORY_DT_VAL = 9;
    private static final int TAG_VHISTORY_UNICODE_VAL = 10;
    private static final int TAG_VHISTORY_FIELD_NAME = 11;

    public GetValHistory(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Security security = this.security();
        if (security.role() != UserRole.ADMIN && !security.getUserInterface().canViewDataHistory) {
            return;
        }
        double recordId = -1.0;
        double tableId = -1.0;
        int fieldId = -1;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    tableId = reader.getDouble();
                    break;
                }
                case 2: {
                    recordId = reader.getDouble();
                    break;
                }
                case 3: {
                    fieldId = reader.getInt();
                }
            }
        }
        if (tableId == -1.0 || recordId == -1.0 || fieldId == -1) {
            return;
        }
        String fieldName = "";
        TableDescriptor tDesc = new TableDescriptor(tableId, false);
        FieldDescriptor fDesc = tDesc.getFieldDescriptor(fieldId);
        if (fDesc != null) {
            fieldName = fDesc.getCaption();
        }
        DatabaseDescriptor databaseDescriptor = tDesc.getDatabaseDescriptor();
        StringBuilder sql = new StringBuilder();
        if (fieldId == -2) {
            sql.append("SELECT FIELD_ID, OP_CODE, OP_TIME, USER_ID, NUM_VAL, STR_VAL, DT_VAL, UNICODE_VAL FROM ");
        } else {
            sql.append("SELECT OP_CODE, OP_TIME, USER_ID, NUM_VAL, STR_VAL, DT_VAL, UNICODE_VAL FROM ");
        }
        databaseDescriptor.appendDetailAuditTableRawName("PHX_CHANGELOG_VAL", sql);
        if (fieldId == -2) {
            sql.append(" WHERE  TABLE_ID = ? AND  RECORD_ID = ? ORDER BY OP_TIME DESC");
        } else {
            sql.append(" WHERE  TABLE_ID = ? AND  RECORD_ID = ? AND FIELD_ID = ? ORDER BY OP_TIME DESC");
        }
        try (DatabaseConnection conn = databaseDescriptor.connect(this, "rq:GetValHistory");
             PreparedStatement stmt = conn.prepareStatement(sql.toString());){
            stmt.setDouble(1, tableId);
            stmt.setDouble(2, recordId);
            if (fieldId != -2) {
                stmt.setInt(3, fieldId);
            }
            try (ResultSet result = stmt.executeQuery(null);){
                ByteArrayOutputStream ar = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(ar);
                if (fieldId != -2) {
                    writer.putString(11, fieldName);
                }
                while (result.next()) {
                    int col = 1;
                    if (fieldId == -2) {
                        int n = col;
                        col = (byte)(col + 1);
                        writer.putInt32(3, result.getInt(n));
                    }
                    int n = col;
                    col = (byte)(col + 1);
                    writer.putInt32(4, result.getInt(n));
                    int n2 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(5, result.getDateTime(n2));
                    int n3 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(6, result.getDouble(n3));
                    int n4 = col;
                    col = (byte)(col + 1);
                    double dVal = result.getDouble(n4);
                    if (!result.wasNull()) {
                        writer.putDouble(7, dVal);
                    }
                    int n5 = col;
                    col = (byte)(col + 1);
                    String strVal = result.getString(n5);
                    if (strVal != null) {
                        writer.putString(8, strVal);
                    }
                    int n6 = col;
                    col = (byte)(col + 1);
                    double dateVal = result.getDateTime(n6);
                    if (!result.wasNull()) {
                        writer.putDouble(9, dateVal);
                    }
                    int n7 = col;
                    col = (byte)(col + 1);
                    String uVal = result.getString(n7);
                    if (result.wasNull()) continue;
                    writer.putString(10, uVal);
                }
                writer.flush();
                this.sendResult(ar.internalBuffer(), ar.size());
            }
        }
    }
}

