/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.SymLinkNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.AlertingEngine;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;

public class ModifyNode
extends Request {
    public ModifyNode(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    public static void modifyNode(SSContext context, ServerSideHost host, byte[] requestContent, boolean needSendResult, double _nodeId) throws Exception {
        Node node = MtdEngine.getValidNode(_nodeId);
        ModifyNode.modifyNode(context, host, requestContent, needSendResult, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyNode(SSContext context, ServerSideHost host, byte[] requestContent, boolean needSendResult, Node node) throws Exception {
        double userId = host.getUserID();
        Security security = host.security();
        double nodeId = node.getId();
        int accessMask = security.accessMask(node);
        if (node.getOwnerId() != userId && AccessMask.accessDenied(0x40000000, accessMask)) {
            throw new InformException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432 \u0443\u0437\u043b\u0430");
        }
        if (node.getType() == 3) {
            MtdEngine.registerFailedLoginCount(nodeId, true);
        }
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(requestContent));
        boolean needNotifyClient = false;
        boolean needNotifyAllClient = false;
        try (Connector.Metabase connector = new Connector.Metabase();){
            BasicNode parent;
            BasicNode refNode;
            Node.ModifyNodeArg arg = new Node.ModifyNodeArg(host, connector, NodeStatus.MODIFIED, security);
            arg.in = in;
            arg.userId = userId;
            arg.sessionId = host.getSessionID();
            node = arg.modifyNode(node);
            if (node instanceof SymLinkNode && (refNode = ((SymLinkNode)node).getRefNode()) != null && refNode.status == null) {
                ((SymLinkNode)node).setModifiedRefNode(arg.modifyNode(refNode));
            }
            double newParentId = node.getParentId();
            String name = node.getName();
            boolean needChangeParent = false;
            boolean needMoveLast = false;
            String newName = name;
            node.beforeLoad();
            block9: while (in.next()) {
                int tag = in.getCurrentTag();
                switch (tag) {
                    case 3: {
                        newParentId = in.getDouble();
                        needChangeParent = true;
                        continue block9;
                    }
                    case 4: {
                        newName = in.getString();
                        node.changeNameAndParent(newName, newParentId, arg);
                        needChangeParent = false;
                        continue block9;
                    }
                    case 25: {
                        needMoveLast = !(node instanceof VirtualUser);
                        continue block9;
                    }
                    case 29: {
                        arg.replId = in.getDouble();
                        continue block9;
                    }
                }
                node.loadModifyTag(tag, arg);
            }
            if (node instanceof SymLinkNode) {
                ((SymLinkNode)node).setModifiedRefNode(null);
            }
            if (needChangeParent) {
                node.changeParent(newParentId, arg);
            }
            if (needMoveLast && (parent = arg.getTranslatedNode(newParentId)) != null) {
                parent.moveNodeLast(node, arg);
            }
            node.setModificationAttributeTime(System.currentTimeMillis());
            for (Node modifiedNode : arg.modifiedNodes) {
                if (node.isNodeAttrChanged(512)) {
                    modifiedNode.setContentModificationUser(userId);
                }
                modifiedNode.setNodeChangingProps(arg);
                if (modifiedNode.isNodeAttrChanged(8704)) {
                    needNotifyClient = true;
                }
                if (modifiedNode.getType() == 2) {
                    needNotifyAllClient = true;
                }
                modifiedNode.setModificationAttributeTime(System.currentTimeMillis());
            }
            node.applyUpdates(context, arg);
        }
        if (needSendResult) {
            host.sendResult();
        }
        if (needNotifyClient || needNotifyAllClient) {
            ByteArrayOutputStream notification = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(notification);
            stream.putDouble(3, host.getNodeID());
            stream.flush();
            if (needNotifyAllClient) {
                AlertingEngine.sendChangeNotification(null, notification.internalBuffer(), notification.size(), 0L);
            } else {
                AlertingEngine.sendChangeNotification(host.client(), notification.internalBuffer(), notification.size(), 0L);
            }
        }
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        ModifyNode.modifyNode(null, (ServerSideHost)this, this.getRequestContent(), true, this.getTranslatedNodeID());
    }
}

