/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;

public class SendClientLogs
extends Request {
    public static final int TAG_SEND_CLIENTLOG_ERR = 1;
    public static final int TAG_SEND_CLIENTLOG_WARN = 2;

    public SendClientLogs(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        AuditJournal clientLogJournal = new AuditJournal(AuditJournal.Journal.CLIENTLOG);
        if (!clientLogJournal.isEnabled()) {
            throw new InformException("\u0416\u0443\u0440\u043d\u0430\u043b \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0445 \u043b\u043e\u0433\u043e\u0432 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
        }
        AuditJournal.ClientLogParams params = new AuditJournal.ClientLogParams();
        params.time = DateTime.currentDateTime();
        params.userId = this.getUserID();
        params.sessionId = this.getSessionID();
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    params.error = in.getRaw();
                    break;
                }
                case 2: {
                    params.warn = in.getRaw();
                }
            }
        }
        if (!(params.warn != null && params.warn.length != 0 || params.error != null && params.error.length != 0)) {
            return;
        }
        clientLogJournal.registerClientLog(params);
    }
}

