/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.mtd.MetadataNodeReader;

public class SetConfiguration
extends Request {
    private int confType = 0;

    public SetConfiguration(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    void parseExtraParams() throws Throwable {
        TaggedReader reader = this.createRequestExtraParamsReader();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.confType = reader.getInt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        try (Connector.Metabase db = new Connector.Metabase();){
            this.parseExtraParams();
            double nodeId = this.rq.nodeId;
            double userId = this.getUserID();
            byte[] confContent = this.getRequestContent();
            try (PreparedStatement stmt = db.connection().prepareStatement("SetConfiguration", "UPDATE " + MetadataNodeReader.mtdConfTableName + " SET conf_content=? WHERE conf_user=? AND node_id=? AND conf_type=?");){
                stmt.setBlob(1, confContent);
                stmt.setDouble(2, userId);
                stmt.setDouble(3, nodeId);
                stmt.setInt(4, this.confType);
                int uc = stmt.executeUpdate(null);
                if (uc == 0) {
                    stmt.close();
                    stmt = db.connection().prepareStatement("SetConfiguration", "INSERT INTO " + MetadataNodeReader.mtdConfTableName + "(id, conf_user, node_id, conf_type, conf_content) VALUES(?,?,?,?,?)");
                    double recId = Core.generateId();
                    stmt.setDouble(1, recId);
                    stmt.setDouble(2, userId);
                    stmt.setDouble(3, nodeId);
                    stmt.setInt(4, this.confType);
                    stmt.setBlob(5, confContent);
                    stmt.executeUpdate(null);
                }
            }
            db.commit();
        }
    }
}

