/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeContentKind;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.obj.DslRuntime;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.AlertingEngine;

public class SetNodeContent
extends Request {
    public static final int TAG_SNC_CONTENT_STAMP = 1;
    private final NodeContentKind contentKind;
    private long contentStamp;

    public SetNodeContent(RequestHeader rq, NodeContentKind contentKind) {
        super(rq, RequestDuration.NORMAL);
        this.contentKind = contentKind;
        this.contentStamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        String dslContent;
        byte[] content;
        if (Ini.ReadonlyMode) {
            return;
        }
        if (this.hasRequestExtraParams()) {
            TaggedReader in = this.createRequestExtraParamsReader();
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        this.contentStamp = in.getLong();
                    }
                }
            }
        }
        double nodeId = this.getTranslatedNodeID();
        BasicNode node = MtdEngine.getValidNodeSync(null, nodeId).getRealNode();
        this.checkAccess(node, 0x40000000);
        node.lockBarrier(this.getSessionID());
        if (this.contentKind != NodeContentKind.Text) {
            content = this.getRequestContent();
            dslContent = null;
        } else {
            content = null;
            dslContent = new String(this.getRequestContent(), TaggedWriter.UTF8);
            DslRuntime.checkDslContent(null, null, this, node, dslContent);
        }
        ByteArrayOutputStream info = new ByteArrayOutputStream();
        try (Connector.Metabase connector = new Connector.Metabase();){
            Node.ModifyNodeArg arg = new Node.ModifyNodeArg(this, connector, NodeStatus.MODIFIED, this.security());
            TaggedWriter infoWriter = new TaggedWriter(info);
            arg.userId = this.getUserID();
            arg.sessionId = this.getSessionID();
            arg.ssContext = this.ssContext;
            arg.contentStamp = this.contentStamp;
            node = arg.modifyNode(node);
            node.setContent(content, dslContent, arg);
            if (node.getPinId() != 0.0) {
                node.Unpin();
            }
            node.setModificationAttributeTime(arg.contentModificationTime);
            try {
                MtdEngine.updateNodes(this.ssContext, arg);
            }
            catch (Throwable ex) {
                node.invalidateContent();
                if (node.getType() == 16) {
                    Core.logger.error("SetNodeContent", ex);
                }
                throw ex;
            }
            BasicNode.NodeContent nodeContent = node.getNodeContent(0.0, false);
            infoWriter.putInt64(3, nodeContent.lastContentTime);
            infoWriter.flush();
        }
        this.sendResult(null, 0, info.internalBuffer(), info.size());
        ByteArrayOutputStream notification = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(notification);
        if (node.getType() == 12) {
            writer.putEmpty(6);
        }
        writer.putDouble(3, nodeId);
        writer.flush();
        AlertingEngine.sendChangeNotification(this.client(), notification.internalBuffer(), notification.size(), 0L);
    }
}

