/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.InformException;
import inform.adt.taggedio.TagReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.am.Telemeter;
import inform.agent.net.Client;
import inform.agent.net.ClientProtocol;
import inform.agent.net.IoMemory;
import inform.agent.net.LoginProtocol;
import inform.agent.web.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;

public class ClientSession
extends SimpleChannelHandler {
    static final int INITIAL_BUFFER_SIZE = 8092;
    private static final int MAX_PENDING_BYTES = 262144;
    private static final Collection<Client> clients = new ConcurrentLinkedQueue<Client>();
    private static final Collection<ClientSession> runningSessions = new ConcurrentLinkedQueue<ClientSession>();
    private static final ChannelGroup group = new DefaultChannelGroup("Clients");
    final QueueSemaphore pendingWritedBytes = new QueueSemaphore(262144);
    private final IoMemory received = new IoMemory();
    Channel channel;
    private boolean closing;
    private ClientProtocol protocol;
    private ClientProtocol lastProtocol;
    protected boolean allowAuthorizedKeys = true;

    public static void gatherTelemetries(Telemeter.Gatherer gatherer) throws IOException {
        Iterator<ClientSession> i = runningSessions.iterator();
        while (i.hasNext()) {
            ClientSession s = i.next();
            ClientProtocol p = s.lastProtocol;
            if (p != null) {
                p.gatherTelemetry(gatherer);
            }
            if (s.isConnected() || p instanceof Client && ((Client)p).hasRunningRequests()) continue;
            i.remove();
        }
    }

    public static ChannelGroupFuture shutdownClients() {
        return group.close();
    }

    public static boolean hasSession(double sessionId) {
        for (Client c : clients) {
            double logonId = c.getLoginId();
            if (!(logonId != 0.0 ? logonId == sessionId : c.getSessionId() == sessionId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUserLogin(double userId) {
        for (Client c : clients) {
            if (c.getUserId() != userId) continue;
            return true;
        }
        return false;
    }

    public static int loginCount(double userId) {
        int count = 0;
        for (Client c : clients) {
            if (c.getUserId() != userId) continue;
            ++count;
        }
        return count;
    }

    public static Collection<Client> getClients() {
        return Collections.unmodifiableCollection(clients);
    }

    public static int clientSessionCount() {
        return clients.size();
    }

    public static int JNI_getClientCount() {
        return clients.size() + HttpServer.sessionsCount();
    }

    public InetSocketAddress socketAddress() {
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    public boolean isConnected() {
        return this.protocol != null;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = ctx.getChannel();
        super.channelConnected(ctx, e);
        this.doChanelConnected(ctx);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.close(true);
        this.channel = null;
        super.channelDisconnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.checkConnection();
        this.processChanelBuffer((ChannelBuffer)e.getMessage());
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        this.pendingWritedBytes.release((int)e.getWrittenAmount());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Core.logger.error("ClientSession", e.getCause());
    }

    void checkConnection() {
        if (this.isConnected() && !this.protocol.isLive()) {
            throw new InformException("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e");
        }
    }

    private void doChanelConnected(ChannelHandlerContext ctx) throws Exception {
        boolean isTlsSession;
        group.add((Object)this.channel);
        ChannelPipeline pipeline = ctx.getPipeline();
        boolean bl = isTlsSession = pipeline.get("ssl") != null;
        if (isTlsSession && pipeline.get("decoder") instanceof HttpRequestDecoder) {
            isTlsSession = false;
        }
        this.lastProtocol = this.protocol = new LoginProtocol(this, isTlsSession);
        Iterator<ClientSession> i = runningSessions.iterator();
        while (i.hasNext()) {
            ClientProtocol p;
            ClientSession s = i.next();
            if (s.isConnected() || (p = s.lastProtocol) instanceof Client && ((Client)p).hasRunningRequests()) continue;
            i.remove();
        }
        runningSessions.add(this);
    }

    void initConnection(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.getChannel();
        this.doChanelConnected(ctx);
    }

    void processChanelBuffer(ChannelBuffer buffer) throws Exception {
        TagReader tag;
        this.received.add(buffer.array());
        while (this.isConnected() && (tag = this.received.poolTagReader()) != null) {
            this.protocol.handleTag(tag);
        }
    }

    void switchProtocol(ClientProtocol newProtocol) {
        assert (this.protocol instanceof LoginProtocol);
        assert (newProtocol instanceof Client);
        Client client = (Client)newProtocol;
        double sessionId = client.getLoginId();
        for (Client c : clients) {
            if (c.getLoginId() != sessionId) continue;
            try {
                c.getSession().close();
            }
            catch (IOException e) {
                Core.logger.error(null, e);
            }
            clients.remove(c);
            break;
        }
        clients.add(client);
        this.lastProtocol = this.protocol = newProtocol;
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void kill(String reason) throws IOException {
        if (!this.isConnected()) {
            return;
        }
        TaggedWriter out = this.createSyncedWriter();
        out.putEmpty(72);
        if (this.channel.isConnected()) {
            out.flush();
        }
        this.close(false, reason);
    }

    public void kill() throws IOException {
        this.kill(null);
    }

    public synchronized void close(boolean force, String reason) throws IOException {
        if (!this.isConnected()) {
            return;
        }
        this.closing = true;
        if (!force) {
            TaggedWriter out = this.createSyncedWriter();
            out.putEmpty(16);
            if (this.channel.isConnected()) {
                out.flush();
            }
        }
        this.protocol.close(reason);
        this.channel.close();
        if (this.protocol instanceof Client) {
            clients.remove(this.protocol);
        }
        this.protocol = null;
        this.channel = null;
    }

    public synchronized void close(boolean force) throws IOException {
        this.close(force, null);
    }

    public TaggedWriter createWriter() {
        return new TaggedWriter((OutputStream)new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)8092)){

            public void flush() throws IOException {
                ClientSession.this.channel.write((Object)this.buffer().copy());
                ClientSession.this.pendingWritedBytes.reduce(this.buffer().writerIndex());
                this.buffer().clear();
            }
        });
    }

    public TaggedWriter createSyncedWriter() {
        return new TaggedWriter((OutputStream)new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)8092)){

            public void flush() throws IOException {
                ChannelFuture f = ClientSession.this.channel.write((Object)this.buffer());
                ClientSession.this.pendingWritedBytes.reduce(this.buffer().writerIndex());
                f.awaitUninterruptibly();
                this.buffer().clear();
            }
        });
    }

    public TaggedWriter createMemoryAwareWriter() {
        return new TaggedWriter((OutputStream)new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)8092)){

            public void flush() throws IOException {
                ClientSession.this.channel.write((Object)this.buffer());
                try {
                    ClientSession.this.pendingWritedBytes.acquire(this.buffer().writerIndex());
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    Client testAndGet(int clientId) throws InformException {
        if (!(this.protocol instanceof Client)) {
            return null;
        }
        Client result = (Client)this.protocol;
        if (result.getClientId() != clientId) {
            throw new InformException("Invalid client session");
        }
        return result;
    }

    public static void statTrySlice(long time) {
        for (Client c : clients) {
            c.statistics.trySlice(time);
        }
    }

    public static void statWrite(long from, long to, TaggedWriter out) throws IOException {
        for (Client c : clients) {
            c.statistics.write(from, to, out, c.loginInfo.userId);
        }
    }

    static class QueueSemaphore {
        static final int MAX_BUFFER_WAIT_TIMEOUT = 60000;
        static final AtomicIntegerFieldUpdater<QueueSemaphore> AFU_buffer = AtomicIntegerFieldUpdater.newUpdater(QueueSemaphore.class, "buffer");
        volatile int buffer;

        QueueSemaphore(int buffer) {
            this.buffer = buffer;
        }

        void reduce(int size) {
            AFU_buffer.addAndGet(this, -size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void acquire(int size) throws InterruptedException {
            long st = 0L;
            while (true) {
                int newsize;
                int oldsize;
                if ((oldsize = this.buffer) < size) {
                    QueueSemaphore queueSemaphore = this;
                    synchronized (queueSemaphore) {
                        oldsize = this.buffer;
                        if (oldsize < size) {
                            long time = System.currentTimeMillis();
                            if (st == 0L) {
                                st = time;
                            } else if (time - st > 60000L) {
                                throw new InformException("send buffer wait timeout");
                            }
                            this.wait(1000L);
                            continue;
                        }
                    }
                }
                if (AFU_buffer.compareAndSet(this, oldsize, newsize = oldsize - size)) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(int size) {
            AFU_buffer.addAndGet(this, size);
            QueueSemaphore queueSemaphore = this;
            synchronized (queueSemaphore) {
                this.notifyAll();
            }
        }
    }
}

