/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.scripts.AdminNotifier;
import inform.agent.scripts.ServerScriptExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LdapUser {
    private static final String[] FORCE_PROP_NAMES = new String[]{"displayName"};

    public static boolean isValidLDAP() {
        return !Strings.isVoid(Ini.ldapHost) && !Strings.isVoid(Ini.ldapAuthDN) && !Strings.isVoid(Ini.ldapAuthPassword);
    }

    public static boolean useLDAP(ServerNode.Descriptor descriptor) {
        return descriptor.useLDAP && LdapUser.isValidLDAP();
    }

    public static boolean useLDAP() {
        return LdapUser.isValidLDAP() && LdapUser.useLDAP(MtdEngine.serverNode().descriptor());
    }

    public static Info queryUserInfo(String login, ServerNode.Descriptor descriptor) {
        Info info;
        List searchResultEntries;
        SearchResult searchResult;
        Filter filter;
        BindResult bindResult;
        LDAPConnection connection;
        ArrayList<String> groups = null;
        if (Ini.ldapQueryGroups) {
            connection = new LDAPConnection();
            try {
                connection.connect(Ini.ldapHost, 389);
                bindResult = connection.bind(Ini.ldapAuthDN, Ini.ldapAuthPassword);
                if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                    throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0443 " + Ini.ldapHost).detail(bindResult.toString());
                }
                filter = Filter.createEqualityFilter((String)Ini.ldapGroupsAttr, (String)login);
                searchResult = connection.search(Ini.ldapBaseDN, SearchScope.SUB, filter, new String[0]);
                searchResultEntries = searchResult.getSearchEntries();
                if (searchResultEntries.isEmpty()) {
                    throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0433\u0440\u0443\u043f\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + login + " \u043d\u0430 LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0435 " + Ini.ldapHost);
                }
                groups = new ArrayList<String>(searchResultEntries.size());
                for (SearchResultEntry entry : searchResultEntries) {
                    String[] values;
                    String groupDN = entry.getDN();
                    DN dn = new DN(groupDN);
                    String[] rdn = dn.getRDN();
                    if (rdn == null || (values = rdn.getAttributeValues()) == null || values.length == 0) continue;
                    groups.add(values[0]);
                }
            }
            finally {
                connection.close();
            }
        }
        connection = new LDAPConnection();
        try {
            connection.connect(Ini.ldapHost, 389);
            bindResult = connection.bind(Ini.ldapAuthDN, Ini.ldapAuthPassword);
            if (bindResult.getResultCode() != ResultCode.SUCCESS) {
                throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0443 " + Ini.ldapHost).detail(bindResult.toString());
            }
            filter = Filter.createEqualityFilter((String)Ini.ldapUserAttr, (String)login);
            searchResult = connection.search(Ini.ldapBaseDN, SearchScope.SUB, filter, new String[0]);
            searchResultEntries = searchResult.getSearchEntries();
            if (searchResultEntries.size() != 1) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c " + login + " \u043d\u0430 LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0435 " + Ini.ldapHost).detail("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0445 LDAP \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 " + searchResultEntries.size());
            }
            SearchResultEntry entry = (SearchResultEntry)searchResultEntries.get(0);
            String userDN = entry.getDN();
            SearchResultEntry userEntry = connection.getEntry(userDN);
            if (userEntry == null) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + login + " \u043d\u0430 LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0435 " + Ini.ldapHost);
            }
            if (groups == null) {
                String[] groupDNs = userEntry.getAttributeValues(Ini.ldapGroupsAttr);
                if (groupDNs == null) {
                    throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0433\u0440\u0443\u043f\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + login + " \u043d\u0430 LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0435 " + Ini.ldapHost);
                }
                groups = new ArrayList(groupDNs.length);
                for (String groupDN : groupDNs) {
                    String[] values;
                    DN dn = new DN(groupDN);
                    RDN rdn = dn.getRDN();
                    if (rdn == null || (values = rdn.getAttributeValues()) == null || values.length == 0) continue;
                    groups.add(values[0]);
                }
            }
            if (!Strings.isVoid(Ini.ldapGroup)) {
                boolean absent = true;
                for (String group : groups) {
                    if (!Ini.ldapGroup.equalsIgnoreCase(group)) continue;
                    absent = false;
                    break;
                }
                if (absent) {
                    throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c " + login + " \u043d\u0430 LDAP \u0441\u0435\u0440\u0432\u0435\u0440\u0435 " + Ini.ldapHost).detail("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0433\u0440\u0443\u043f\u043f\u0443 " + Ini.ldapGroup);
                }
            }
            Collection attributes = userEntry.getAttributes();
            ArrayList<Property> properties = new ArrayList<Property>(attributes.size());
            for (Attribute attr : attributes) {
                String attrName = attr.getName();
                String[] attValues = attr.getValues();
                if (attValues == null) continue;
                ArrayList<String> values = new ArrayList<String>(attValues.length);
                Collections.addAll(values, attValues);
                boolean skipProp = false;
                for (String v : values) {
                    if (v.indexOf(0) < 0) continue;
                    skipProp = true;
                    break;
                }
                if (skipProp) continue;
                properties.add(new Property(attrName, values));
            }
            double tempalteId = 0.0;
            double moduleId = 0.0;
            String moduleParam = null;
            double actualPeriod = 0.0;
            TaggedReader in = new TaggedReader(descriptor.ldap);
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 2: {
                        tempalteId = in.getDouble();
                        break;
                    }
                    case 3: {
                        moduleId = in.getNodeID();
                        break;
                    }
                    case 4: {
                        moduleParam = in.getString();
                        break;
                    }
                    case 5: {
                        actualPeriod = in.getDouble();
                    }
                }
            }
            info = new Info(login, properties, groups, tempalteId, moduleId, moduleParam, actualPeriod);
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InformException e) {
                throw e;
            }
            catch (Exception e) {
                throw InformException.wrap(e);
            }
        }
        connection.close();
        return info;
    }

    public static UserNode createUserNode(Info ldapInfo, ServerNode.Descriptor serverNodeDescriptor) throws Exception {
        double roleId = 0.0;
        UsersTable usersTable = new UsersTable(serverNodeDescriptor);
        SqlParameter[] props = usersTable.selectByRecordId(null, ldapInfo.tempalteId);
        if (props != null) {
            block6: for (SqlParameter prop : props) {
                if (null == prop) continue;
                switch (prop.getId()) {
                    case 2: {
                        roleId = prop.getDouble();
                        continue block6;
                    }
                    case 20: {
                        prop.setBoolean(true);
                        continue block6;
                    }
                    case 21: {
                        if (ldapInfo.actualPeriod > 0.0) {
                            prop.setDateTime(DateTime.currentDateTime() + ldapInfo.actualPeriod);
                            continue block6;
                        }
                        prop.setNull();
                        continue block6;
                    }
                    case 4: {
                        prop.setBoolean(false);
                    }
                }
            }
        }
        double userId = Core.generateId();
        usersTable.insertUserEx(null, new AdminNotifier.SSHost(2.0, 2.0), userId, ldapInfo.userName, roleId, props);
        return VirtualUser.getUser(userId);
    }

    public static void updateUserNode(double userId, Info ldapInfo, ServerNode.Descriptor serverNodeDescriptor, boolean needUpdateEndDate) throws Exception {
        AdminNotifier.SSHost ssHost = null;
        if (needUpdateEndDate && ldapInfo.actualPeriod > 0.0) {
            ssHost = new AdminNotifier.SSHost(2.0, 2.0);
            UsersTable usersTable = new UsersTable(serverNodeDescriptor);
            usersTable.updateServerManagedEndDate(null, ssHost, userId, DateTime.currentDateTime() + ldapInfo.actualPeriod);
        }
        if (ldapInfo.moduleId != 0.0) {
            if (ssHost == null) {
                ssHost = new AdminNotifier.SSHost(2.0, 2.0);
            }
            byte[] parameters = null;
            if (!Strings.isVoid(ldapInfo.moduleParam)) {
                StringBuilder json = new StringBuilder();
                json.append("{\"userID\":");
                Strings.toJSON(NumberConverter.doubleToString(userId), json).append(',').append("\"userName\":");
                Strings.toJSON(ldapInfo.userName, json).append(',').append("\"groups\":[");
                int groupComma = 32;
                for (String string : ldapInfo.groups) {
                    json.append((char)groupComma);
                    Strings.toJSON(string, json);
                    groupComma = 44;
                }
                json.append("],\"attributes\":{");
                int propComma = 32;
                for (Property prop : ldapInfo.properties) {
                    json.append((char)propComma);
                    Strings.toJSON(prop.name, json).append(":[");
                    int valueComma = 32;
                    for (String value : prop.value) {
                        json.append((char)valueComma);
                        Strings.toJSON(value, json);
                        valueComma = 44;
                    }
                    json.append("]");
                    propComma = 44;
                }
                json.append("}}");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TaggedWriter out = new TaggedWriter(byteArrayOutputStream);
                out.putString(14, ldapInfo.moduleParam);
                out.putString(6, json.toString());
                out.flush();
                byteArrayOutputStream.flush();
                parameters = byteArrayOutputStream.toByteArray();
            }
            try {
                ServerScriptExecutor.execute(null, 0, ldapInfo.moduleId, parameters, ssHost);
            }
            catch (Throwable e) {
                throw InformException.wrap(e);
            }
        }
    }

    public static class Info {
        public final String userName;
        public final ArrayList<Property> properties;
        public final ArrayList<String> groups;
        public final double tempalteId;
        public final double moduleId;
        public final String moduleParam;
        public final double actualPeriod;

        public Info(String userName, ArrayList<Property> properties, ArrayList<String> groups, double tempalteId, double moduleId, String moduleParam, double actualPeriod) {
            this.userName = userName;
            this.properties = properties;
            this.groups = groups;
            this.tempalteId = tempalteId;
            this.moduleId = moduleId;
            this.moduleParam = moduleParam;
            this.actualPeriod = actualPeriod;
        }
    }

    public static class Property {
        public final String name;
        public final ArrayList<String> value;

        public Property(String name, ArrayList<String> value) {
            this.name = name;
            this.value = value;
        }
    }
}

