/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.web.IconServlet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetAllIconIds
extends Request {
    final Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    final Pattern _keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
    final Pattern _icoIdFromFileName = Pattern.compile("img(\\d+)\\.ico$");
    final Pattern _icoIdAndNamesFromNames = Pattern.compile("(\\d+)(\\s)(.*)");
    static final int TAG_ICON_ID = 1;
    static final int TAG_ICON_NAMES = 2;
    static final int TAG_ICON_TAGS = 3;

    public GetAllIconIds(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        this.prepareOutputStream(out);
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    private void prepareOutputStream(TaggedWriter out) throws Exception {
        try (InputStream in = IconServlet.class.getResourceAsStream("/WEB-ROOT/images/icons/all-ini.txt");){
            if (in == null) {
                throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b all-ini.txt");
            }
            this.fillEntriesFromIniFile(in, out);
        }
    }

    private void fillEntriesFromIniFile(InputStream in, TaggedWriter out) throws Exception {
        ByteArrayOutputStream iniContent = new ByteArrayOutputStream();
        int n = 0;
        byte[] buf = new byte[4096];
        while ((n = in.read(buf)) > -1) {
            iniContent.write(buf, 0, n);
        }
        if (iniContent.size() == 0) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(iniContent.internalBuffer())));){
            String line;
            String section = null;
            String icoId = "";
            String names = "";
            String tags = "";
            while ((line = br.readLine()) != null) {
                Matcher m = this._section.matcher(line);
                if (m.matches()) {
                    section = m.group(1).trim();
                    if (!section.equalsIgnoreCase("image")) continue;
                    if (!icoId.isEmpty()) {
                        out.putInt32(1, Integer.parseInt(icoId));
                        if (!names.isEmpty()) {
                            out.putString(2, names);
                        }
                        if (!tags.isEmpty()) {
                            out.putString(3, tags);
                        }
                    }
                    icoId = "";
                    names = "";
                    tags = "";
                    continue;
                }
                if (section == null || !section.equalsIgnoreCase("image") || !(m = this._keyValue.matcher(line)).matches()) continue;
                String key = m.group(1).trim();
                String value = m.group(2).trim();
                if (key.equalsIgnoreCase("id")) {
                    icoId = value;
                }
                if (key.equalsIgnoreCase("file") && icoId.isEmpty() && (m = this._icoIdFromFileName.matcher(value)).matches()) {
                    icoId = m.group(1).trim();
                }
                if (key.equalsIgnoreCase("name")) {
                    names = value;
                }
                if (key.equalsIgnoreCase("names") && icoId.isEmpty() && (m = this._icoIdAndNamesFromNames.matcher(value)).matches()) {
                    icoId = m.group(1).trim();
                    names = m.group(3).trim();
                }
                if (!key.equalsIgnoreCase("tags")) continue;
                tags = value;
            }
            if (!icoId.isEmpty()) {
                out.putInt32(1, Integer.parseInt(icoId));
                if (!names.isEmpty()) {
                    out.putString(2, names);
                }
                if (!tags.isEmpty()) {
                    out.putString(3, tags);
                }
            }
        }
    }
}

