/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerList;
import inform.adt.collections.IntegerSet;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.db.utils.SqlExecutor;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.UnpackedRowContent;
import inform.agent.files.BFS;
import inform.agent.replication.DataReplicationApplyEngine;
import inform.agent.replication.ReplicationRecord;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.textutils.ExtractionDataInfo;
import inform.agent.scripts.textutils.TextExtractor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.impl.AsmoLogger;

public class ModifyCommand {
    public static final int FLUSH_DATA_SIZE_LIMIT = 0x1000000;
    private final ServerSideHost ssHost;
    public final SSContext ssContext;
    private final DataReplicationApplyEngine engine;
    private SqlExecutor command = null;
    private final SqlCommandBatch insertCommand = new SqlCommandBatch();
    private final SqlCommandBatch modifyCommand = new SqlCommandBatch(null, true);
    private final Collection<UnpackedRowContent> modifiedRows = new ArrayList<UnpackedRowContent>();
    private boolean canBatchUpdate;
    private boolean forceInsert = false;
    private TableDescriptor table = null;
    private FieldDescriptor pkField = null;
    private TableDataAudit dataAudit = null;
    private DatabaseConnection connection;
    private long dataSize = 0L;
    private DatabaseCaps caps;
    private BFS bfs = null;
    private BFS.Replica bfsReplica = null;

    public ModifyCommand(DataReplicationApplyEngine engine, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.engine = engine;
        this.ssContext = engine.ssContext;
        this.insertCommand.setParentBatch(this.modifyCommand);
    }

    public void close() {
        if (this.command != null) {
            this.command.close();
        }
    }

    public void setForceInsert(boolean forceInsert) {
        this.forceInsert = forceInsert;
    }

    public void setTable(TableDescriptor table, TableDataAudit dataAudit, DatabaseConnection connection) throws InformException, SQLException {
        if (this.table != table) {
            this.close();
            this.flush(true);
            this.table = table;
            this.canBatchUpdate = table.hasStandartPrimaryKey();
            this.dataAudit = dataAudit;
            this.connection = connection;
            this.pkField = table.getRecordIdField();
            this.command = new SqlExecutor(this.ssContext, connection);
            this.command.setTableDescriptor(table);
            this.insertCommand.setTableDesc(table);
            this.modifyCommand.setTableDesc(table);
            this.caps = connection.getDescriptor().getDatabaseType().caps();
        }
    }

    public void setDeletedRows(DoubleSet deletedRows) {
        this.modifyCommand.setDeletedRows(deletedRows);
        this.insertCommand.setDeletedRows(deletedRows);
    }

    public void add(UnpackedRowContent row, boolean detectChanges) throws InformException, SQLException, IOException {
        this.dataSize += row.contentSize;
        if (!row.fullRow && this.forceInsert) {
            this.throwAbsentChangedRow(row);
        }
        if (this.bfs != null && this.bfsReplica != null) {
            int valueIndex = 0;
            for (FieldDescriptor field : row.fields) {
                String blobPoint;
                BFS.ReplicationBlobFile rbf;
                SqlParameter value;
                if (field.isVirtual()) continue;
                if ((value = (SqlParameter)row.values.get(valueIndex++)).getType() == SqlDataType.FILE && (rbf = this.bfsReplica.getFile(this.table, field.getId(), row.rowId)) != null && (blobPoint = rbf.fixate(this.ssContext, this.ssHost, this.connection, this.bfs, !this.forceInsert)) != null) {
                    value.setFile(blobPoint);
                }
                if (field.getType().toSqlDataType() == value.getType()) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 [").append(NumberConverter.doubleToString(row.rowId)).append("] \u0442\u0430\u0431\u043b\u0438\u0446\u044b [").append(NumberConverter.doubleToString(this.table.getNodeId())).append("]: \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0442\u0438\u043f \u043f\u043e\u043b\u044f ");
                field.toLogString(msg);
                msg.append(" (\u0442\u0438\u043f ").append(field.getType().toSqlDataType().getCaption()).append(") \u0438 \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                msg.append(" (\u0442\u0438\u043f ").append(value.getType().getCaption()).append(')');
                throw new InformException(msg.toString());
            }
        }
        if (this.forceInsert) {
            this.insertRow(row);
            this.register(row, AuditModification.APPEND);
            return;
        }
        this.engine.checkModifyAccess();
        if (row.altKeyValues.isEmpty()) {
            this.flushRows(row, detectChanges);
        } else {
            this.flushAltRows(row);
        }
    }

    public void flush(boolean force) throws SQLException, InformException {
        if (this.dataSize > 0x1000000L) {
            force = true;
        }
        this.idle();
        this.flushModifiedRows(force);
        this.idle();
        boolean wasFlushed = false;
        if (this.modifyCommand.flush(this.connection, force, this.engine.ssContext)) {
            wasFlushed = true;
        }
        this.idle();
        if (this.insertCommand.flush(this.connection, force, this.engine.ssContext)) {
            wasFlushed = true;
        }
        this.idle();
        if (wasFlushed) {
            this.dataSize = 0L;
        }
    }

    private void insertRow(UnpackedRowContent row) throws SQLException, InformException {
        this.engine.checkInsertAccess();
        this.idle();
        if (!row.fullRow) {
            String msg = "\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 [" + NumberConverter.doubleToString(row.rowId) + "] \u0442\u0430\u0431\u043b\u0438\u0446\u044b [" + NumberConverter.doubleToString(this.table.getNodeId()) + "] \u043a \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0437\u0430\u043f\u0438\u0441\u0438";
            throw new InformException(msg);
        }
        StringBuilder sql = new StringBuilder();
        this.command.clear();
        this.command.rowId = row.rowId;
        this.command.recordIdValid = true;
        this.command.sqlText.append("insert into ").appendFull(this.table).append(" (");
        int comma = 32;
        for (int i = 0; i < row.fields.size(); ++i) {
            FieldDescriptor field = row.fields.get(i);
            if (field.isVirtual() || field.isAutoFill()) continue;
            this.command.sqlText.append((char)comma).append(field);
            sql.append((char)comma).append('?');
            comma = 44;
            this.command.addModifiedField(field.getId());
            SqlParameter param = (SqlParameter)row.values.get(i);
            this.command.params.addParameter(param);
            if (!field.hasExtractionText()) continue;
            byte[] data = param.getBlob();
            this.addExtractionTextInsertParams(sql, field, row, data);
        }
        if (this.table.getKind() == TableDescriptor.Kind.INTERNAL) {
            this.command.sqlText.append((char)comma).append(this.pkField);
            sql.append((char)comma).append('?');
            this.command.params.add(new SqlParameter().setDouble(row.rowId));
            this.command.addModifiedField(this.pkField.getId());
        }
        this.command.sqlText.append(") values (").append(sql).append(')');
        this.insertCommand.add(this.command, this.connection, this.engine.ssContext);
        this.idle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeModify(UnpackedRowContent row, IntegerList modifiedFields) throws SQLException, InformException {
        this.idle();
        int rowCount = this.command.executeUpdate(this.ssContext, this.connection);
        switch (rowCount) {
            case 0: {
                this.insertRow(row);
                this.register(row, AuditModification.APPEND);
                return;
            }
            case 1: {
                if (modifiedFields == null) {
                    this.register(row, AuditModification.MODIFY);
                    return;
                }
                this.registerDetectedChanges(row, modifiedFields);
                return;
            }
            default: {
                StringBuilder msg = new StringBuilder();
                msg.append("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u043a\u043b\u044e\u0447\u0435\u0439, \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0442 \u0434\u043b\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f").append(" \u0447\u0438\u0441\u043b\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: ").append(rowCount).append(" table: [").append(this.table.getLogNodeId()).append("] ").append(this.table.getRawName()).append(" records:").append(NumberConverter.doubleToString(row.rowId));
                try {
                    if (row.altKeyFields.isEmpty()) throw new InformException(msg.toString());
                    SqlCommand select = new SqlCommand();
                    select.sqlText.append("select ").append(this.pkField).append(" from ").appendFull(this.table).append(" where ");
                    int count = row.altKeyFields.size();
                    String delimiter = " (";
                    for (int a = 0; a < count; ++a) {
                        String name = row.altKeyFields.get(a);
                        SqlParameter param = (SqlParameter)row.altKeyValues.get(a);
                        this.command.sqlText.append(delimiter).append(name);
                        delimiter = " AND ";
                        if (param.isNull()) {
                            this.command.sqlText.append(" IS NULL");
                        } else {
                            this.command.sqlText.append(" = ?");
                            this.command.params.add(param);
                        }
                        this.idle();
                    }
                    if (count > 0) {
                        this.command.sqlText.append(") OR");
                    }
                    this.command.sqlText.append(' ').append(this.pkField).append("=?");
                    this.command.params.add(new SqlParameter().setDouble(row.rowId));
                    try (ClosableResult result = this.command.executeQuery(this.ssContext, this.connection);){
                        ResultSet fetch = result.getResultSet();
                        while (fetch.next()) {
                            double rowId = fetch.getAsDouble(1);
                            if (row.rowId == rowId) continue;
                            msg.append(',').append((long)rowId);
                        }
                        throw new InformException(msg.toString());
                    }
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
                throw new InformException(msg.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDetectChanges(UnpackedRowContent row) throws SQLException {
        this.command.clear();
        this.command.rowId = row.rowId;
        this.command.recordIdValid = true;
        this.command.sqlText.append("select");
        int comma = 32;
        for (int i = 0; i < row.fields.size(); ++i) {
            FieldDescriptor field = row.fields.get(i);
            if (field.isVirtual() || field.isAutoFill()) continue;
            this.command.sqlText.append((char)comma).append("T.").append(field);
            comma = 44;
        }
        this.command.sqlText.append(" from ").appendFull(this.table);
        this.command.sqlText.append(" T where ");
        this.addPkCondition(row);
        ClosableResult closableResult = this.command.executeQuery(this.ssContext, this.connection);
        int recordCount = 0;
        IntegerList modifiedFields = new IntegerList(row.fields.size());
        try {
            ResultSet resultSet = closableResult.getResultSet();
            while (resultSet.next()) {
                if (recordCount != 0) {
                    boolean bl = false;
                    return bl;
                }
                ++recordCount;
                int columnIndex = 0;
                for (int i = 0; i < row.fields.size(); ++i) {
                    FieldDescriptor field = row.fields.get(i);
                    if (field.isVirtual() || field.isAutoFill() || row.isFieldEquals((SqlParameter)row.values.get(i), ++columnIndex, resultSet)) continue;
                    modifiedFields.add(i);
                }
            }
        }
        finally {
            closableResult.close();
        }
        if (recordCount == 0) {
            this.insertRow(row);
            this.register(row, AuditModification.APPEND);
        }
        if (modifiedFields.size() == 0) {
            return true;
        }
        this.command.clear();
        this.command.rowId = row.rowId;
        this.command.recordIdValid = true;
        this.command.sqlText.append("update ").appendFull(this.table).append(" set ");
        comma = 32;
        for (IntegerList.Cursor i : modifiedFields) {
            FieldDescriptor field = row.fields.get(i.value);
            if (field.isVirtual() || field.isAutoFill()) continue;
            this.command.sqlText.append((char)comma).append(field).append("=?");
            comma = 44;
            this.command.addModifiedField(field.getId());
            SqlParameter param = (SqlParameter)row.values.get(i.value);
            this.command.params.addParameter(param);
            if (!field.hasExtractionText()) continue;
            byte[] data = param.getBlob();
            this.addExtractionTextUpdateParams(field, row, data);
        }
        this.command.sqlText.append(" where ");
        this.addPkCondition(row);
        this.executeModify(row, modifiedFields);
        return true;
    }

    private void flushRows(UnpackedRowContent row, boolean detectChanges) throws SQLException, InformException {
        this.idle();
        if (!row.fullRow) {
            this.engine.checkModifyAccess();
            this.prepareModifyCommand(row);
            this.modifyCommand.add(this.command, this.connection, this.ssContext);
            this.register(row, AuditModification.MODIFY);
            this.idle();
            return;
        }
        if (detectChanges && this.executeDetectChanges(row)) {
            return;
        }
        if (this.canBatchUpdate) {
            this.modifiedRows.add(row);
            this.flushModifiedRows(false);
            return;
        }
        this.prepareModifyCommand(row);
        this.executeModify(row, null);
        this.idle();
    }

    private void prepareModifyCommand(UnpackedRowContent row) {
        this.command.clear();
        this.command.rowId = row.rowId;
        this.command.recordIdValid = true;
        this.command.sqlText.append("update ").appendFull(this.table).append(" set ");
        int comma = 32;
        for (int i = 0; i < row.fields.size(); ++i) {
            FieldDescriptor field = row.fields.get(i);
            if (field.isVirtual() || field.isAutoFill()) continue;
            this.command.sqlText.append((char)comma).append(field).append("=?");
            comma = 44;
            this.command.addModifiedField(field.getId());
            SqlParameter param = (SqlParameter)row.values.get(i);
            this.command.params.addParameter(param);
            if (!field.hasExtractionText()) continue;
            byte[] data = param.getBlob();
            this.addExtractionTextUpdateParams(field, row, data);
        }
        this.command.sqlText.append(" where ");
        this.addPkCondition(row);
    }

    private void flushAltRows(UnpackedRowContent row) throws SQLException, InformException {
        this.idle();
        this.command.clear();
        this.command.rowId = row.rowId;
        this.command.recordIdValid = true;
        this.command.sqlText.append("update ").appendFull(this.table).append(" set ");
        int comma = 32;
        for (int i = 0; i < row.fields.size(); ++i) {
            FieldDescriptor field = row.fields.get(i);
            if (field.isVirtual() || field.isAutoFill()) continue;
            this.command.sqlText.append((char)comma).append(field).append("=?");
            comma = 44;
            SqlParameter param = (SqlParameter)row.values.get(i);
            this.command.params.addParameter(param);
            if (!field.hasExtractionText()) continue;
            byte[] data = param.getBlob();
            this.addExtractionTextUpdateParams(field, row, data);
        }
        this.command.sqlText.append(" where ");
        assert (row.altKeyFields.size() == row.altKeyValues.size());
        int count = row.altKeyFields.size();
        String delimiter = " (";
        for (int a = 0; a < count; ++a) {
            String name = row.altKeyFields.get(a);
            SqlParameter param = (SqlParameter)row.altKeyValues.get(a);
            this.command.sqlText.append(delimiter).append(name);
            delimiter = " AND ";
            if (param.isNull()) {
                this.command.sqlText.append(" IS NULL");
            } else {
                this.command.sqlText.append(" = ?");
                this.command.params.add(param);
            }
            this.idle();
        }
        if (count > 0) {
            this.command.sqlText.append(") OR (");
        }
        this.addPkCondition(row);
        this.command.sqlText.append(')');
        this.executeModify(row, null);
        this.idle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushModifiedRows(boolean force) throws SQLException {
        if (this.modifiedRows.isEmpty()) {
            return;
        }
        if (!force && this.modifiedRows.size() < 1000) {
            return;
        }
        this.command.clear();
        this.command.sqlText.append("select ").append(this.table.getRecordIdField()).append(" from ").appendFull(this.table).append(" where ").append(this.table.getRecordIdField()).append(" in ");
        int comma = 40;
        for (UnpackedRowContent row : this.modifiedRows) {
            this.command.sqlText.append((char)comma).append('?');
            comma = 44;
            SqlParameter param = new SqlParameter();
            this.command.params.add(param);
            param.setDouble(row.rowId);
        }
        this.command.sqlText.append(')');
        DoubleSet existingRows = new DoubleSet();
        try (ResultSet rs = this.command.executeQueryCached();){
            while (rs.next()) {
                existingRows.add(rs.getDouble(1));
            }
        }
        for (UnpackedRowContent row : this.modifiedRows) {
            if (existingRows.contains(row.rowId)) {
                this.engine.checkModifyAccess();
                this.prepareModifyCommand(row);
                this.modifyCommand.add(this.command, this.connection, this.ssContext);
                this.register(row, AuditModification.MODIFY);
                continue;
            }
            this.insertRow(row);
            this.register(row, AuditModification.APPEND);
        }
        this.modifiedRows.clear();
        this.idle();
    }

    private void addPkCondition(UnpackedRowContent row) {
        ArrayList<FieldDescriptor> pkFields = this.table.getPrimaryKeyFields();
        if (pkFields.isEmpty()) {
            String msg = "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"" + this.table.getCaption() + "\" [" + (long)this.table.getNodeId() + "] \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447";
            throw new InformException(msg);
        }
        if (pkFields.size() == 1 && this.table.getRecordIdField() != null) {
            this.command.sqlText.append(this.table.getRecordIdField()).append("=?");
            SqlParameter param = new SqlParameter();
            this.command.params.add(param);
            param.setDouble(row.rowId);
        } else {
            ArrayList<ReplicationRecord.Value> pkValues = new ArrayList<ReplicationRecord.Value>();
            for (int index = 0; index < row.fields.size(); ++index) {
                FieldDescriptor field = row.fields.get(index);
                if (!field.isPrimaryKey()) continue;
                ReplicationRecord.Value value = new ReplicationRecord.Value(field, index);
                value.assign((SqlParameter)row.values.get(index));
                pkValues.add(value);
            }
            if (pkFields.size() != pkValues.size()) {
                String msg = "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"" + this.table.getCaption() + "\" [" + (long)this.table.getNodeId() + "] \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0435 \u043a\u043b\u044e\u0447\u0438";
                throw new InformException(msg);
            }
            String and = "";
            for (ReplicationRecord.Value v : pkValues) {
                this.command.sqlText.append(and).append(v.field);
                and = " AND ";
                if (v.isNull()) {
                    this.command.sqlText.append(" IS NULL");
                    continue;
                }
                this.command.sqlText.append("=?");
                this.command.params.add(v);
            }
        }
    }

    private void register(UnpackedRowContent row, AuditModification modification) throws InformException, SQLException {
        this.idle();
        if (this.dataAudit == null) {
            return;
        }
        if (row.userId != 0.0) {
            this.dataAudit.setUserID(row.userId);
        }
        this.dataAudit.setOwnerId(row.dataLogOwnerId);
        this.dataAudit.setAuditEventId(row.dataLogEventId);
        if (!row.fullRow && this.dataAudit.isDataAuditEnabled(this.table)) {
            block7: for (int i = 0; i < row.fields.size(); ++i) {
                FieldDescriptor field = row.fields.get(i);
                SqlParameter value = (SqlParameter)row.values.get(i);
                if (value.isNull()) {
                    this.dataAudit.registrateSetNull(this.table, row.rowId, modification, field.getId());
                    continue;
                }
                switch (value.getType()) {
                    case BLOB: {
                        this.dataAudit.registrateSetBlob(this.table, row.rowId, modification, field, value.getBlob());
                        continue block7;
                    }
                    case DATE_TIME: 
                    case TIMESTAMP: {
                        this.dataAudit.registrateSetDateTime(this.table, row.rowId, modification, field.getId(), value.getDateTime());
                        continue block7;
                    }
                    case DOUBLE: 
                    case INTEGER: 
                    case BOOLEAN: {
                        this.dataAudit.registrateSetNumber(this.table, row.rowId, modification, field.getId(), value.getDouble());
                        continue block7;
                    }
                    case STRING: 
                    case FILE: {
                        this.dataAudit.registrateSetString(this.table, row.rowId, modification, field.getId(), value.getString());
                        continue block7;
                    }
                    case UNICODE: {
                        this.dataAudit.registrateSetUnicode(this.table, row.rowId, modification, field.getId(), value.getString());
                    }
                }
            }
        }
        this.dataAudit.registrateModification(this.table, row.rowId, modification, 0.0);
        this.idle();
    }

    private void registerDetectedChanges(UnpackedRowContent row, IntegerList modifiedFields) throws InformException, SQLException {
        this.idle();
        if (this.dataAudit == null) {
            return;
        }
        if (row.userId != 0.0) {
            this.dataAudit.setUserID(row.userId);
        }
        this.dataAudit.setOwnerId(row.dataLogOwnerId);
        this.dataAudit.setAuditEventId(row.dataLogEventId);
        if (this.dataAudit.isDataAuditEnabled(this.table)) {
            for (IntegerList.Cursor i : modifiedFields) {
                FieldDescriptor field = row.fields.get(i.value);
                SqlParameter value = (SqlParameter)row.values.get(i.value);
                if (value.isNull()) {
                    this.dataAudit.registrateSetNull(this.table, row.rowId, AuditModification.MODIFY, field.getId());
                    continue;
                }
                switch (value.getType()) {
                    case BLOB: {
                        this.dataAudit.registrateSetBlob(this.table, row.rowId, AuditModification.MODIFY, field, value.getBlob());
                        break;
                    }
                    case DATE_TIME: 
                    case TIMESTAMP: {
                        this.dataAudit.registrateSetDateTime(this.table, row.rowId, AuditModification.MODIFY, field.getId(), value.getDateTime());
                        break;
                    }
                    case DOUBLE: 
                    case INTEGER: 
                    case BOOLEAN: {
                        this.dataAudit.registrateSetNumber(this.table, row.rowId, AuditModification.MODIFY, field.getId(), value.getDouble());
                        break;
                    }
                    case STRING: 
                    case FILE: {
                        this.dataAudit.registrateSetString(this.table, row.rowId, AuditModification.MODIFY, field.getId(), value.getString());
                        break;
                    }
                    case UNICODE: {
                        this.dataAudit.registrateSetUnicode(this.table, row.rowId, AuditModification.MODIFY, field.getId(), value.getString());
                    }
                }
            }
        }
        this.dataAudit.registrateModification(this.table, row.rowId, AuditModification.MODIFY, 0.0);
        this.idle();
    }

    private void throwAbsentChangedRow(UnpackedRowContent row) throws InformException {
        String msg = "\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 [" + NumberConverter.doubleToString(row.rowId) + "] \u0442\u0430\u0431\u043b\u0438\u0446\u044b [" + NumberConverter.doubleToString(this.table.getNodeId()) + "] \u043a \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0437\u0430\u043f\u0438\u0441\u0438";
        throw new InformException(msg);
    }

    public void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    public void setBfs(BFS bfs) {
        this.bfs = bfs;
    }

    public void setBfsReplica(BFS.Replica bfsReplica) {
        this.bfsReplica = bfsReplica;
    }

    private void addExtractionTextInsertParams(StringBuilder sql, FieldDescriptor field, UnpackedRowContent row, byte[] data) {
        String text = this.extractText(field, row, data);
        IntegerSet extractionFields = field.getExtractionTextFields();
        if (extractionFields == null) {
            return;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor fd = this.table.getExistingFieldDescriptor(fieldId);
            this.command.sqlText.append(',').append(fd);
            sql.append(',').append(this.caps.tranformSqlParameter(fd));
            int size = TextExtractor.maxTextLength(fd);
            if (size > 0 && text != null && text.length() > size) {
                this.command.params.add(new SqlParameter().setString(text.substring(0, size)));
                continue;
            }
            this.command.params.add(new SqlParameter().setString(text));
        }
    }

    private void addExtractionTextUpdateParams(FieldDescriptor field, UnpackedRowContent row, byte[] data) {
        String text = this.extractText(field, row, data);
        IntegerSet extractionFields = field.getExtractionTextFields();
        if (extractionFields == null) {
            return;
        }
        for (Cursor.Integer c : extractionFields) {
            int fieldId = c.value;
            FieldDescriptor fd = this.table.getExistingFieldDescriptor(fieldId);
            this.command.addModifiedField(fd.getId());
            this.command.sqlText.append(',').append(fd).append('=').append(this.caps.tranformSqlParameter(fd));
            int size = TextExtractor.maxTextLength(fd);
            if (size > 0 && text != null && text.length() > size) {
                this.command.params.add(new SqlParameter().setString(text.substring(0, size)));
                continue;
            }
            this.command.params.add(new SqlParameter().setString(text));
        }
    }

    private String extractText(FieldDescriptor field, UnpackedRowContent row, byte[] data) {
        String text = null;
        if (data != null) {
            try {
                ExtractionDataInfo info = null;
                ArrayList<FieldDescriptor> pkFields = this.table.getPrimaryKeyFields();
                if (pkFields.size() == 1 && this.table.getRecordIdField() != null) {
                    info = new ExtractionDataInfo(this.table, field, row.rowId);
                } else {
                    ArrayList<ReplicationRecord.Value> pkValues = new ArrayList<ReplicationRecord.Value>();
                    for (int index = 0; index < row.fields.size(); ++index) {
                        FieldDescriptor fld = row.fields.get(index);
                        if (!fld.isPrimaryKey()) continue;
                        ReplicationRecord.Value value = new ReplicationRecord.Value(fld, index);
                        value.assign((SqlParameter)row.values.get(index));
                        pkValues.add(value);
                    }
                    info = new ExtractionDataInfo(this.table, field, pkValues);
                }
                TextExtractor textExtractor = new TextExtractor(data, info);
                TextExtractor.DOCUMENT_FORMAT format = textExtractor.getFormat();
                if (format != null && format != TextExtractor.DOCUMENT_FORMAT.DOCUMENT_BINARY) {
                    text = textExtractor.extractText();
                }
            }
            catch (Exception ex) {
                Core.logger.log(AsmoLogger.Level.ERROR, null, ex);
            }
        }
        return text;
    }
}

