/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneHost;
import inform.adt.TimeZoneOffsetHost;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.AgentJARVersion;
import inform.agent.CancelRequestException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.Restructure;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.LockEngine;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.replication.ApplyException;
import inform.agent.replication.DataReplicationApplyEngine;
import inform.agent.replication.ReceivingTable;
import inform.agent.replication.Replication;
import inform.agent.replication.ReplicationException;
import inform.agent.replication.TableDataIO;
import inform.agent.replication.UploadParams;
import inform.agent.scripts.SSContext;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class ReplicationApplyEngine {
    public long startTime;
    long metadataTime;
    long dataTime;
    long endTime;
    private String nodeMessage;
    private final ProgressInfo progressInfo;
    private final Replication.ReplicaContext ssContext;
    private final double receivingId;
    private final double defaultTableNodeParentId;
    private double backReceivingId = 0.0;
    private final ServerSideHost ssHost;
    private TimeZoneHost timeZoneHost = null;
    private long replicaSize = 0L;
    private String replicaFileName = null;
    private double replicantId;
    private NodeRecord nodeRecord = null;
    private boolean dataReplicationFollow = false;
    private boolean deferredCheckConstraints = false;
    private byte[] nodeContent = null;
    private String dslContent = null;
    private MetadataNodeReader.NodeChanges nodeChanges = null;
    private final AuditJournal.ReplicationParams audit;
    private Stage stage;
    private final AbstractConnectionManager connectionManager;
    private DatabaseConnection metabaseConnection;
    private TableDataIO tableData = null;
    private TableDataIO.Upload upload = null;
    private UploadParams uploadParams = null;
    private final DoubleSet processedNodes = new DoubleSet();
    private final DoubleSet nodesToDelete = new DoubleSet();
    private final DoubleSet syncChildrenNodes = new DoubleSet();
    private final DoubleHash<ProcessedTable> processedTables = new DoubleHash();
    private String auditComment = null;
    private int mtdChangeCount = 0;
    private int commitCount;
    private double replicaId = 0.0;
    private double processingNodeId = 0.0;
    private boolean lockReplica = false;
    private int initSate = 0;
    private boolean replaceData = false;
    private boolean rollbackRegistered = false;
    private boolean securityChanged;
    private UsersTable usersTable = null;
    private boolean needUpdateMtdCache = false;
    private boolean wasEndOfReplica = false;
    private static final String INVALID_REPLICATION = "\u0420\u0435\u043f\u043b\u0438\u043a\u0430 \u043f\u043e\u0432\u0440\u0435\u0436\u0435\u0434\u0435\u043d\u0430 \u0438\u043b\u0438 \u0438\u043c\u0435\u0435\u0442 \u043d\u043e\u0432\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442";
    private static final int INIT_STATE_RECEIVER_CHECKED = 1;
    private static final int INIT_STATE_REPLICA_ID_RECEIVED = 2;
    private static final int INIT_STATE_REPLICA_NODE_RECEIVED = 4;
    private static final int INIT_STATE_CHECKED = 8;

    public ReplicationApplyEngine(SSContext parentContext, double receivingId, ServerSideHost ssHost, ProgressInfo progressInfo) throws IOException {
        this.receivingId = receivingId;
        this.ssHost = ssHost;
        this.timeZoneHost = Core.serverTimeZoneHost;
        this.stage = Stage.INIT;
        this.audit = new AuditJournal.ReplicationParams();
        this.audit.opCode = 2;
        this.audit.timeBeginOperation = DateTime.currentDateTime();
        this.audit.userNodeId = ssHost.security().id;
        this.audit.channelId = receivingId;
        this.commitCount = 0;
        this.progressInfo = progressInfo;
        this.ssContext = new Replication.ReplicaContext(SSContext.getContext(parentContext));
        this.ssContext.type = "\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0438";
        this.ssContext.channelId = receivingId;
        this.connectionManager = new ConnectionManager(this.ssContext, "ReplicationApplyEngine", true);
        this.needUpdateMtdCache = false;
        double accountId = 0.0;
        String receivingTitle = "";
        ReceivingTable receivingTable = new ReceivingTable();
        this.defaultTableNodeParentId = receivingTable.enabled() ? receivingTable.table().getNodeId() : receivingId;
        SqlParameter[] receivingFields = null;
        try {
            receivingFields = receivingTable.select(this.ssContext, receivingId);
        }
        catch (SQLException e) {
            throw InformException.wrap(e);
        }
        if (receivingFields != null) {
            SqlParameter field = receivingFields[1];
            if (field != null) {
                receivingTitle = field.getString();
            }
            if ((field = receivingFields[2]) != null) {
                accountId = field.getDouble();
            }
        } else {
            Node receiving = MtdEngine.getNode(receivingId);
            if (receiving == null || receiving.getType() != 23) {
                this.registerFailed("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 " + NumberConverter.doubleToString(receivingId));
                MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438", receivingId);
            }
            byte[] receivingContent = receiving.getRealNode().getContent();
            TaggedReader in = new TaggedReader(receivingContent);
            while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        accountId = in.getNodeID();
                    }
                }
            }
        }
        AccountNode account = null;
        if (accountId != 0.0 && (account = MtdEngine.getAccountNode(accountId)) == null) {
            String text = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c[" + (long)accountId + "], \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439 \u0432 \u0443\u0437\u043b\u0435 \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 " + receivingTitle + "[" + (long)receivingId + "]";
            this.registerFailed(text);
            throw new InformException(text);
        }
        this.uploadParams = new UploadParams(receivingId, account);
        this.uploadParams.auditData = true;
    }

    public void idle() {
        this.ssHost.idle();
    }

    public double getReplicaId() {
        return this.replicaId;
    }

    public double getProcessingNodeId() {
        return this.processingNodeId;
    }

    public Stage getStage() {
        return this.stage;
    }

    public static void throwInvalidReplicationStream(String detailing) throws ApplyException {
        throw new ApplyException(INVALID_REPLICATION).detail(detailing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double finalizeReplica(long replicaSize, String fileName) throws InformException, IOException, SQLException {
        double auditID = 0.0;
        try {
            if (!this.wasEndOfReplica) {
                throw new ReplicationException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e\u0449\u0430\u044f \u0447\u0430\u0441\u0442\u044c \u0440\u0435\u043f\u043b\u0438\u043a\u0438");
            }
            this.commit();
            if (this.commitCount > 0) {
                this.commitCount = 0;
                AuditJournal jornal = new AuditJournal(AuditJournal.Journal.REPLICATION);
                this.audit.timeEndOperation = DateTime.currentDateTime();
                this.audit.successfullyResult = true;
                this.audit.replicaSize = replicaSize < this.replicaSize ? (double)this.replicaSize : (double)replicaSize;
                this.audit.fileName = fileName != null ? fileName : this.replicaFileName;
                auditID = jornal.registerReplication(this.ssContext, this.audit);
            }
            if (this.securityChanged) {
                AccountNode.invalidateSecurity();
            }
        }
        finally {
            if (this.upload != null) {
                this.tableData.closeUpload(this.upload);
            }
            this.connectionManager.release();
        }
        return auditID;
    }

    private void commit() throws SQLException, IOException, InformException {
        if (this.metabaseConnection != null) {
            double[] list = this.nodesToDelete.toArray();
            double[] toDelete = new double[list.length];
            int deleteCount = 0;
            for (double id : list) {
                if (this.processedNodes.contains(id)) continue;
                toDelete[deleteCount++] = id;
            }
            if (deleteCount > 0) {
                MetadataNodeReader.rawDeleteNodesTransact(this.ssContext, this.ssHost.getUserID(), toDelete, deleteCount, this.metabaseConnection, this.ssContext);
                ++this.mtdChangeCount;
            }
            this.metabaseConnection.commit();
            this.metabaseConnection.close();
            this.metabaseConnection = null;
            ++this.commitCount;
        }
        if (this.upload != null) {
            this.upload.applyEngine.commit();
            this.tableData.closeUpload(this.upload);
            this.upload = null;
            ++this.commitCount;
        }
        if (this.mtdChangeCount > 0) {
            MtdEngine.invalidate();
            ++this.commitCount;
        }
        this.mtdChangeCount = 0;
        this.rollbackRegistered = false;
        this.endTime = System.currentTimeMillis();
    }

    public void rollback(Throwable error) {
        if (this.rollbackRegistered) {
            error = null;
        } else {
            boolean bl = this.rollbackRegistered = error != null;
        }
        if (this.metabaseConnection != null) {
            try {
                this.metabaseConnection.close();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
            this.metabaseConnection = null;
        }
        if (this.upload != null) {
            try {
                this.upload.applyEngine.rollback();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
            try {
                this.tableData.closeUpload(this.upload);
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
        }
        this.upload = null;
        if (this.mtdChangeCount > 0) {
            MtdEngine.invalidate();
        }
        this.mtdChangeCount = 0;
        if (error != null) {
            this.registerFailed(AuditJournal.getJournalErrorText(error));
        }
    }

    private void registerFailed(String msg) {
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        this.audit.timeEndOperation = DateTime.currentDateTime();
        this.audit.successfullyResult = false;
        this.audit.resultMessage = msg;
        try {
            journal.registerReplication(this.ssContext, this.audit);
        }
        catch (InformException ex1) {
            Core.logger.error(null, ex1);
        }
    }

    public void close() {
        if (this.lockReplica) {
            LockEngine.unlockReplica(this.audit.replNodeId, this.receivingId);
        }
    }

    private void waitMtdCache() throws InterruptedException {
        if (this.needUpdateMtdCache) {
            this.needUpdateMtdCache = false;
            MtdEngine.invalidate();
            for (int i = 0; i < 100; ++i) {
                if (MtdEngine.wasLoaded()) {
                    if (i <= 1) break;
                    Core.logger.info("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043a\u0435\u0448\u0430 \u0443\u0437\u043b\u043e\u0432 {} \u0440\u0430\u0437 (\u0441\u0435\u043a\u0443\u043d\u0434)", (Object)i);
                    break;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
        }
    }

    public void process(TaggedReader in) throws InformException, SQLException {
        this.rollbackRegistered = false;
        if (this.metabaseConnection == null) {
            this.metabaseConnection = this.connectionManager.getConnection(2.0, "ReplicationApplyEngine");
            this.metabaseConnection.setPendingDirty();
        }
        try {
            while (in.next()) {
                this.idle();
                switch (in.getCurrentTag()) {
                    case 99: {
                        this.wasEndOfReplica = true;
                        this.commit();
                        return;
                    }
                    case 100: {
                        long minApplyServerVersion = in.getUnsignedInt();
                        if (VersionInfo.toNumber(AgentJARVersion.MAJOR, AgentJARVersion.MINOR, AgentJARVersion.RELEASE) >= minApplyServerVersion) break;
                        throw new InformException("\u0414\u043b\u044f \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440 \u0441 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 " + VersionInfo.toString(minApplyServerVersion));
                    }
                }
                switch (this.stage) {
                    case INIT: {
                        this.dataTime = this.endTime = System.currentTimeMillis();
                        this.metadataTime = this.endTime;
                        this.startTime = this.endTime;
                        this.processInit(in);
                        break;
                    }
                    case CHECK_TABLE_STRUCT: {
                        this.processCheckTableStruct(in);
                        break;
                    }
                    case TABLE_METADATA: 
                    case METADATA: {
                        try {
                            this.processMetadata(in);
                            break;
                        }
                        catch (Throwable ex) {
                            try {
                                this.rollback(ex);
                            }
                            catch (Throwable ex2) {
                                throw ApplyException.remake(null, this.nodeMessage + "\n" + ex2.toString(), ex);
                            }
                            throw ApplyException.remake(null, this.nodeMessage, ex);
                        }
                    }
                    case TABLE_DATA: {
                        try {
                            this.processTableData(in);
                            break;
                        }
                        catch (ApplyException ex) {
                            throw ex;
                        }
                        catch (Throwable ex) {
                            throw ApplyException.remake(this.getApplyTableDataError(this.processingNodeId), this.nodeMessage, ex);
                        }
                    }
                }
            }
        }
        catch (CancelRequestException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw ApplyException.remake(null, this.nodeMessage, ex);
        }
    }

    private String getApplyTableDataError(double tableId) {
        StringBuilder msg = new StringBuilder();
        String caption = MtdEngine.tryGetNodeName(tableId);
        if (caption == null) {
            msg.append("\u0442\u0430\u0431\u043b\u0438\u0446\u0430 ").append((long)tableId).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        } else {
            msg.append("\u0434\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(MtdEngine.tryGetNodeName(tableId)).append(" [").append((long)tableId).append(']');
        }
        return msg.toString();
    }

    private void processInit(TaggedReader in) throws IOException, TaggedReaderException, ApplyException {
        switch (in.getCurrentTag()) {
            case 27: {
                this.wasEndOfReplica = false;
                double destinationId = in.getDouble();
                if (destinationId != this.receivingId) {
                    throw new ApplyException("\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0438 \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442").detail(this.nodeMessage);
                }
                this.initSate |= 1;
                break;
            }
            case 19: {
                this.replicantId = in.getDouble();
                break;
            }
            case 94: {
                this.replicaSize = in.getLong();
                break;
            }
            case 95: {
                this.replicaFileName = in.getString();
                break;
            }
            case 20: {
                this.wasEndOfReplica = false;
                this.audit.replicaId = this.uploadParams.replicaId = in.getDouble();
                this.replicaId = this.uploadParams.replicaId;
                this.auditComment = "\u0420\u0435\u043f\u043b\u0438\u043a\u0430 " + NumberConverter.doubleToString(this.audit.replicaId);
                this.initSate |= 2;
                Core.logger.info("replica-id: {}", (Object)NumberConverter.doubleToString(this.audit.replicaId));
                break;
            }
            case 16: {
                this.checkInitState();
                this.stage = Stage.TABLE_METADATA;
                this.dataTime = this.endTime = System.currentTimeMillis();
                this.metadataTime = this.endTime;
                break;
            }
            case 17: {
                this.checkInitState();
                this.stage = Stage.METADATA;
                this.dataTime = this.endTime = System.currentTimeMillis();
                this.metadataTime = this.endTime;
                break;
            }
            case 18: {
                this.checkInitState();
                this.stage = Stage.TABLE_DATA;
                this.dataTime = this.endTime = System.currentTimeMillis();
                this.tableData = new TableDataIO(this.ssContext, this.ssHost, this.timeZoneHost);
                break;
            }
            case 34: {
                if (!Core.isTimeZoneConversionUsed) break;
                this.timeZoneHost = new TimeZoneOffsetHost(in.getInt());
                break;
            }
            case 21: {
                this.audit.dataSliceBegin = DateTime.toServerTime(in.getDouble(), this.timeZoneHost);
                break;
            }
            case 22: {
                this.audit.dataSliceEnd = DateTime.toServerTime(in.getDouble(), this.timeZoneHost);
                if (this.nodeMessage == null) break;
                this.nodeMessage = this.nodeMessage + ", data-slice-begin: " + DateTime.toString(this.audit.dataSliceBegin) + ", data-slice-end: " + DateTime.toString(this.audit.dataSliceEnd);
                Core.logger.info("\u041f\u0440\u0438\u0451\u043c \u0440\u0435\u043f\u043b\u0438\u043a\u0438 [replnode-id: {}, receiving-id: {}, back-receiving-id: {}, replica-id: {}, data-slice-begin: {}, data-slice-end: {}]", NumberConverter.doubleToString(this.audit.replNodeId), NumberConverter.doubleToString(this.receivingId), NumberConverter.doubleToString(this.backReceivingId), NumberConverter.doubleToString(this.replicaId), DateTime.toString(this.audit.dataSliceBegin), DateTime.toString(this.audit.dataSliceEnd));
                break;
            }
            case 24: {
                this.uploadParams.auditData = false;
                Core.logger.info("\u0420\u0435\u0436\u0438\u043c \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438: \u0430\u0443\u0434\u0438\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
                break;
            }
            case 25: {
                this.replaceData = true;
                Core.logger.info("\u0420\u0435\u0436\u0438\u043c \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438: \u043f\u043e\u043b\u043d\u043e\u0435 \u0437\u0430\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445");
                break;
            }
            case 26: {
                this.wasEndOfReplica = false;
                this.initSate |= 4;
                this.audit.replNodeId = in.getDouble();
                if (this.ssContext != null) {
                    this.ssContext.nodeId = this.audit.replNodeId;
                }
                this.nodeMessage = "\"" + MtdEngine.tryGetNodeName(this.audit.replNodeId) + "\" \u0447\u0435\u0440\u0435\u0437 \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \"" + NumberConverter.doubleToString(this.receivingId) + "\"[replnode-id: " + NumberConverter.doubleToString(this.audit.replNodeId) + ", receiving-id: " + NumberConverter.doubleToString(this.receivingId) + ", back-receiving-id: " + NumberConverter.doubleToString(this.backReceivingId) + ", replica-id: " + NumberConverter.doubleToString(this.replicaId) + "\"";
                assert (!this.lockReplica);
                LockEngine.Locker locker = LockEngine.lockReplica(this.audit.replNodeId, this.receivingId, this.ssHost.getUserID());
                if (locker != null) {
                    throw new ApplyException("\u0420\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0443\u0437\u043b\u0443 \u043f\u0440\u0438\u0435\u043c\u0430 \u0443\u0436\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f").detail(this.nodeMessage);
                }
                this.lockReplica = true;
                break;
            }
            case 28: {
                this.checkInitState();
                this.stage = Stage.CHECK_TABLE_STRUCT;
                break;
            }
            case 31: {
                this.deferredCheckConstraints = true;
                break;
            }
            case 32: {
                this.backReceivingId = in.getDouble();
            }
        }
    }

    private void checkInitState() throws ApplyException {
        if ((this.initSate & 8) != 0) {
            return;
        }
        if ((this.initSate & 1) == 0) {
            throw new ApplyException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430").detail(this.nodeMessage);
        }
        if ((this.initSate & 2) == 0) {
            throw new ApplyException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d ID \u0440\u0435\u043f\u043b\u0438\u043a\u0438").detail(this.nodeMessage);
        }
        if ((this.initSate & 4) == 0) {
            throw new ApplyException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438").detail(this.nodeMessage);
        }
        this.initSate |= 8;
    }

    private void checkTableStruct(double tableId, byte[] struct) throws IOException {
        TableDescriptor table = TableDescriptor.get(tableId);
        TaggedReader in = new TaggedReader(struct);
        while (in.next()) {
            int fieldId = in.getInt(1);
            in.getInt(2);
            String caption = in.getString(3);
            FieldDescriptor field = table.getFieldDescriptor(fieldId);
            if (field == null) {
                String msg = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + caption + " [" + fieldId + "] \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + table.getCaption() + " [" + (long)table.getNodeId() + "]";
                throw new ApplyException(msg);
            }
            if (!field.isAbstract()) continue;
            String msg = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043f\u043e\u043b\u0435 " + caption + " [" + fieldId + "] \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + table.getCaption() + " [" + (long)table.getNodeId() + "]";
            throw new ApplyException(msg);
        }
    }

    private void processCheckTableStruct(TaggedReader in) throws IOException, InformException {
        switch (in.getCurrentTag()) {
            case 29: {
                this.checkTableStruct(in.getDouble(), in.getRaw(202));
                break;
            }
            default: {
                this.processInit(in);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMetadata(TaggedReader in) throws IOException, InformException, SQLException {
        switch (in.getCurrentTag()) {
            case 1: {
                this.processingNodeId = in.getDouble();
                this.dataReplicationFollow = false;
                this.nodeRecord = new NodeRecord(NodeStatus.MODIFIED);
                this.nodeRecord.setId(this.processingNodeId);
                break;
            }
            case 2: {
                this.nodeRecord.setParentId(in.getDouble());
                break;
            }
            case 3: {
                this.nodeRecord.setType(in.getInt());
                break;
            }
            case 4: {
                this.nodeRecord.setName(in.getAnsi());
                break;
            }
            case 5: {
                this.nodeRecord.setIdentName(in.getAnsi());
                break;
            }
            case 6: {
                this.nodeRecord.setDescription(in.getAnsi());
                break;
            }
            case 7: {
                this.nodeRecord.setOwnerId(in.getDouble());
                break;
            }
            case 8: {
                this.nodeRecord.setOrderNo(in.getInt());
                break;
            }
            case 9: {
                this.nodeRecord.setCreationTime(DateTime.toUnixTime(in.getDouble()) + (long)DateTime.serverTimeZoneOffset(this.timeZoneHost));
                break;
            }
            case 10: {
                this.nodeRecord.setModificationContentTime(DateTime.toUnixTime(in.getDouble()) + (long)DateTime.serverTimeZoneOffset(this.timeZoneHost));
                break;
            }
            case 11: {
                this.nodeRecord.setModificationUserId(in.getDouble());
                break;
            }
            case 12: {
                this.nodeRecord.setRawAttributes(in.getRaw());
                break;
            }
            case 13: {
                this.nodeContent = in.getRaw();
                break;
            }
            case 35: {
                this.dslContent = new String(in.getRaw(), TaggedWriter.UTF8);
                break;
            }
            case 30: {
                this.dataReplicationFollow = true;
                break;
            }
            case 14: {
                syncChildren = LittleEndian.toDoubleArray(in.getRaw());
                for (double child : children = MetadataNodeReader.getNodeChildrenIds(this.ssContext, this.metabaseConnection, this.nodeRecord.getId())) {
                    missing = true;
                    for (double sync : syncChildren) {
                        if (child != sync) continue;
                        missing = false;
                        break;
                    }
                    if (!missing) continue;
                    this.nodesToDelete.add(child);
                }
                this.syncChildrenNodes.add(this.nodeRecord.getId());
                break;
            }
            case 23: {
                this.processedNodes.add(this.nodeRecord.getId());
                try {
                    this.flushAuthentication(in.getStreamReader());
                }
                catch (Throwable ex) {
                    throw ApplyException.remake("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f [ \u0443\u0437\u0435\u043b: " + NumberConverter.doubleToString(this.processingNodeId) + "]", this.nodeMessage, ex);
                }
                ++this.mtdChangeCount;
                break;
            }
            case 15: {
                if (this.stage == Stage.TABLE_METADATA) {
                    if (this.processedNodes.contains(this.nodeRecord.getId())) {
                        this.nodeRecord = null;
                        break;
                    }
                    try {
                        this.flushTableNode();
                        if (this.progressInfo == null) ** GOTO lbl105
                        try {
                            this.progressInfo.updateProgress("\u041c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + this.nodeRecord.getName());
                        }
                        catch (Exception e) {
                            Core.logger.error(null, e);
                        }
                    }
                    catch (Throwable ex) {
                        throw ApplyException.remake("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b [\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + NumberConverter.doubleToString(this.processingNodeId) + "]", this.nodeMessage, ex);
                    }
                } else {
                    try {
                        if (this.nodeRecord.getType() != 12 && this.processedNodes.contains(this.nodeRecord.getId())) {
                            this.nodeRecord = null;
                            break;
                        }
                        this.flushMetadataNode();
                        if (this.progressInfo != null) {
                            try {
                                this.progressInfo.updateProgress("\u0423\u0437\u0435\u043b " + this.nodeRecord.getName());
                            }
                            catch (Exception e) {
                                Core.logger.error(null, e);
                            }
                        }
                    }
                    catch (InformException ex) {
                        throw ApplyException.remake("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0437\u043b\u0430 [\u0443\u0437\u0435\u043b: " + NumberConverter.doubleToString(this.processingNodeId) + "]", this.nodeMessage, ex);
                    }
                }
lbl105:
                // 5 sources

                this.processedNodes.add(this.nodeRecord.getId());
                this.nodeRecord = null;
                ++this.mtdChangeCount;
                break;
            }
            case 16: {
                this.stage = Stage.TABLE_METADATA;
                this.dataTime = this.endTime = System.currentTimeMillis();
                this.metadataTime = this.endTime;
                break;
            }
            case 17: {
                this.stage = Stage.METADATA;
                this.dataTime = this.endTime = System.currentTimeMillis();
                this.metadataTime = this.endTime;
                break;
            }
            case 18: {
                this.commit();
                this.stage = Stage.TABLE_DATA;
                this.dataTime = this.endTime = System.currentTimeMillis();
                this.tableData = new TableDataIO(this.ssContext, this.ssHost, this.timeZoneHost);
            }
        }
    }

    private void processTableData(TaggedReader in) throws IOException, InformException, InterruptedException {
        switch (in.getCurrentTag()) {
            case 91: {
                double tableId;
                this.processingNodeId = tableId = in.getDouble();
                Core.logger.info("[ {} ] {} import data", (Object)NumberConverter.doubleToString(tableId), (Object)MtdEngine.tryGetNodeName(tableId));
                if (this.progressInfo != null) {
                    String tableName = MtdEngine.tryGetNodeName(tableId);
                    if (tableName == null) {
                        tableName = "";
                    }
                    try {
                        this.progressInfo.updateProgress("\u0414\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + tableName);
                    }
                    catch (Exception e) {
                        Core.logger.error(null, e);
                    }
                }
                this.checkSecurityChanging(tableId);
                ProcessedTable table = this.getProcessedTable(tableId);
                this.uploadParams.replaceData = this.replaceData && !table.contentReplicated;
                this.uploadParams.insertData = this.replaceData;
                this.uploadParams.deferredCheckConstraints = this.deferredCheckConstraints;
                if (this.upload == null) {
                    this.waitMtdCache();
                    try {
                        this.upload = this.tableData.beginUpload(tableId, table.content, this.uploadParams, IntegerSet.EMPTY);
                        this.upload.detailing = this.nodeMessage;
                        break;
                    }
                    catch (Throwable ex) {
                        throw ApplyException.remake(this.getApplyTableDataError(tableId), this.nodeMessage, ex);
                    }
                }
                try {
                    this.upload.applyEngine.endUploadTableData();
                }
                catch (Throwable ex) {
                    throw ApplyException.remake(this.getApplyTableDataError(this.upload.tableId), this.nodeMessage, ex);
                }
                this.upload.tableId = tableId;
                this.upload.params = this.uploadParams;
                this.upload.applyEngine.setReplaceData(this.uploadParams.replaceData);
                this.upload.applyEngine.setInsertData(this.uploadParams.insertData);
                try {
                    this.upload.tableInfo = new TableDescriptor(tableId, table.content, true);
                    this.upload.fields = IntegerSet.EMPTY;
                    this.upload.applyEngine.beginUploadTableData(this.upload.tableInfo);
                    break;
                }
                catch (Throwable ex) {
                    throw ApplyException.remake(this.getApplyTableDataError(tableId), this.nodeMessage, ex);
                }
            }
            case 93: {
                if (this.upload == null) {
                    ReplicationApplyEngine.throwInvalidReplicationStream(this.nodeMessage);
                }
                double[] fields = LittleEndian.toDoubleArray(in.getRaw());
                IntegerSet filter = new IntegerSet();
                for (double field : fields) {
                    filter.add((int)field);
                }
                this.upload.fields = filter;
                break;
            }
            case 92: {
                if (this.upload == null) {
                    ReplicationApplyEngine.throwInvalidReplicationStream(this.nodeMessage);
                }
                try {
                    this.upload.applyEngine.endUploadTableData();
                    break;
                }
                catch (Throwable ex) {
                    throw ApplyException.remake(this.getApplyTableDataError(this.upload.tableId), this.nodeMessage, ex);
                }
            }
            default: {
                if (this.upload == null) {
                    ReplicationApplyEngine.throwInvalidReplicationStream(this.nodeMessage);
                }
                try {
                    this.tableData.processUploadTag(this.upload, in);
                    break;
                }
                catch (Throwable ex) {
                    throw ApplyException.remake(this.getApplyTableDataError(this.upload.tableId), this.nodeMessage, ex);
                }
            }
        }
    }

    private ProcessedTable getProcessedTable(double tableId) throws InformException {
        ProcessedTable table = this.processedTables.get(tableId);
        if (table == null) {
            BasicNode node = MtdEngine.getValidTranslatedNode(tableId);
            table = new ProcessedTable(tableId, node.getParentId());
            table.content = node.getContent();
            table.contentReplicated = false;
            this.processedTables.add(table);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntegerSet restructTable(TableDescriptor nd, TableDescriptor od) throws SQLException {
        if (Restructure.isRestructurable(nd)) {
            try (DatabaseConnection connection = nd.getDatabaseDescriptor().connect(this.ssHost, "ReplicationApplyEngine::restructTable");){
                IntegerSet integerSet;
                DbScheme scheme = connection.openScheme();
                Statement statement = connection.createStatement();
                try {
                    IntegerSet up = Restructure.updateStructure(this.ssContext, scheme, statement, nd, od, Restructure.DDL_LOGGER, Restructure.Strategy.UPDATE, Restructure.Progress.NULL);
                    connection.commit();
                    integerSet = up;
                }
                catch (Throwable throwable) {
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return integerSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restructTableIndices(TableDescriptor nd, TableDescriptor od, IntegerSet up) throws SQLException {
        try (DatabaseConnection connection = nd.getDatabaseDescriptor().connect(this.ssHost, "ReplicationApplyEngine::restructTableIndices");){
            DbScheme scheme = connection.openScheme();
            try (Statement statement = connection.createStatement();){
                Restructure.restructureIndices(this.ssContext, scheme, statement, nd, od, Restructure.DDL_LOGGER, Restructure.Strategy.UPDATE, up, Restructure.Progress.NULL);
                connection.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restructExistingTableNode() throws SQLException {
        TableDescriptor nd = new TableDescriptor(this.nodeRecord.getId(), this.nodeContent);
        if (Restructure.isRestructurable(nd)) {
            TableDescriptor od = TableDescriptor.get(this.nodeRecord.getId());
            try (DatabaseConnection connection = nd.getDatabaseDescriptor().connect(this.ssHost, "ReplicationApplyEngine::restructExistingTableNode");){
                DbScheme scheme = connection.openScheme();
                try (Statement statement = connection.createStatement();){
                    IntegerSet up = Restructure.updateStructure(this.ssContext, scheme, statement, nd, od, Restructure.DDL_LOGGER, Restructure.Strategy.UPDATE, Restructure.Progress.NULL);
                    if (up != null) {
                        Restructure.restructureIndices(this.ssContext, scheme, statement, nd, od, Restructure.DDL_LOGGER, Restructure.Strategy.UPDATE, up, Restructure.Progress.NULL);
                    }
                    connection.commit();
                }
            }
        }
    }

    private void flushTableNode() throws SQLException, InformException {
        Core.logger.info("\u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + NumberConverter.doubleToString(this.nodeRecord.getId()));
        if (!MetadataNodeReader.isNodeExists(this.ssContext, this.nodeRecord.getParentId(), this.metabaseConnection)) {
            this.nodeRecord.setParentId(this.defaultTableNodeParentId);
            this.needUpdateMtdCache = true;
        }
        if (this.nodeChanges == null) {
            this.nodeChanges = new MetadataNodeReader.NodeChanges();
        } else {
            this.nodeChanges.clear();
        }
        Node oldNode = MtdEngine.getNode(this.nodeRecord.getId());
        try {
            boolean isNewNode;
            if (oldNode != null) {
                byte[] oldContent;
                oldNode.lockBarrier(0.0);
                if (!Ini.SkipRestructureIfUnchanged && oldNode.isSame(this.nodeRecord) && oldNode instanceof BasicNode && Arrays.equals(oldContent = ((BasicNode)oldNode).getContent(0.0), this.nodeContent)) {
                    this.restructExistingTableNode();
                    if (this.replaceData && this.dataReplicationFollow) {
                        DataReplicationApplyEngine.truncateTableRecords(this.ssContext, this.metabaseConnection, (TableNode)MtdEngine.getValidNodeSync(this.ssContext, this.nodeRecord.getId()), this.receivingId, this.replicaId, this.ssHost.getUserID(), this.ssHost.getSessionID(), this.ssHost.security());
                    }
                    return;
                }
            }
            boolean bl = isNewNode = !MetadataNodeReader.isNodeExists(this.ssContext, this.nodeRecord.getId(), this.metabaseConnection);
            if (isNewNode) {
                this.nodeChanges.setId(this.nodeRecord.getId());
                this.nodeChanges.setType(this.nodeRecord.getType());
                this.nodeChanges.setCreationTime(this.nodeRecord.getCreationTime());
            }
            this.nodeChanges.setParentId(this.nodeRecord.getParentId());
            this.nodeChanges.setName(this.nodeRecord.getName());
            this.nodeChanges.setIdentName(this.nodeRecord.getIdentName());
            this.nodeChanges.setDescription(this.nodeRecord.getDescription());
            this.nodeChanges.setOwnerId(this.nodeRecord.getOwnerId());
            this.nodeChanges.setOrderNo(this.nodeRecord.getOrderNo());
            this.nodeChanges.setModificationContentTime(this.nodeRecord.getModificationContentTime());
            this.nodeChanges.setModificationUserId(this.nodeRecord.getModificationUserId());
            this.nodeChanges.setRawAttributes(this.nodeRecord.getRawAttributes());
            this.nodeChanges.setContent(this.nodeContent);
            this.nodeChanges.setModificationAttributeTime(System.currentTimeMillis());
            this.nodeChanges.setReplId(this.replicaId);
            this.nodeChanges.setReplNodeId(this.receivingId);
            TableDescriptor nd = new TableDescriptor(this.nodeRecord.getId(), this.nodeContent);
            TableDescriptor od = isNewNode ? new TableDescriptor(this.nodeRecord.getId(), Empty.byteArray) : TableDescriptor.get(this.nodeRecord.getId());
            IntegerSet restructed = null;
            if (!Ini.SkipRestructureIfUnchanged || isNewNode || !Arrays.equals(this.nodeContent, MtdEngine.getNodeContent(this.nodeRecord.getId()))) {
                restructed = this.restructTable(nd, od);
            }
            if (isNewNode) {
                MetadataNodeReader.createNodeTransact(this.ssContext, this.nodeChanges, this.nodeRecord.getId(), this.ssHost.getUserID(), this.ssHost.getSessionID(), this.auditComment, this.nodeRecord.getType(), this.metabaseConnection);
            } else {
                if (this.replaceData && this.dataReplicationFollow) {
                    DataReplicationApplyEngine.truncateTableRecords(this.ssContext, this.metabaseConnection, (TableNode)MtdEngine.getValidNodeSync(this.ssContext, this.nodeRecord.getId()), this.receivingId, this.replicaId, this.ssHost.getUserID(), this.ssHost.getSessionID(), this.ssHost.security());
                }
                MetadataNodeReader.updateNodeTransact(this.ssContext, this.nodeChanges, this.nodeRecord.getId(), this.ssHost.getUserID(), this.ssHost.getSessionID(), this.auditComment, this.nodeRecord.getType(), this.metabaseConnection);
            }
            this.metabaseConnection.commit();
            if (restructed != null) {
                this.restructTableIndices(nd, od, restructed);
            }
            MtdEngine.getValidNodeSync(this.ssContext, this.nodeRecord.getId());
            ProcessedTable table = new ProcessedTable(this.nodeRecord.getId(), this.nodeRecord.getParentId());
            table.content = this.nodeContent;
            table.contentReplicated = !isNewNode;
            this.processedTables.add(table);
        }
        catch (SQLException ex) {
            try {
                this.rollback(ex);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            throw ex;
        }
        catch (Throwable ex) {
            try {
                this.rollback(ex);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            throw InformException.wrap(ex);
        }
    }

    private void flushMetadataNode() throws InformException {
        Core.logger.info("\u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u0443\u0437\u043b\u0430 " + NumberConverter.doubleToString(this.nodeRecord.getId()));
        if (this.nodeChanges == null) {
            this.nodeChanges = new MetadataNodeReader.NodeChanges();
        } else {
            this.nodeChanges.clear();
        }
        try {
            if (this.nodeRecord.getType() == 12) {
                double tableParentID = -1.0;
                ProcessedTable table = this.processedTables.get(this.nodeRecord.getId());
                if (table == null) {
                    if (this.processedNodes.contains(this.nodeRecord.getId())) {
                        tableParentID = MtdEngine.getValidTranslatedNode(this.nodeRecord.getId()).getParentId();
                    } else {
                        if (this.syncChildrenNodes.contains(this.nodeRecord.getId())) {
                            return;
                        }
                        ReplicationApplyEngine.throwInvalidReplicationStream(this.nodeMessage);
                    }
                } else {
                    tableParentID = table.parentId;
                }
                if (tableParentID == this.nodeRecord.getParentId()) {
                    return;
                }
                if (!MetadataNodeReader.isNodeExists(this.ssContext, this.nodeRecord.getParentId(), this.metabaseConnection)) {
                    return;
                }
                this.nodeChanges.setParentId(this.nodeRecord.getParentId());
                this.nodeChanges.setReplId(this.replicaId);
                MetadataNodeReader.updateNodeTransact(this.ssContext, this.nodeChanges, this.nodeRecord.getId(), this.ssHost.getUserID(), this.ssHost.getSessionID(), this.auditComment, this.nodeRecord.getType(), this.metabaseConnection);
            } else {
                boolean isNewNode;
                if (!MetadataNodeReader.isNodeExists(this.ssContext, this.nodeRecord.getParentId(), this.metabaseConnection)) {
                    MtdEngine.throwDetailError("\u0412\u044b\u0448\u0435\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u0443\u0437\u0435\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", this.nodeRecord.getParentId());
                }
                Node oldNode = MtdEngine.getNode(this.nodeRecord.getId());
                boolean bl = isNewNode = !MetadataNodeReader.isNodeExists(this.ssContext, this.nodeRecord.getId(), this.metabaseConnection);
                if (isNewNode) {
                    this.nodeChanges.setId(this.nodeRecord.getId());
                    this.nodeChanges.setType(this.nodeRecord.getType());
                    this.nodeChanges.setCreationTime(this.nodeRecord.getCreationTime());
                } else if (oldNode != null) {
                    byte[] oldContent;
                    if (oldNode.isSame(this.nodeRecord) && oldNode instanceof BasicNode && Arrays.equals(oldContent = ((BasicNode)oldNode).getContent(0.0), this.nodeContent)) {
                        return;
                    }
                    oldNode.lockBarrier(0.0);
                }
                this.nodeChanges.setParentId(this.nodeRecord.getParentId());
                this.nodeChanges.setName(this.nodeRecord.getName());
                this.nodeChanges.setIdentName(this.nodeRecord.getIdentName());
                this.nodeChanges.setDescription(this.nodeRecord.getDescription());
                this.nodeChanges.setOwnerId(this.nodeRecord.getOwnerId());
                this.nodeChanges.setOrderNo(this.nodeRecord.getOrderNo());
                this.nodeChanges.setModificationContentTime(this.nodeRecord.getModificationContentTime());
                this.nodeChanges.setModificationUserId(this.nodeRecord.getModificationUserId());
                this.nodeChanges.setRawAttributes(this.nodeRecord.getRawAttributes());
                if (this.dslContent != null) {
                    this.nodeChanges.setDslContent(this.dslContent);
                } else {
                    this.nodeChanges.setContent(this.nodeContent);
                }
                this.nodeChanges.setModificationAttributeTime(System.currentTimeMillis());
                this.nodeChanges.setReplId(this.replicaId);
                this.nodeChanges.setReplNodeId(this.receivingId);
                switch (this.nodeRecord.getType()) {
                    case 3: 
                    case 4: 
                    case 57: {
                        this.securityChanged = true;
                    }
                }
                if (isNewNode) {
                    MetadataNodeReader.createNodeTransact(this.ssContext, this.nodeChanges, this.nodeRecord.getId(), this.ssHost.getUserID(), this.ssHost.getSessionID(), this.auditComment, this.nodeRecord.getType(), this.metabaseConnection);
                } else {
                    MetadataNodeReader.updateNodeTransact(this.ssContext, this.nodeChanges, this.nodeRecord.getId(), this.ssHost.getUserID(), this.ssHost.getSessionID(), this.auditComment, this.nodeRecord.getType(), this.metabaseConnection);
                }
            }
        }
        catch (Throwable ex) {
            try {
                this.rollback(ex);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            throw InformException.wrap(ex);
        }
    }

    private void flushAuthentication(TaggedReader in) throws IOException, InformException {
        AccountNode accountNode = MtdEngine.getValidAccountNode(this.nodeRecord.getId());
        if (accountNode.getType() != 3) {
            return;
        }
        byte[] hash = null;
        byte[] salt = null;
        byte[] sha256Hash = null;
        byte[] sha256Salt = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 101: {
                    hash = in.getRaw();
                    break;
                }
                case 102: {
                    salt = in.getRaw();
                    break;
                }
                case 121: {
                    sha256Hash = in.getRaw();
                    break;
                }
                case 122: {
                    sha256Salt = in.getRaw();
                }
            }
        }
        if (!(hash != null && hash.length == 16 && salt != null && salt.length == 8 || sha256Hash != null && sha256Hash.length == 32 && sha256Salt != null && sha256Salt.length == 16)) {
            return;
        }
        TaggedReader oldAttr = new TaggedReader(accountNode.getRawAttributes());
        ByteArrayOutputStream newRawAttr = new ByteArrayOutputStream();
        TaggedWriter newAttr = new TaggedWriter(newRawAttr);
        block17: while (oldAttr.next()) {
            switch (oldAttr.getCurrentTag()) {
                case 101: {
                    if (hash == null) continue block17;
                    newAttr.putRaw(101, hash);
                    byte[] bin = oldAttr.getRaw();
                    if (!Arrays.equals(bin, hash)) continue block17;
                    hash = null;
                    continue block17;
                }
                case 102: {
                    if (salt == null) continue block17;
                    newAttr.putRaw(102, salt);
                    byte[] bin = oldAttr.getRaw();
                    if (!Arrays.equals(bin, salt)) continue block17;
                    salt = null;
                    continue block17;
                }
                case 121: {
                    if (sha256Hash == null) continue block17;
                    newAttr.putRaw(121, sha256Hash);
                    byte[] bin = oldAttr.getRaw();
                    if (!Arrays.equals(bin, sha256Hash)) continue block17;
                    sha256Hash = null;
                    continue block17;
                }
                case 122: {
                    if (sha256Salt == null) continue block17;
                    newAttr.putRaw(122, sha256Salt);
                    byte[] bin = oldAttr.getRaw();
                    if (!Arrays.equals(bin, sha256Salt)) continue block17;
                    sha256Salt = null;
                    continue block17;
                }
            }
            oldAttr.transferTag(newAttr);
        }
        if (hash == null && salt == null && sha256Hash == null && sha256Salt == null) {
            return;
        }
        newAttr.flush();
        if (this.nodeChanges == null) {
            this.nodeChanges = new MetadataNodeReader.NodeChanges();
        } else {
            this.nodeChanges.clear();
        }
        this.nodeChanges.setRawAttributes(newRawAttr.toByteArray());
        this.nodeChanges.setModificationAttributeTime(System.currentTimeMillis());
        try {
            MetadataNodeReader.updateNodeTransact(this.ssContext, this.nodeChanges, this.nodeRecord.getId(), this.ssHost.getUserID(), this.ssHost.getSessionID(), this.auditComment, this.nodeRecord.getType(), this.metabaseConnection);
        }
        catch (Throwable ex) {
            try {
                this.rollback(ex);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            throw InformException.wrap(ex);
        }
    }

    private void checkSecurityChanging(double tableNodeId) throws IOException {
        if (this.securityChanged) {
            return;
        }
        if (this.usersTable == null) {
            this.usersTable = new UsersTable();
        }
        if (this.usersTable.enabled() && this.usersTable.getTableID() == tableNodeId) {
            this.securityChanged = true;
        }
    }

    private static class ProcessedTable
    implements DoubleHash.Entry {
        final double id;
        final double parentId;
        byte[] content = null;
        boolean contentReplicated = false;

        ProcessedTable(double id, double parentId) {
            this.id = id;
            this.parentId = parentId;
        }

        @Override
        public double key() {
            return this.id;
        }
    }

    public static enum Stage {
        INIT,
        CHECK_TABLE_STRUCT,
        TABLE_METADATA,
        METADATA,
        TABLE_DATA;

    }

    public static interface ProgressInfo {
        public void updateProgress(String var1) throws Exception;
    }
}

