/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.agent.Core;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.ArrayList;

public class TableMetadata {
    public static ArrayList<Column> getMetadata(SSContext ssContext, String tableName, DatabaseConnection connection) {
        ArrayList<Column> metadata = new ArrayList<Column>();
        try {
            DbTable table = connection.openScheme().getTable(ssContext, tableName);
            if (table == null) {
                return metadata;
            }
            for (DbColumn c : table.getColumns(ssContext).values()) {
                Column field = new Column();
                field.dataType = c.getType().getTypeId();
                field.phenixType = DataType.getDataTypeBySqlTypeId(field.dataType);
                field.dataSize = c.getSize();
                field.notNull = !c.isNullable();
                field.name = c.name();
                metadata.add(field);
            }
        }
        catch (SQLException ex) {
            Core.logger.error(null, ex);
            return null;
        }
        return metadata;
    }

    public static class Column {
        public int dataType = 0;
        public int dataSize = 0;
        public String name = "";
        public boolean notNull = false;
        public int options = 0;
        public DataType phenixType = DataType.NONE;
    }
}

