/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.replication.ApplyException;
import inform.agent.replication.ReceivingTable;
import inform.agent.replication.ReplicationApplyEngine;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.zip.InflaterInputStream;

public class ApplyReplica
extends Request
implements ReplicationApplyEngine.ProgressInfo {
    public static final int TAG_APPLY_PROGRESS = 1;
    public static final int TAG_APPLY_MESSAGE = 2;
    private ReplicationApplyEngine applier;
    private String nodeMessage;
    private ByteArrayInputStream input = null;
    private long processedBytes = 0L;
    private final ByteArrayOutputStream result = new ByteArrayOutputStream();
    private final TaggedWriter out = new TaggedWriter(this.result);
    private File logReplFile = null;

    public ApplyReplica(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
        this.setChunkedInput();
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        double receivingId = this.getNodeID();
        ReceivingTable receivingTable = new ReceivingTable();
        Object receivingTitle = "";
        SqlParameter[] receivingFields = receivingTable.select(this.ssContext, receivingId);
        if (receivingFields != null) {
            SqlParameter field = receivingFields[1];
            if (field != null) {
                receivingTitle = field.getString();
            }
            if (Strings.isVoid((String)receivingTitle)) {
                receivingTitle = "[" + NumberConverter.doubleToString(receivingId) + "]";
            }
        } else {
            Node receiving = MtdEngine.getNode(receivingId);
            if (receiving == null || receiving.getType() != 23) {
                MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438", receivingId);
            }
            receivingTitle = receiving.getName();
        }
        this.nodeMessage = "[" + NumberConverter.doubleToString(receivingId) + "] " + (String)receivingTitle;
        long startTime = System.currentTimeMillis();
        Core.logger.info("--- \u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)this.nodeMessage);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.applier = new ReplicationApplyEngine(this.ssContext, receivingId, this, this);
        try {
            this.processInputChunk(this.getRequestContent());
            this.processChunkedInput();
            double auditId = this.applier.finalizeReplica(this.processedBytes, null);
            if (auditId != 0.0) {
                TaggedWriter out = new TaggedWriter(result);
                out.putDouble(12, auditId);
                out.flush();
                result.flush();
            }
            Core.logger.info("--- \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0435\u043c\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {} replicaId: {}", (Object)this.nodeMessage, (Object)NumberConverter.doubleToString(this.applier.getReplicaId()));
            Core.logger.info("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {}", (Object)(System.currentTimeMillis() - startTime));
            if (this.logReplFile != null) {
                this.logReplFile.delete();
            }
        }
        catch (Throwable ex) {
            Object reason = null;
            try {
                String coreReason = Core.getAgentStopReason();
                String thisReason = this.getCancelReason();
                if (coreReason != null) {
                    reason = coreReason;
                }
                if (thisReason != null) {
                    reason = reason != null ? (String)reason + "\n" + (String)reason : thisReason;
                }
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            Core.logger.info("--- \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u0435\u043c\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0438 {} {} replicaId: {}\r\n node: {} stage: {} {}", new Object[]{this.nodeMessage, reason, NumberConverter.doubleToString(this.applier.getReplicaId()), NumberConverter.doubleToString(this.applier.getProcessingNodeId()), this.applier.getStage(), ex});
            try {
                this.applier.rollback(ex);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            throw ApplyException.remake((String)reason, this.nodeMessage, ex);
        }
        finally {
            this.applier.close();
        }
        this.sendResult(result.internalBuffer(), result.size());
    }

    private void storeToFile(byte[] chunk) {
        this.idle();
        try {
            if (this.logReplFile == null) {
                this.logReplFile = new File(Ini.LogFolderPath, "replica-" + NumberConverter.doubleToString(this.applier.getReplicaId()) + ".bin");
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.logReplFile, true);){
                TaggedWriter out = new TaggedWriter(fileOutputStream);
                out.putRaw(1, chunk);
                out.flush();
            }
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
        }
    }

    @Override
    protected void processInputChunk(byte[] chunk) throws InformException, SQLException, IOException {
        if (chunk == null || chunk.length == 0) {
            return;
        }
        this.processedBytes += (long)chunk.length;
        this.input = new ByteArrayInputStream(chunk);
        InflaterInputStream compression = new InflaterInputStream(this.input);
        try {
            this.idle();
            this.applier.process(new TaggedReader(compression));
            if (Ini.ReplSaveStream) {
                this.storeToFile(chunk);
            }
        }
        catch (Throwable ex) {
            if (Ini.ReplSaveStream) {
                this.storeToFile(chunk);
            }
            throw ApplyException.remake(null, this.nodeMessage, ex);
        }
    }

    @Override
    public void updateProgress(String msg) throws Exception {
        if (msg != null) {
            this.out.putString(2, msg);
        }
        long progress = this.processedBytes;
        if (this.input != null) {
            progress -= (long)this.input.available();
        }
        this.out.putLong(1, progress);
        this.out.flush();
        this.sendChunk(this.result.internalBuffer(), this.result.size());
        this.result.reset();
        this.out.reset(this.result);
    }
}

