/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.SendReadyResponse;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.replication.DownloadParams;
import inform.agent.replication.TableDataIO;
import java.util.zip.DeflaterOutputStream;

public class DownloadTableData
extends Request
implements SendReadyResponse {
    public static final int RAW_CHUNK_SIZE = 0x2000000;
    private ByteArrayOutputStream result = null;
    private DeflaterOutputStream compression = null;
    private SendReadyTaggedWriter writer = null;
    private static final int TAG_DOWNLOAD_TABLE_DATA_RECORD_COUNT = 1;

    public DownloadTableData(RequestHeader rq) {
        super(rq, RequestDuration.LONG);
        this.rq.contentPacked = true;
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        DownloadParams params = new DownloadParams();
        params.parse(in);
        double tableId = this.getNodeID();
        TaggedWriter out = this.createWriter(params.isChunkedData());
        TableDataIO tableData = new TableDataIO(null, this, Core.serverTimeZoneHost);
        ByteArrayOutputStream info = new ByteArrayOutputStream();
        if (params.getProcessData() != 0) {
            TableDataIO.RowStats stats = tableData.download(tableId, params, out);
            int rowCount = stats == null ? 0 : stats.modified;
            TaggedWriter writer = new TaggedWriter(info);
            writer.putInt32(1, rowCount);
            writer.flush();
            info.flush();
        }
        out.flush();
        this.compression.close();
        this.sendResult(this.result.internalBuffer(), this.result.size(), info.internalBuffer(), info.size());
    }

    @Override
    public void notifyReadyToSend() throws Exception {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.compression.close();
        this.sendChunk(this.result.internalBuffer(), this.result.size());
        this.result = new ByteArrayOutputStream();
        this.compression = new DeflaterOutputStream(this.result);
        this.writer.reset(this.compression);
    }

    private TaggedWriter createWriter(boolean chunkedData) {
        this.result = new ByteArrayOutputStream();
        this.compression = new DeflaterOutputStream(this.result);
        if (chunkedData) {
            this.writer = new SendReadyTaggedWriter(this.compression, this);
            this.writer.setNotifySize(0x2000000L);
            return this.writer;
        }
        return new TaggedWriter(this.compression);
    }
}

