/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.sched;

import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.am.AMRequest;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.sched.Sched;
import java.io.IOException;

public class GetAgentSchedInfo
extends AMRequest {
    private static final int CMD_SCHED_INFO = 0;
    private static final int CMD_SCHED_RUN = 1;
    private static final int CMD_SCHED_STOP = 2;
    private static final int CMD_SCHED_LOCK = 3;
    private static final int CMD_SCHED_UNLOCK = 4;
    private static final int TAG_SCHED_INFO_JOB_RUN_NODE_NAME = 9;
    private TaggedWriter out;

    public GetAgentSchedInfo(int request, int flags) {
        super(request, flags);
    }

    @Override
    public byte[] run() throws Throwable {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        this.out = new TaggedWriter(outContent);
        TaggedReader reader = this.createContentReader();
        double nodeId = 0.0;
        while (reader.getNextTag() != 0) {
            block0 : switch (reader.getCurrentTag()) {
                case 1: {
                    nodeId = reader.getDouble();
                    break;
                }
                case 2: {
                    int command = reader.getInt();
                    switch (command) {
                        case 0: {
                            this.sendJobState(nodeId, true);
                            break block0;
                        }
                        case 1: {
                            if (nodeId == 0.0) break;
                            Sched.explicitRun(nodeId);
                            break block0;
                        }
                        case 2: {
                            if (nodeId == 0.0) break;
                            Sched.explicitStop(nodeId);
                            break block0;
                        }
                        case 3: {
                            if (nodeId == 0.0) break;
                            GetAgentSchedInfo.modifyLockNode(true, nodeId);
                            break block0;
                        }
                        case 4: {
                            if (nodeId == 0.0) break;
                            GetAgentSchedInfo.modifyLockNode(false, nodeId);
                        }
                    }
                    break;
                }
            }
        }
        this.out.flush();
        return outContent.internalBuffer();
    }

    private void sendJobState(double nodeId, boolean force) throws IOException {
        if (nodeId == 0.0) {
            DoubleList jobs = new DoubleList(1);
            Sched.enumJobs(jobs);
            for (Cursor.Double c : jobs) {
                this.sendJobState(c.value, false);
            }
            return;
        }
        ByteArrayOutputStream stateContent = new ByteArrayOutputStream();
        TaggedWriter state = new TaggedWriter(stateContent);
        Sched.getInfo(null, nodeId, state, force);
        this.out.putDouble(1, nodeId);
        state.putAnsi(9, GetAgentSchedInfo.getNodeName(nodeId));
        state.flush();
        if (stateContent.size() == 0) {
            this.out.putEmpty(202);
        } else {
            this.out.putRaw(202, stateContent);
        }
    }

    private static void modifyLockNode(boolean enableLock, double nodeId) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(16);
        TaggedWriter w = new TaggedWriter(out);
        if (enableLock) {
            w.putInt32(57, 512);
        } else {
            w.putInt32(57, 1024);
        }
        w.flush();
    }

    private static String getNodeName(double nodeId) {
        Node node = MtdEngine.getNode(nodeId);
        String nodeName = "";
        if (node != null && node.getName() != null) {
            nodeName = node.getName();
        }
        return nodeName;
    }
}

