/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.TransformProps;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.IntUnaryOperator;

public class Attribute
extends Paragraph {
    public int Flags = 0;
    public boolean Inscribe = false;

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        ((Attribute)Dest).Flags = this.Flags;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 73: {
                    this.Flags = reader.getInt();
                    break;
                }
                case 128: {
                    this.Inscribe = reader.getBoolean();
                }
            }
        }
    }

    @Override
    protected void afterParse() {
        if (this.Inscribe && this.ParentGB != null) {
            this.OrgX = 0.0;
            this.OrgY = 0.0;
            if (this.TransProps == null) {
                this.TransProps = new TransformProps();
            }
            this.TransProps.CenterX = 0.0;
            this.TransProps.CenterY = 0.0;
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        if (this.Flags != 0) {
            writer.putInt32(73, this.Flags);
        }
        if (this.Inscribe) {
            writer.putBool(128, this.Inscribe);
        }
    }

    @Override
    protected void paint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if ((this.Flags & 1) == 0) {
            super.paint(g2d, Engine2);
        }
    }

    public boolean invisible() {
        return (this.Flags & 1) != 0;
    }

    public void setInvisible(boolean value) {
        this.Flags = value ? (this.Flags |= 1) : (this.Flags &= 0xFFFFFFFE);
    }

    public boolean constant() {
        return (this.Flags & 0x10) != 0;
    }

    public void ajustOrgPoint(double x, double y) {
        this.OrgX = x;
        this.OrgY = y;
        this.Inscribe = false;
    }

    public void ajustSidesPoint(double x, double y) {
        if (!this.AutoSize) {
            double[] pt = new double[]{this.SideX / 2.0, this.SideY / 2.0};
            pt = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(this), pt);
            double xx = this.SideX + (x - pt[0]);
            double yy = this.SideY + (y - pt[1]);
            if (this.TransProps == null) {
                this.TransProps = new TransformProps();
            }
            this.TransProps.CenterX += (x - pt[0]) / 2.0;
            this.TransProps.CenterY += (y - pt[1]) / 2.0;
            this.SideX = xx;
            this.SideY = yy;
        }
    }

    void setInscribeExt(GraphicBlock parent, boolean updateLines, boolean ignoreSemicolon, boolean recalcOrg) {
        int strCount;
        if (!this.Inscribe) {
            this.Inscribe = true;
        }
        if (!updateLines) {
            return;
        }
        int n = strCount = this.Lines == null ? 0 : this.Lines.size();
        if (strCount <= 0) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < strCount; ++i) {
            BaseGraphic bg = (BaseGraphic)this.Lines.get(i);
            if (!(bg instanceof RectTextLine)) continue;
            strings.add(((RectTextLine)bg).Text);
        }
        this.setValueExt(parent, this.getText(";"), false, strings, recalcOrg);
    }

    public void setValueExt(GraphicBlock parent, String text, boolean ignoreLines, ArrayList<String> strings, boolean recalcOrg) {
    }

    public void correctAttribute(BaseGraphic block, BaseGraphic parent, String name, String value, boolean divide, int hAlign, int vAlign, boolean ignoreLines, ArrayList<String> strings, boolean recalcOrg) {
    }

    protected void updateLines(String text) {
        int i;
        if (text == null || text.isEmpty()) {
            return;
        }
        char[] textStr = text.toCharArray();
        StringBuilder lCurrLine = new StringBuilder();
        int lCount = 0;
        IntUnaryOperator AddLineText = linesCount -> {
            if (linesCount + 1 > this.Lines.size()) {
                this.Lines.addLine("");
            }
            ((RectTextLine)this.Lines.get((int)linesCount)).Text = lCurrLine.toString();
            lCurrLine.setLength(0);
            return linesCount + 1;
        };
        for (i = 0; i < textStr.length; ++i) {
            if (textStr[i] == ';' || i == textStr.length - 1) {
                if (textStr[i] != ';') {
                    lCurrLine.append(textStr[i]);
                } else if (i == textStr.length - 1) {
                    lCount = AddLineText.applyAsInt(lCount);
                }
                lCount = AddLineText.applyAsInt(lCount);
                continue;
            }
            lCurrLine.append(textStr[i]);
        }
        if (lCount == 0) {
            if (this.Lines == null) {
                this.Lines = new Paragraph.Lines();
            }
            this.Lines.addLine(text);
            ++lCount;
        }
        if (this.Lines != null) {
            for (i = this.Lines.size(); i > lCount; --i) {
                this.Lines.remove(i - 1);
            }
            this.Lines.applyFontToLines();
        }
        this.freshSides();
    }

    public static BaseGraphic.RealPoint calcAttributeOrg(Attribute attr, double oldOrgX, double oldOrgY, double blockSizeX, double blockSizeY, double sizeX, double sizeY, int hAlign, int vAlign) {
        assert (attr != null);
        double x = oldOrgX;
        double y = oldOrgY;
        double centerX = attr.TransProps == null ? 0.0 : attr.TransProps.CenterX;
        double centerY = attr.TransProps == null ? 0.0 : attr.TransProps.CenterY;
        switch (hAlign) {
            case 1: {
                x = -0.5 * (blockSizeX - sizeX) - centerX;
                break;
            }
            case 2: {
                x = -centerX;
                break;
            }
            case 3: {
                x = 0.5 * (blockSizeX - sizeX) - centerX;
            }
        }
        switch (vAlign) {
            case 1: {
                y = -0.5 * (blockSizeY - sizeY) - centerY;
                break;
            }
            case 2: {
                y = -centerY;
                break;
            }
            case 3: {
                y = 0.5 * (blockSizeY - sizeY) - centerY;
            }
        }
        return new BaseGraphic.RealPoint(x, y);
    }
}

