/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.VsdxReader;
import java.util.ArrayList;

public class AttributeDef
extends Attribute {
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public int shapeType() {
        return 225;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    public void setValueExt(GraphicBlock parent, String text, boolean ignoreLines, ArrayList<String> strings, boolean recalcOrg) {
        if (this.Inscribe && parent != null && GraphicBlock.class.equals(parent.getClass())) {
            int lInt;
            switch (this.Align) {
                case 0: {
                    lInt = 1;
                    break;
                }
                case 1: {
                    lInt = 3;
                    break;
                }
                default: {
                    lInt = 2;
                }
            }
            this.correctAttribute(parent, null, "", text, true, lInt, 2, ignoreLines, strings, recalcOrg);
            if (this.TransProps != null && this.TransProps.Angle != 0.0) {
                this.TransProps.Angle = 0.0;
            }
        } else if (strings == null) {
            this.updateLines(text);
        }
    }

    @Override
    public void correctAttribute(BaseGraphic bg, BaseGraphic parent, String name, String value, boolean divide, int hAlign, int vAlign, boolean ignoreLines, ArrayList<String> strings, boolean recalcOrg) {
        boolean lByLines;
        if (!(bg instanceof GraphicBlock)) {
            return;
        }
        GraphicBlock block = (GraphicBlock)bg;
        if (this.Lines == null || this.Lines.isEmpty()) {
            return;
        }
        RectTextLine lRectTextLine = (RectTextLine)this.Lines.get(0);
        if (lRectTextLine == null) {
            return;
        }
        BaseGraphic.RealPoint lBlockSize = new BaseGraphic.RealPoint(Math.abs(block.MaxPtX - block.MinPtX), Math.abs(block.MaxPtY - block.MinPtY));
        if (this.Inscribe) {
            lBlockSize.X = lBlockSize.X * Math.abs(block.TransProps == null ? 1.0 : block.TransProps.ScaleX);
        }
        BaseGraphic.RealPoint lSize = VsdxReader.calcTextSize(this.getFont(), value);
        if (lBlockSize.X <= FloatTolerance || lSize.X <= FloatTolerance) {
            return;
        }
        StringBuilder lText = new StringBuilder();
        boolean lModified = false;
        boolean bl = lByLines = strings != null;
        if (lByLines) {
            int lStrIdx = 0;
            BaseGraphic.RealPoint lMaxLineSize = new BaseGraphic.RealPoint();
            int cnt = strings.size();
            for (int i = 0; i < cnt; ++i) {
                if (lStrIdx > this.Lines.size() - 1) {
                    this.Lines.addLine(strings.get(i));
                } else {
                    ((RectTextLine)this.Lines.get((int)lStrIdx)).Text = strings.get(i);
                }
                ++lStrIdx;
                BaseGraphic.RealPoint lLineSize = new BaseGraphic.RealPoint();
                ArrayList<String> lStrings = new ArrayList<String>();
                AttributeDef.divideText(strings.get(i), this.getFont(), lBlockSize.X, true, false, true, lStrings, lLineSize);
                if (lStrings.size() > 1) {
                    --lStrIdx;
                    int cntj = lStrings.size();
                    for (int j = 0; j < cntj; ++j) {
                        if (lStrIdx > this.Lines.size() - 1) {
                            this.Lines.addLine(lStrings.get(j).trim());
                            lModified = true;
                        } else if (!lStrings.get(j).trim().equals(((RectTextLine)this.Lines.get((int)lStrIdx)).Text)) {
                            ((RectTextLine)this.Lines.get((int)lStrIdx)).Text = lStrings.get(j).trim();
                            lModified = true;
                        }
                        ++lStrIdx;
                    }
                }
                if (lMaxLineSize.X < lLineSize.X) {
                    lMaxLineSize.X = lLineSize.X;
                }
                if (!(lLineSize.Y > 0.0)) continue;
                lMaxLineSize.Y = (double)this.Lines.size() * lLineSize.Y;
            }
            if (lMaxLineSize.X > 0.0) {
                lSize.X = lMaxLineSize.X;
            }
            if (lMaxLineSize.Y > 0.0) {
                lSize.Y = lMaxLineSize.Y;
            }
            if (this.Inscribe) {
                if (this.SideX < lSize.X) {
                    this.SideX = lSize.X;
                }
                if (this.SideX < lBlockSize.X) {
                    this.SideX = lBlockSize.X;
                }
                if (this.SideY < lSize.Y) {
                    this.SideY = lSize.Y;
                }
            }
        } else {
            AttributeDef.divideText(value, this.getFont(), lBlockSize.X, divide, ignoreLines, false, strings, lSize);
            if (strings != null) {
                int cnt = strings.size();
                for (int i = 0; i < cnt; ++i) {
                    lText.append(strings.get(i));
                    if (i >= cnt - 1) continue;
                    lText.append(";");
                }
            }
            boolean bl2 = lModified = !lText.toString().equals(this.getText());
        }
        if (lModified) {
            if (lByLines) {
                this.freshSides();
            } else {
                this.updateLines(lText.toString());
            }
        }
        if ((hAlign > 0 && hAlign <= 3 || vAlign > 0 && vAlign <= 3) && this.Inscribe && recalcOrg) {
            BaseGraphic.RealPoint org = AttributeDef.calcAttributeOrg(this, this.OrgX, this.OrgY, lBlockSize.X, lBlockSize.Y, lSize.X, lSize.Y, hAlign, vAlign);
            this.OrgX = org.X;
            this.OrgY = org.Y;
        }
    }
}

