/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;

public abstract class BaseShape
extends BaseGraphic {
    public double ProfileID = 0.0;
    public Color bColor = null;
    public Color pColor = null;
    public Color BkColor = null;
    public int PenPattern = -1;
    public int BrushPattern = -1;
    public double lWidth = -1.0;
    public int CornerStyle = 0;
    public double CornerRadius = 0.0;
    public int LineCap;
    public int Transparent = 0;
    public int TransparentBorder = 0;
    public boolean TransparentByLayer = false;
    public boolean TransparentBorderByLayer = false;

    @Override
    public int shapeType() {
        return 209;
    }

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        BaseShape shape = (BaseShape)Dest;
        shape.ProfileID = this.ProfileID;
        shape.bColor = this.bColor;
        shape.pColor = this.pColor;
        shape.BkColor = this.BkColor;
        shape.PenPattern = this.PenPattern;
        shape.BrushPattern = this.BrushPattern;
        shape.lWidth = this.lWidth;
        shape.CornerStyle = this.CornerStyle;
        shape.CornerRadius = this.CornerRadius;
        shape.LineCap = this.LineCap;
        shape.Transparent = this.Transparent;
        shape.TransparentBorder = this.TransparentBorder;
        shape.TransparentByLayer = this.TransparentByLayer;
        shape.TransparentBorderByLayer = this.TransparentBorderByLayer;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 29: {
                    this.ProfileID = reader.getDouble();
                    break;
                }
                case 30: {
                    this.bColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 31: {
                    this.pColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 32: {
                    this.BkColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 33: {
                    this.PenPattern = reader.getInt();
                    break;
                }
                case 34: {
                    this.BrushPattern = reader.getInt();
                    break;
                }
                case 35: {
                    this.lWidth = reader.getDouble();
                    break;
                }
                case 115: {
                    this.CornerStyle = reader.getInt();
                    break;
                }
                case 116: {
                    this.CornerRadius = reader.getDouble();
                    break;
                }
                case 141: {
                    this.LineCap = reader.getInt();
                    break;
                }
                case 145: {
                    this.Transparent = Byte.toUnsignedInt(reader.getByte());
                    break;
                }
                case 146: {
                    this.TransparentBorder = Byte.toUnsignedInt(reader.getByte());
                }
            }
        }
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        switch (tag) {
            case 12: {
                this.TransparentByLayer = true;
                break;
            }
            case 13: {
                this.TransparentBorderByLayer = true;
                break;
            }
            default: {
                super.readExtraTagged(parser, reader, tag);
            }
        }
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        writer.putRaw(3, os);
        if (this.ProfileID != 0.0) {
            writer.putDouble(29, this.ProfileID);
        } else {
            SchemeUtils.writeColor(writer, 30, this.bColor);
            SchemeUtils.writeColor(writer, 31, this.pColor);
            SchemeUtils.writeColor(writer, 32, this.BkColor);
            if (this.PenPattern != -1) {
                writer.putInt32(33, this.PenPattern);
            }
            if (this.BrushPattern != -1) {
                writer.putInt32(34, this.BrushPattern);
            }
            if (this.lWidth != -1.0) {
                writer.putDouble(35, this.lWidth);
            }
        }
        if (this.CornerStyle != 0 && this.CornerRadius > FloatTolerance) {
            writer.putInt32(115, this.CornerStyle);
            writer.putDouble(116, this.CornerRadius);
        }
        if (this.LineCap != 0) {
            writer.putInt32(141, this.LineCap);
        }
        if (this.Transparent != 0) {
            writer.putInt08(145, (byte)this.Transparent);
        }
        if (this.TransparentBorder != 0) {
            writer.putInt08(146, (byte)this.TransparentBorder);
        }
    }

    @Override
    protected void calcOrgAndAjust(int idxPoint, boolean ignoreGP) {
        double vY;
        double vX;
        int i;
        int verticesCount = this.getVerticesCount();
        if (verticesCount <= 1) {
            return;
        }
        double maxPtX = -2.147483647E9;
        double maxPtY = -2.147483647E9;
        double minPtX = 2.147483647E9;
        double minPtY = 2.147483647E9;
        for (i = 0; i < verticesCount; ++i) {
            vX = this.getVertexX(i);
            vY = this.getVertexY(i);
            if (maxPtX < vX) {
                maxPtX = vX;
            }
            if (maxPtY < vY) {
                maxPtY = vY;
            }
            if (minPtX > vX) {
                minPtX = vX;
            }
            if (!(minPtY > vY)) continue;
            minPtY = vY;
        }
        this.OrgX = minPtX + (maxPtX - minPtX) / 2.0;
        this.OrgY = minPtY + (maxPtY - minPtY) / 2.0;
        for (i = 0; i < verticesCount; ++i) {
            vX = this.getVertexX(i);
            vY = this.getVertexY(i);
            this.setVertex(i, vX - this.OrgX, vY - this.OrgY);
        }
    }

    @Override
    public void genDistRadius(boolean ignoreGP) {
        int i;
        int verticesCount = this.getVerticesCount();
        if (verticesCount <= 1) {
            return;
        }
        double maxPtX = -2.147483647E9;
        double maxPtY = -2.147483647E9;
        double minPtX = 2.147483647E9;
        double minPtY = 2.147483647E9;
        for (i = 0; i < verticesCount; ++i) {
            double vX = this.getVertexX(i);
            double vY = this.getVertexY(i);
            if (maxPtX < vX) {
                maxPtX = vX;
            }
            if (maxPtY < vY) {
                maxPtY = vY;
            }
            if (minPtX > vX) {
                minPtX = vX;
            }
            if (!(minPtY > vY)) continue;
            minPtY = vY;
        }
        if (!ignoreGP) {
            int cnt;
            int n = cnt = this.GluePoints == null ? 0 : this.GluePoints.size();
            for (i = 0; i < cnt; ++i) {
                BaseGraphic.GluePoint gp = (BaseGraphic.GluePoint)this.GluePoints.get(i);
                double vX = gp.ptX;
                double vY = gp.ptY;
                if (maxPtX < vX) {
                    maxPtX = vX;
                }
                if (maxPtY < vY) {
                    maxPtY = vY;
                }
                if (minPtX > vX) {
                    minPtX = vX;
                }
                if (!(minPtY > vY)) continue;
                minPtY = vY;
            }
        }
        double[] pts = new double[]{minPtX, minPtY, maxPtX, minPtY, maxPtX, maxPtY, minPtX, maxPtY, 0.0, 0.0};
        pts = SchemeEngine.MulPointsTM(this.Engine.GTM, pts);
        this.ptArrToBounds(pts, 4);
    }

    public boolean calcPrimPolylineBounds(BaseGraphic.RealPoint minPt, BaseGraphic.RealPoint maxPt) {
        return false;
    }

    private void ptArrToBounds(double[] points, int cntPoint) {
        BaseGraphic.RealRect rect = this.ptArrToRect(points, cntPoint);
        if (rect == null) {
            return;
        }
        this.Left = rect.Left;
        this.Top = rect.Top;
        this.Right = rect.Right;
        this.Bottom = rect.Bottom;
    }

    @Override
    public BaseGraphic.RealRect getMinMaxRect() {
        int verticesCount = this.getVerticesCount();
        if (verticesCount > 0) {
            BaseGraphic.RealPoint maxPt;
            BaseGraphic.RealPoint minPt = new BaseGraphic.RealPoint(BaseShape.initMinX(), BaseShape.initMinY());
            boolean primPolylineBoundsCalced = this.calcPrimPolylineBounds(minPt, maxPt = new BaseGraphic.RealPoint(BaseShape.initMaxX(), BaseShape.initMaxY()));
            if (!primPolylineBoundsCalced) {
                for (int i = 0; i < verticesCount; ++i) {
                    double vX = this.getVertexX(i);
                    double vY = this.getVertexY(i);
                    if (maxPt.X < vX) {
                        maxPt.X = vX;
                    }
                    if (maxPt.Y < vY) {
                        maxPt.Y = vY;
                    }
                    if (minPt.X >= vX) {
                        minPt.X = vX;
                    }
                    if (!(minPt.Y >= vY)) continue;
                    minPt.Y = vY;
                }
            }
            int gluePointsCount = this.GluePoints == null ? 0 : this.GluePoints.size();
            for (int i = 0; i < gluePointsCount; ++i) {
                BaseGraphic.GluePoint gp = (BaseGraphic.GluePoint)this.GluePoints.get(i);
                if (maxPt.X < gp.ptX) {
                    maxPt.X = gp.ptX;
                }
                if (maxPt.Y < gp.ptY) {
                    maxPt.Y = gp.ptY;
                }
                if (minPt.X >= gp.ptX) {
                    minPt.X = gp.ptX;
                }
                if (!(minPt.Y >= gp.ptY)) continue;
                minPt.Y = gp.ptY;
            }
            double[] pts = new double[]{minPt.X, minPt.Y, maxPt.X, minPt.Y, maxPt.X, maxPt.Y, minPt.X, maxPt.Y};
            pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(this), pts);
            return this.ptArrToRect(pts, 4);
        }
        return new BaseGraphic.RealRect();
    }
}

