/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.IOException;

public class Ellipse
extends Rectangle {
    public int Slices = 30;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        ((Ellipse)Dest).Slices = this.Slices;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 37: {
                    this.Slices = reader.getInt();
                }
            }
        }
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        int pcount = this.Slices;
        double[] Pts = SchemeEngine.SidesToEllipse(this.SideX, this.SideY, pcount);
        if (Engine2.UseGTM) {
            Pts = Engine2.MulPoints(Pts);
        }
        if (Engine2.UseJavaShapes) {
            int idx = 0;
            Path2D.Double shape = new Path2D.Double();
            ((Path2D)shape).moveTo(Pts[0], Pts[1]);
            for (int i = 1; i < pcount; ++i) {
                idx = 2 * i;
                ((Path2D)shape).lineTo(Pts[idx], Pts[idx + 1]);
            }
            shape.closePath();
            if (Engine2.isNeedFill(this.BrushPattern)) {
                Engine2.setActualBColor(g2d, this.bColor);
                g2d.fill(shape);
            }
            if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
                Engine2.setActualPColor(g2d, this.pColor);
                Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
                g2d.draw(shape);
            }
        } else {
            int[] x = new int[pcount];
            int[] y = new int[pcount];
            int idx = 0;
            for (int i = 0; i < pcount; ++i) {
                idx = 2 * i;
                x[i] = (int)Math.round(Pts[idx]);
                y[i] = (int)Math.round(Pts[idx + 1]);
            }
            if (Engine2.isNeedFill(this.BrushPattern)) {
                Engine2.setActualBColor(g2d, this.bColor);
                g2d.fillPolygon(x, y, pcount);
            }
            if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
                Engine2.setActualPColor(g2d, this.pColor);
                Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
                g2d.drawPolygon(x, y, pcount);
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        if (this.Slices != 30) {
            writer.putInt32(37, this.Slices);
        }
    }

    @Override
    public int shapeType() {
        return 215;
    }

    @Override
    public int shapeVersion() {
        return version;
    }
}

