/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TransformProps;
import java.io.IOException;

public class EmbeddedText
extends AttributeDef {
    public static final int TAG_EM_TEXT_ORG_X = 1;
    public static final int TAG_EM_TEXT_ORG_Y = 2;
    public static final int TAG_EM_TEXT_CENTER_X = 3;
    public static final int TAG_EM_TEXT_CENTER_Y = 4;
    public static final int TAG_EM_TEXT_ANGLE = 5;
    public static final int TAG_EM_TEXT_SIDE_X = 6;
    public static final int TAG_EM_TEXT_SIDE_Y = 7;
    public static final int TAG_EM_TEXT_FONT_HEIGHT = 8;
    public static final int TAG_EM_TEXT_FONT_NAME = 9;
    public static final int TAG_EM_TEXT_FONT_COLOR = 10;
    public static final int TAG_EM_TEXT_FONT_STYLE = 11;
    public static final int TAG_EM_TEXT_INSCRIBE = 12;
    public static final int TAG_EM_TEXT_TL = 13;
    public static final int TAG_EM_TEXT_ALIGN = 14;
    public static final int TAG_EM_TEXT_VERT_ALIGN = 15;
    public static final int TAG_EM_TEXT_WIDTH_SCALE = 16;
    public static final int TAG_EM_TEXT_FIXED_SIZE = 17;
    public static final int TAG_EM_TEXT_LINE_SPACING = 18;
    public static final int TAG_EM_TEXT_TAB_STOP_POSITION = 19;
    public static final int TAG_EM_TEXT_LEFT_MARGIN = 20;
    public static final int TAG_EM_TEXT_RIGHT_MARGIN = 21;
    public static final int TAG_EM_TEXT_TOP_MARGIN = 22;
    public static final int TAG_EM_TEXT_BOTTOM_MARGIN = 23;
    public static final int TAG_EM_TEXT_TRANSPARENT_TEXT = 24;
    public static final int TAG_EM_EXPORT_SIDE_X = 25;
    public static final int TAG_EM_EXPORT_SIDE_Y = 26;
    public static final int TAG_EM_TEXT_FLAGS = 27;
    public static final int TAG_EM_TEXT_TL_TEXT = 1;
    public static final int TAG_EM_TEXT_TL_SIDE_X = 2;
    public static final int TAG_EM_TEXT_TL_SIDE_Y = 3;
    public static final int TAG_EM_TEXT_TL_PARTS = 4;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public int shapeVersion() {
        return version;
    }

    public EmbeddedText loadTags(TaggedReader reader) throws IOException {
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.OrgX = reader.getDouble();
                    break;
                }
                case 2: {
                    this.OrgY = reader.getDouble();
                    break;
                }
                case 3: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.CenterX = reader.getDouble();
                    break;
                }
                case 4: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.CenterY = reader.getDouble();
                    break;
                }
                case 5: {
                    if (this.TransProps == null) {
                        this.TransProps = new TransformProps();
                    }
                    this.TransProps.Angle = reader.getDouble();
                    break;
                }
                case 6: {
                    this.SideX = reader.getDouble();
                    break;
                }
                case 7: {
                    this.SideY = reader.getDouble();
                    break;
                }
                case 8: {
                    this.lfHeight = reader.getDouble();
                    break;
                }
                case 9: {
                    if (this.Lines == null) {
                        this.Lines = new Paragraph.Lines();
                    }
                    this.Lines.FontName = reader.getString();
                    break;
                }
                case 10: {
                    if (this.Lines == null) {
                        this.Lines = new Paragraph.Lines();
                    }
                    this.Lines.FontColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 11: {
                    if (this.Lines == null) {
                        this.Lines = new Paragraph.Lines();
                    }
                    this.Lines.FontStyle = reader.getByte();
                    break;
                }
                case 12: {
                    this.Inscribe = reader.getBoolean();
                    break;
                }
                case 13: {
                    if (this.Lines == null) {
                        this.Lines = new Paragraph.Lines();
                    }
                    int count = this.Lines.size();
                    int idx = -1;
                    reader.skip();
                    TaggedReader stream = reader.getStreamReader(202);
                    block36: while (stream.next()) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                RectTextLine rtl;
                                if (++idx >= count) {
                                    rtl = new RectTextLine();
                                    rtl.FontColor = this.Lines.FontColor;
                                    rtl.FontName = this.Lines.FontName;
                                    rtl.FontStyle = this.Lines.FontStyle;
                                    this.Lines.add(rtl);
                                    ++count;
                                }
                                rtl = (RectTextLine)this.Lines.get(idx);
                                rtl.Text = stream.getString();
                                continue block36;
                            }
                            case 2: {
                                Rectangle rect = (Rectangle)this.Lines.get(idx);
                                rect.SideX = stream.getDouble();
                                continue block36;
                            }
                            case 3: {
                                Rectangle rect = (Rectangle)this.Lines.get(idx);
                                rect.SideY = stream.getDouble();
                                continue block36;
                            }
                            case 4: {
                                stream.skip();
                                assert (idx >= 0);
                                TaggedReader subReader = stream.getStreamReader(202);
                                RectTextLine rtl = (RectTextLine)this.Lines.get(idx);
                                while (subReader.next()) {
                                    rtl.readExtraTaggedLines(subReader, subReader.getCurrentTag(), this);
                                }
                                continue block36;
                            }
                        }
                    }
                    break;
                }
                case 14: {
                    this.Align = reader.getByte();
                    break;
                }
                case 15: {
                    this.VertAlign = reader.getByte();
                    break;
                }
                case 16: {
                    this.WidthScale = reader.getDouble();
                    break;
                }
                case 17: {
                    this.AutoSize = false;
                    break;
                }
                case 18: {
                    this.LineSpacing = reader.getDouble();
                    break;
                }
                case 19: {
                    this.TabStopPosition = reader.getDouble();
                    break;
                }
                case 20: {
                    this.LeftMargin = reader.getDouble();
                    break;
                }
                case 21: {
                    this.RightMargin = reader.getDouble();
                    break;
                }
                case 22: {
                    this.TopMargin = reader.getDouble();
                    break;
                }
                case 23: {
                    this.BottomMargin = reader.getDouble();
                    break;
                }
                case 24: {
                    this.TransparentText = Byte.toUnsignedInt(reader.getByte());
                    break;
                }
                case 25: {
                    this.exportSidesX = reader.getDouble();
                    break;
                }
                case 26: {
                    this.exportSidesY = reader.getDouble();
                    break;
                }
                case 27: {
                    this.Flags = reader.getInt();
                }
            }
        }
        return null;
    }

    void storeTags(TaggedWriter writer) throws IOException {
        int count;
        assert (writer != null);
        if (this.OrgX != 0.0) {
            writer.putDouble(1, this.OrgX);
        }
        if (this.OrgY != 0.0) {
            writer.putDouble(2, this.OrgY);
        }
        if (this.TransProps != null) {
            if (this.TransProps.CenterX != 0.0) {
                writer.putDouble(3, this.TransProps.CenterX);
            }
            if (this.TransProps.CenterY != 0.0) {
                writer.putDouble(4, this.TransProps.CenterY);
            }
            if (!SchemeUtils.isEqual(this.TransProps.Angle, 0.0)) {
                writer.putDouble(5, this.TransProps.Angle);
            }
        }
        if (this.SideX != 0.0) {
            writer.putDouble(6, this.SideX);
        }
        if (this.SideY != 0.0) {
            writer.putDouble(7, this.SideY);
        }
        if (this.lfHeight != 0.0) {
            writer.putDouble(8, this.lfHeight);
        }
        if (this.Lines != null) {
            if (this.Lines.FontName != null && !this.Lines.FontName.equals(Paragraph.DEFAULT_FONTNAME)) {
                writer.putString(9, this.Lines.FontName);
            }
            SchemeUtils.writeColor(writer, 10, this.Lines.FontColor);
            if (this.Lines.FontStyle != 0) {
                writer.putInt08(11, this.Lines.FontStyle);
            }
        }
        if (this.Inscribe) {
            writer.putBool(12, this.Inscribe);
        }
        if (this.Align != 0) {
            writer.putInt08(14, this.Align);
        }
        if (this.VertAlign != 0) {
            writer.putInt08(15, (byte)this.VertAlign);
        }
        if (this.WidthScale != 1.0) {
            writer.putDouble(16, this.WidthScale);
        }
        if (!this.AutoSize) {
            writer.putEmpty(17);
        }
        if (!SchemeUtils.isEqual(this.LineSpacing, 1.0)) {
            writer.putDouble(18, this.LineSpacing);
        }
        if (!SchemeUtils.isEqual(this.TabStopPosition, 15.0)) {
            writer.putDouble(19, this.TabStopPosition);
        }
        if (!SchemeUtils.isEqual(this.LeftMargin, 0.0)) {
            writer.putDouble(20, this.LeftMargin);
        }
        if (!SchemeUtils.isEqual(this.RightMargin, 0.0)) {
            writer.putDouble(21, this.RightMargin);
        }
        if (!SchemeUtils.isEqual(this.TopMargin, 0.0)) {
            writer.putDouble(22, this.TopMargin);
        }
        if (!SchemeUtils.isEqual(this.BottomMargin, 0.0)) {
            writer.putDouble(23, this.BottomMargin);
        }
        if (this.TransparentText != 0) {
            writer.putInt08(24, (byte)this.TransparentText);
        }
        if (this.Flags != 0) {
            writer.putInt32(27, this.Flags);
        }
        int n = count = this.Lines == null ? 0 : this.Lines.size();
        if (count > 0) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TaggedWriter subWriter = new TaggedWriter(os);
            for (int i = 0; i < count; ++i) {
                BaseGraphic bg = (BaseGraphic)this.Lines.get(i);
                if (!(bg instanceof RectTextLine)) continue;
                RectTextLine line = (RectTextLine)bg;
                subWriter.putString(1, line.Text);
                if (line.SideX != 0.0) {
                    subWriter.putDouble(2, line.SideX);
                }
                if (line.SideY != 0.0) {
                    subWriter.putDouble(3, line.SideY);
                }
                ByteArrayOutputStream partOs = new ByteArrayOutputStream();
                TaggedWriter partWriter = new TaggedWriter(partOs);
                line.writeExtraTaggedLine(partWriter, this);
                partWriter.flush();
                if (partOs.size() <= 0) continue;
                subWriter.putEmpty(4);
                subWriter.putRaw(202, partOs);
            }
            subWriter.flush();
            if (os.size() > 0) {
                writer.putEmpty(13);
                writer.putRaw(202, os);
            }
        }
    }
}

