/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Container;
import inform.agent.schemes.Dimension;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.PrimParam;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.TransformProps;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GraphicBlock
extends BaseGraphic {
    public double MinPtX = 0.0;
    public double MinPtY = 0.0;
    public double MaxPtX = 0.0;
    public double MaxPtY = 0.0;
    public double LibID = 0.0;
    public double SourceID = 0.0;
    public ArrayList<BaseGraphic> Objects = null;
    public List<PrimParam> BlockParams = new ArrayList<PrimParam>();
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        GraphicBlock shape = (GraphicBlock)Dest;
        shape.MinPtX = this.MinPtX;
        shape.MinPtY = this.MinPtY;
        shape.MaxPtX = this.MaxPtX;
        shape.MaxPtY = this.MaxPtY;
        shape.LibID = this.LibID;
        shape.SourceID = this.SourceID;
        int ccount = this.Objects.size();
        BaseGraphic Child = null;
        BaseGraphic tmpBG = null;
        shape.Objects = null;
        for (int i = 0; i < ccount; ++i) {
            Child = this.Objects.get(i);
            if (Child == null || (tmpBG = (BaseGraphic)Child.getClass().newInstance()) == null) continue;
            Child.assign(tmpBG);
            tmpBG.ParentGB = shape;
            if (shape.Objects == null) {
                shape.Objects = new ArrayList();
            }
            shape.Objects.add(tmpBG);
        }
    }

    @Override
    protected void afterParse() {
        if (this.Objects == null) {
            return;
        }
        for (int i = 0; i < this.Objects.size(); ++i) {
            BaseGraphic Child = this.Objects.get(i);
            if (Child == null) continue;
            Child.afterParse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        int tmpInt = 0;
        BaseGraphic tmpBG = null;
        byte[] tmpBytes = null;
        TaggedReader StreamReader = null;
        TaggedReader StreamReader1 = null;
        block20: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 92: {
                    tmpBytes = reader.getRaw();
                    this.MinPtX = LittleEndian.getDouble(tmpBytes, 0);
                    this.MinPtY = LittleEndian.getDouble(tmpBytes, 8);
                    break;
                }
                case 93: {
                    tmpBytes = reader.getRaw();
                    this.MaxPtX = LittleEndian.getDouble(tmpBytes, 0);
                    this.MaxPtY = LittleEndian.getDouble(tmpBytes, 8);
                    break;
                }
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 94: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    boolean isGB = this.getClass() == GraphicBlock.class || this.getClass() == Dimension.class || this.getClass() == Container.class;
                    AffineTransform OldGTM = null;
                    if (isGB) {
                        OldGTM = new AffineTransform();
                        OldGTM.setTransform(Parser2.tmpGTM);
                    }
                    try {
                        if (isGB) {
                            Parser2.tmpGTM.concatenate(SchemeEngine.GenTransform(this));
                        }
                        while (StreamReader.getNextTag() != 0) {
                            switch (StreamReader.getCurrentTag()) {
                                case 1: {
                                    StreamReader1 = StreamReader.getStreamReader();
                                    if (StreamReader1 == null) break;
                                    while (StreamReader1.getNextTag() != 0) {
                                        switch (StreamReader1.getCurrentTag()) {
                                            case 2: {
                                                tmpBytes = StreamReader1.getRaw();
                                                tmpInt = LittleEndian.getInt(tmpBytes, 0);
                                                tmpBG = Parser2.createObject(tmpInt);
                                                if (tmpBG == null) break;
                                                tmpBG.parse(Parser2, StreamReader1);
                                                if (tmpBG.isBadObject) break;
                                                if (this.Objects == null) {
                                                    this.Objects = new ArrayList();
                                                }
                                                this.Objects.add(tmpBG);
                                                if (!isGB) break;
                                                tmpBG.ParentGB = this;
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        double[] proto = new double[]{this.MinPtX, this.MinPtY, this.MaxPtX, this.MaxPtY};
                        double[] pts = SchemeEngine.MulPointsTM(Parser2.tmpGTM, proto);
                        this.Left = pts[0];
                        this.Right = pts[2];
                        this.Top = pts[1];
                        this.Bottom = pts[3];
                        if (isGB) {
                            Parser2.tmpGTM.setTransform(OldGTM);
                        }
                        throw throwable;
                    }
                    double[] proto = new double[]{this.MinPtX, this.MinPtY, this.MaxPtX, this.MaxPtY};
                    double[] pts = SchemeEngine.MulPointsTM(Parser2.tmpGTM, proto);
                    this.Left = pts[0];
                    this.Right = pts[2];
                    this.Top = pts[1];
                    this.Bottom = pts[3];
                    if (!isGB) continue block20;
                    Parser2.tmpGTM.setTransform(OldGTM);
                    break;
                }
                case 97: {
                    if (this.shapeType() != 202) break;
                    this.LibID = reader.getDouble();
                    break;
                }
                case 98: {
                    if (this.shapeType() != 202) break;
                    this.SourceID = reader.getDouble();
                    break;
                }
                case 40: {
                    StreamReader = reader.getStreamReader();
                    while (StreamReader.getNextTag() != 0) {
                        switch (StreamReader.getCurrentTag()) {
                            case 1: {
                                TaggedReader paramReader = StreamReader.getStreamReader();
                                PrimParam param = new PrimParam();
                                param.parse(paramReader);
                                this.BlockParams.add(param);
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        if (this.Objects != null) {
            int ccount = this.Objects.size();
            BaseGraphic Child = null;
            for (int i = 0; i < ccount; ++i) {
                Child = this.Objects.get(i);
                if (Child == null) continue;
                PhxLayer OldLayer = Engine2.tmpLayer;
                try {
                    if (!(Engine2.tmpInsertPaint || Engine2.tmpPrimPolylinePaint || Engine2.tmpDimPaint)) {
                        Engine2.setTmpLayer(Child.LayerID);
                    }
                    Child.paint(g2d, Engine2);
                    continue;
                }
                finally {
                    Engine2.tmpLayer = OldLayer;
                }
            }
        }
    }

    public synchronized void writeTaggedChildren(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (!simult && writer != null && this.Objects != null && this.Objects.size() > 0) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TaggedWriter subWriter = new TaggedWriter(stream);
            int cnt = this.Objects.size();
            for (int i = 0; i < cnt; ++i) {
                ByteArrayOutputStream stream1 = new ByteArrayOutputStream();
                TaggedWriter subWriter1 = new TaggedWriter(stream1);
                BaseGraphic object = this.Objects.get(i);
                assert (object != null);
                SchemeUtils.writeShapeClassInfo(subWriter1, object.getShapeClassInfo());
                object.writeTaggedData(subWriter1, clipboard, simult);
                subWriter1.flush();
                subWriter.putRaw(1, stream1);
            }
            subWriter.flush();
            writer.putRaw(94, stream);
        }
    }

    @Override
    public int shapeType() {
        return 202;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    public synchronized void writeTaggedDataAsShape(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(stream);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (stream.size() > 0) {
            writer.putRaw(3, stream);
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        SchemeUtils.writeDoubles(writer, 92, this.MinPtX, this.MinPtY);
        SchemeUtils.writeDoubles(writer, 93, this.MaxPtX, this.MaxPtY);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(stream);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (stream.size() > 0) {
            writer.putRaw(3, stream);
        }
        this.writeTaggedChildren(writer, clipboard, simult);
        if (this.shapeType() == 202) {
            if (this.LibID != 0.0) {
                writer.putDouble(97, this.LibID);
            }
            if (this.SourceID != 0.0) {
                writer.putDouble(98, this.SourceID);
            }
            if (!this.BlockParams.isEmpty()) {
                ByteArrayOutputStream paramStream = new ByteArrayOutputStream();
                TaggedWriter paramWriter = new TaggedWriter(paramStream);
                for (PrimParam param : this.BlockParams) {
                    ByteArrayOutputStream paramDetailsStream = new ByteArrayOutputStream();
                    TaggedWriter paramDetailsWriter = new TaggedWriter(paramDetailsStream);
                    param.store(paramDetailsWriter);
                    paramDetailsWriter.flush();
                    paramWriter.putRaw(1, paramDetailsStream);
                }
                paramStream.flush();
                writer.putRaw(40, paramStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calcOrgAndAjust(int idxPoint, boolean ignoreGP) {
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.Engine.GTM);
        double OldAngle = this.Engine.tmpAngle;
        if (this.TransProps != null && this.TransProps.Angle != 0.0) {
            this.Engine.tmpAngle += this.TransProps.Angle;
        }
        this.Engine.GTM.setToIdentity();
        try {
            int cnt;
            this.MaxPtX = GraphicBlock.initMaxX();
            this.MaxPtY = GraphicBlock.initMaxY();
            this.MinPtX = GraphicBlock.initMinX();
            this.MinPtY = GraphicBlock.initMinY();
            this.minMaxPts(this, false, false, false, ignoreGP);
            this.OrgX = this.MinPtX + (this.MaxPtX - this.MinPtX) / 2.0;
            this.OrgY = this.MinPtY + (this.MaxPtY - this.MinPtY) / 2.0;
            int n = cnt = this.Objects == null ? 0 : this.Objects.size();
            for (int i = 0; i < cnt; ++i) {
                BaseGraphic obj = this.Objects.get(i);
                obj.OrgX -= this.OrgX;
                obj.OrgY -= this.OrgY;
            }
        }
        finally {
            this.Engine.GTM.setTransform(OldGTM);
            this.Engine.tmpAngle = OldAngle;
        }
    }

    void minMaxPts(GraphicBlock root) {
        this.minMaxPts(root, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void minMaxPts(GraphicBlock root, boolean withLineWidth, boolean ignoreInvisible, boolean ignoreSel, boolean ignoreGP) {
        if (root == null || root.Objects == null) {
            return;
        }
        int cntli = root.Objects.size();
        for (int li = 0; li < cntli; ++li) {
            BaseGraphic obj = root.Objects.get(li);
            if (obj instanceof Attribute || obj instanceof GraphicBlock && !obj.isCartographic()) continue;
            AffineTransform OldGTM = new AffineTransform();
            OldGTM.setTransform(this.Engine.GTM);
            double OldAngle = this.Engine.tmpAngle;
            if (this.TransProps != null && this.TransProps.Angle != 0.0) {
                this.Engine.tmpAngle += this.TransProps.Angle;
            }
            try {
                int cntlj;
                double tmpRPtY;
                double[] tmpRPt;
                int lj;
                this.Engine.GTM.concatenate(SchemeEngine.GenTransform(obj));
                if (obj instanceof GraphicBlock) {
                    this.minMaxPts((GraphicBlock)obj, withLineWidth, ignoreInvisible, ignoreSel, ignoreGP);
                    continue;
                }
                assert (obj instanceof BaseShape);
                BaseShape shape = (BaseShape)obj;
                if (shape instanceof Paragraph && ((Paragraph)shape).getText().isEmpty()) continue;
                if (shape instanceof Spline) {
                    int verticesCount = this.getVerticesCount();
                    if (verticesCount > 0) {
                        double[] cpts = ((Spline)shape).calcPoints();
                        cpts = SchemeEngine.MulPointsTM(this.Engine.GTM, cpts);
                        double lLineWidth = 0.0;
                        if (shape.lWidth != -1.0) {
                            lLineWidth = shape.lWidth;
                        }
                        int i = 0;
                        int cnt = cpts.length - 1;
                        while (i < cnt) {
                            double x = cpts[i++];
                            double y = cpts[i++];
                            if (this.MaxPtX < x) {
                                this.MaxPtX = x;
                            }
                            if (this.MaxPtY < y) {
                                this.MaxPtY = y;
                            }
                            if (this.MinPtX >= x) {
                                this.MinPtX = x;
                            }
                            if (this.MinPtY >= y) {
                                this.MinPtY = y;
                            }
                            if (!withLineWidth || !(lLineWidth > 0.0)) continue;
                            if (this.MaxPtX < x + lLineWidth) {
                                this.MaxPtX = x + lLineWidth;
                            }
                            if (this.MaxPtY < y + lLineWidth) {
                                this.MaxPtY = y + lLineWidth;
                            }
                            if (this.MinPtX >= x - lLineWidth) {
                                this.MinPtX = x - lLineWidth;
                            }
                            if (!(this.MinPtY >= y - lLineWidth)) continue;
                            this.MinPtY = y - lLineWidth;
                        }
                    }
                } else {
                    int cntlj2 = shape.getVerticesCount();
                    for (lj = 0; lj < cntlj2; ++lj) {
                        double[] pt = new double[]{shape.getVertexX(lj), shape.getVertexY(lj)};
                        tmpRPt = SchemeEngine.MulPointsTM(this.Engine.GTM, pt);
                        assert (tmpRPt != null && tmpRPt.length == 2);
                        double tmpRPtX = tmpRPt[0];
                        tmpRPtY = tmpRPt[1];
                        if (this.MaxPtX < tmpRPtX) {
                            this.MaxPtX = tmpRPtX;
                        }
                        if (this.MaxPtY < tmpRPtY) {
                            this.MaxPtY = tmpRPtY;
                        }
                        if (this.MinPtX >= tmpRPtX) {
                            this.MinPtX = tmpRPtX;
                        }
                        if (this.MinPtY >= tmpRPtY) {
                            this.MinPtY = tmpRPtY;
                        }
                        double lLineWidth = 0.0;
                        if (shape.lWidth != -1.0) {
                            lLineWidth = shape.lWidth;
                        }
                        if (!withLineWidth || !(lLineWidth > 0.0)) continue;
                        if (this.MaxPtX < tmpRPtX + lLineWidth) {
                            this.MaxPtX = tmpRPtX + lLineWidth;
                        }
                        if (this.MaxPtY < tmpRPtY + lLineWidth) {
                            this.MaxPtY = tmpRPtY + lLineWidth;
                        }
                        if (this.MinPtX >= tmpRPtX - lLineWidth) {
                            this.MinPtX = tmpRPtX - lLineWidth;
                        }
                        if (!(this.MinPtY >= tmpRPtY - lLineWidth)) continue;
                        this.MinPtY = tmpRPtY - lLineWidth;
                    }
                }
                if (ignoreGP) continue;
                int n = cntlj = shape.GluePoints == null ? 0 : shape.GluePoints.size();
                for (lj = 0; lj < cntlj; ++lj) {
                    BaseGraphic.GluePoint gp = (BaseGraphic.GluePoint)shape.GluePoints.get(lj);
                    assert (gp != null);
                    tmpRPt = SchemeEngine.MulPointsTM(this.Engine.GTM, new double[]{gp.ptX, gp.ptY});
                    double tmpRPtX = tmpRPt[0];
                    tmpRPtY = tmpRPt[1];
                    if (this.MaxPtX < tmpRPtX) {
                        this.MaxPtX = tmpRPtX;
                    }
                    if (this.MaxPtY < tmpRPtY) {
                        this.MaxPtY = tmpRPtY;
                    }
                    if (this.MinPtX >= tmpRPtX) {
                        this.MinPtX = tmpRPtX;
                    }
                    if (!(this.MinPtY >= tmpRPtY)) continue;
                    this.MinPtY = tmpRPtY;
                }
                continue;
            }
            finally {
                this.Engine.GTM.setTransform(OldGTM);
                this.Engine.tmpAngle = OldAngle;
            }
        }
    }

    @Override
    protected int getVerticesCount() {
        return 8;
    }

    @Override
    protected double getVertexX(int index) {
        BaseGraphic obj;
        int childrenCount;
        if (index >= 4) {
            return 0.0;
        }
        int lIndex = -index - 2;
        int n = childrenCount = this.Objects == null ? 0 : this.Objects.size();
        if (lIndex >= 0 && lIndex < childrenCount && (obj = this.Objects.get(lIndex)) instanceof AttributeDef) {
            return ((AttributeDef)obj).OrgX;
        }
        lIndex = -index - 2 - childrenCount;
        if (lIndex >= 0 && lIndex < childrenCount && (obj = this.Objects.get(lIndex)) instanceof AttributeDef) {
            AttributeDef lAttr = (AttributeDef)obj;
            if (!lAttr.AutoSize) {
                double[] pt = new double[]{lAttr.SideX / 2.0, lAttr.SideY / 2.0};
                pt = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(lAttr), pt);
                return pt[0];
            }
        }
        double pX = (this.MaxPtX - this.MinPtX) / 2.0;
        switch (index) {
            case 0: 
            case 3: {
                return -pX;
            }
            case 1: 
            case 2: {
                return pX;
            }
        }
        return 0.0;
    }

    @Override
    protected double getVertexY(int index) {
        BaseGraphic obj;
        int childrenCount;
        if (index >= 4) {
            return 0.0;
        }
        int lIndex = -index - 2;
        int n = childrenCount = this.Objects == null ? 0 : this.Objects.size();
        if (lIndex >= 0 && lIndex < childrenCount && (obj = this.Objects.get(lIndex)) instanceof AttributeDef) {
            return ((AttributeDef)obj).OrgY;
        }
        lIndex = -index - 2 - childrenCount;
        if (lIndex >= 0 && lIndex < childrenCount && (obj = this.Objects.get(lIndex)) instanceof AttributeDef) {
            AttributeDef lAttr = (AttributeDef)obj;
            if (!lAttr.AutoSize) {
                double[] pt = new double[]{lAttr.SideX / 2.0, lAttr.SideY / 2.0};
                pt = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(lAttr), pt);
                return pt[1];
            }
        }
        double pY = (this.MaxPtY - this.MinPtY) / 2.0;
        switch (index) {
            case 0: 
            case 1: {
                return -pY;
            }
            case 2: 
            case 3: {
                return pY;
            }
        }
        return 0.0;
    }

    @Override
    protected void setVertex(int index, double x, double y) {
        double AspectY;
        BaseGraphic obj;
        if (index == this.getVerticesCount()) {
            return;
        }
        int childrenCount = this.Objects == null ? 0 : this.Objects.size();
        int lIndex = -index - 2;
        if (lIndex >= 0 && lIndex < childrenCount && (obj = this.Objects.get(lIndex)) instanceof AttributeDef) {
            AttributeDef attr = (AttributeDef)obj;
            attr.ajustOrgPoint(x, y);
            return;
        }
        lIndex = -index - 2 - childrenCount;
        if (lIndex >= 0 && lIndex < childrenCount && (obj = this.Objects.get(lIndex)) instanceof AttributeDef) {
            AttributeDef attr = (AttributeDef)obj;
            if (!attr.AutoSize) {
                attr.ajustSidesPoint(x, y);
                return;
            }
        }
        if (this.TransProps == null) {
            this.TransProps = new TransformProps();
        }
        double lMinPtX = this.MinPtX;
        double lMinPtY = this.MinPtY;
        double lMaxPtX = this.MaxPtX;
        double lMaxPtY = this.MaxPtY;
        double oldSidesX = lMaxPtX - lMinPtX;
        double oldSidesY = lMaxPtY - lMinPtY;
        if (oldSidesX == 0.0) {
            oldSidesX += 1.0E-12;
        }
        if (oldSidesY == 0.0) {
            oldSidesY += 1.0E-12;
        }
        double lSidesX = 0.0;
        double lSidesY = 0.0;
        if (index == 1 || index == 2 || index == 5) {
            lSidesX = x - this.getVertexX(0);
        } else if (index == 0 || index == 3 || index == 7) {
            lSidesX = this.getVertexX(1) - x;
        }
        if (index == 2 || index == 3 || index == 6) {
            lSidesY = y - this.getVertexY(0);
        } else if (index == 0 || index == 1 || index == 4) {
            lSidesY = this.getVertexY(2) - y;
        }
        double AspectX = oldSidesX == 0.0 ? 1.0 : lSidesX / oldSidesX;
        double d = AspectY = oldSidesY == 0.0 ? 1.0 : lSidesY / oldSidesY;
        if (AspectX != 0.0) {
            double lx = this.TransProps.ScaleX;
            this.TransProps.ScaleX *= AspectX;
            if (lx != 0.0) {
                lx = this.TransProps.ScaleX / lx;
            }
            if (lx != 0.0) {
                this.TransProps.CenterX /= lx;
            }
        }
        if (AspectY != 0.0) {
            double ly = this.TransProps.ScaleY;
            this.TransProps.ScaleY *= AspectY;
            if (ly != 0.0) {
                ly = this.TransProps.ScaleY / ly;
            }
            if (ly != 0.0) {
                this.TransProps.CenterY /= ly;
            }
        }
    }

    @Override
    public void minMaxPt(boolean ignoreInvisible, boolean ignoreGP) {
        this.MaxPtX = GraphicBlock.initMaxX();
        this.MaxPtY = GraphicBlock.initMaxY();
        this.MinPtX = GraphicBlock.initMinX();
        this.MinPtY = GraphicBlock.initMinY();
        this.minMaxPts(this, false, ignoreInvisible, false, ignoreGP);
        if (this.TransProps != null) {
            if (this.MinPtX == this.MaxPtX) {
                this.MaxPtX *= this.TransProps.ScaleX;
            }
            if (this.MinPtY == this.MaxPtY) {
                this.MaxPtY *= this.TransProps.ScaleY;
            }
        }
    }

    @Override
    public void genDistRadius(boolean ignoreGP) {
        int childrenCount;
        int n = childrenCount = this.Objects == null ? 0 : this.Objects.size();
        if (childrenCount > 0) {
            this.Left = 2.147483647E9;
            this.Top = 2.147483647E9;
            this.Bottom = -2.147483647E9;
            this.Right = -2.147483647E9;
            for (int i = 0; i < childrenCount; ++i) {
                BaseGraphic bg = this.Objects.get(i);
                if (bg instanceof Attribute) continue;
                if (this.Left > bg.Left) {
                    this.Left = bg.Left;
                }
                if (this.Left > bg.Right) {
                    this.Left = bg.Right;
                }
                if (this.Right < bg.Left) {
                    this.Right = bg.Left;
                }
                if (this.Right < bg.Right) {
                    this.Right = bg.Right;
                }
                if (this.Top > bg.Top) {
                    this.Top = bg.Top;
                }
                if (this.Top > bg.Bottom) {
                    this.Top = this.Bottom;
                }
                if (this.Bottom < bg.Top) {
                    this.Bottom = bg.Top;
                }
                if (!(this.Bottom < bg.Bottom)) continue;
                this.Bottom = bg.Bottom;
            }
        }
    }

    @Override
    public BaseGraphic.RealRect getMinMaxRect() {
        this.minMaxPt(false, false);
        double[] pts = new double[]{this.MinPtX, this.MinPtY, this.MaxPtX, this.MinPtY, this.MaxPtX, this.MaxPtY, this.MinPtX, this.MaxPtY};
        pts = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(this), pts);
        return this.ptArrToRect(pts, 4);
    }
}

