/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.SchemeParser;
import java.io.IOException;

public class GraphicInsert
extends GraphicBlock {
    public String SourceName = null;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        ((GraphicInsert)Dest).SourceName = this.SourceName;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 96: {
                    this.SourceName = reader.getUnicode();
                    break;
                }
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                }
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        if (this.SourceName != null && !this.SourceName.isEmpty()) {
            writer.putUnicode(96, this.SourceName);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
    }

    @Override
    public int shapeType() {
        return 206;
    }

    @Override
    public int shapeVersion() {
        return version;
    }
}

