/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.schemes.ModificationCommand;
import inform.agent.schemes.NoSuchObjectException;
import inform.agent.schemes.ObjectChangedException;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import java.util.Date;

class ModifyObjectCommand
extends ModificationCommand {
    ModifyObjectCommand() {
    }

    @Override
    public void run(Scheme scheme, Request request) throws ObjectChangedException, NoSuchObjectException {
        SchemeObject subjDesc = this.getSubjectDescriptor();
        SchemeObject so = this.getLockedObject();
        assert (so != null);
        so.setGeometry(subjDesc.getGeometry());
        so.setGeometryLrs(subjDesc.getGeometryLrs());
        if (subjDesc.isContentChanged()) {
            so.setParams(subjDesc.getParams());
        }
        if (subjDesc.isParentChanged()) {
            so.setParentID(subjDesc.getParentID());
        }
        if (subjDesc.isLayerChanged()) {
            so.setLayerID(subjDesc.getLayerID());
        }
        if (subjDesc.isOrderChanged()) {
            so.setOrder(subjDesc.getOrder());
        }
        int type0 = so.getType();
        int type1 = subjDesc.getType();
        if (type1 != type0 && SchemeObjectsTypes.ObjTypeIsShape(type0) && SchemeObjectsTypes.ObjTypeIsShape(type1)) {
            so.setType(type1);
        }
        so.setRevision(this.getSessionSchemeRevision());
        so.setLastModTime(DateTime.fromUnixTime(new Date().getTime()));
        so.setLastModUser(request.getUserID());
        so.setCaption(subjDesc.getCaption());
        so.BGChanged = true;
    }

    @Override
    boolean isModificationAllowed(Scheme scheme) {
        boolean allowed;
        SchemeObject so = this.getLockedObject();
        boolean bl = allowed = so != null;
        if (!allowed) {
            Core.logger.debug("Denial reason: object doesn't exist");
            return false;
        }
        boolean bl2 = allowed = allowed && so.getRevision() == this.getSubjectDescriptor().getRevision();
        if (!allowed) {
            Core.logger.debug("Denial reason: revisions mismatch, server {}, client {}", so.getRevision(), this.getSubjectDescriptor().getRevision());
        }
        return allowed;
    }
}

