/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.io.IOException;

public class Polygon
extends Polyline {
    public int[] Counts = null;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        Polygon shape = (Polygon)Dest;
        int count = this.Counts.length;
        shape.Counts = new int[count];
        for (int i = 0; i < count; ++i) {
            shape.Counts[i] = this.Counts[i];
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 78: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        switch (StreamReader.getCurrentTag()) {
                            case 80: {
                                this.Counts = LittleEndian.toIntArray(StreamReader.getRaw());
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        this.writeTaggedCounts(writer);
    }

    synchronized void writeTaggedCounts(TaggedWriter writer) throws IOException {
        if (this.Counts == null || this.Counts.length == 0) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        if (this.Counts.length != 1) {
            w.putInt32(79, this.Counts.length);
        }
        w.putRaw(80, LittleEndian.intArrayToBinary(this.Counts, this.Counts.length));
        w.flush();
        writer.putRaw(78, os);
    }

    @Override
    public int shapeType() {
        return 211;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        double[] Pts = null;
        Pts = Engine2.UseGTM ? Engine2.MulPoints(this.Points) : this.Points;
        int pcount = Pts.length / 2;
        int SectCount = 0;
        if (this.Counts != null) {
            SectCount = this.Counts.length;
        }
        if (Engine2.UseJavaShapes || SectCount > 1) {
            int idx = 0;
            int SectIdx = 0;
            int Count = 0;
            Path2D.Double shape = new Path2D.Double();
            shape.setWindingRule(0);
            for (int i = 0; i < pcount; ++i) {
                idx = 2 * i;
                if (i == 0 || i == Count) {
                    if (SectCount > 1) {
                        Count += this.Counts[SectIdx];
                    }
                    ((Path2D)shape).moveTo(Pts[idx], Pts[idx + 1]);
                    ++SectIdx;
                    continue;
                }
                ((Path2D)shape).lineTo(Pts[idx], Pts[idx + 1]);
                if (i != pcount - 1 && i != Count - 1) continue;
                shape.closePath();
            }
            if (Engine2.isNeedFill(this.BrushPattern)) {
                Engine2.setActualBColor(g2d, this.bColor);
                g2d.fill(shape);
            }
            if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
                Engine2.setActualPColor(g2d, this.pColor);
                Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
                g2d.draw(shape);
            }
        } else {
            int[] x = new int[pcount];
            int[] y = new int[pcount];
            int idx = 0;
            for (int i = 0; i < pcount; ++i) {
                idx = 2 * i;
                x[i] = (int)Math.round(Pts[idx]);
                y[i] = (int)Math.round(Pts[idx + 1]);
            }
            if (Engine2.isNeedFill(this.BrushPattern)) {
                Engine2.setActualBColor(g2d, this.bColor);
                g2d.fillPolygon(x, y, pcount);
            }
            if (Engine2.isNeedPen(this.PenPattern) && (!Engine2.isNeedFill(this.BrushPattern) || Engine2.getActualPColor(this.pColor) != Engine2.getActualBColor(this.bColor))) {
                Engine2.setActualPColor(g2d, this.pColor);
                Engine2.setActualPenStyle(g2d, this.PenPattern, this.lWidth);
                g2d.drawPolygon(x, y, pcount);
            }
        }
    }
}

