/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BindingNode;
import inform.agent.schemes.Container;
import inform.agent.schemes.Diagram;
import inform.agent.schemes.DiagramTable;
import inform.agent.schemes.Dimension;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Guide;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.PrimLibrary;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeKeepSettings;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemePageNotes;
import inform.agent.schemes.Spline;
import inform.agent.schemes.Table;
import inform.agent.scripts.SSContext;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;

public class SchemeParser {
    public AffineTransform tmpGTM = new AffineTransform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseProps(SSContext ssContext, ConnectionManager dbMgr, Scheme s, boolean exporting) throws IOException, TaggedReaderException, InformException, SQLException {
        this.tmpGTM.setToIdentity();
        int BGCount = 0;
        int BGParseCount = 0;
        long t1 = System.currentTimeMillis();
        Iterator it = s.schemeObjects.iterator();
        while (it.hasNext()) {
            SchemeObject i;
            SchemeObject schemeObject = i = (SchemeObject)it.next();
            synchronized (schemeObject) {
                if (!i.isDeleted()) {
                    if (SchemeObjectsTypes.ObjTypeIsBG(i.getType())) {
                        ++BGCount;
                    }
                    if (this.ParseObject(ssContext, dbMgr, i, s, exporting)) {
                        ++BGParseCount;
                    }
                }
            }
        }
        if (BGParseCount > 0) {
            s.BoundsCalculated = false;
            long t2 = System.currentTimeMillis();
            Core.logger.info("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 \u0444\u0438\u0433\u0443\u0440 ({} \u0438\u0437 {}) \u0441\u0445\u0435\u043c\u044b {}: {}ms", BGParseCount, BGCount, NumberConverter.doubleToString(s.getSchemeId()), t2 - t1);
        }
    }

    private boolean ParseObject(SSContext ssContext, ConnectionManager dbMgr, SchemeObject Obj, Scheme s, boolean exporting) throws IOException, TaggedReaderException, InformException, SQLException {
        byte[] Data2;
        boolean res = false;
        if (Obj != null && (Data2 = Obj.getParams()) != null && Data2.length > 0) {
            int ObjType = Obj.getType();
            if (SchemeObjectsTypes.ObjTypeIsBG(ObjType) && (Obj.BG == null || Obj.BGChanged)) {
                TaggedReader reader = new TaggedReader(Data2);
                BaseGraphic BG = this.createObject(ObjType);
                if (BG != null) {
                    BG.parse(this, reader);
                    if (BG.isBadObject) {
                        return false;
                    }
                    BG.afterParse();
                    Obj.BG = BG;
                    res = true;
                }
                Obj.BGChanged = false;
            } else {
                switch (ObjType) {
                    case -16: {
                        s.BkColor = SchemeParser.parseColor(LittleEndian.getInt(Data2, 0));
                        break;
                    }
                    case -29: {
                        break;
                    }
                    case 104: {
                        double dbl = LittleEndian.getDouble(Data2, 0);
                        if (dbl == 0.0 || s.PrimLibraries.get(dbl) != null) break;
                        PrimLibrary PrimLib = new PrimLibrary(dbl);
                        PrimLib.Parse(ssContext, dbMgr, this, s);
                        s.PrimLibraries.add(PrimLib);
                        break;
                    }
                    case 106: {
                        double dbl1 = LittleEndian.getDouble(Data2, 0);
                        if (dbl1 == 0.0 || s.BindingNodes.get(dbl1) != null) break;
                        BindingNode Binding2 = new BindingNode(dbl1);
                        Binding2.parse(ssContext, dbMgr, s.getSchemeId());
                        s.BindingNodes.add(Binding2);
                        break;
                    }
                    case -34: {
                        TaggedReader plReader = new TaggedReader(Data2);
                        SchemePageLayout pl = s.getPageLayout();
                        pl.load(plReader);
                        break;
                    }
                    case 116: {
                        this.parsePage(s, Obj.getID(), Obj.getOrder(), Data2);
                        break;
                    }
                    case 117: {
                        this.parseInternalPrim(s, Data2);
                        break;
                    }
                    case 118: {
                        DiagramTable.loadDiagramTable(s, Data2);
                    }
                }
            }
        }
        return res;
    }

    public BaseGraphic createObject(int Type2) {
        switch (Type2) {
            case 202: {
                return new GraphicBlock();
            }
            case 204: {
                return new PhxLayer();
            }
            case 207: {
                return new PhxGraphicInsert();
            }
            case 210: {
                return new Polyline();
            }
            case 211: {
                return new Polygon();
            }
            case 212: {
                return new Spline();
            }
            case 213: {
                return new Region();
            }
            case 214: {
                return new Rectangle();
            }
            case 215: {
                return new Ellipse();
            }
            case 216: {
                return new Pie();
            }
            case 217: {
                return new Image();
            }
            case 218: {
                return new PhxImage();
            }
            case 222: {
                return new RectTextLine();
            }
            case 223: {
                return new Paragraph();
            }
            case 225: {
                return new AttributeDef();
            }
            case 226: {
                return new AttributeRef();
            }
            case 231: {
                return new Dimension();
            }
            case 232: {
                return new Container();
            }
            case 233: {
                return new Table();
            }
            case 234: {
                return new Guide();
            }
            case 235: {
                return new Diagram();
            }
        }
        Core.logger.info("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f " + Type2);
        return null;
    }

    private void parsePage(Scheme s, double id, int order, byte[] data) throws IOException {
        SchemePage page = s.Pages.get(id);
        if (page == null) {
            page = new SchemePage(id, order);
            s.Pages.add(page);
        } else {
            page.setOrder(order);
        }
        TaggedReader pageReader = new TaggedReader(data);
        while (pageReader.getNextTag() != 0) {
            switch (pageReader.getCurrentTag()) {
                case 1: {
                    page.setCaption(pageReader.getString());
                    break;
                }
                case 2: {
                    byte[] content = pageReader.getRaw();
                    if (content.length == 0) break;
                    if (page.pageLayout == null) {
                        page.pageLayout = new SchemePageLayout();
                    }
                    TaggedReader pageLayoutReader = new TaggedReader(content);
                    page.pageLayout.load(pageLayoutReader);
                    break;
                }
                case 4: {
                    page.BkColor = SchemeParser.parseColor(pageReader.getInt());
                    break;
                }
                case 5: {
                    page.isBackPage = pageReader.getBoolean();
                    break;
                }
                case 6: {
                    page.backPageId = pageReader.getDouble();
                    break;
                }
                case 11: {
                    byte[] content = pageReader.getRaw();
                    if (content.length == 0) break;
                    if (page.pageNotes == null) {
                        page.pageNotes = new SchemePageNotes();
                    }
                    page.pageNotes.load(new TaggedReader(content));
                    break;
                }
                case 9: {
                    page.LineJumpEnable = true;
                    pageReader.skip();
                    byte[] jumpsData = pageReader.getRaw();
                    if (jumpsData.length == 0) break;
                    TaggedReader jumpsReader = new TaggedReader(jumpsData);
                    block14: while (jumpsReader.next()) {
                        switch (jumpsReader.getCurrentTag()) {
                            case 2: {
                                page.LineJumpType = jumpsReader.getInt();
                                continue block14;
                            }
                            case 3: {
                                page.LineJumpSize = jumpsReader.getDouble();
                                continue block14;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    private void parseInternalPrim(Scheme s, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return;
        }
        assert (s != null);
        if (s.internalLib == null) {
            s.internalLib = new PrimLibrary(0.0);
        }
        Primitive prim = new Primitive();
        prim.parse(this, new TaggedReader(data));
        assert (s.internalLib.Primitives != null);
        s.internalLib.Primitives.put(prim.key(), prim);
    }

    public static boolean isGZip(byte[] data) {
        return data.length > 1 && data[0] == 31 && data[1] == -117;
    }

    public static Color parseColor(int c) {
        if (c != 0x1FFFFFFF) {
            return new Color(c & 0xFF, c >> 8 & 0xFF, c >> 16 & 0xFF);
        }
        return null;
    }

    public static SchemeKeepSettings parseKeepSettings(byte[] data) throws IOException {
        double keepSettingsId = 0.0;
        TaggedReader reader = new TaggedReader(data);
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 151: {
                    keepSettingsId = reader.getDouble();
                }
            }
        }
        if (keepSettingsId == 0.0 || Ini.libraryMode) {
            return null;
        }
        Node node = MtdEngine.getNode(keepSettingsId);
        if (node == null || node.getType() != 52) {
            return null;
        }
        BasicNode n = node.getRealNode();
        if (n == null) {
            return null;
        }
        byte[] nodeContent = n.getContent();
        return new SchemeKeepSettings(new TaggedReader(nodeContent));
    }
}

