/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class VisioOldFormatsConverter {
    private static final String SYSTEM_LICENSE_RESOURCE = "/resources/license/Aspose.Diagram.Java.lic";
    private final ServerSideHost stateHost;

    public VisioOldFormatsConverter(ServerSideHost requestState) {
        this.stateHost = requestState;
    }

    public byte[] convertOldVisioFormatToNew(byte[] content, SaveFormat format) throws Exception {
        if (this.stateHost != null) {
            this.stateHost.putRequestStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f VSD-\u0444\u0430\u0439\u043b\u0430");
            this.stateHost.putRequestStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0430\u043d\u0430\u043b\u0438\u0437 VSD-\u0444\u0430\u0439\u043b\u0430");
        }
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f VSD-\u0444\u0430\u0439\u043b\u0430");
        URL converterJarUrl = VisioOldFormatsConverter.getConverterJarUrl();
        PrivilegedAction<byte[]> action = () -> {
            try (CustomClassLoader classLoader = new CustomClassLoader(new URL[]{converterJarUrl});){
                byte[] byArray;
                Object diagram;
                Class<?> licenseClass = ((ClassLoader)classLoader).loadClass("com.aspose.diagram.License");
                Class<?> diagramClass = ((ClassLoader)classLoader).loadClass("com.aspose.diagram.Diagram");
                boolean isLicenseSet = VisioOldFormatsConverter.applyLicense(licenseClass);
                if (!isLicenseSet) {
                    throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 VSD. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: 002");
                }
                try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
                    diagram = diagramClass.getConstructor(InputStream.class).newInstance(is);
                }
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    diagramClass.getMethod("save", OutputStream.class, Integer.TYPE).invoke(diagram, os, format.formatIdx());
                    byArray = os.toByteArray();
                }
                return byArray;
            }
            catch (Exception ex) {
                throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 VSD. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: 004", ex);
            }
        };
        return AccessController.doPrivileged(action);
    }

    private static URL getConverterJarUrl() throws Exception {
        File libDirectory = new File(Ini.RootPath, "lib");
        File[] jarDirectoryFiles = libDirectory.listFiles();
        assert (jarDirectoryFiles != null);
        File jarLib = Stream.of(jarDirectoryFiles).filter(file -> file.isFile() && file.getName().startsWith("aspose-diagram-")).max(Comparator.naturalOrder()).orElseThrow(() -> new FileNotFoundException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 jar \u0444\u0430\u0439\u043b"));
        return jarLib.toURI().toURL();
    }

    private static boolean applyLicense(Class<?> licenseClass) {
        boolean bl;
        block8: {
            InputStream is = VisioOldFormatsConverter.class.getResourceAsStream(SYSTEM_LICENSE_RESOURCE);
            try {
                Object license = licenseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                licenseClass.getMethod("setLicense", InputStream.class).invoke(license, is);
                bl = (Boolean)licenseClass.getMethod("isLicenseSet", new Class[0]).invoke(null, new Object[0]);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 VSD. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: 001");
                }
            }
            is.close();
        }
        return bl;
    }

    public static class CustomClassLoader
    extends URLClassLoader {
        private final Set<String> netLibsWhiteList = new HashSet<String>(Arrays.asList("java.net.URL", "java.net.URI"));

        public CustomClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.toLowerCase().contains(".net.") && !this.netLibsWhiteList.contains(name)) {
                throw new ClassNotFoundException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 VSD. \u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: 003 (" + name + ")");
            }
            return super.loadClass(name);
        }
    }

    public static enum SaveFormat {
        VSDX(15),
        VSSX(17);

        private final int formatIdx;

        private SaveFormat(int formatIdx) {
            this.formatIdx = formatIdx;
        }

        public int formatIdx() {
            return this.formatIdx;
        }
    }
}

