/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Container;
import inform.agent.schemes.Diagram;
import inform.agent.schemes.DiagramTable;
import inform.agent.schemes.Dimension;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.EmbeddedText;
import inform.agent.schemes.GradientPattern;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Guide;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.PrimLibrary;
import inform.agent.schemes.PrimParam;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemePageNotes;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.Table;
import inform.agent.schemes.TextProps;
import inform.agent.schemes.TransformProps;
import inform.agent.schemes.converters.vsdx.EmfReader;
import inform.agent.schemes.converters.vsdx.Vsdx;
import inform.agent.schemes.converters.vsdx.VsdxCharacter;
import inform.agent.schemes.converters.vsdx.VsdxChart;
import inform.agent.schemes.converters.vsdx.VsdxComment;
import inform.agent.schemes.converters.vsdx.VsdxCommentsParser;
import inform.agent.schemes.converters.vsdx.VsdxConnect;
import inform.agent.schemes.converters.vsdx.VsdxDocumentParser;
import inform.agent.schemes.converters.vsdx.VsdxForeignData;
import inform.agent.schemes.converters.vsdx.VsdxGeometry;
import inform.agent.schemes.converters.vsdx.VsdxGradientStops;
import inform.agent.schemes.converters.vsdx.VsdxLayer;
import inform.agent.schemes.converters.vsdx.VsdxMaster;
import inform.agent.schemes.converters.vsdx.VsdxMasterParser;
import inform.agent.schemes.converters.vsdx.VsdxPage;
import inform.agent.schemes.converters.vsdx.VsdxPageParser;
import inform.agent.schemes.converters.vsdx.VsdxParagraph;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxProperty;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxShapeParser;
import inform.agent.schemes.converters.vsdx.VsdxStyle;
import inform.agent.schemes.converters.vsdx.VsdxTabs;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import inform.agent.schemes.converters.vsdx.VsdxWindowsParser;
import inform.agent.schemes.converters.vsdx.themes.VsdxTheme;
import inform.agent.schemes.effects.Glow;
import inform.agent.schemes.effects.Reflection;
import inform.agent.schemes.effects.Shadow;
import inform.agent.schemes.effects.SoftEdges;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.imageio.ImageIO;

public class VsdxReader {
    private boolean isEmbeddingsVsdx = false;
    private boolean isFromOldFormat = false;
    private boolean importHiddenPaths;
    private ServerSideHost stateHost;
    private double userId = 0.0;
    private double modifiedTime;
    private boolean currentLayerColor;
    private double currentPageScale;
    private double koefScale = 1.0;
    private double koefScaleX = 1.0;
    private double koefScaleY = 1.0;
    private double currentLayerID;
    private double currentPageLayerID;
    private Map<String, Double> layerIDs;
    private Map<String, String> layerColors;
    private Map<Double, PhxLayer> layers;
    private Map<String, List<ConnectToInfo>> shapeConnects = new HashMap<String, List<ConnectToInfo>>();
    private Map<String, DoubleList> visioShapesHash;
    private DoubleHash<SchemeObject> pageObjects;
    private Map<Double, BaseGraphic> pageShapes;
    private Map<Double, Double> parents;
    private Map<String, Double> primsHash;
    private Map<String, BaseGraphic> containerObjects;
    private final Map<String, BaseGraphic> containerObjectsByName = new HashMap<String, BaseGraphic>();
    private Map<String, VsdxShape> containerShapes;
    private VsdxUtils.VsdxShapeStyle currentShapeStyle = new VsdxUtils.VsdxShapeStyle();
    private Scheme scheme;
    private SchemeEngine engine;
    private int orderIndex = 0;
    private int cntErrors = 100;
    private CONTENT_TYPE contentType;
    private GraphicBlock currentPrimitiveBlock = null;
    private static final double SIZE_STEP = 0.1;
    private static final double MIN_FONT_SCALE = 0.01;
    private static final double MAX_FONT_SCALE = 6.0;
    private static final int MAX_POLY_POINTS_COUNT = 4;
    private static final double GLUE_TOLERANCE = 0.001;
    private static final double RECT_TOLERANCE = 0.1;
    private static final String DEF_ATT_CAPTION = "\u0410\u0442\u0440\u0438\u0431\u0443\u0442";
    private static final boolean USE_AUTO_SIZE = false;
    private static final String COSMETIC_LAYER_NAME = "\u041a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u043b\u043e\u0439";
    private static final int MAX_LOG_ERRORS = 100;

    public static double inchToMM(String value, VsdxShape shape) {
        return VsdxUtils.convertDouble(value, shape) * 25.4;
    }

    static int inchToPT(String value, VsdxShape shape) {
        return SchemeUtils.inchToPT(VsdxUtils.convertDouble(value, shape));
    }

    private Vsdx parseVssx(byte[] content) throws Exception {
        if (content == null || content.length == 0) {
            return null;
        }
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0438\u043c\u043f\u043e\u0440\u0442 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0430\u043d\u0430\u043b\u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438");
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0430\u043d\u0430\u043b\u0438\u0437 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 Visio");
        Vsdx vsdx = new Vsdx();
        vsdx.setFromOldFormat(this.isFromOldFormat);
        VsdxParser vsdxParser = new VsdxParser(content);
        VsdxDocumentParser documentParser = vsdxParser.getDocumentParser();
        if (documentParser != null) {
            vsdx.documentColors = documentParser.getColorEntries();
            vsdx.styles = documentParser.getStyles();
        }
        int cntMasters = vsdxParser.countMasters();
        int curPosition = 1;
        int maxPosition = cntMasters * 2 + 1;
        this.putStateProgressMax(maxPosition);
        for (int masterIdx = 0; masterIdx < cntMasters; ++masterIdx) {
            VsdxMaster vsdxMaster;
            this.putStateProgressPosition(curPosition++);
            VsdxMasterParser masterParser = vsdxParser.getMaster(masterIdx);
            if (masterParser == null || (vsdxMaster = masterParser.getVsdxMaster(vsdx)) == null || !this.importHiddenPaths && (vsdxMaster.isHidden || vsdxMaster.isPatternFlags)) continue;
            vsdx.masters.add(vsdxMaster);
            this.putStateProgressPosition(curPosition++);
            int cnt = vsdxMaster.shapes == null ? 0 : vsdxMaster.shapes.size();
            vsdx.totalShapes += cnt;
        }
        this.putStateProgressPosition(maxPosition);
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0430\u043d\u0430\u043b\u0438\u0437 " + vsdx.totalShapes + " \u0444\u0438\u0433\u0443\u0440 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 Visio");
        return vsdx;
    }

    private Vsdx parseVsdx(byte[] content) throws Exception {
        return this.parseVsdx(content, false);
    }

    private Vsdx parseVsdx(byte[] content, boolean silent) throws Exception {
        List<VsdxComment> comments;
        VsdxCommentsParser commentsParser;
        VsdxWindowsParser windowParser;
        if (content == null || content.length == 0) {
            return null;
        }
        if (!silent) {
            this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0438\u043c\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
            this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0430\u043d\u0430\u043b\u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
            Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0430\u043d\u0430\u043b\u0438\u0437 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Visio");
        }
        Vsdx vsdx = new Vsdx();
        vsdx.setFromOldFormat(this.isFromOldFormat);
        VsdxParser vsdxParser = new VsdxParser(content);
        for (int i = 0; i < vsdxParser.countThemes(); ++i) {
            vsdx.themes.add(vsdxParser.parseTheme(i));
        }
        VsdxDocumentParser documentParser = vsdxParser.getDocumentParser();
        if (documentParser != null) {
            vsdx.documentColors = documentParser.getColorEntries();
            vsdx.styles = documentParser.getStyles();
        }
        int cntPages = vsdxParser.countPages();
        int curPosition = 1;
        int maxPosition = cntPages * 4 + 1;
        this.putStateProgressMax(maxPosition);
        for (int pageIdx = 0; pageIdx < cntPages; ++pageIdx) {
            int shapesCount;
            VsdxPageParser pageParser;
            if (!silent) {
                this.putStateProgressPosition(curPosition++);
            }
            if ((pageParser = vsdxParser.getPageParser(pageIdx)) == null) continue;
            VsdxPage vsdxPage = pageParser.parsePage(vsdx);
            if ("1".equals(vsdxPage.Background)) {
                if (vsdx.backPages == null) {
                    vsdx.backPages = new ArrayList<VsdxPage>();
                }
                vsdx.backPages.add(vsdxPage);
            } else {
                vsdx.pages.add(vsdxPage);
            }
            if (!silent) {
                this.putStateProgressPosition(curPosition++);
            }
            int countLayers = pageParser.countLayers();
            vsdx.totalLayers += countLayers;
            for (int layerIdx = 0; layerIdx < countLayers; ++layerIdx) {
                if (vsdxPage.layers == null) {
                    vsdxPage.layers = new ArrayList<VsdxLayer>();
                }
                VsdxLayer vsdxLayer = pageParser.parseLayer(layerIdx);
                vsdxPage.layers.add(vsdxLayer);
            }
            if (!silent) {
                this.putStateProgressPosition(curPosition++);
            }
            if ((shapesCount = pageParser.countShapes()) > 0 && vsdxPage.shapes == null) {
                vsdxPage.shapes = new ArrayList<VsdxShape>();
            }
            for (int shapeIdx = 0; shapeIdx < shapesCount; ++shapeIdx) {
                VsdxShapeParser shapeParser = pageParser.getShapeParser(shapeIdx);
                if (shapeParser == null) continue;
                VsdxShape vsdxShape = new VsdxShape(vsdx, null, vsdxPage);
                VsdxMasterParser masterParser = shapeParser.getMasterParser();
                shapeParser.parseShape(vsdxShape, false, masterParser);
                vsdxPage.shapes.add(vsdxShape);
                if (vsdxShape.isMasterBase()) {
                    vsdx.baseShapes.put(vsdxShape.getMasterBaseID(), vsdxShape.getMasterShape());
                }
                ++vsdx.totalShapes;
                if (vsdx.totalShapes % 1000 != 0) continue;
                this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0430\u043d\u0430\u043b\u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b (\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e " + vsdx.totalShapes + " \u0444\u0438\u0433\u0443\u0440)");
            }
            if (!silent) {
                this.putStateProgressPosition(curPosition++);
            }
            for (int connectIdx = 0; connectIdx < pageParser.countConnects(); ++connectIdx) {
                VsdxConnect connect = pageParser.getConnect(connectIdx);
                if (connect == null) continue;
                if (vsdxPage.connects == null) {
                    vsdxPage.connects = new ArrayList<VsdxConnect>();
                }
                vsdxPage.connects.add(connect);
            }
        }
        if (vsdx.backPages != null) {
            vsdx.pages.addAll(vsdx.backPages);
        }
        if ((windowParser = vsdxParser.getWindowsParser()) != null) {
            vsdx.currentPage = windowParser.parseCurrentPageID();
        }
        if ((commentsParser = vsdxParser.getCommentsParser()) != null && (comments = commentsParser.parseComments()) != null && !comments.isEmpty()) {
            for (VsdxComment comment : comments) {
                VsdxPage page;
                if (SchemeUtils.isEmpty(comment.PageID) || (page = vsdx.findPage(comment.PageID)) == null) continue;
                if (SchemeUtils.isEmpty(comment.ShapeID)) {
                    if (page.comments == null) {
                        page.comments = new ArrayList<VsdxComment>();
                    }
                    page.comments.add(comment);
                    continue;
                }
                VsdxShape[] findShapePath = page.findShapePath(comment.ShapeID);
                if (findShapePath == null || findShapePath.length == 0) continue;
                VsdxShape s = findShapePath[findShapePath.length - 1];
                if (s.comments == null) {
                    s.comments = new ArrayList<VsdxComment>();
                }
                s.comments.add(comment);
            }
        }
        if (!silent) {
            this.putStateProgressPosition(maxPosition);
            Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0430\u043d\u0430\u043b\u0438\u0437 " + vsdx.totalShapes + " \u0444\u0438\u0433\u0443\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Visio");
        }
        return vsdx;
    }

    public static String updateName(String name, Set<String> names) {
        assert (name != null);
        assert (names != null);
        Object result = name;
        int index = 0;
        while (names.contains(result)) {
            result = name + " " + ++index;
        }
        return result;
    }

    public byte[] importWmf(byte[] content) throws Exception {
        EmfReader emfReader;
        this.scheme = new Scheme();
        this.engine = new SchemeEngine(this.scheme);
        this.engine.InitTmpProps();
        this.scheme.primInsFlags = 0;
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
        int maxPosition = 1;
        this.putStateProgressMax(maxPosition);
        PhxImage image = null;
        if (EmfReader.isEmf(content)) {
            emfReader = new EmfReader(this.engine);
            image = emfReader.parseEmfImage(content);
        } else if (EmfReader.isWmf(content)) {
            emfReader = new EmfReader(this.engine);
            image = emfReader.parseWmfImage(content, EmfReader.DEFAULT_PIXELS, EmfReader.DEFAULT_PIXELS);
        }
        if (image != null) {
            double layerId = Core.generateId();
            SchemeObject layerObject = new SchemeObject(layerId, 204);
            PhxLayer phxLayer = new PhxLayer();
            phxLayer.ID = layerId;
            phxLayer.Cosmetic = true;
            phxLayer.setCaption(COSMETIC_LAYER_NAME);
            layerObject.setParams(phxLayer.asBinary());
            this.updateModifiedInfo(layerObject);
            this.scheme.placeLast(layerObject);
            image.initClipPoints();
            image.SideX = image.BmpWidth;
            image.SideY = image.BmpHeight;
            image.ID = Core.generateId();
            image.LayerID = layerId;
            SchemeObject obj = new SchemeObject(image.ID, 218);
            obj.setParams(image.asBinary());
            this.updateModifiedInfo(obj);
            this.scheme.placeLast(obj);
        }
        this.putStateProgressPosition(maxPosition);
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        Core.logger.info("\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 Wmf/Emf \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.scheme.saveAll(out, null, true, false);
        return out.toByteArray();
    }

    GraphicBlock correctPrimitiveBlock(GraphicBlock block) {
        if (block == null || block.Objects == null || block.Objects.size() != 1) {
            return block;
        }
        BaseGraphic bg = block.Objects.get(0);
        if (bg == null || bg.shapeType() != 202) {
            return block;
        }
        return (GraphicBlock)bg;
    }

    public byte[] importVssx(byte[] content) throws Exception {
        double layerId;
        Vsdx vsdx;
        if (this.contentType == null) {
            this.contentType = CONTENT_TYPE.VSSX;
        }
        if ((vsdx = this.parseVssx(content)) == null) {
            return null;
        }
        this.scheme = new Scheme();
        this.engine = new SchemeEngine(this.scheme);
        this.engine.InitTmpProps();
        this.layers = new HashMap<Double, PhxLayer>();
        PhxLayer phxLayer = new PhxLayer();
        phxLayer.ID = layerId = 0.0;
        phxLayer.Cosmetic = true;
        this.layers.put(layerId, phxLayer);
        phxLayer.setCaption(COSMETIC_LAYER_NAME);
        PrimLibrary library = new PrimLibrary(0.0);
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u0446\u043e\u0432 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432");
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u0446\u043e\u0432 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432");
        int cntMasters = vsdx.masters == null ? 0 : vsdx.masters.size();
        int maxPosition = 1 + cntMasters;
        int curPosition = 1;
        this.putStateProgressMax(maxPosition);
        this.cntErrors = 100;
        for (int i = 0; i < cntMasters; ++i) {
            int cnt;
            VsdxMaster master = vsdx.masters.get(i);
            if (master == null) continue;
            Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u0446\u0430 " + this.getMasterInfo(master));
            this.putStateProgressPosition(curPosition++);
            this.visioShapesHash = new HashMap<String, DoubleList>();
            this.pageObjects = new DoubleHash();
            this.pageShapes = new HashMap<Double, BaseGraphic>();
            this.parents = new HashMap<Double, Double>();
            this.containerObjects = new HashMap<String, BaseGraphic>();
            this.containerShapes = new HashMap<String, VsdxShape>();
            double pageScale = VsdxUtils.convertDouble(master.PageScale, null);
            double drawingScale = VsdxUtils.convertDouble(master.DrawingScale, null);
            if (pageScale == 0.0) {
                pageScale = 1.0;
            }
            this.currentPageScale = Math.abs(drawingScale) > BaseGraphic.FloatTolerance && Math.abs(pageScale) > BaseGraphic.FloatTolerance ? Math.abs(drawingScale / pageScale) : 1.0;
            GraphicBlock block = new GraphicBlock();
            block.setEngine(this.engine);
            block.ID = Core.generateId();
            this.currentPrimitiveBlock = block;
            VsdxShape textShape = null;
            int n = cnt = master.shapes == null ? 0 : master.shapes.size();
            for (int j = 0; j < cnt; ++j) {
                VsdxShape shape = master.shapes.get(j);
                if (shape == null) continue;
                shape.applyStyles(false);
                if (textShape == null) {
                    textShape = shape;
                }
                try {
                    this.convertVsdxShape(shape, block, true, false, false, 0, new BaseGraphic.RealPoint());
                    continue;
                }
                catch (Exception e) {
                    this.logError(shape, e);
                }
            }
            this.currentPrimitiveBlock = null;
            block = this.correctPrimitiveBlock(block);
            block.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
            this.updateInscribeAttributes(block);
            this.addTextToMaster(textShape, block);
            Primitive primitive = new Primitive();
            primitive.BG = block;
            primitive.PrimParams = block.BlockParams;
            primitive.setID(block.ID);
            primitive.Caption = master.Name != null && !master.Name.isEmpty() ? master.Name : "\u041c\u0430\u0441\u0442\u0435\u0440." + master.ID;
            library.Primitives.put(primitive.key(), primitive);
            if (block.StringProps == null) {
                block.StringProps = new TextProps();
            }
            block.StringProps.Caption = primitive.Caption;
            this.initContainers();
        }
        this.putStateProgressPosition(maxPosition);
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        Core.logger.info("\u0418\u043c\u043f\u043e\u0440\u0442 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043e\u0432 vssx \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(out);
        library.store(writer);
        writer.flush();
        return out.toByteArray();
    }

    public byte[] importVsdx(byte[] content) throws Exception {
        int cntPages;
        this.contentType = CONTENT_TYPE.VSDX;
        Vsdx vsdx = this.parseVsdx(content);
        if (vsdx == null) {
            return null;
        }
        this.scheme = new Scheme();
        this.engine = new SchemeEngine(this.scheme);
        this.engine.InitTmpProps();
        this.scheme.primInsFlags = 0;
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
        Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0445\u0435\u043c\u044b");
        int maxPosition = 1 + vsdx.totalLayers + vsdx.totalShapes;
        if (vsdx.baseShapes != null) {
            maxPosition += vsdx.baseShapes.size();
        }
        int curPosition = 0;
        this.putStateProgressMax(maxPosition);
        this.putStateProgressPosition(curPosition++);
        this.scheme.placeLast(this.scheme.createPropObject(-6));
        this.scheme.placeLast(this.scheme.createPropObject(-30));
        this.scheme.placeLast(this.scheme.createPropObject(-34));
        this.scheme.placeLast(this.scheme.createPropObject(-7));
        this.scheme.placeLast(this.scheme.createPropObject(-26));
        this.scheme.placeLast(this.scheme.createPropObject(-4));
        this.scheme.placeLast(this.scheme.createPropObject(-22));
        this.scheme.placeLast(this.scheme.createPropObject(-5));
        this.scheme.placeLast(this.scheme.createPropObject(-18));
        this.scheme.placeLast(this.scheme.createPropObject(-3));
        this.scheme.placeLast(this.scheme.createPropObject(-15));
        this.scheme.placeLast(this.scheme.createPropObject(-31));
        this.scheme.placeLast(this.scheme.createPropObject(-32));
        this.scheme.placeLast(this.scheme.createPropObject(-13));
        this.scheme.placeLast(this.scheme.createPropObject(-27));
        this.scheme.placeLast(this.scheme.createPropObject(-2));
        this.scheme.placeLast(this.scheme.createPropObject(-11));
        this.scheme.placeLast(this.scheme.createPropObject(-1));
        this.scheme.placeLast(this.scheme.createPropObject(-23));
        this.scheme.placeLast(this.scheme.createPropObject(-9));
        this.scheme.placeLast(this.scheme.createPropObject(-33));
        this.scheme.placeLast(this.scheme.createPropObject(-19));
        this.scheme.placeLast(this.scheme.createPropObject(-28));
        this.scheme.placeLast(this.scheme.createPropObject(-24));
        this.scheme.placeLast(this.scheme.createPropObject(-20));
        this.scheme.placeLast(this.scheme.createPropObject(-16));
        this.scheme.placeLast(this.scheme.createPropObject(-29));
        this.scheme.placeLast(this.scheme.createPropObject(-14));
        this.scheme.placeLast(this.scheme.createPropObject(-25));
        this.scheme.placeLast(this.scheme.createPropObject(-12));
        this.scheme.placeLast(this.scheme.createPropObject(-21));
        this.scheme.placeLast(this.scheme.createPropObject(-10));
        this.scheme.placeLast(this.scheme.createPropObject(-8));
        this.putStateProgressPosition(curPosition++);
        HashSet<String> layerNames = new HashSet<String>();
        this.layers = new HashMap<Double, PhxLayer>();
        this.primsHash = new HashMap<String, Double>();
        int pageIndex = 0;
        int layerOrder = 1;
        double cosmLayerID = 0.0;
        this.cntErrors = 100;
        if (vsdx.baseShapes != null && !vsdx.baseShapes.isEmpty()) {
            this.scheme.internalLib = new PrimLibrary(0.0);
            this.visioShapesHash = new HashMap<String, DoubleList>();
            this.pageObjects = new DoubleHash();
            this.pageShapes = new HashMap<Double, BaseGraphic>();
            this.parents = new HashMap<Double, Double>();
            this.containerObjects = new HashMap<String, BaseGraphic>();
            this.containerShapes = new HashMap<String, VsdxShape>();
            for (VsdxShape shape : vsdx.baseShapes.values()) {
                this.putStateProgressPosition(curPosition++);
                if (shape.master == null) continue;
                double pageScale = VsdxUtils.convertDouble(shape.master.PageScale, null);
                double drawingScale = VsdxUtils.convertDouble(shape.master.DrawingScale, null);
                if (pageScale == 0.0) {
                    pageScale = 1.0;
                }
                this.currentPageScale = Math.abs(drawingScale) > BaseGraphic.FloatTolerance && Math.abs(pageScale) > BaseGraphic.FloatTolerance ? Math.abs(drawingScale / pageScale) : 1.0;
                double primId = Core.generateId();
                GraphicBlock block = new GraphicBlock();
                block.setEngine(this.engine);
                block.ID = Core.generateId();
                this.currentPrimitiveBlock = block;
                shape.applyStyles(false);
                try {
                    this.convertVsdxShape(shape, block, true, false, false, 0, new BaseGraphic.RealPoint());
                }
                catch (Exception e) {
                    this.logError(shape, e);
                }
                this.currentPrimitiveBlock = null;
                block = this.correctPrimitiveBlock(block);
                Primitive prim = new Primitive();
                prim.setID(primId);
                shape.avesID = primId;
                prim.ImportID = shape.getBaseID();
                prim.Imported = true;
                this.scheme.internalLib.Primitives.put(primId, prim);
                this.updateInscribeAttributes(block);
                this.addTextToMaster(shape, block);
                block.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                prim.BG = block;
                prim.Caption = "\u041f\u0440\u0438\u043c\u0438\u0442\u0438\u0432 " + this.scheme.internalLib.Primitives.size();
                prim.PrimParams = block.BlockParams;
            }
            this.initContainers();
        }
        int n = cntPages = vsdx.pages == null ? 0 : vsdx.pages.size();
        for (int i = 0; i < cntPages; ++i) {
            int cnt;
            int j;
            String name;
            PhxLayer phxLayer;
            double layerId;
            int lineJumpCode;
            byte[] bytes;
            SchemePageNotes pageNotes;
            VsdxPage backPage;
            SchemePageLayout layout;
            double pageId;
            double pageRulerOriginY;
            VsdxPage page = vsdx.pages.get(i);
            if (page == null) continue;
            Core.logger.info("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b " + this.getPageInfo(page));
            this.visioShapesHash = new HashMap<String, DoubleList>();
            this.pageObjects = new DoubleHash();
            this.pageShapes = new HashMap<Double, BaseGraphic>();
            this.parents = new HashMap<Double, Double>();
            this.containerObjects = new HashMap<String, BaseGraphic>();
            this.containerShapes = new HashMap<String, VsdxShape>();
            double pageScale = VsdxUtils.convertDouble(page.PageScale, null);
            double drawingScale = VsdxUtils.convertDouble(page.DrawingScale, null);
            double pageRulerOriginX = page.XRulerOrigin == null ? 0.0 : VsdxReader.inchToMM(page.XRulerOrigin, null);
            double d = pageRulerOriginY = page.YRulerOrigin == null ? 0.0 : VsdxReader.inchToMM(page.YRulerOrigin, null);
            if (pageScale == 0.0) {
                pageScale = 1.0;
            }
            this.currentPageScale = Math.abs(drawingScale) > BaseGraphic.FloatTolerance && Math.abs(pageScale) > BaseGraphic.FloatTolerance ? Math.abs(drawingScale / pageScale) : 1.0;
            boolean isBackPage = "1".equals(page.Background);
            if (pageIndex == 0) {
                pageId = 1.0;
                if (isBackPage) {
                    page.avesID = pageId;
                }
            } else {
                pageId = page.avesID;
                if (pageId == 0.0) {
                    pageId = Core.generateId();
                }
            }
            SchemeObject pageObject = new SchemeObject(pageId, 116);
            pageObject.setOrder(pageIndex);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(os);
            if (page.Name != null && !page.Name.isEmpty()) {
                writer.putString(1, page.Name);
            }
            if ((layout = this.convertPageLayout(page)) != null) {
                ByteArrayOutputStream os2 = new ByteArrayOutputStream();
                TaggedWriter writer2 = new TaggedWriter(os2);
                layout.store(writer2);
                writer2.flush();
                if (os2.size() > 0) {
                    writer.putRaw(2, os2);
                }
            }
            if (isBackPage) {
                writer.putBool(5, true);
            }
            if ((backPage = vsdx.pageById(page.BackPage)) != null) {
                if (backPage.avesID == 0.0) {
                    backPage.avesID = Core.generateId();
                }
                writer.putDouble(6, backPage.avesID);
            }
            if ((pageNotes = this.convertVsdxComments(page.comments)) != null && (bytes = pageNotes.asBinary()) != null && bytes.length > 0) {
                writer.putRaw(11, bytes);
            }
            if ((lineJumpCode = page.getLineJumpCode()) > 0) {
                double lineJumpSize;
                switch (lineJumpCode) {
                    case 1: {
                        lineJumpSize = page.getLineJumpSizeX();
                        break;
                    }
                    case 2: {
                        lineJumpSize = page.getLineJumpSizeY();
                        break;
                    }
                    default: {
                        lineJumpSize = Math.min(page.getLineJumpSizeX(), page.getLineJumpSizeY());
                    }
                }
                int lineJumpType = page.getLineJumpType();
                ByteArrayOutputStream os3 = new ByteArrayOutputStream();
                TaggedWriter writer3 = new TaggedWriter(os3);
                if (lineJumpType != VsdxPage.LINE_JUMP_DEF_TYPE) {
                    writer3.putInt32(2, lineJumpType);
                }
                if (!SchemeUtils.isEqual(lineJumpSize, 2.0, 1.0E-6)) {
                    writer3.putDouble(3, lineJumpSize);
                }
                writer3.flush();
                writer.putEmpty(9);
                writer.putRaw(202, os3.toByteArray());
            }
            writer.flush();
            if (os.size() > 0) {
                pageObject.setParams(os.toByteArray());
            }
            this.scheme.placeLast(pageObject);
            this.layerIDs = new HashMap<String, Double>();
            this.layerColors = new HashMap<String, String>();
            this.shapeConnects = new HashMap<String, List<ConnectToInfo>>();
            if (i == 0) {
                cosmLayerID = layerId = Core.generateId();
                SchemeObject layerObject = new SchemeObject(layerId, 204);
                layerObject.setOrder(layerOrder++);
                phxLayer = new PhxLayer();
                phxLayer.ID = layerId;
                phxLayer.Cosmetic = true;
                name = VsdxReader.updateName(COSMETIC_LAYER_NAME, layerNames);
                layerNames.add(name);
                this.layers.put(layerId, phxLayer);
                phxLayer.setCaption(name);
                if (pageId > 1.0) {
                    phxLayer.PageId = pageId;
                }
                layerObject.setParams(phxLayer.asBinary());
                this.updateModifiedInfo(layerObject);
                this.scheme.placeLast(layerObject);
            }
            layerId = Core.generateId();
            if (!this.isEmbeddingsVsdx) {
                this.currentPageLayerID = layerId;
            }
            SchemeObject pageLayerObject = new SchemeObject(layerId, 204);
            phxLayer = new PhxLayer();
            phxLayer.ID = layerId;
            name = VsdxReader.updateName(page.Name, layerNames);
            layerNames.add(name);
            this.layers.put(layerId, phxLayer);
            phxLayer.setCaption(name);
            if (vsdx.styles != null) {
                VsdxStyle textStyle;
                VsdxStyle fillStyle;
                VsdxStyle lineStyle;
                VsdxStyle vsdxStyle = lineStyle = page.LineStyle == null || page.LineStyle.isEmpty() ? null : vsdx.styles.get(page.LineStyle);
                if (lineStyle != null && lineStyle.cellValues != null) {
                    boolean transp = "1".equals(lineStyle.cellValues.get("LineColorTrans"));
                    if (lineStyle.cellValues.containsKey("LinePattern")) {
                        phxLayer.PenPattern = VsdxUtils.convertLineStyle(lineStyle.cellValues.get("LinePattern"), transp);
                    }
                    if (lineStyle.cellValues.containsKey("LineColor")) {
                        phxLayer.pColor = vsdx.parseColor(lineStyle.cellValues.get("LineColor"));
                    }
                    if (lineStyle.cellValues.containsKey("LineWeight")) {
                        phxLayer.lWidth = this.roundWithTol(Math.abs(this.currentPageScale * VsdxReader.inchToMM(lineStyle.cellValues.get("LineWeight"), null)), 0.1, true);
                    }
                }
                VsdxStyle vsdxStyle2 = fillStyle = page.FillStyle == null || page.FillStyle.isEmpty() ? null : vsdx.styles.get(page.FillStyle);
                if (fillStyle != null && fillStyle.cellValues != null) {
                    boolean transp = "1".equals(fillStyle.cellValues.get("FillForegndTrans"));
                    if (fillStyle.cellValues.containsKey("FillPattern")) {
                        phxLayer.BrushPattern = VsdxUtils.convertFillStyle(fillStyle.cellValues.get("FillPattern"), transp);
                    }
                    if (fillStyle.cellValues.containsKey("FillForegnd")) {
                        phxLayer.bColor = vsdx.parseColor(fillStyle.cellValues.get("FillForegnd"));
                    }
                    if (fillStyle.cellValues.containsKey("FillBkgnd")) {
                        phxLayer.BkColor = vsdx.parseColor(fillStyle.cellValues.get("FillBkgnd"));
                    }
                }
                VsdxStyle vsdxStyle3 = textStyle = page.TextStyle == null || page.TextStyle.isEmpty() ? null : vsdx.styles.get(page.TextStyle);
                if (textStyle != null && textStyle.characterValues != null && textStyle.characterValues.containsKey("Color")) {
                    phxLayer.FontColor = vsdx.parseColor(textStyle.characterValues.get("Color"));
                }
            }
            if (pageId > 1.0) {
                phxLayer.PageId = pageId;
            }
            int countLayers = page.layers == null ? 0 : page.layers.size();
            for (j = 0; j < countLayers; ++j) {
                this.putStateProgressPosition(curPosition++);
                VsdxLayer layer = page.layers.get(j);
                if (layer.Name == null || layer.Name.isEmpty()) {
                    layer.Name = "Layer Row=" + layer.ID;
                }
                if (i == 0 && SchemeUtils.isEqual(layer.Name, COSMETIC_LAYER_NAME)) {
                    this.layerIDs.put(layer.ID, cosmLayerID);
                    continue;
                }
                boolean isPageLayer = SchemeUtils.isEqual(layer.Name, page.Name);
                if (isPageLayer) {
                    layerId = this.currentPageLayerID;
                    phxLayer = this.layers.get(layerId);
                } else {
                    layerId = Core.generateId();
                    phxLayer = new PhxLayer();
                }
                this.layerIDs.put(layer.ID, layerId);
                this.layerColors.put(layer.ID, layer.Color);
                phxLayer.bColor = phxLayer.pColor = vsdx.parseColor(layer.Color);
                phxLayer.FontColor = phxLayer.pColor;
                phxLayer.BkColor = Color.WHITE;
                phxLayer.Visible = layer.Visible;
                boolean bl = phxLayer.Selectable = !layer.Lock;
                if (isPageLayer) continue;
                double transparency = VsdxUtils.convertDouble(layer.ColorTrans, null);
                if (transparency > 0.0) {
                    phxLayer.TransparentBorder = phxLayer.Transparent = (int)(255.0 * transparency);
                }
                phxLayer.ID = layerId;
                if (pageId > 1.0) {
                    phxLayer.PageId = pageId;
                }
                name = VsdxReader.updateName(layer.Name, layerNames);
                layerNames.add(name);
                this.layers.put(layerId, phxLayer);
                phxLayer.setCaption(name);
                SchemeObject layerObject = new SchemeObject(layerId, 204);
                layerObject.setOrder(layerOrder++);
                layerObject.setParams(phxLayer.asBinary());
                this.updateModifiedInfo(layerObject);
                this.scheme.placeLast(layerObject);
            }
            phxLayer = this.layers.get(this.currentPageLayerID);
            assert (phxLayer != null);
            pageLayerObject.setParams(phxLayer.asBinary());
            pageLayerObject.setOrder(layerOrder++);
            this.updateModifiedInfo(pageLayerObject);
            this.scheme.placeLast(pageLayerObject);
            int n2 = cnt = page.shapes == null ? 0 : page.shapes.size();
            for (j = 0; j < cnt; ++j) {
                this.putStateProgressPosition(curPosition++);
                VsdxShape shape = page.shapes.get(j);
                if (shape == null) continue;
                VsdxTheme.getTheme(page, shape).ifPresentOrElse(shapeTheme -> {
                    shape.applyStyles(true);
                    int varColor = SchemeUtils.convertInt(page.VariationColorIndex);
                    shapeTheme.applyStyleToShape(shape, varColor);
                }, () -> shape.applyStyles(false));
                try {
                    this.convertVsdxShape(shape, null, true, false, false, 0, new BaseGraphic.RealPoint());
                    continue;
                }
                catch (Exception e) {
                    this.logError(shape, e);
                }
            }
            this.initContainers();
            this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0444\u0438\u0433\u0443\u0440");
            this.gluePageShapes(page);
            this.putStateProgressPosition(maxPosition);
            this.pageObjects.forEach(obj -> {
                BaseGraphic bg = this.pageShapes.get(obj.getID());
                assert (bg != null);
                try {
                    if (pageRulerOriginX != 0.0) {
                        bg.OrgX -= pageRulerOriginX;
                    }
                    if (pageRulerOriginY != 0.0) {
                        bg.OrgY += pageRulerOriginY;
                    }
                    obj.setParams(bg.asBinary());
                    this.updateModifiedInfo((SchemeObject)obj);
                    this.scheme.placeLast((SchemeObject)obj);
                }
                catch (IOException ex) {
                    throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 VSDX", ex);
                }
            });
            layerNames.clear();
            ++pageIndex;
        }
        if (this.scheme.internalLib != null && this.scheme.internalLib.Primitives != null) {
            for (Primitive prim : this.scheme.internalLib.Primitives.values()) {
                SchemeObject obj2 = new SchemeObject(prim.key(), 117);
                obj2.setOrder(this.orderIndex++);
                obj2.setParams(prim.asBinary());
                this.updateModifiedInfo(obj2);
                this.scheme.placeLast(obj2);
            }
        }
        if (this.scheme.diagTables != null) {
            for (DiagramTable table : this.scheme.diagTables) {
                SchemeObject obj3 = new SchemeObject(table.ID, 118);
                obj3.setOrder(this.orderIndex++);
                obj3.setParams(DiagramTable.diagramTableToBlob(table));
                this.updateModifiedInfo(obj3);
                this.scheme.placeLast(obj3);
            }
        }
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        Core.logger.info("\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 vsdx \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.scheme.saveAll(out, null, true, false);
        out.flush();
        byte[] bytes = out.toByteArray();
        Core.logger.info("\u0421\u043e\u0437\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 aves (" + (bytes == null ? 0 : bytes.length) + "b)");
        return bytes;
    }

    private void initContainers() {
        if (this.containerShapes == null || this.containerObjects == null) {
            return;
        }
        this.containerShapes.forEach((shapeId, shape) -> {
            BaseGraphic shapeObj = this.containerObjects.get(shapeId);
            Container container = null;
            if (shapeObj instanceof Container) {
                container = (Container)shapeObj;
                if (container.Objects == null) {
                    container.Objects = new ArrayList();
                }
                if (container.Objects.isEmpty()) {
                    Rectangle rect = new Rectangle();
                    rect.PenPattern = 5;
                    rect.BrushPattern = 1;
                    BaseGraphic.RealPoint size = shape.getShapeSizeMM();
                    rect.SideX = size.X;
                    rect.SideY = size.Y;
                    rect.setEngine(this.engine);
                    rect.ID = Core.generateId();
                    rect.LayerID = container.LayerID;
                    container.Objects.add(rect);
                }
            }
            if (container != null && shape.shapes != null) {
                int cntk = shape.shapes.size();
                for (int k = 0; k < cntk; ++k) {
                    VsdxShape child = shape.shapes.get(k);
                    if (child == null || child.getContainerType() != VsdxShape.ContainerType.HEADING) continue;
                    Container.HeadingContainer h = new Container.HeadingContainer();
                    h.id = child.avesID;
                    h.edge = "Right".equals(child.msvSDContainerHeadingEdge) ? (byte)1 : ("Top".equals(child.msvSDContainerHeadingEdge) ? (byte)2 : ("Bottom".equals(child.msvSDContainerHeadingEdge) ? (byte)3 : (byte)0));
                    if (container.Headings == null) {
                        container.Headings = new ArrayList<Container.HeadingContainer>();
                    }
                    container.Headings.add(h);
                }
            }
            if (shape.Relationships != null && !shape.Relationships.isEmpty()) {
                block21: for (String[] relations : shape.Relationships) {
                    String type;
                    if (relations == null || relations.length < 2) continue;
                    switch (type = relations[0]) {
                        case "1": {
                            break;
                        }
                        case "2": {
                            if (container == null) break;
                            int cnt = relations.length;
                            for (int r = 1; r < cnt; ++r) {
                                String bgID = relations[r];
                                BaseGraphic bg = this.containerObjects.get(bgID);
                                if (bg == null || bg.ID == 0.0) continue;
                                container.OrderRelationshipIds.add(bg.ID);
                            }
                            continue block21;
                        }
                        case "3": {
                            break;
                        }
                        case "4": 
                        case "5": 
                        case "6": {
                            BaseGraphic bg;
                            String containerId = relations.length == 2 ? relations[1] : this.findContainerId(relations);
                            if (containerId == null) continue block21;
                            BaseGraphic containerObj = this.containerObjects.get(containerId);
                            if (!(containerObj instanceof Container)) {
                                containerObj = this.containerObjectsByName.get(containerId);
                            }
                            if (!(containerObj instanceof Container) || (bg = this.containerObjects.get(shapeId)) == null) continue block21;
                            bg.ContainerID = containerObj.ID;
                            break;
                        }
                        case "7": 
                        case "8": 
                        case "9": {
                            BaseGraphic containerObj;
                            BaseGraphic bg;
                            String containerId = relations.length == 2 ? relations[1] : this.findContainerId(relations);
                            if (containerId == null || !((containerObj = this.containerObjects.get(containerId)) instanceof Container) || (bg = this.containerObjects.get(shapeId)) == null || bg.ContainerID != 0.0) continue block21;
                            bg.ContainerID = containerObj.ID;
                            break;
                        }
                    }
                }
            }
        });
    }

    private String findContainerId(String[] relations) {
        String result = null;
        if (relations == null || relations.length < 2) {
            return result;
        }
        assert (this.containerShapes != null && !this.containerShapes.isEmpty());
        HashSet<String> allIDs = new HashSet<String>();
        for (int i = 1; i < relations.length; ++i) {
            if (relations[i] == null || relations[i].isEmpty()) continue;
            allIDs.add(relations[i]);
        }
        HashSet<String> disabledIDs = new HashSet<String>();
        for (String id : allIDs) {
            VsdxShape shape = this.containerShapes.get(id);
            if (shape == null || shape.Relationships == null) continue;
            for (String[] rels : shape.Relationships) {
                String type;
                if (relations.length < 2) continue;
                switch (type = rels[0]) {
                    case "4": 
                    case "5": 
                    case "6": {
                        for (int r = 1; r < rels.length; ++r) {
                            String s = rels[r];
                            if (!allIDs.contains(s)) continue;
                            disabledIDs.add(s);
                        }
                        break;
                    }
                }
            }
        }
        for (int i = 1; i < relations.length; ++i) {
            String s = relations[i];
            if (s == null || s.isEmpty() || disabledIDs.contains(s)) continue;
            result = s;
            break;
        }
        return result;
    }

    public static double convertAngle(String rad, VsdxShape shape) {
        double result = -VsdxUtils.convertDouble(rad, shape) * 180.0 / Math.PI;
        if ((result = SchemeEngine.NormAngle(result)) >= 360.0) {
            result -= 360.0;
        }
        return result;
    }

    private static void transformBG(VsdxShape vsdxShape, BaseGraphic bg, BaseGraphic.RealPoint size, BaseGraphic.RealPoint parentSize, BaseGraphic.RealPoint centerShift) {
        VsdxUtils.VsdxTransformProps props = VsdxUtils.getTransformPropsMM(vsdxShape, size, parentSize, bg instanceof Paragraph);
        bg.OrgX = props.OrgX;
        bg.OrgY = props.OrgY;
        if (bg.TransProps == null) {
            bg.TransProps = new TransformProps();
        }
        bg.TransProps.CenterX = props.CenterX + centerShift.X;
        bg.TransProps.CenterY = props.CenterY + centerShift.Y;
        if (props.ScaleX != 1.0) {
            if (bg instanceof Paragraph) {
                bg.TransProps.CenterX -= 2.0 * props.CenterX;
            } else {
                bg.TransProps.ScaleX = props.ScaleX;
            }
        }
        if (props.ScaleY != 1.0) {
            if (bg instanceof Paragraph) {
                bg.TransProps.CenterY -= 2.0 * props.CenterY;
            } else {
                bg.TransProps.ScaleY = props.ScaleY;
            }
        }
        bg.TransProps.Angle = props.Angle;
    }

    private void updateInscribeAttributes(GraphicBlock block) {
    }

    private void convertGluePoints(VsdxShape vsdxShape, BaseGraphic bg, boolean root, boolean polyline) {
        Consumer<AddGPParams> AddGP = prm -> {
            assert (prm != null);
            double lPtX = prm.ptX;
            double lPtY = prm.ptY;
            if (prm.vertIdx >= 0) {
                lPtX = bg.getVertexX(prm.vertIdx);
                lPtY = bg.getVertexY(prm.vertIdx);
            }
            if (prm.polyline && bg instanceof Polyline) {
                ((Polyline)bg).addGluePointToVertex(lPtX, lPtY, prm.vertIdx);
            } else {
                bg.addGluePoint(lPtX, lPtY);
            }
            int gPIdx = bg.GluePoints.size() - 1;
            if (prm.vertIdx >= 0) {
                bg.GluePoints.get((int)gPIdx).vertIdx = prm.vertIdx;
            }
            if (prm.contactNumber >= 0) {
                bg.GluePoints.get((int)gPIdx).contactNumber = prm.contactNumber;
            }
        };
        polyline = bg.shapeType() == 210 || bg.shapeType() == 212;
        boolean checkAngle = bg.TransProps == null || SchemeUtils.isEqual(bg.TransProps.Angle, 0.0);
        List<VsdxShape.VsdxConnectionPoint> connectionPoints = vsdxShape.getConnectionPoints(false, checkAngle, bg);
        if (root && polyline && (bg.getVerticesCount() <= 4 || connectionPoints == null || connectionPoints.size() < 2)) {
            AddGP.accept(new AddGPParams(true, 0, 1, 0.0, 0.0));
            AddGP.accept(new AddGPParams(true, bg.getVerticesCount() - 1, 2, 0.0, 0.0));
        } else if (connectionPoints != null) {
            for (VsdxShape.VsdxConnectionPoint cp : connectionPoints) {
                AddGP.accept(new AddGPParams(false, -1, cp.ContactNumber, cp.X, cp.Y));
            }
        }
        if (bg instanceof GraphicBlock) {
            SchemeUtils.liftGluePoints((GraphicBlock)bg);
        }
    }

    private void convertArrows(VsdxShape shape, Polyline poly) {
        poly.StartVisArrowType = VsdxUtils.convertArrowType(shape.BeginArrow);
        poly.EndVisArrowType = VsdxUtils.convertArrowType(shape.EndArrow);
        double lineWidth = poly.lWidth;
        if (lineWidth == -1.0) {
            PhxLayer layer;
            PhxLayer phxLayer = layer = this.layers == null ? null : this.layers.get(this.currentLayerID);
            if (layer != null) {
                lineWidth = layer.lWidth;
            }
        }
        double currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
        poly.StartVisArrowSize = VsdxUtils.convertArrowSize(shape.BeginArrowSize, poly.StartVisArrowType, lineWidth, currentScale);
        poly.EndVisArrowSize = VsdxUtils.convertArrowSize(shape.EndArrowSize, poly.EndVisArrowType, lineWidth, currentScale);
    }

    private void applyGradientProperties(VsdxShape vsdxShape, BaseShape shape) {
        Color color = shape.bColor = !this.currentLayerColor ? this.currentShapeStyle.Color : null;
        if (vsdxShape.fillGradient == null) {
            return;
        }
        ArrayList<String[]> gradientPoints = new ArrayList<String[]>();
        for (VsdxGradientStops.VsdxGradientStopsRow row : vsdxShape.fillGradient.rows) {
            if (row == null || "1".equals(row.Del)) continue;
            String color2 = row.GradientStopColor;
            if (color2 == null) {
                color2 = "1";
            }
            String pos = row.GradientStopPosition;
            gradientPoints.add(new String[]{color2, pos});
        }
        if (gradientPoints.isEmpty()) {
            return;
        }
        String firstPointColor = ((String[])gradientPoints.get(0))[0];
        String lastPointColor = ((String[])gradientPoints.get(gradientPoints.size() - 1))[0];
        int gradientDirection = SchemeUtils.convertInt(vsdxShape.FillGradientDir);
        double angle = VsdxUtils.convertDouble(vsdxShape.FillGradientAngle, vsdxShape);
        if (gradientPoints.size() > 2 && gradientDirection == 0 && Objects.equals(firstPointColor, lastPointColor)) {
            shape.BkColor = vsdxShape.parseColor(firstPointColor);
            shape.bColor = vsdxShape.parseColor(this.getMiddlePointColor(gradientPoints));
            shape.BrushPattern = this.getGradientPattern(gradientDirection, true, angle).getValue();
        } else {
            shape.BkColor = vsdxShape.parseColor(firstPointColor);
            shape.bColor = vsdxShape.parseColor(lastPointColor);
            shape.BrushPattern = this.getGradientPattern(gradientDirection, false, angle).getValue();
        }
    }

    private String getMiddlePointColor(List<String[]> gradientPoints) {
        double positionDelta = 1.0;
        String color = "";
        for (int i = 1; i < gradientPoints.size() - 1; ++i) {
            double position = VsdxUtils.convertDouble(gradientPoints.get(i)[1], null);
            if (!(Math.abs(position - 0.5) < positionDelta)) continue;
            positionDelta = Math.abs(position - 0.5);
            color = gradientPoints.get(i)[0];
        }
        return color;
    }

    private GradientPattern getGradientPattern(int dir, boolean hasMiddle, double radians) {
        switch (dir) {
            case 0: {
                return this.getLinearGradientPattern(hasMiddle, radians);
            }
            case 1: 
            case 8: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder3 : GradientPattern.pgtRadial4;
            }
            case 2: 
            case 9: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder1 : GradientPattern.pgtRadial1;
            }
            case 3: 
            case 10: 
            case 13: {
                return GradientPattern.pgtDiamond2;
            }
            case 6: 
            case 11: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder1 : GradientPattern.pgtRadial2;
            }
            case 7: 
            case 12: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder3 : GradientPattern.pgtRadial3;
            }
        }
        return GradientPattern.pgtHoriz1;
    }

    private GradientPattern getLinearGradientPattern(boolean hasMiddle, double radians) {
        double degree = Math.toDegrees(radians) % 360.0;
        double sectionSize = 45.0;
        int degSection = (int)(degree / sectionSize);
        switch (degSection) {
            case 0: {
                return hasMiddle ? GradientPattern.pgtHorizCylinder1 : GradientPattern.pgtHoriz2;
            }
            case 1: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder3 : GradientPattern.pgtRadial3;
            }
            case 2: {
                return hasMiddle ? GradientPattern.pgtVertCylinder1 : GradientPattern.pgtVert2;
            }
            case 3: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder1 : GradientPattern.pgtRadial2;
            }
            case 4: {
                return hasMiddle ? GradientPattern.pgtHorizCylinder1 : GradientPattern.pgtHoriz1;
            }
            case 5: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder3 : GradientPattern.pgtRadial4;
            }
            case 6: {
                return hasMiddle ? GradientPattern.pgtVertCylinder1 : GradientPattern.pgtVert1;
            }
            case 7: {
                return hasMiddle ? GradientPattern.pgtDiagCylinder1 : GradientPattern.pgtRadial1;
            }
        }
        return GradientPattern.pgtHorizCylinder1;
    }

    private void applyShapeStyle(BaseGraphic bg, boolean polyline, boolean getStyle, boolean noFill, boolean noLine, VsdxShape vsdxShape) {
        double borderTransparency;
        if (!(bg instanceof BaseShape)) {
            return;
        }
        BaseShape shape = (BaseShape)bg;
        if (getStyle) {
            this.currentShapeStyle.LinePattern = vsdxShape.LinePattern;
            this.currentShapeStyle.lWidth = vsdxShape.LineWeight;
            this.currentShapeStyle.LineTransp = vsdxShape.LineColorTrans;
            this.currentShapeStyle.FillPattern = vsdxShape.FillPattern;
            this.currentShapeStyle.Transp = vsdxShape.FillForegndTrans;
            if (!this.currentLayerColor) {
                this.currentShapeStyle.pColor = vsdxShape.getLineColor();
            }
            this.currentShapeStyle.Color = vsdxShape.getFillForegnd();
            this.currentShapeStyle.BkColor = vsdxShape.getFillBkgnd();
        }
        boolean lineTransparency = "1".equals(this.currentShapeStyle.LineTransp);
        shape.PenPattern = VsdxUtils.convertLineStyle(this.currentShapeStyle.LinePattern, noLine || lineTransparency);
        shape.LineCap = VsdxUtils.convertLineCap(vsdxShape.LineCap);
        Color currLayerColor = null;
        int currLayerColorTrans = 0;
        if (this.layers != null && this.layers.containsKey(this.currentLayerID)) {
            PhxLayer curLayer = this.layers.get(this.currentLayerID);
            currLayerColor = curLayer.bColor;
            currLayerColorTrans = curLayer.Transparent;
        }
        if (!this.currentLayerColor) {
            shape.pColor = this.currentShapeStyle.pColor;
        } else {
            shape.pColor = currLayerColor;
            shape.TransparentBorder = shape.Transparent = currLayerColorTrans;
        }
        double currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
        shape.lWidth = this.roundWithTol(Math.abs(currentScale * VsdxReader.inchToMM(this.currentShapeStyle.lWidth, vsdxShape)), 0.1, true);
        double transparency = VsdxUtils.convertDouble(this.currentShapeStyle.Transp, vsdxShape);
        if (transparency > 0.0) {
            ((BaseShape)bg).Transparent = (int)(255.0 * transparency);
        }
        if ((borderTransparency = VsdxUtils.convertDouble(this.currentShapeStyle.LineTransp, vsdxShape)) > 0.0) {
            ((BaseShape)bg).TransparentBorder = (int)(255.0 * borderTransparency);
        }
        bg.AngleRoundSize = VsdxReader.inchToMM(vsdxShape.Rounding, vsdxShape);
        if (!polyline) {
            if (vsdxShape.isFillGradientEnabled()) {
                if (this.currentLayerColor) {
                    this.currentShapeStyle.FillPattern = "1";
                } else {
                    this.applyGradientProperties(vsdxShape, shape);
                    return;
                }
            }
            boolean transp = "1".equals(this.currentShapeStyle.Transp);
            shape.BrushPattern = VsdxUtils.convertFillStyle(this.currentShapeStyle.FillPattern, noFill || transp);
            if (shape.BrushPattern >= 10000) {
                shape.bColor = !this.currentLayerColor ? this.currentShapeStyle.Color : currLayerColor;
                shape.BkColor = !this.currentLayerColor ? this.currentShapeStyle.BkColor : currLayerColor;
            } else if (shape.BrushPattern >= 2) {
                Color color = shape.bColor = !this.currentLayerColor ? this.currentShapeStyle.Color : currLayerColor;
                shape.BkColor = !this.currentLayerColor ? this.currentShapeStyle.BkColor : (Color.WHITE.equals(currLayerColor) ? Color.BLACK : Color.WHITE);
            } else {
                shape.bColor = !this.currentLayerColor ? this.currentShapeStyle.Color : (Color.WHITE.equals(currLayerColor) ? Color.BLACK : Color.WHITE);
                Color color = shape.BkColor = !this.currentLayerColor ? this.currentShapeStyle.BkColor : currLayerColor;
            }
            if (bg instanceof Polyline) {
                this.convertArrows(vsdxShape, (Polyline)bg);
            }
        } else {
            assert (bg instanceof Polyline);
            assert (!(bg instanceof Polygon));
            this.convertArrows(vsdxShape, (Polyline)bg);
        }
    }

    private void findShapeConnect(VsdxShape shape) {
        ConnectToInfo info;
        boolean exists;
        Function<String, ConnectToInfo> FindConnect = str -> {
            ConnectToInfo result = null;
            if (!SchemeUtils.isEmpty(str)) {
                String findStr = "!Connections";
                int idx = str.indexOf(findStr);
                for (int i = idx - 1; i > 0; --i) {
                    if (str.charAt(i) != '.') continue;
                    result = new ConnectToInfo();
                    result.shapeTo = str.substring(i + 1, idx);
                    break;
                }
                if (result != null && result.shapeTo != null && !result.shapeTo.isEmpty()) {
                    int len;
                    if ((idx += findStr.length()) + 3 < (len = str.length()) && str.charAt(idx) == '.' && str.charAt(idx + 1) == 'X') {
                        int i;
                        for (i = idx + 2; i < len && str.charAt(i) >= '0' && str.charAt(i) <= '9'; ++i) {
                        }
                        String pointStr = str.substring(idx + 2, i);
                        try {
                            int point = Integer.parseInt(pointStr);
                            if (point > 0) {
                                result.gluePointIdx = point - 1;
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        int idx2 = str.indexOf(".X", idx);
                        if (idx2 < 0) {
                            idx2 = str.indexOf(".Y", idx);
                        }
                        if (idx + 1 < idx2) {
                            result.gluePointName = str.substring(idx + 1, idx2);
                        }
                    }
                }
            }
            return result;
        };
        assert (shape != null);
        ConnectToInfo shapeToInfo = FindConnect.apply(shape.FPinX);
        if (shapeToInfo == null || shapeToInfo.shapeTo == null || shapeToInfo.shapeTo.isEmpty()) {
            shapeToInfo = FindConnect.apply(shape.FPinY);
        }
        if (shapeToInfo == null || shapeToInfo.shapeTo == null || shapeToInfo.shapeTo.isEmpty()) {
            return;
        }
        List<ConnectToInfo> shapesTo = this.shapeConnects.get(shape.ID);
        boolean bl = exists = shapesTo != null;
        if (!exists) {
            shapesTo = new ArrayList<ConnectToInfo>();
        }
        if ((info = ConnectToInfo.findInList(shapesTo, shapeToInfo.shapeTo)) == null && shapesTo != null) {
            shapesTo.add(shapeToInfo);
            if (!exists) {
                this.shapeConnects.put(shape.ID, shapesTo);
            }
        }
    }

    private SchemePageNotes convertVsdxComments(List<VsdxComment> vsdxComents) {
        if (vsdxComents == null || vsdxComents.isEmpty()) {
            return null;
        }
        ArrayList<SchemePageNotes.SchemeNote> notes = new ArrayList<SchemePageNotes.SchemeNote>();
        for (VsdxComment vsdxComment : vsdxComents) {
            if (SchemeUtils.isEmpty(vsdxComment.Text)) continue;
            SchemePageNotes.SchemeNote note = new SchemePageNotes.SchemeNote();
            note.userName = vsdxComment.Autor;
            note.dateTime = vsdxComment.EditDate;
            note.text = vsdxComment.Text;
            notes.add(note);
        }
        if (notes.isEmpty()) {
            return null;
        }
        SchemePageNotes result = new SchemePageNotes();
        result.setNotes(notes);
        return result;
    }

    private void convertVsdxShape(VsdxShape shape, GraphicBlock parent, boolean root, boolean inMaster, boolean local, int localCount, BaseGraphic.RealPoint parentSize) throws IOException {
        boolean hasText;
        VsdxShape.ContainerType containerType;
        boolean isContainer;
        boolean hasRelationships;
        boolean isLibMaster;
        ConvertShapeLocal vars = new ConvertShapeLocal();
        vars.AddCount = 0;
        vars.AddIdx = -1;
        vars.IsPolylines = false;
        vars.GPDone = false;
        vars.ShapeId = "";
        String shapeType = shape.Type;
        boolean oneD = shape.isOneD();
        List<VsdxShape> shapes = shape.getShapes();
        int count = shapes == null ? 0 : shapes.size();
        boolean isMaster = isLibMaster = "TypePage".equals(shapeType);
        boolean isOnlyText = shape.onlyText();
        if (!isLibMaster && !inMaster) {
            isMaster = shape.hasMaster() && !isOnlyText;
        }
        BiConsumer<String, Double> AddVisioShapesHash = (visioShapeId, shapeId) -> {
            if (!local) {
                DoubleList entry = this.visioShapesHash.get(visioShapeId);
                if (entry == null) {
                    entry = new DoubleList(2);
                    this.visioShapesHash.put((String)visioShapeId, entry);
                }
                entry.add((double)shapeId);
            }
        };
        if ("1".equals(shape.Del)) {
            return;
        }
        this.findShapeConnect(shape);
        boolean bl = hasRelationships = shape.Relationships != null && !shape.Relationships.isEmpty();
        if (!local) {
            vars.ShapeId = shape.ID;
        }
        boolean bl2 = isContainer = (containerType = shape.getContainerType()) != null && containerType != VsdxShape.ContainerType.HEADING;
        if ((containerType != null || hasRelationships) && !shape.isMaster) {
            this.containerShapes.put(shape.ID, shape);
        }
        Predicate<String> EmptyProperty = s -> s == null || s.isEmpty() || "0".equals(s);
        Consumer<BaseGraphic> ApplyContainerProperties = bg -> {
            if (bg == null) {
                return;
            }
            if (!EmptyProperty.test(shape.msvShapeCategories)) {
                bg.Categories = shape.msvShapeCategories;
            }
            if (!(bg instanceof Container)) {
                return;
            }
            Container container = (Container)bg;
            if (!EmptyProperty.test(shape.msvSDContainerLocked)) {
                container.Locked = true;
            }
            if (!EmptyProperty.test(shape.msvSDContainerMargin)) {
                container.Margin = VsdxReader.inchToMM(shape.msvSDContainerMargin, shape);
            }
            if (shape.msvSDContainerResize != null && !shape.msvSDContainerResize.isEmpty()) {
                container.AutomaticResize = (byte)VsdxUtils.convertDouble(shape.msvSDContainerResize, shape);
            }
            if (!EmptyProperty.test(shape.msvSDContainerRequiredCategories)) {
                container.RequiredCategories = shape.msvSDContainerRequiredCategories;
            }
            if (!EmptyProperty.test(shape.msvSDContainerExcludedCategories)) {
                container.ExcludedCategories = shape.msvSDContainerExcludedCategories;
            }
            if (containerType == VsdxShape.ContainerType.LIST) {
                container.AsList = true;
                if (!EmptyProperty.test(shape.msvSDListRequiredCategories)) {
                    container.ListRequiredCategories = shape.msvSDListRequiredCategories;
                }
                if (!EmptyProperty.test(shape.msvSDListExcludedCategories)) {
                    container.ListExcludedCategories = shape.msvSDListExcludedCategories;
                }
                if (shape.msvSDListAlignment != null && !shape.msvSDListAlignment.isEmpty()) {
                    container.ListAlignment = (byte)VsdxUtils.convertDouble(shape.msvSDListAlignment, shape);
                }
                if (shape.msvSDListDirection != null && !shape.msvSDListDirection.isEmpty()) {
                    container.ListDirection = (byte)VsdxUtils.convertDouble(shape.msvSDListDirection, shape);
                }
            }
        };
        Consumer<BaseGraphic> ApplyImportPrimitive = bg -> {
            String baseID;
            if (!(bg instanceof PhxGraphicInsert)) {
                return;
            }
            VsdxShape masterShape = shape.getMasterShape();
            String string = baseID = masterShape == null ? null : masterShape.getMasterBaseID();
            if (!SchemeUtils.isEmpty(baseID)) {
                GraphicBlock block;
                double primId;
                PhxGraphicInsert insert = (PhxGraphicInsert)bg;
                if (insert.Objects != null) {
                    for (BaseGraphic g : insert.Objects) {
                        if (!(g instanceof Attribute)) continue;
                        AttributeRef ref = new AttributeRef();
                        try {
                            g.assign(ref);
                        }
                        catch (Exception e) {
                            throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432 \u0432\u0441\u0442\u0430\u0432\u043a\u0438 \u043f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u0430", e);
                        }
                        if (!this.primsHash.containsKey(baseID)) {
                            ref.ID = Core.generateId();
                        }
                        if (insert.Attributes == null) {
                            insert.Attributes = new ArrayList();
                        }
                        insert.Attributes.add(ref);
                    }
                }
                if (this.primsHash.containsKey(baseID)) {
                    primId = this.primsHash.get(baseID);
                } else {
                    primId = Core.generateId();
                    block = new GraphicBlock();
                    block.setEngine(this.engine);
                    block.ID = primId;
                    block.Objects = insert.Objects;
                    insert.Objects = null;
                    this.primsHash.put(baseID, primId);
                    if (this.scheme.internalLib == null) {
                        this.scheme.internalLib = new PrimLibrary(0.0);
                    }
                    Primitive prim = new Primitive();
                    prim.setID(primId);
                    prim.ImportID = baseID;
                    prim.Imported = true;
                    this.scheme.internalLib.Primitives.put(primId, prim);
                    block.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                    prim.BG = block;
                    prim.Caption = "\u041f\u0440\u0438\u043c\u0438\u0442\u0438\u0432 " + this.scheme.internalLib.Primitives.size();
                }
                block = (GraphicBlock)bg;
                block.LibID = this.scheme.internalLib.key();
                block.SourceID = primId;
            }
        };
        BiConsumer<BaseGraphic, Boolean> AddGluePoints = (bg, isPoly) -> {
            if (!(bg instanceof BaseShape)) {
                return;
            }
            if (local) {
                return;
            }
            if (isPoly.booleanValue() || !vars.GPDone) {
                this.convertGluePoints(shape, (BaseGraphic)bg, root, (boolean)isPoly);
            }
            if (!isPoly.booleanValue()) {
                vars.GPDone = true;
            }
            if (bg.ID == 0.0) {
                bg.ID = Core.generateId();
            }
            AddVisioShapesHash.accept(shape.ID, bg.ID);
        };
        this.currentLayerColor = !SchemeUtils.isEmpty(shape.LayerMember) && this.layerIDs != null && this.layerIDs.containsKey(shape.LayerMember) && this.layerColors != null && this.layerColors.containsKey(shape.LayerMember) && !"255".equals(this.layerColors.get(shape.LayerMember));
        this.currentLayerID = !SchemeUtils.isEmpty(shape.LayerMember) && this.layerIDs != null && this.layerIDs.containsKey(shape.LayerMember) ? this.layerIDs.get(shape.LayerMember) : this.currentPageLayerID;
        BiConsumer<BaseGraphic, Integer> AddChild = (bg, bgType) -> {
            if (shape.InvalidConverting) {
                return;
            }
            assert (bg != null && bgType != null);
            if (bg.StringProps == null) {
                bg.StringProps = new TextProps();
            }
            bg.StringProps.Caption = shape.getName();
            if (bg.ID == 0.0) {
                bg.ID = Core.generateId();
            }
            shape.avesID = bg.ID;
            this.pageShapes.put(bg.ID, (BaseGraphic)bg);
            if (bgType == 207) {
                ApplyImportPrimitive.accept((BaseGraphic)bg);
            } else {
                bg.LayerID = this.currentLayerID;
            }
            ++vars.AddCount;
            if (parent != null) {
                if (parent.Objects == null) {
                    parent.Objects = new ArrayList();
                }
                if (vars.AddIdx < 0) {
                    vars.AddIdx = parent.Objects.size();
                }
                parent.Objects.add((BaseGraphic)bg);
                this.parents.put(bg.ID, parent.ID);
            } else {
                assert (bgType != 0);
                SchemeObject obj = new SchemeObject(bg.ID, (int)bgType);
                if (vars.schemeObjects == null) {
                    vars.schemeObjects = new ArrayList();
                }
                if (vars.AddIdx < 0) {
                    vars.AddIdx = vars.schemeObjects.size();
                }
                vars.schemeObjects.add((BaseGraphic)bg);
                obj.setOrder(this.orderIndex++);
                this.pageObjects.add(obj);
            }
            if ((bgType == 232 || hasRelationships) && !shape.isMaster) {
                this.containerObjects.put(shape.ID, (BaseGraphic)bg);
                this.containerObjectsByName.put(shape.Name, (BaseGraphic)bg);
            }
            bg.setBgNotes(this.convertVsdxComments(shape.comments));
        };
        Consumer<AddStyleGlueChildParams> AddStyleGlueChild = prm -> {
            assert (prm != null && prm.shape != null && prm.shapeType != 0);
            boolean polyline = prm.shapeType == 210;
            this.applyShapeStyle(prm.shape, polyline, vars.AddCount == 0, prm.noFill, prm.noLine, shape);
            AddGluePoints.accept(prm.shape, polyline);
            AddChild.accept(prm.shape, prm.shapeType);
        };
        Consumer<AddPolyParams> AddPoly = prm -> {
            assert (prm != null && prm.poly != null && prm.pts != null);
            int type = 210;
            if (prm.poly instanceof Region) {
                type = 213;
            } else if (prm.poly instanceof Spline) {
                type = 212;
            } else if (prm.poly instanceof Polygon) {
                type = 211;
            }
            if (type == 210 || type == 212) {
                vars.IsPolylines = true;
            }
            prm.poly.Points = prm.pts.getPoints();
            prm.poly.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
            AddStyleGlueChild.accept(new AddStyleGlueChildParams(prm.poly, type, prm.noFill, prm.noLine));
            prm.poly.OrgX -= 0.5 * parentSize.X;
            prm.poly.OrgY += 0.5 * parentSize.Y;
        };
        Predicate<GraphicBlock> CheckIsGeom = block -> {
            if (block == null || block.Objects == null) {
                return false;
            }
            for (BaseGraphic g : block.Objects) {
                if (g.Hidden || g instanceof Attribute) continue;
                return true;
            }
            return false;
        };
        Predicate<GraphicBlock> CheckHasAttribute = block -> {
            if (block == null || block.Objects == null) {
                return false;
            }
            for (BaseGraphic g : block.Objects) {
                if (!(g instanceof Attribute)) continue;
                return true;
            }
            return false;
        };
        BaseGraphic.RealPoint shapeSize = shape.getShapeSizeMM();
        BaseGraphic.RealPoint centerShift = new BaseGraphic.RealPoint();
        if (parent != null && root) {
            for (VsdxProperty property : shape.Properties) {
                if (property.isDel()) continue;
                boolean showInContextMenu = shape.Actions.stream().filter(a -> a.getActionFormula() != null).anyMatch(a -> a.getActionFormula().contains(property.getName()));
                if (!property.isVisible() && !showInContextMenu) continue;
                PrimParam param = property.createPrimParam();
                param.setShowInContextMenu(showInContextMenu);
                parent.BlockParams.add(param);
            }
        }
        boolean isGroup = "Group".equals(shapeType);
        if (this.isFromOldFormat) {
            VsdxShapeParser.correctShape(shape);
        }
        int allPathsCount = shape.getVisiblePaths() == null ? 0 : shape.getVisiblePaths().size();
        boolean putGeometriesInGroup = (allPathsCount += shape.getHiddenPaths() == null ? 0 : shape.getHiddenPaths().size()) > 1 && shape.getFillArr().size() <= 1;
        String text = shape.getText();
        boolean bl3 = hasText = !this.emptyText(text);
        if (!local && (isContainer || isGroup || count > 0 || isMaster && !oneD || putGeometriesInGroup && !isOnlyText) && !"Foreign".equals(shapeType)) {
            Object libShape;
            BaseGraphic.RealPoint scalePrimitive = new BaseGraphic.RealPoint();
            boolean insertPrimitive = false;
            GraphicBlock block2 = isContainer ? new Container() : (insertPrimitive ? new PhxGraphicInsert() : new GraphicBlock());
            ApplyContainerProperties.accept(block2);
            if (shape.isMasterBase() && shape.vsdx.baseShapes != null && (libShape = shape.vsdx.baseShapes.get(shape.getMasterBaseID())) != null && this.scheme != null && this.scheme.internalLib != null) {
                block2.LibID = this.scheme.internalLib.key();
                block2.SourceID = ((VsdxShape)libShape).avesID;
            }
            if (root) {
                for (VsdxProperty property : shape.Properties) {
                    if (property.isDel()) continue;
                    boolean visible = property.isVisible();
                    if (!visible) {
                        boolean bl4 = visible = shape.Actions != null && shape.Actions.stream().filter(a -> a.getActionFormula() != null).anyMatch(a -> a.getActionFormula().contains(property.getName()));
                    }
                    if (!visible) continue;
                    PrimParam param = property.createPrimParam();
                    block2.BlockParams.add(param);
                }
            }
            VsdxReader.convertEffects(shape, block2);
            block2.setEngine(this.engine);
            block2.ID = Core.generateId();
            this.pageShapes.put(block2.ID, block2);
            BaseGraphic.RealPoint lSize = new BaseGraphic.RealPoint();
            String groupDisplayMode = shape.DisplayMode != null ? shape.DisplayMode : "2";
            vars.FirstShapeIdx = -1;
            if (!isLibMaster) {
                lSize = shapeSize;
                if ("1".equals(groupDisplayMode)) {
                    this.convertVsdxShape(shape, block2, false, isMaster || inMaster, true, count, lSize);
                }
            }
            vars.FirstShapeIdx = (block2.Objects == null ? 0 : block2.Objects.size()) - 1;
            double parentLayerId = this.currentLayerID;
            for (int i = 0; i < count; ++i) {
                VsdxShape childShape = shapes.get(i);
                if (childShape == null) continue;
                this.convertVsdxShape(childShape, block2, isLibMaster, isMaster || inMaster, false, 0, lSize);
                if (vars.FirstShapeIdx >= 0 || (block2.Objects == null ? 0 : block2.Objects.size()) != 1) continue;
                vars.FirstShapeIdx = i + 1;
            }
            this.currentLayerID = parentLayerId;
            boolean isGeom = CheckIsGeom.test(block2);
            if (!isLibMaster) {
                if ("2".equals(groupDisplayMode)) {
                    this.convertVsdxShape(shape, block2, false, isMaster || inMaster, true, count, lSize);
                    isGeom = CheckIsGeom.test(block2);
                }
                if (isGeom || hasText) {
                    if (isGeom) {
                        block2.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                    } else if (block2 instanceof Container) {
                        block2.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                    }
                    boolean canInscribe = SchemeUtils.isEqual(block2.OrgX, 0.0, 1.0E-6) && SchemeUtils.isEqual(block2.OrgY, 0.0, 1.0E-6);
                    VsdxReader.transformBG(shape, block2, lSize, parentSize, new BaseGraphic.RealPoint(block2.OrgX, block2.OrgY));
                    if (hasText || !CheckHasAttribute.test(block2)) {
                        GraphicBlock txtShape = hasText && this.enableEmbeddedText(block2, parent) ? block2 : null;
                        this.convertText(shape, text, block2, true, false, !isGeom, canInscribe, false, new BaseGraphic.RealPoint(), new BaseGraphic.RealPoint(), txtShape);
                    }
                    boolean bl5 = isGeom = isGeom || CheckIsGeom.test(block2);
                    if (isGeom) {
                        this.updateInscribeAttributes(block2);
                        this.convertGluePoints(shape, block2, root, false);
                        AddVisioShapesHash.accept(vars.ShapeId, block2.ID);
                    }
                } else if (block2 instanceof Container) {
                    block2.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                    VsdxReader.transformBG(shape, block2, lSize, parentSize, new BaseGraphic.RealPoint(block2.OrgX, block2.OrgY));
                }
            } else if (isGeom) {
                block2.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                this.updateInscribeAttributes(block2);
            }
            if (insertPrimitive && (scalePrimitive.X != 1.0 || scalePrimitive.Y != 1.0)) {
                if (block2.TransProps == null) {
                    block2.TransProps = new TransformProps();
                }
                block2.TransProps.ScaleX = scalePrimitive.X;
                block2.TransProps.ScaleY = scalePrimitive.Y;
                AffineTransform TM = new AffineTransform();
                TM.scale(1.0 / scalePrimitive.X, 1.0 / scalePrimitive.Y);
                this.transformPrimitive(TM, block2);
            }
            if (isGeom || isContainer) {
                AddChild.accept(block2, isContainer ? 232 : (insertPrimitive ? 207 : 202));
            }
        } else if ("Guide".equals(shapeType)) {
            double angle = SchemeUtils.convertAngle(shape.getAngle());
            int direct = 0;
            if (SchemeUtils.isEqual(angle, 0.0) || SchemeUtils.isEqual(angle, 180.0)) {
                direct = 2;
            } else if (SchemeUtils.isEqual(angle, 90.0) || SchemeUtils.isEqual(angle, 270.0)) {
                direct = 1;
            }
            if (direct != 0 && shape.geometries != null && !shape.geometries.isEmpty() && !shape.geometries.get(0).isNoLine()) {
                Guide guide = new Guide();
                guide.Direct = (byte)direct;
                guide.OrgX = SchemeUtils.inchToMM(VsdxUtils.convertDouble(shape.PinX, shape));
                guide.OrgY = -SchemeUtils.inchToMM(VsdxUtils.convertDouble(shape.PinY, shape));
                if (!local) {
                    VsdxReader.transformBG(shape, guide, shapeSize, parentSize, centerShift);
                }
                this.applyShapeStyle(guide, false, vars.AddCount == 0, true, false, shape);
                AddChild.accept(guide, 234);
            }
        } else {
            int hiddenPathsCount;
            int visiblePathsCount = shape.getVisiblePaths().size();
            IntegerList hiddenPaths = shape.getHiddenPaths();
            int n = hiddenPathsCount = !this.importHiddenPaths || hiddenPaths == null ? 0 : hiddenPaths.size();
            if (visiblePathsCount + hiddenPathsCount > 0) {
                boolean isPolyPolygon;
                boolean singlePath = localCount <= 0 && visiblePathsCount == 1;
                IntegerList fillArr = shape.getFillArr();
                int fillCount = fillArr.size();
                boolean bl6 = isPolyPolygon = fillCount > 1;
                if (isPolyPolygon) {
                    boolean asBezier = false;
                    for (int i = 0; i < fillCount; ++i) {
                        int pathIdx = fillArr.get(i);
                        VsdxGeometry geometry = shape.geometries.get(pathIdx);
                        int cntBezier = geometry.countBezier();
                        if (cntBezier > 0) {
                            asBezier = true;
                            continue;
                        }
                        if (cntBezier >= 0) continue;
                        asBezier = false;
                        break;
                    }
                    BaseGraphic.RealPoints pointList = new BaseGraphic.RealPoints();
                    BaseGraphic.RealPoints pointListNoLine = new BaseGraphic.RealPoints();
                    IntegerList cntList = new IntegerList(2);
                    IntegerList cntListNoLine = new IntegerList(2);
                    for (int i = 0; i < fillCount; ++i) {
                        int curMove;
                        int j;
                        int pathIdx = fillArr.get(i);
                        VsdxGeometry geometry = shape.geometries.get(pathIdx);
                        BaseGraphic.RealPoints points = geometry.getPoints(local, asBezier, shape.isFlipX(), shape.isFlipY());
                        if (SchemeUtils.removeDuplicatePoints(points).size() < 2) continue;
                        int pointsCount = points.size();
                        IntegerList moveArr = geometry.getMoveArr(asBezier);
                        int lastMove = 0;
                        if (geometry.isNoLine()) {
                            pointListNoLine.addAll(points);
                            for (j = 1; j < moveArr.size(); ++j) {
                                curMove = moveArr.get(j);
                                cntListNoLine.add(curMove - lastMove);
                                lastMove = curMove;
                            }
                            cntListNoLine.add(pointsCount - lastMove);
                            continue;
                        }
                        for (j = 1; j < moveArr.size(); ++j) {
                            curMove = moveArr.get(j);
                            int cntMove = curMove - lastMove;
                            if (cntMove == 1) {
                                ++cntMove;
                                points.add(curMove, new BaseGraphic.RealPoint((BaseGraphic.RealPoint)points.get(curMove - 1)));
                            }
                            cntList.add(cntMove);
                            lastMove = curMove;
                        }
                        int cntMove = pointsCount - lastMove;
                        if (cntMove == 1) {
                            ++cntMove;
                            pointsCount = points.size();
                            points.add(new BaseGraphic.RealPoint((BaseGraphic.RealPoint)points.get(pointsCount - 1)));
                        }
                        cntList.add(cntMove);
                        pointList.addAll(points);
                    }
                    BiFunction<IntegerList, Boolean, Polyline> CreatePoly = (aCntList, asRegion) -> {
                        Polyline poly = null;
                        if (aCntList != null && !aCntList.empty()) {
                            if (Boolean.TRUE.equals(asRegion)) {
                                Region region = new Region();
                                region.Counts = aCntList.toArray();
                                poly = region;
                            } else {
                                Polygon polygon = new Polygon();
                                polygon.Counts = aCntList.toArray();
                                poly = polygon;
                            }
                            poly.ID = Core.generateId();
                            poly.setEngine(this.engine);
                        }
                        return poly;
                    };
                    Polyline poly = CreatePoly.apply(cntList, asBezier);
                    if (poly != null) {
                        VsdxReader.convertEffects(shape, poly);
                    }
                    if (poly != null && !pointList.isEmpty()) {
                        AddPoly.accept(new AddPolyParams(poly, false, false, pointList));
                    }
                    if ((poly = CreatePoly.apply(cntListNoLine, asBezier)) != null && !pointListNoLine.isEmpty()) {
                        AddPoly.accept(new AddPolyParams(poly, false, true, pointListNoLine));
                    }
                }
                int pathIdx = 0;
                IntegerList lineArr = shape.getLineArr();
                int lineCount = lineArr.size();
                int pathsCount = lineCount + 1;
                for (int i = 0; i < pathsCount + hiddenPathsCount; ++i) {
                    int moveToIdxsCount;
                    boolean noLine;
                    boolean isRect;
                    boolean noFill = i != 0 && i < pathsCount;
                    boolean isFill = !noFill && !shape.checkEmptyFill();
                    boolean hidden = false;
                    if (i == 0) {
                        if (fillCount != 1) continue;
                        pathIdx = fillArr.get(0);
                    } else if (i < pathsCount) {
                        pathIdx = lineArr.get(i - 1);
                    } else {
                        hidden = true;
                        pathIdx = hiddenPaths.get(i - pathsCount);
                    }
                    VsdxGeometry geometry = shape.geometries.get(pathIdx);
                    boolean asBezier = geometry.countBezier() > 0;
                    BaseGraphic.RealPoints points = geometry.getPoints(local, asBezier);
                    int pointsCount = asBezier ? points.size() : SchemeUtils.removeDuplicatePoints(points).size();
                    IntegerList moveToIdxs = geometry.getMoveArr(asBezier);
                    boolean closed = geometry.getClosed() > 0;
                    boolean isEllipse = !asBezier && geometry.isEllipse();
                    boolean bl7 = isRect = !asBezier && geometry.isRect();
                    if (!isEllipse && !isRect && pointsCount < 2) continue;
                    boolean bl8 = noLine = i == 0 && geometry.isNoLine();
                    if (isEllipse || isRect) {
                        Rectangle rectangle = null;
                        int bsType = 214;
                        boolean ellipseRow = false;
                        VsdxUtils.EllipseRowInfo ellipseInfo = new VsdxUtils.EllipseRowInfo();
                        if (isEllipse) {
                            rectangle = new Ellipse();
                            ((Ellipse)rectangle).Slices = 60;
                            bsType = 215;
                            assert (geometry.rows != null && !geometry.rows.isEmpty());
                            ellipseRow = VsdxUtils.calcEllipseRow(shape, geometry.rows.get(0), ellipseInfo);
                        } else {
                            rectangle = new Rectangle();
                        }
                        if (ellipseRow) {
                            rectangle.SideX = ellipseInfo.radiusX * 2.0;
                            rectangle.SideY = ellipseInfo.radiusY * 2.0;
                            centerShift.X = ellipseInfo.offsetX;
                            centerShift.Y = ellipseInfo.offsetY;
                        } else {
                            rectangle.SideX = shapeSize.X;
                            rectangle.SideY = shapeSize.Y;
                        }
                        VsdxReader.convertEffects(shape, rectangle);
                        rectangle.setEngine(this.engine);
                        rectangle.ID = Core.generateId();
                        rectangle.Hidden = hidden;
                        if (!local) {
                            VsdxReader.transformBG(shape, rectangle, shapeSize, parentSize, centerShift);
                        } else if (centerShift.X != 0.0 || centerShift.Y != 0.0) {
                            if (rectangle.TransProps == null) {
                                rectangle.TransProps = new TransformProps();
                            }
                            rectangle.TransProps.CenterX = centerShift.X;
                            rectangle.TransProps.CenterY = centerShift.Y;
                        }
                        if (ellipseRow && !SchemeUtils.isEqual(ellipseInfo.angle, 0.0)) {
                            if (rectangle.TransProps == null) {
                                rectangle.TransProps = new TransformProps();
                            }
                            rectangle.TransProps.Angle += ellipseInfo.angle;
                            rectangle.TransProps.Angle %= Math.PI * 2;
                            rectangle.TransProps.Angle = SchemeUtils.convertAngle(rectangle.TransProps.Angle);
                            rectangle.OrgX += rectangle.TransProps.CenterX;
                            rectangle.OrgY += rectangle.TransProps.CenterY;
                            rectangle.TransProps.CenterX = 0.0;
                            rectangle.TransProps.CenterY = 0.0;
                        }
                        AddStyleGlueChild.accept(new AddStyleGlueChildParams(rectangle, bsType, noFill, noLine));
                        continue;
                    }
                    BaseGraphic.RealPoints arrPoints = geometry.getPoints(local, asBezier, shape.isFlipX(), shape.isFlipY());
                    int moveToCount = moveToIdxsCount = moveToIdxs.size();
                    Function<Integer, BaseGraphic.RealPoints> GetPointsByMoveToIdx = moveToIdx -> {
                        if (moveToCount <= 1) {
                            return arrPoints;
                        }
                        if (moveToIdx < 0 || moveToIdx >= moveToCount) {
                            return null;
                        }
                        int idx1 = moveToIdxs.get((int)moveToIdx);
                        int idx2 = (moveToIdx < moveToCount - 1 ? moveToIdxs.get(moveToIdx + 1) : arrPoints.size()) - 1;
                        int cnt = idx2 - idx1 + 1;
                        if (cnt <= 0) {
                            return null;
                        }
                        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
                        for (int p = 0; p < cnt; ++p) {
                            result.add((BaseGraphic.RealPoint)arrPoints.get(idx1 + p));
                        }
                        return asBezier ? result : SchemeUtils.removeDuplicatePoints(result);
                    };
                    for (int j = 0; j < moveToCount; ++j) {
                        int ptsLength;
                        BaseGraphic.RealPoints pts = GetPointsByMoveToIdx.apply(j);
                        int n2 = ptsLength = pts == null ? 0 : pts.size();
                        if (ptsLength < 2) continue;
                        Polyline polyline = null;
                        if (closed && ptsLength > 2 && (isFill || moveToCount == 1)) {
                            if (asBezier) {
                                polyline = new Region();
                                ((Region)polyline).Counts = new int[]{pts.size()};
                            } else {
                                polyline = new Polygon();
                                ((Polygon)polyline).Counts = new int[]{pts.size()};
                            }
                        } else if (asBezier) {
                            polyline = new Spline();
                        } else {
                            polyline = new Polyline();
                            if (shape.isLineRoute()) {
                                polyline.ConnectorView = shape.isStraightLineRoute() ? 1 : (shape.isRepairLineRoute() ? 3 : 2);
                            }
                        }
                        VsdxReader.convertEffects(shape, polyline);
                        polyline.setEngine(this.engine);
                        polyline.ID = Core.generateId();
                        polyline.Hidden = hidden;
                        AddPoly.accept(new AddPolyParams(polyline, noFill, noLine, pts));
                    }
                }
            }
            if ("Foreign".equals(shapeType) && shape.foreignData != null && shape.foreignData.hasAttribute("ForeignType")) {
                shapeSize = shape.getShapeSizeMM();
                String foreignType = shape.foreignData.getAttribute("ForeignType");
                PhxImage image = null;
                VsdxForeignData.OleFormat oleFormat = shape.foreignData.getRawFormat();
                if (oleFormat == VsdxForeignData.OleFormat.VSD || oleFormat == VsdxForeignData.OleFormat.VSDX) {
                    try {
                        GraphicBlock block3 = this.convertEmbeddingsVsdx(shape, this.currentPageLayerID);
                        if (block3 != null) {
                            block3.ID = Core.generateId();
                            this.updateInscribeAttributes(block3);
                            if (!local) {
                                VsdxReader.transformBG(shape, block3, shapeSize, parentSize, centerShift);
                                double angle = VsdxReader.convertAngle(shape.Angle, shape);
                                BaseGraphic.RealPoint p2 = SchemeUtils.rotatePoint(block3.TransProps.CenterX, block3.TransProps.CenterY, angle);
                                block3.OrgX += p2.X;
                                block3.OrgY += p2.Y;
                                block3.TransProps.CenterX = 0.0;
                                block3.TransProps.CenterY = 0.0;
                            }
                            AddGluePoints.accept(block3, false);
                            AddChild.accept(block3, 202);
                        }
                    }
                    catch (Exception e) {
                        String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e OLE \u043e\u0431\u044a\u0435\u043a\u0442\u0430";
                        Core.logger.error(message, e);
                        this.putStateLog(message + ": " + e.getMessage());
                    }
                } else if (shape.charts != null && shape.charts.size() == 1) {
                    int cntk;
                    VsdxChart chart = shape.charts.get(0);
                    int serieType = 0;
                    if (chart.chartType != null) {
                        switch (chart.chartType) {
                            case BAR: {
                                serieType = 4;
                                break;
                            }
                            case LINE: {
                                serieType = 1;
                                break;
                            }
                            case PIE: {
                                serieType = 2;
                                break;
                            }
                            case AREA: {
                                serieType = 2;
                                break;
                            }
                        }
                    }
                    Diagram diag = new Diagram();
                    if (diag.SeriesList == null) {
                        diag.SeriesList = new ArrayList();
                    }
                    if (this.scheme.diagTables == null) {
                        this.scheme.diagTables = new ArrayList<DiagramTable>();
                    }
                    int n3 = cntk = chart.chartSeries == null ? 0 : chart.chartSeries.size();
                    for (int k = 0; k < cntk; ++k) {
                        int i;
                        int cnt;
                        VsdxChart.VsdxChartSeries vsdxSeries = chart.chartSeries.get(k);
                        if (vsdxSeries == null) continue;
                        DiagramTable table = new DiagramTable();
                        table.ID = Core.generateId();
                        table.Name = SchemeUtils.isEmpty(vsdxSeries.title) ? "\u0422\u0430\u0431\u043b\u0438\u0446\u0430 " + (k + 1) : vsdxSeries.title;
                        DiagramTable.DiagramColumn colX = new DiagramTable.DiagramColumn();
                        colX.Name = "\u041e\u0441\u044c X";
                        colX.ValueType = 3;
                        table.Columns.add(colX);
                        DiagramTable.DiagramColumn colY = new DiagramTable.DiagramColumn();
                        colY.Name = "\u041e\u0441\u044c Y";
                        colY.ValueType = 3;
                        table.Columns.add(colY);
                        DiagramTable.DiagramColumn colT = new DiagramTable.DiagramColumn();
                        colT.Name = "\u0422\u0435\u043a\u0441\u0442";
                        colT.ValueType = 5;
                        table.Columns.add(colT);
                        Diagram.Serie serie = new Diagram.Serie();
                        serie.SType = (byte)serieType;
                        serie.TableId = table.ID;
                        serie.XFieldIndex = 0;
                        serie.YFieldIndex = 1;
                        serie.StrFieldIndex = 2;
                        diag.SeriesList.add(serie);
                        int n4 = cnt = vsdxSeries.cells == null ? 0 : vsdxSeries.cells.size();
                        for (i = 0; i < cnt; ++i) {
                            VsdxChart.VsdxChartCell cell = vsdxSeries.cells.get(i);
                            colX.Values.add(DiagramTable.DiagramValue.createNumValue(i));
                            colY.Values.add(DiagramTable.DiagramValue.createNumValue(cell.numValue));
                        }
                        int n5 = cnt = vsdxSeries.categoryLabels == null ? 0 : vsdxSeries.categoryLabels.size();
                        for (i = 0; i < cnt; ++i) {
                            String lbl = vsdxSeries.categoryLabels.get(i);
                            colT.Values.add(DiagramTable.DiagramValue.createStrValue(lbl != null ? lbl : ""));
                        }
                        this.scheme.diagTables.add(table);
                    }
                    diag.setEngine(this.engine);
                    diag.ID = Core.generateId();
                    diag.SideX = shapeSize.X;
                    diag.SideY = shapeSize.Y;
                    if (!local) {
                        VsdxReader.transformBG(shape, diag, shapeSize, parentSize, centerShift);
                    } else if (centerShift.X != 0.0 || centerShift.Y != 0.0) {
                        if (diag.TransProps == null) {
                            diag.TransProps = new TransformProps();
                        }
                        diag.TransProps.CenterX = centerShift.X;
                        diag.TransProps.CenterY = centerShift.Y;
                    }
                    AddStyleGlueChild.accept(new AddStyleGlueChildParams(diag, 235, false, false));
                    diag.BrushPattern = 0;
                } else if ("MetaFile".equals(foreignType) || "EnhMetaFile".equals(foreignType) || "Object".equals(foreignType)) {
                    try {
                        image = this.convertEmfImage(shape);
                    }
                    catch (Exception e) {
                        String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 EMF \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f";
                        Core.logger.error(message, e);
                        this.putStateLog(message + ": " + e.getMessage());
                    }
                    if (image != null) {
                        image.SideX = shapeSize.X;
                        image.SideY = shapeSize.Y;
                        image.initClipPoints();
                    } else if ("Object".equals(foreignType)) {
                        image = this.convertBitmapShape(shape, shapeSize);
                    }
                } else if ("Bitmap".equals(foreignType)) {
                    image = this.convertBitmapShape(shape, shapeSize);
                }
                if (image != null) {
                    double transparency = VsdxUtils.convertDouble(shape.Transparency, shape);
                    if (transparency > 0.0) {
                        image.Transparent = (int)(255.0 * transparency);
                    }
                    if (!local) {
                        double shiftX = image.OrgX;
                        double shiftY = image.OrgY;
                        VsdxReader.transformBG(shape, image, shapeSize, parentSize, centerShift);
                        image.OrgX += shiftX;
                        image.OrgY += shiftY;
                    }
                    VsdxReader.convertEffects(shape, image);
                    if (!SchemeUtils.isEmpty(shape.Contrast)) {
                        image.Contrast = 100.0 * VsdxUtils.convertDouble(shape.Contrast, shape);
                    }
                    if (!SchemeUtils.isEmpty(shape.Brightness)) {
                        image.Brightness = 100.0 * VsdxUtils.convertDouble(shape.Brightness, shape);
                    }
                    if (!SchemeUtils.isEmpty(shape.Gamma)) {
                        image.Gamma = VsdxUtils.convertDouble(shape.Gamma, shape);
                    }
                    AddGluePoints.accept(image, false);
                    AddChild.accept(image, 218);
                }
            }
            if (!local && hasText) {
                if (vars.AddIdx >= 0 && vars.AddCount > 0) {
                    if (vars.AddCount == 1) {
                        BaseGraphic bg2;
                        BaseGraphic baseGraphic = bg2 = parent == null ? vars.schemeObjects.get(vars.schemeObjects.size() - 1) : parent.Objects.get(parent.Objects.size() - 1);
                        assert (bg2 != null);
                        if (this.enableEmbeddedText(bg2, parent) && !shape.onlyText()) {
                            this.convertText(shape, text, parent, false, false, true, true, true, parentSize, new BaseGraphic.RealPoint(), bg2);
                            hasText = false;
                        }
                    }
                    if (hasText && !vars.IsPolylines) {
                        GraphicBlock block4 = new GraphicBlock();
                        block4.setEngine(this.engine);
                        block4.ID = Core.generateId();
                        block4.Objects = new ArrayList();
                        for (int i = 0; i < vars.AddCount; ++i) {
                            BaseGraphic bg3;
                            BaseGraphic baseGraphic = bg3 = parent == null ? vars.schemeObjects.remove(vars.schemeObjects.size() - 1) : parent.Objects.remove(parent.Objects.size() - 1);
                            assert (bg3 != null);
                            if (parent == null) {
                                this.pageObjects.remove(bg3.ID);
                            }
                            block4.Objects.add(bg3);
                            this.parents.put(bg3.ID, block4.ID);
                        }
                        block4.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
                        if (root) {
                            SchemeUtils.liftGluePoints(block4);
                        }
                        AddVisioShapesHash.accept(vars.ShapeId, block4.ID);
                        double angle = SchemeUtils.convertAngle(shape.getAngle());
                        if (angle != 0.0) {
                            this.rotateWithoutChildren(block4, angle);
                        }
                        GraphicBlock txtShape = hasText && this.enableEmbeddedText(block4, parent) && !shape.onlyText() ? block4 : null;
                        this.convertText(shape, text, block4, false, false, !CheckIsGeom.test(block4), true, true, parentSize, new BaseGraphic.RealPoint(block4.OrgX, block4.OrgY), txtShape);
                        AddChild.accept(block4, 202);
                        hasText = false;
                    }
                }
                if (hasText) {
                    boolean asPar = parent instanceof PhxLayer || !CheckIsGeom.test(parent) || !isGroup && shape.getVisiblePaths().size() > 0;
                    GraphicBlock txtShape = this.enableEmbeddedText(parent, parent) && !shape.onlyText() && parent != null && parent.Objects != null && !parent.Objects.isEmpty() ? parent : null;
                    this.convertText(shape, text, parent, false, vars.AddCount == 0, asPar, false, false, parentSize, new BaseGraphic.RealPoint(), txtShape);
                }
            }
        }
    }

    private static void convertEffects(VsdxShape shape, BaseGraphic block) {
        int reflectionTrans = (int)VsdxUtils.convertFromRealToPercent(shape.ReflectionTrans, shape);
        int reflectionSize = (int)VsdxUtils.convertFromRealToPercent(shape.ReflectionSize, shape);
        double reflectionBlur = VsdxReader.inchToMM(shape.ReflectionBlur, shape);
        double reflectionDist = VsdxReader.inchToMM(shape.ReflectionDist, shape);
        block.ReflectionEffect = new Reflection(reflectionTrans, reflectionSize, reflectionBlur, reflectionDist);
        Color glowColor = shape.vsdx.parseNullableColor(shape.GlowColor).orElse(SchemeUtils.Colors.NONE);
        double glowSize = VsdxReader.inchToMM(shape.GlowSize, shape);
        int glowColorTrans = (int)VsdxUtils.convertFromRealToPercent(shape.GlowColorTrans, shape);
        block.GlowEffect = new Glow(glowColor, glowSize, glowColorTrans);
        double softEdgesSize = VsdxReader.inchToMM(shape.SoftEdgesSize, shape);
        block.SoftEdgesEffect = new SoftEdges(softEdgesSize);
        Color shdwForegnd = shape.vsdx.parseColor(shape.ShdwForegnd);
        int shdwForegndTrans = (int)VsdxUtils.convertFromRealToPercent(shape.ShdwForegndTrans, shape);
        int shdwPattern = (int)VsdxUtils.convertDouble(shape.ShdwPattern, shape);
        double shapeShdwOffsetX = VsdxReader.inchToMM(shape.ShapeShdwOffsetX, shape);
        double shapeShdwOffsetY = VsdxReader.inchToMM(shape.ShapeShdwOffsetY, shape);
        int shapeShdwType = (int)VsdxUtils.convertDouble(shape.ShapeShdwType, shape);
        double ShapeShdwObliqueAngle = VsdxUtils.convertDouble(shape.ShapeShdwObliqueAngle, shape) * 180.0 / Math.PI;
        int ShapeShdwScaleFactor = (int)VsdxUtils.convertFromRealToPercent(shape.ShapeShdwScaleFactor, shape);
        double shapeShdwBlur = VsdxReader.inchToMM(shape.ShapeShdwBlur, shape);
        int ShapeShdwShow = (int)VsdxUtils.convertDouble(shape.ShapeShdwShow, shape);
        VsdxUtils.PolarPoint shadowPos = VsdxUtils.convertCartesianToPolar(shapeShdwOffsetX, shapeShdwOffsetY);
        if (shdwForegnd.equals(Color.BLACK) && shdwForegndTrans == 0 && shapeShdwOffsetX == 0.0 && shapeShdwOffsetY == 0.0 && ShapeShdwScaleFactor == 0 && shapeShdwBlur == 0.0) {
            block.ShadowEffect = Shadow.NO_EFFECT;
        } else {
            switch (shapeShdwType) {
                case 1: {
                    block.ShadowEffect = Shadow.createOuterShadow(shdwForegnd, shdwForegndTrans, ShapeShdwScaleFactor, shapeShdwBlur, shadowPos.getDegrees(), shadowPos.getLength());
                    break;
                }
                case 2: {
                    block.ShadowEffect = Shadow.createPerspectiveShadow(shdwForegnd, shdwForegndTrans, ShapeShdwScaleFactor, shapeShdwBlur, shadowPos.getDegrees(), shadowPos.getLength(), ShapeShdwObliqueAngle);
                    break;
                }
                case 3: {
                    block.ShadowEffect = Shadow.createInnerShadow(shdwForegnd, shdwForegndTrans, shapeShdwBlur, shadowPos.getDegrees(), shadowPos.getLength());
                    break;
                }
                default: {
                    block.ShadowEffect = Shadow.NO_EFFECT;
                }
            }
        }
    }

    private SchemePageLayout convertPageLayout(VsdxPage page) {
        double valuePageScale;
        double pageScale = VsdxUtils.convertDouble(page.PageScale, null);
        double drawingScale = VsdxUtils.convertDouble(page.DrawingScale, null);
        if (drawingScale == 0.0) {
            drawingScale = 1.0;
        }
        double d = valuePageScale = Math.abs(drawingScale) > BaseGraphic.FloatTolerance && Math.abs(pageScale) > BaseGraphic.FloatTolerance ? Math.abs(pageScale / drawingScale) : 1.0;
        if (valuePageScale == 0.0) {
            valuePageScale = 1.0;
        }
        double pageWidth = 25.4 * VsdxUtils.convertDouble(page.PageWidth, null);
        double pageHeight = 25.4 * VsdxUtils.convertDouble(page.PageHeight, null);
        if (pageWidth == 0.0 && pageHeight == 0.0) {
            if (page.isLandscape) {
                pageWidth = 297.0;
                pageHeight = 210.0;
            } else {
                pageWidth = 210.0;
                pageHeight = 297.0;
            }
        }
        pageWidth = valuePageScale * pageWidth;
        pageHeight = valuePageScale * pageHeight;
        SchemePageLayout layout = new SchemePageLayout();
        if (!SchemeUtils.isEqual(valuePageScale, 1.0)) {
            layout.setActive(true);
            int scaleInt = (int)(valuePageScale * 1000000.0);
            byte preScale = -1;
            switch (scaleInt) {
                case 1000: {
                    preScale = 0;
                    break;
                }
                case 2000: {
                    preScale = 1;
                    break;
                }
                case 5000: {
                    preScale = 2;
                    break;
                }
                case 10000: {
                    preScale = 3;
                    break;
                }
                case 20000: {
                    preScale = 4;
                    break;
                }
                case 40000: {
                    preScale = 5;
                    break;
                }
                case 50000: {
                    preScale = 6;
                    break;
                }
                case 100000: {
                    preScale = 7;
                    break;
                }
                case 200000: {
                    preScale = 8;
                    break;
                }
                case 400000: {
                    preScale = 9;
                    break;
                }
                case 500000: {
                    preScale = 10;
                    break;
                }
                case 1000000: {
                    preScale = 11;
                    break;
                }
                case 10000000: {
                    preScale = 12;
                    break;
                }
                case 20000000: {
                    preScale = 13;
                    break;
                }
                case 50000000: {
                    preScale = 14;
                }
            }
            if (preScale >= 0) {
                layout.setScalePageType((byte)1);
                layout.setScalePage(preScale);
            } else {
                layout.setScalePageType((byte)2);
                layout.setScaleFloat(1.0 / valuePageScale);
            }
        }
        if (pageWidth > 0.0 && pageHeight > 0.0) {
            layout.setActive(true);
            boolean portrait = pageWidth < pageHeight;
            layout.setPortrait(portrait);
            int w = (int)Math.round(pageWidth);
            int h = (int)Math.round(pageHeight);
            int v1 = portrait ? w : h;
            int v2 = portrait ? h : w;
            int format = 0;
            if (v1 == 148 && v2 == 210) {
                format = 6;
            } else if (v1 == 210 && v2 == 297) {
                format = 5;
            } else if (v1 == 297 && v2 == 420) {
                format = 4;
            } else if (v1 == 420 && v2 == 594) {
                format = 3;
            } else if (v1 == 594 && v2 == 841) {
                format = 2;
            } else if (v1 == 841 && v2 == 1189) {
                format = 1;
            }
            layout.setFormat(format);
            if (format == 0) {
                layout.setWidth(w);
                layout.setHeight(h);
            }
        }
        VsdxStyle noStyle = page.vsdx == null || page.vsdx.styles == null ? null : page.vsdx.styles.get("0");
        Map<String, String> defValues = noStyle == null ? null : noStyle.cellValues;
        int margin = (int)Math.ceil(25.4 * VsdxUtils.convertDouble(page.PageLeftMargin == null && defValues != null ? defValues.get("PageLeftMargin") : page.PageLeftMargin, null));
        layout.setLeftField(margin);
        if (margin != 10) {
            layout.setActive(true);
        }
        margin = (int)Math.ceil(25.4 * VsdxUtils.convertDouble(page.PageRightMargin == null && defValues != null ? defValues.get("PageRightMargin") : page.PageRightMargin, null));
        layout.setRightField(margin);
        if (margin != 10) {
            layout.setActive(true);
        }
        margin = (int)Math.ceil(25.4 * VsdxUtils.convertDouble(page.PageTopMargin == null && defValues != null ? defValues.get("PageTopMargin") : page.PageTopMargin, null));
        layout.setTopField(margin);
        if (margin != 10) {
            layout.setActive(true);
        }
        margin = (int)Math.ceil(25.4 * VsdxUtils.convertDouble(page.PageBottomMargin == null && defValues != null ? defValues.get("PageBottomMargin") : page.PageBottomMargin, null));
        layout.setBottomField(margin);
        if (margin != 10) {
            layout.setActive(true);
        }
        return layout;
    }

    private PhxImage convertEmfImage(VsdxShape shape) throws IOException {
        if (shape == null || shape.foreignData == null) {
            return null;
        }
        byte[] bytes = shape.foreignData.getRawData();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        PhxImage image = null;
        if (EmfReader.isEmf(bytes)) {
            EmfReader emfReader = new EmfReader(this.engine);
            image = emfReader.parseEmfImage(bytes);
        } else if (EmfReader.isWmf(bytes)) {
            EmfReader emfReader = new EmfReader(this.engine);
            image = emfReader.parseWmfImage(bytes, shape.foreignData.getExtentX(), shape.foreignData.getExtentY());
        }
        return image;
    }

    private boolean convertEmf(GraphicBlock emf, VsdxShape shape) throws IOException {
        PhxImage image;
        EmfReader emfReader;
        if (shape == null || shape.foreignData == null) {
            return false;
        }
        byte[] bytes = shape.foreignData.getRawData();
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        if (EmfReader.isEmf(bytes)) {
            emfReader = new EmfReader(this.engine);
            image = emfReader.parseEmfImage(bytes);
            if (image == null) {
                return false;
            }
            emf.Objects = new ArrayList();
            emf.Objects.add(image);
        } else if (EmfReader.isWmf(bytes)) {
            emfReader = new EmfReader(this.engine);
            image = emfReader.parseWmfImage(bytes, shape.foreignData.getExtentX(), shape.foreignData.getExtentY());
            if (image == null) {
                return false;
            }
            emf.Objects = new ArrayList();
            emf.Objects.add(image);
        }
        if (emf.Objects == null || emf.Objects.isEmpty()) {
            return false;
        }
        int cnt = emf.Objects.size();
        for (int i = 0; i < cnt; ++i) {
            BaseGraphic bg = emf.Objects.get(i);
            bg.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
            boolean isPolyline = false;
            if (bg instanceof Polyline) {
                isPolyline = !(bg instanceof Polygon);
            }
            this.convertGluePoints(shape, bg, false, isPolyline);
        }
        emf.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
        double ptX = emf.MaxPtX - emf.MinPtX;
        double ptY = emf.MaxPtY - emf.MinPtY;
        BaseGraphic.RealPoint shapeSizeMM = shape.getShapeSizeMM();
        double scaleX = shapeSizeMM.X / ptX;
        double scaleY = shapeSizeMM.Y / ptY;
        emf.OrgX = 0.0;
        emf.OrgY = 0.0;
        if (scaleX != 1.0 && scaleY != 1.0) {
            if (emf.TransProps == null) {
                emf.TransProps = new TransformProps();
            }
            emf.TransProps.ScaleX = scaleX;
            emf.TransProps.ScaleY = scaleY;
            double scaleXY = (scaleX + scaleY) / 2.0;
            int cnt2 = emf.Objects.size();
            for (int i = 0; i < cnt2; ++i) {
                BaseGraphic bg = emf.Objects.get(i);
                if (!(bg instanceof BaseShape)) continue;
                BaseShape bs = (BaseShape)bg;
                if (bs.lWidth == -1.0) continue;
                bs.lWidth *= scaleXY;
            }
        }
        return true;
    }

    private String getPageInfo(VsdxPage page) {
        assert (page != null);
        return (page.Name == null ? "" : page.Name) + " (ID=" + page.ID + ") ";
    }

    private String getMasterInfo(VsdxMaster master) {
        assert (master != null);
        return (master.Name == null ? "" : master.Name) + " (ID=" + master.ID + ") ";
    }

    private String getShapeInfo(VsdxPage page, String vsdxShape, BaseGraphic shape) {
        VsdxShape[] findShapePath;
        StringBuilder sb = new StringBuilder();
        sb.append(vsdxShape);
        if (vsdxShape != null && page != null && (findShapePath = page.findShapePath(vsdxShape)) != null && findShapePath.length > 0) {
            String name;
            VsdxShape s = findShapePath[findShapePath.length - 1];
            String string = name = s != null && s.Name != null ? s.Name : "";
            if (!name.isEmpty() || shape != null) {
                sb.append(" (");
                sb.append(name);
                if (shape != null) {
                    sb.append(" id=").append((long)shape.ID);
                }
                sb.append(')');
            }
        }
        return sb.toString();
    }

    private boolean connectShapes(VsdxPage page, String fromSheet, String toSheet, byte flag1, byte flag2, String connectInfo, boolean fromDynamic, boolean toDynamic, int toPoint) {
        BiFunction<DoubleList, Integer, BaseGraphic> FindBaseGraphic = (entry, idx) -> {
            BaseGraphic parentBG;
            if (idx < 0 || entry == null) {
                return null;
            }
            int size = entry.size();
            if (idx >= size) {
                return null;
            }
            double bgID = entry.get((int)idx);
            BaseGraphic bg = this.pageShapes.get(bgID);
            while (this.parents.containsKey(bgID) && (parentBG = this.pageShapes.get(bgID = this.parents.get(bgID).doubleValue())) != null) {
                bg = parentBG;
            }
            return bg;
        };
        boolean glued = false;
        DoubleList entry1 = SchemeUtils.isEmpty(fromSheet) ? null : this.visioShapesHash.get(fromSheet);
        DoubleList entry2 = SchemeUtils.isEmpty(toSheet) ? null : this.visioShapesHash.get(toSheet);
        Predicate<String> SkipConnectMessage = shapeID -> {
            VsdxShape[] findShapePath = page.findShapePath((String)shapeID);
            if (findShapePath != null && findShapePath.length > 0) {
                VsdxShape s = findShapePath[findShapePath.length - 1];
                if (s == null) {
                    return false;
                }
                if ("Guide".equalsIgnoreCase(s.Type)) {
                    return true;
                }
                if ("Shape".equalsIgnoreCase(s.Type)) {
                    IntegerList paths = s.getVisiblePaths();
                    if (this.emptyText(s.getText()) && (paths == null || paths.size() == 0)) {
                        return true;
                    }
                    int cnt = paths.size();
                    for (int k = 0; k < cnt; ++k) {
                        BaseGraphic.RealPoints points;
                        VsdxGeometry geometry = s.geometries.get(k);
                        if (geometry == null || (points = geometry.getPoints(true, false)) == null || SchemeUtils.removeDuplicatePoints(points).size() < 2) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        };
        if (entry1 == null || entry1.empty()) {
            if (SkipConnectMessage.test(fromSheet)) {
                return glued;
            }
            StringBuilder sb = new StringBuilder("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0435\u0440\u0432\u043e\u0439 \u0444\u0438\u0433\u0443\u0440\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
            sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
            sb.append(this.getShapeInfo(page, fromSheet, null)).append(" \u0438 ");
            BaseGraphic shape2 = null;
            DoubleList entry3 = this.visioShapesHash.get(toSheet);
            if (entry3 != null && !entry3.empty()) {
                shape2 = FindBaseGraphic.apply(entry3, 0);
            }
            sb.append(this.getShapeInfo(page, toSheet, shape2));
            String message = sb.toString();
            Core.logger.warn(message);
            this.putStateLog(message);
            return glued;
        }
        if (entry2 == null || entry2.empty()) {
            if (SkipConnectMessage.test(toSheet)) {
                return glued;
            }
            StringBuilder sb = new StringBuilder("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u0442\u043e\u0440\u043e\u0439 \u0444\u0438\u0433\u0443\u0440\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
            sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
            BaseGraphic shape3 = null;
            DoubleList entry4 = this.visioShapesHash.get(fromSheet);
            if (entry4 != null && !entry4.empty()) {
                shape3 = FindBaseGraphic.apply(entry4, 0);
            }
            sb.append(this.getShapeInfo(page, fromSheet, shape3)).append(" \u0438 ");
            sb.append(this.getShapeInfo(page, toSheet, null));
            String message = sb.toString();
            Core.logger.warn(message);
            this.putStateLog(message);
            return glued;
        }
        if (fromSheet.equals(toSheet)) {
            return glued;
        }
        double[] pt = new double[2];
        double[] pt1 = new double[2];
        double[] pt2 = new double[2];
        if (entry1 != null && entry2 != null) {
            BaseGraphic shape1 = null;
            BaseGraphic shape2 = null;
            int count1 = entry1.size();
            int count2 = entry2.size();
            if (!fromDynamic && !toDynamic) {
                for (int j = 0; j < count1; ++j) {
                    int gpCount1;
                    shape1 = FindBaseGraphic.apply(entry1, j);
                    if (shape1 == null) continue;
                    int n = gpCount1 = shape1.GluePoints == null ? 0 : shape1.GluePoints.size();
                    if (gpCount1 == 0) continue;
                    for (int k = 0; k < count2; ++k) {
                        int gpCount2;
                        shape2 = FindBaseGraphic.apply(entry2, k);
                        if (shape2 == null) continue;
                        int n2 = gpCount2 = shape2.GluePoints == null ? 0 : shape2.GluePoints.size();
                        if (gpCount2 != 0 && (glued = this.glueShapes(shape1, shape2, flag1, flag2, 0.001))) break;
                    }
                    if (glued) break;
                }
            }
            if (!glued) {
                boolean line2line = false;
                boolean dynamic = false;
                for (int j = 0; j < count1; ++j) {
                    shape1 = FindBaseGraphic.apply(entry1, j);
                    if (shape1 == null) continue;
                    for (int k = 0; k < count2; ++k) {
                        double rectSize2;
                        int verticesCount;
                        shape2 = FindBaseGraphic.apply(entry2, k);
                        if (shape2 == null) continue;
                        BaseGraphic node = null;
                        BaseGraphic polyline = null;
                        if (this.shapeIsArc(shape1) && shape1 instanceof Polyline) {
                            polyline = shape1;
                        } else if (this.shapeIsNode(shape1)) {
                            node = shape1;
                            dynamic = fromDynamic;
                        }
                        if (this.shapeIsArc(shape2) && shape2 instanceof Polyline) {
                            if (polyline != null) {
                                line2line = true;
                            }
                            polyline = shape2;
                        } else if (this.shapeIsNode(shape2)) {
                            node = shape2;
                            dynamic = toDynamic;
                        }
                        if (node == null || polyline == null) continue;
                        if (!dynamic && fromDynamic != toDynamic) {
                            int gpCount2;
                            int n = gpCount2 = shape2.GluePoints == null ? 0 : shape2.GluePoints.size();
                            if (gpCount2 == 0) continue;
                            glued = this.glueShapes(shape1, shape2, flag1, flag2, 0.001);
                            if (glued) break;
                        }
                        pt[0] = 0.0;
                        pt[1] = 0.0;
                        pt = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(node), pt);
                        int n = verticesCount = polyline.GluePoints == null ? 0 : polyline.GluePoints.size();
                        assert (verticesCount > 1);
                        BaseGraphic.GluePoint linePoint1 = polyline.GluePoints.get(0);
                        pt1[0] = linePoint1.ptX;
                        pt1[1] = linePoint1.ptY;
                        pt1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(polyline), pt1);
                        BaseGraphic.GluePoint linePoint2 = polyline.GluePoints.get(verticesCount - 1);
                        pt2[0] = linePoint2.ptX;
                        pt2[1] = linePoint2.ptY;
                        pt2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(polyline), pt2);
                        BaseGraphic.RealRect rect = node.getMinMaxRect();
                        double rectSize = Math.abs(rect.Right - rect.Left);
                        if (rectSize < (rectSize2 = Math.abs(rect.Bottom - rect.Top))) {
                            rectSize = rectSize2;
                        }
                        rect.Left -= rectSize * 0.1;
                        rect.Right += rectSize * 0.1;
                        rect.Top -= rectSize * 0.1;
                        rect.Bottom += rectSize * 0.1;
                        if (SchemeEngine.IsPointInRect(rect.Left, rect.Top, rect.Right, rect.Bottom, pt1[0], pt1[1]) || SchemeEngine.IsPointInRect(rect.Left, rect.Top, rect.Right, rect.Bottom, pt2[0], pt2[1])) {
                            if (SchemeUtils.distance(pt[0], pt[1], pt1[0], pt1[1]) < SchemeUtils.distance(pt[0], pt[1], pt2[0], pt2[1])) {
                                pt2 = pt1;
                                linePoint2 = linePoint1;
                            }
                            try {
                                AffineTransform tm = SchemeEngine.GenTransform(node);
                                tm.invert();
                                pt2 = SchemeEngine.MulPointsTM(tm, pt2);
                            }
                            catch (NoninvertibleTransformException ex) {
                                StringBuilder sb = new StringBuilder("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
                                sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
                                sb.append(this.getShapeInfo(page, fromSheet, shape1)).append(" \u0438 ");
                                sb.append(this.getShapeInfo(page, toSheet, shape2));
                                String message = sb.toString();
                                Core.logger.warn(message, ex);
                                this.putStateLog(message);
                                continue;
                            }
                            if (polyline instanceof Spline && !dynamic) {
                                node.addGluePoint(pt2[0], pt2[1]);
                                glued = this.glueShapes(shape1, shape2, flag1, flag2, 0.001);
                            } else {
                                node.addDynamicGluePoint();
                                double linkId = node.DynamicGluePoint.joinId != 0.0 ? node.DynamicGluePoint.joinId : Core.generateId();
                                node.DynamicGluePoint.flags = flag1;
                                node.DynamicGluePoint.joinId = linkId;
                                linePoint2.flags = flag2;
                                linePoint2.joinId = linkId;
                                glued = true;
                            }
                        }
                        if (glued) break;
                    }
                    if (glued) break;
                }
                if (line2line) {
                    BaseGraphic bg1 = shape1;
                    BaseGraphic bg2 = shape2;
                    BiPredicate<BaseGraphic, BaseGraphic> GlueLines = (connector, shape) -> {
                        int cntConnector = connector.getVerticesCount();
                        int cntShape = shape.getVerticesCount();
                        if (cntConnector < 2 || cntShape < 2) {
                            return false;
                        }
                        double[] conn1 = new double[2];
                        double[] conn2 = new double[2];
                        double[] p1 = new double[2];
                        double[] p2 = new double[2];
                        double[] point = null;
                        conn1[0] = connector.getVertexX(0);
                        conn1[1] = connector.getVertexY(0);
                        conn1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(connector), conn1);
                        conn2[0] = connector.getVertexX(cntConnector - 1);
                        conn2[1] = connector.getVertexY(cntConnector - 1);
                        conn2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(connector), conn2);
                        p1[0] = shape.getVertexX(0);
                        p1[1] = shape.getVertexY(0);
                        p1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(shape), p1);
                        for (int idx = 1; idx < cntShape && point == null; ++idx) {
                            p2[0] = shape.getVertexX(idx);
                            p2[1] = shape.getVertexY(idx);
                            p2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(shape), p2);
                            if (SchemeUtils.isPointOnLine(p1[0], p1[1], p2[0], p2[1], conn1[0], conn1[1])) {
                                point = conn1;
                                continue;
                            }
                            if (SchemeUtils.isPointOnLine(p1[0], p1[1], p2[0], p2[1], conn2[0], conn2[1])) {
                                point = conn2;
                                continue;
                            }
                            p1[0] = p2[0];
                            p1[1] = p2[1];
                        }
                        if (point != null) {
                            try {
                                AffineTransform tm = SchemeEngine.GenTransform(shape);
                                tm.invert();
                                point = SchemeEngine.MulPointsTM(tm, point);
                            }
                            catch (NoninvertibleTransformException ex) {
                                StringBuilder sb = new StringBuilder("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
                                sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
                                sb.append(this.getShapeInfo(page, fromSheet, bg1)).append(" \u0438 ");
                                sb.append(this.getShapeInfo(page, toSheet, bg2));
                                String message = sb.toString();
                                Core.logger.warn(message, ex);
                                this.putStateLog(message);
                                return false;
                            }
                            if (shape.getGluePoint(point[0], point[1]) == null) {
                                shape.addGluePoint(point[0], point[1]);
                            }
                            if (this.glueShapes((BaseGraphic)shape, (BaseGraphic)connector, flag1, flag2, 0.001)) {
                                return true;
                            }
                        }
                        return false;
                    };
                    for (int j = 0; j < count1; ++j) {
                        shape1 = FindBaseGraphic.apply(entry1, j);
                        if (shape1 == null) continue;
                        for (int k = 0; !(k >= count2 || (shape2 = FindBaseGraphic.apply(entry2, k)) != null && this.shapeIsArc(shape1) && shape1 instanceof Polyline && this.shapeIsArc(shape2) && shape2 instanceof Polyline && ((glued = GlueLines.test(shape1, shape2)) || (glued = GlueLines.test(shape2, shape1)))); ++k) {
                        }
                        if (glued) break;
                    }
                }
            }
            if (!glued) {
                BiFunction<List, List, BaseGraphic.RealPoint> findPoint = (list1, list2) -> {
                    if (list1 == null || list2 == null) {
                        return null;
                    }
                    for (BaseGraphic.RealPoint p1 : list1) {
                        for (BaseGraphic.RealPoint p2 : list2) {
                            if (!SchemeUtils.isEqual(p1, p2, 1.0E-6)) continue;
                            return p1;
                        }
                    }
                    return null;
                };
                for (int j = 0; j < count1; ++j) {
                    shape1 = FindBaseGraphic.apply(entry1, j);
                    if (shape1 == null) continue;
                    ArrayList<BaseGraphic.RealPoint> gluePoints1 = new ArrayList<BaseGraphic.RealPoint>();
                    ArrayList<BaseGraphic.RealPoint> vertices1 = new ArrayList<BaseGraphic.RealPoint>();
                    this.fillGroupPoints(shape1, null, gluePoints1, vertices1);
                    for (int k = 0; k < count2; ++k) {
                        BaseGraphic.GluePoint gp;
                        shape2 = FindBaseGraphic.apply(entry2, k);
                        if (shape2 == null) continue;
                        ArrayList<BaseGraphic.RealPoint> gluePoints2 = new ArrayList<BaseGraphic.RealPoint>();
                        ArrayList<BaseGraphic.RealPoint> vertices2 = new ArrayList<BaseGraphic.RealPoint>();
                        this.fillGroupPoints(shape2, null, gluePoints2, vertices2);
                        BaseGraphic.RealPoint p = findPoint.apply(gluePoints1, gluePoints2);
                        if (p == null) {
                            p = findPoint.apply(gluePoints1, vertices2);
                            if (p == null) {
                                p = findPoint.apply(vertices1, gluePoints2);
                            }
                            if (p == null) {
                                p = findPoint.apply(vertices1, vertices2);
                            }
                        }
                        if (p == null && shape2.GluePoints != null && toPoint >= 0 && toPoint < shape2.GluePoints.size() && (gp = shape2.GluePoints.get(toPoint)) != null) {
                            AffineTransform tm = SchemeEngine.GenTransform(shape2);
                            double[] pnt = new double[]{gp.ptX, gp.ptY};
                            pnt = SchemeEngine.MulPointsTM(tm, pnt);
                            p = new BaseGraphic.RealPoint(pnt[0], pnt[1]);
                        }
                        if (p != null) {
                            BiFunction<BaseGraphic, BaseGraphic.RealPoint, BaseGraphic.GluePoint> GetGluePoint = (shape, point) -> {
                                if (shape == null) {
                                    return null;
                                }
                                if (shape.GluePoints == null) {
                                    shape.GluePoints = new ArrayList<BaseGraphic.GluePoint>();
                                } else {
                                    for (BaseGraphic.GluePoint gp : shape.GluePoints) {
                                        if (!SchemeUtils.isEqual(point.X, gp.ptX) || !SchemeUtils.isEqual(point.Y, gp.ptY)) continue;
                                        return gp;
                                    }
                                }
                                int cnt = shape.GluePoints.size();
                                shape.addGluePoint(point.X, point.Y);
                                return shape.GluePoints.get(cnt);
                            };
                            double[] pnt = new double[2];
                            BaseGraphic.GluePoint gp1 = null;
                            BaseGraphic.GluePoint gp2 = null;
                            try {
                                AffineTransform tm = SchemeEngine.GenTransform(shape1);
                                tm.invert();
                                pnt[0] = p.X;
                                pnt[1] = p.Y;
                                pnt = SchemeEngine.MulPointsTM(tm, pnt);
                                gp1 = GetGluePoint.apply(shape1, new BaseGraphic.RealPoint(pnt[0], pnt[1]));
                                tm = SchemeEngine.GenTransform(shape2);
                                tm.invert();
                                pnt[0] = p.X;
                                pnt[1] = p.Y;
                                pnt = SchemeEngine.MulPointsTM(tm, pnt);
                                gp2 = GetGluePoint.apply(shape2, new BaseGraphic.RealPoint(pnt[0], pnt[1]));
                            }
                            catch (NoninvertibleTransformException ex) {
                                StringBuilder sb = new StringBuilder("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
                                sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
                                sb.append(this.getShapeInfo(page, fromSheet, shape1)).append(" \u0438 ");
                                sb.append(this.getShapeInfo(page, toSheet, shape2));
                                String message = sb.toString();
                                Core.logger.warn(message, ex);
                                this.putStateLog(message);
                            }
                            if (gp1 != null && gp2 != null) {
                                double linkId = gp1.joinId != 0.0 ? gp1.joinId : (gp2.joinId != 0.0 ? gp2.joinId : Core.generateId());
                                gp1.flags = flag1;
                                gp1.joinId = linkId;
                                gp2.flags = flag2;
                                gp2.joinId = linkId;
                                glued = true;
                            }
                        }
                        if (glued) break;
                    }
                    if (glued) break;
                }
            }
            if (!glued) {
                if (shape1 == null) {
                    StringBuilder sb = new StringBuilder("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0430\u044f \u0444\u0438\u0433\u0443\u0440\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
                    sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
                    sb.append(this.getShapeInfo(page, fromSheet, shape1)).append(" \u0438 ");
                    sb.append(this.getShapeInfo(page, toSheet, shape2));
                    String message = sb.toString();
                    Core.logger.warn(message);
                    this.putStateLog(message);
                } else if (shape2 == null) {
                    StringBuilder sb = new StringBuilder("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0442\u043e\u0440\u0430\u044f \u0444\u0438\u0433\u0443\u0440\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f ");
                    sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
                    sb.append(this.getShapeInfo(page, fromSheet, shape1)).append(" \u0438 ");
                    sb.append(this.getShapeInfo(page, toSheet, shape2));
                    String message = sb.toString();
                    Core.logger.warn(message);
                    this.putStateLog(message);
                } else {
                    StringBuilder sb = new StringBuilder("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 ");
                    sb.append(connectInfo).append(" \u0434\u043b\u044f \u0444\u0438\u0433\u0443\u0440 ");
                    sb.append(this.getShapeInfo(page, fromSheet, shape1)).append(" \u0438 ");
                    sb.append(this.getShapeInfo(page, toSheet, shape2));
                    String message = sb.toString();
                    Core.logger.warn(message);
                    this.putStateLog(message);
                }
            }
        }
        return glued;
    }

    private void gluePageShapes(VsdxPage page) {
        int cnt;
        if (page == null || page.connects == null && this.shapeConnects.isEmpty()) {
            return;
        }
        byte gpfMoveWithObject = 1;
        byte gpfMoveWithGluedObject = 4;
        String pageInfo = " (" + page.Name + " [" + page.ID + "]) ";
        HashMap<String, HashSet<String>> connected = this.shapeConnects.isEmpty() ? null : new HashMap<String, HashSet<String>>();
        BiPredicate<String, String> CheckConnected = (shape1, shape2) -> {
            if (connected == null) {
                return false;
            }
            Set shapes = (Set)connected.get(shape1);
            if (shapes != null && shapes.contains(shape2)) {
                return true;
            }
            shapes = (Set)connected.get(shape2);
            return shapes != null && shapes.contains(shape1);
        };
        Predicate<String> CheckDynamic = value -> {
            String v;
            if (value != null && (v = value.trim()).length() > 2) {
                try {
                    return Integer.parseInt(v) < 100;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
        String findStr = "Connections.";
        int n = cnt = page.connects == null ? 0 : page.connects.size();
        for (int i = 0; i < cnt; ++i) {
            boolean exists;
            VsdxConnect connect = page.connects.get(i);
            if (connect == null) continue;
            boolean fromDyn = CheckDynamic.test(connect.FromPart);
            boolean toDyn = CheckDynamic.test(connect.ToPart);
            int toCellIdx = -1;
            if (connect.ToCell != null && connect.ToCell.startsWith(findStr)) {
                char c;
                int idx1 = findStr.length();
                int idx2 = connect.ToCell.indexOf(".X", idx1);
                if (idx2 < 0) {
                    idx2 = connect.ToCell.indexOf(".Y", idx1);
                }
                if (idx2 > idx1) {
                    String n2 = connect.ToCell.substring(idx1, idx2);
                    VsdxShape[] findShapePath = page.findShapePath(connect.ToSheet);
                    if (findShapePath != null && findShapePath.length > 0) {
                        VsdxShape s = findShapePath[findShapePath.length - 1];
                        toCellIdx = s.getConnectionPointIndexByName(n2);
                    }
                } else if (idx1 + 1 < connect.ToCell.length() && ((c = connect.ToCell.charAt(idx1)) == 'X' || c == 'Y')) {
                    String s = connect.ToCell.substring(idx1 + 1);
                    try {
                        int point = Integer.parseInt(s);
                        if (point > 0) {
                            toCellIdx = point - 1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String s = connect.ToCell.substring("Connections.X".length());
                try {
                    int point = Integer.parseInt(s);
                    if (point > 0) {
                        toCellIdx = point - 1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.connectShapes(page, connect.FromSheet, connect.ToSheet, gpfMoveWithGluedObject, gpfMoveWithGluedObject, i + 1 + pageInfo, fromDyn, toDyn, toCellIdx) || connected == null) continue;
            HashSet<String> shapes = (HashSet<String>)connected.get(connect.FromSheet);
            boolean bl = exists = shapes != null;
            if (!exists) {
                shapes = new HashSet<String>();
            }
            shapes.add(connect.ToSheet);
            if (exists) continue;
            connected.put(connect.FromSheet, shapes);
        }
        if (connected == null) {
            return;
        }
        for (Map.Entry<String, List<ConnectToInfo>> entry : this.shapeConnects.entrySet()) {
            String shapeFrom = entry.getKey();
            List<ConnectToInfo> shapes = entry.getValue();
            assert (shapes != null);
            for (ConnectToInfo shapeToInfo : shapes) {
                VsdxShape[] findShapePath;
                if (CheckConnected.test(shapeFrom, shapeToInfo.shapeTo)) continue;
                if (shapeToInfo.gluePointIdx < 0 && shapeToInfo.gluePointName != null && !shapeToInfo.gluePointName.isEmpty() && (findShapePath = page.findShapePath(shapeToInfo.shapeTo)) != null && findShapePath.length > 0) {
                    VsdxShape s = findShapePath[findShapePath.length - 1];
                    shapeToInfo.gluePointIdx = s.getConnectionPointIndexByName(shapeToInfo.gluePointName);
                }
                this.connectShapes(page, shapeFrom, shapeToInfo.shapeTo, gpfMoveWithObject, gpfMoveWithGluedObject, pageInfo, false, false, shapeToInfo.gluePointIdx);
            }
        }
    }

    private boolean shapeIsNode(BaseGraphic shape) {
        if (shape == null) {
            return false;
        }
        return shape instanceof GraphicBlock ? !this.shapeIsArc(shape) : shape instanceof Rectangle || shape instanceof Polygon || shape instanceof Region;
    }

    private boolean shapeIsArc(BaseGraphic shape) {
        if (shape == null) {
            return false;
        }
        if (shape instanceof GraphicBlock) {
            GraphicBlock block = (GraphicBlock)shape;
            int linesCount = 0;
            int childrenCount = block.Objects == null ? 0 : block.Objects.size();
            for (int i = 0; i < childrenCount; ++i) {
                boolean isLine;
                BaseGraphic child = block.Objects.get(i);
                boolean bl = isLine = child instanceof Polyline && child.getVerticesCount() == 2 && !(child instanceof Spline) && !(child instanceof Polygon) && !(child instanceof Region);
                if (isLine) {
                    ++linesCount;
                }
                if ((isLine || child instanceof AttributeDef) && linesCount <= 1) continue;
                return false;
            }
            return true;
        }
        return shape instanceof Polyline && !(shape instanceof Polygon) && !(shape instanceof Region);
    }

    private void fillGroupPoints(BaseGraphic shape, AffineTransform transform, List<BaseGraphic.RealPoint> gluePoints, List<BaseGraphic.RealPoint> vertices) {
        int verticesCount;
        AffineTransform tm;
        if (transform == null) {
            tm = SchemeEngine.GenTransform(shape);
        } else {
            tm = (AffineTransform)transform.clone();
            tm.concatenate(SchemeEngine.GenTransform(shape));
        }
        double[] pt = new double[2];
        if (shape.GluePoints != null) {
            int cnt = shape.GluePoints.size();
            for (int i = 0; i < cnt; ++i) {
                BaseGraphic.GluePoint p = shape.GluePoints.get(i);
                pt[0] = p.ptX;
                pt[1] = p.ptY;
                pt = SchemeEngine.MulPointsTM(tm, pt);
                gluePoints.add(new BaseGraphic.RealPoint(pt[0], pt[1]));
            }
        }
        if (shape instanceof Polyline && !(shape instanceof Polygon) && !(shape instanceof Region) && (verticesCount = shape.getVerticesCount()) > 1) {
            pt[0] = shape.getVertexX(0);
            pt[1] = shape.getVertexY(0);
            pt = SchemeEngine.MulPointsTM(tm, pt);
            vertices.add(new BaseGraphic.RealPoint(pt[0], pt[1]));
            pt[0] = shape.getVertexX(verticesCount - 1);
            pt[1] = shape.getVertexY(verticesCount - 1);
            pt = SchemeEngine.MulPointsTM(tm, pt);
            vertices.add(new BaseGraphic.RealPoint(pt[0], pt[1]));
        }
        if (shape instanceof GraphicBlock && ((GraphicBlock)shape).Objects != null) {
            for (BaseGraphic bg : ((GraphicBlock)shape).Objects) {
                this.fillGroupPoints(bg, tm, gluePoints, vertices);
            }
        }
    }

    private boolean glueShapes(BaseGraphic shape1, BaseGraphic shape2, byte flag1, byte flag2, double tolerance) {
        if (shape1 == null || shape1.GluePoints == null || shape1.GluePoints.isEmpty()) {
            return false;
        }
        if (shape2 == null || shape2.GluePoints == null || shape2.GluePoints.isEmpty()) {
            return false;
        }
        double[] p1 = new double[2];
        double[] p2 = new double[2];
        for (int i = 0; i < shape1.GluePoints.size(); ++i) {
            BaseGraphic.GluePoint gp1 = shape1.GluePoints.get(i);
            if (gp1 == null) continue;
            p1[0] = gp1.ptX;
            p1[1] = gp1.ptY;
            p1 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(shape1), p1);
            for (int j = 0; j < shape2.GluePoints.size(); ++j) {
                BaseGraphic.GluePoint gp2 = shape2.GluePoints.get(j);
                if (gp2 == null) continue;
                p2[0] = gp2.ptX;
                p2[1] = gp2.ptY;
                p2 = SchemeEngine.MulPointsTM(SchemeEngine.GenTransform(shape2), p2);
                if (!(SchemeUtils.distance(p1[0], p1[1], p2[0], p2[1]) < tolerance)) continue;
                double linkId = gp1.joinId != 0.0 ? gp1.joinId : (gp2.joinId != 0.0 ? gp2.joinId : Core.generateId());
                gp1.flags = flag1;
                gp1.joinId = linkId;
                gp2.flags = flag2;
                gp2.joinId = linkId;
                return true;
            }
        }
        return false;
    }

    private double roundWithTol(double value, double tol, boolean isLineWidth) {
        return isLineWidth && Math.abs(value) < tol ? 0.0 : tol * (double)Math.round(Math.abs(value) / tol);
    }

    private int getNextAttIdx(GraphicBlock parent) {
        int index = 0;
        if (parent != null && parent.Objects != null) {
            for (BaseGraphic bg : parent.Objects) {
                if (!(bg instanceof AttributeDef)) continue;
                ++index;
            }
        }
        return index + 1;
    }

    private BaseGraphic.RealPoint transformPoint(BaseGraphic.RealPoint pin, BaseGraphic.RealPoint locPin, double angle, boolean flipX, boolean flipY, BaseGraphic.RealPoint p) {
        BaseGraphic.RealPoint result = new BaseGraphic.RealPoint(0.0, 0.0);
        double deltaX = pin.X - locPin.X;
        double deltaY = locPin.Y - pin.Y;
        boolean hasAngle = Math.abs(angle) > BaseGraphic.FloatTolerance;
        double cos = 1.0;
        double sin = 0.0;
        if (hasAngle) {
            cos = Math.cos(angle);
            sin = Math.sin(angle);
        }
        if (hasAngle || flipX || flipY) {
            double dx = flipX ? locPin.X - p.X : p.X - locPin.X;
            double dy = flipY ? locPin.Y - p.Y : p.Y - locPin.Y;
            double x = locPin.X + dx * cos - dy * sin;
            double y = locPin.Y + dx * sin + dy * cos;
            result.X = deltaX + x;
            result.Y = deltaY - y;
        } else {
            result.X = deltaX + p.X;
            result.Y = deltaY - p.Y;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertText(VsdxShape shape, String textValue, GraphicBlock parent, boolean local, boolean singleText, boolean asPar, boolean canInscribe, boolean fakeBlock, BaseGraphic.RealPoint parentSize, BaseGraphic.RealPoint blockShift, BaseGraphic textBg) {
        block102: {
            ConvertTextLocal l;
            block101: {
                boolean hasRelationships;
                double transparency;
                double spLine;
                boolean asTextShape;
                double transparency2;
                if (shape.InvalidConverting) {
                    return;
                }
                double TEXT_INSCRIBE_TOL = 0.25;
                if (!local && (textValue == null || textValue.isEmpty())) {
                    return;
                }
                l = new ConvertTextLocal();
                l.Text = textValue == null || textValue.isEmpty() ? " " : textValue;
                List<String> strings = SchemeUtils.getStrings(l.Text);
                assert (strings != null);
                if (strings.size() == 1) {
                    l.Text = strings.get(0);
                }
                boolean bl = l.Empty = strings.size() > 1 ? false : l.Text.trim().isEmpty();
                if (shape.isHideText() && asPar) {
                    return;
                }
                VsdxCharacter partCharacter = null;
                VsdxParagraph partParagraph = null;
                List<VsdxShape.VsdxTextPart> textParts = shape.getTextParts();
                if (textParts != null && textParts.size() == 1) {
                    VsdxShape.VsdxTextPart part = textParts.get(0);
                    partCharacter = shape.getCharacter(part.cp);
                    partParagraph = shape.getParagraph(part.pp);
                }
                VsdxCharacter shapeCharacter = partCharacter != null ? partCharacter : shape.getCharacter(shape.PreferredCharacterIX);
                VsdxParagraph shapeParagraph = partParagraph != null ? partParagraph : shape.getParagraph(shape.PreferredParagraphIX);
                l.IsTextTransformRow = shape.hasTextTransform();
                l.Text = shapeCharacter.applyCase(l.Text);
                l.Size = shape.getShapeSizeMM();
                BaseGraphic.RealPoint lTextSize = l.IsTextTransformRow ? new BaseGraphic.RealPoint(VsdxReader.inchToMM(shape.TxtWidth, shape), VsdxReader.inchToMM(shape.TxtHeight, shape)) : l.Size;
                l.TextWidth = lTextSize.X;
                l.TextHeight = lTextSize.Y;
                if (l.IsTextTransformRow) {
                    l.TextPinX = VsdxUtils.convertDouble(shape.TxtPinX, shape);
                    l.TextPinY = VsdxUtils.convertDouble(shape.TxtPinY, shape);
                    l.TextLocX = VsdxUtils.convertDouble(shape.TxtLocPinX, shape);
                    l.TextLocY = VsdxUtils.convertDouble(shape.TxtLocPinY, shape);
                    l.TextX = SchemeUtils.inchToMM(l.TextPinX - l.TextLocX) + 0.5 * l.TextWidth;
                    l.TextY = SchemeUtils.inchToMM(l.TextPinY - l.TextLocY) + 0.5 * l.TextHeight;
                } else {
                    l.TextX = 0.5 * l.Size.X;
                    l.TextY = 0.5 * l.Size.Y;
                }
                Predicate<Boolean> CheckTextInscribe = wrongTextSize -> {
                    BaseGraphic.RealPoint s;
                    BaseGraphic.RealPoint realPoint = s = l.IsSingle ? parentSize : l.Size;
                    if (Boolean.TRUE.equals(wrongTextSize) ? l.TextWidth != s.X : Math.abs(l.TextWidth - s.X) > TEXT_INSCRIBE_TOL * s.X || Math.abs(l.TextHeight - s.Y) > TEXT_INSCRIBE_TOL * s.Y) {
                        return false;
                    }
                    return !(Math.abs(l.TextX - 0.5 * s.X) > 0.5 * TEXT_INSCRIBE_TOL * s.X) && !(Math.abs(l.TextY - 0.5 * s.Y) > 0.5 * TEXT_INSCRIBE_TOL * s.Y);
                };
                Color shapeTextBkgnd = null;
                if (shape.TextBkgnd != null && !shape.TextBkgnd.isEmpty() && !"0".equals(shape.TextBkgnd)) {
                    if (shape.TextBkgnd.startsWith("#")) {
                        shapeTextBkgnd = Color.decode(shape.TextBkgnd);
                    } else {
                        String colorKey = Integer.toString(Integer.parseInt(shape.TextBkgnd) - 1);
                        if (shape.vsdx.documentColors != null && shape.vsdx.documentColors.containsKey(colorKey)) {
                            shapeTextBkgnd = Color.decode(shape.vsdx.documentColors.get(colorKey));
                        } else if (Vsdx.VSDX_SYS_COLORS.containsKey(colorKey)) {
                            shapeTextBkgnd = Color.decode(Vsdx.VSDX_SYS_COLORS.get(colorKey));
                        }
                    }
                }
                if (shapeTextBkgnd != null && SchemeUtils.isEqualOrMore(transparency2 = VsdxUtils.convertDouble(shape.TextBkgndTrans, shape), 100.0, 0.1)) {
                    shapeTextBkgnd = null;
                }
                Color fontBgColor = shapeTextBkgnd == null ? null : shapeTextBkgnd;
                Consumer<Void> SetTextBlockProps = p -> {
                    double currentScale;
                    VsdxTabs.VsdxTab tab = shape.findTabByIndex("0");
                    double d = currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
                    if (tab != null) {
                        l.Par.TabStopPosition = currentScale * VsdxReader.inchToMM(tab.Position, shape);
                    } else if (!SchemeUtils.isEmpty(shape.DefaultTabStop)) {
                        l.Par.TabStopPosition = currentScale * VsdxReader.inchToMM(shape.DefaultTabStop, shape);
                    }
                    if (!SchemeUtils.isEmpty(shape.LeftMargin)) {
                        l.Par.LeftMargin = currentScale * VsdxReader.inchToMM(shape.LeftMargin, shape);
                    }
                    if (!SchemeUtils.isEmpty(shape.TopMargin)) {
                        l.Par.TopMargin = currentScale * VsdxReader.inchToMM(shape.TopMargin, shape);
                    }
                    if (!SchemeUtils.isEmpty(shape.RightMargin)) {
                        l.Par.RightMargin = currentScale * VsdxReader.inchToMM(shape.RightMargin, shape);
                    }
                    if (!SchemeUtils.isEmpty(shape.BottomMargin)) {
                        l.Par.BottomMargin = currentScale * VsdxReader.inchToMM(shape.BottomMargin, shape);
                    }
                };
                Consumer<Boolean> SetLines = forInscribe -> {
                    if (!(l.Empty || l.Att == null && strings.size() <= 1)) {
                        Paragraph.setMLineText(l.Par, strings, false, 0.0, false, true);
                        l.Par.freshSides();
                    } else {
                        l.Par.setText(l.Text);
                        if (!forInscribe.booleanValue()) {
                            l.Par.genDistRadius(true);
                        }
                    }
                    SetTextBlockProps.accept(null);
                };
                BooleanSupplier SetVsdxLines = () -> {
                    VsdxParagraph curParagraph;
                    VsdxCharacter curCharacter;
                    List<VsdxShape.VsdxTextPart> parts = shape.getTextParts();
                    if (parts == null || parts.isEmpty()) {
                        return false;
                    }
                    if (parts.size() < 2 && fontBgColor == null) {
                        VsdxShape.VsdxTextPart part = parts.get(0);
                        assert (part != null);
                        curCharacter = null;
                        if (part.cp != null && !part.cp.isEmpty()) {
                            curCharacter = shape.getCharacter(part.cp);
                        }
                        if (curCharacter == null) {
                            curCharacter = shapeCharacter;
                        }
                        assert (curCharacter != null);
                        if (!"1".equals(curCharacter.Pos) && !"2".equals(curCharacter.Pos)) {
                            curParagraph = null;
                            if (part.pp != null && !part.pp.isEmpty()) {
                                curParagraph = shape.getParagraph(part.pp);
                            }
                            if (curParagraph == null) {
                                curParagraph = shapeParagraph;
                            }
                            if (curParagraph == null || SchemeUtils.isEqual(VsdxUtils.convertDouble(curParagraph.IndFirst, shape), 0.0) && SchemeUtils.isEqual(VsdxUtils.convertDouble(curParagraph.IndLeft, shape), 0.0) && SchemeUtils.isEqual(VsdxUtils.convertDouble(curParagraph.IndRight, shape), 0.0) && SchemeUtils.isEqual(VsdxUtils.convertDouble(curParagraph.SpBefore, shape), 0.0) && SchemeUtils.isEqual(VsdxUtils.convertDouble(curParagraph.SpAfter, shape), 0.0)) {
                                return false;
                            }
                        }
                    }
                    if (l.Par.Lines == null) {
                        l.Par.Lines = new Paragraph.Lines();
                    }
                    l.Par.Lines.clear();
                    RectTextLine curLine = null;
                    curCharacter = null;
                    curParagraph = null;
                    double curLineSpacing = 0.0;
                    double curFontHeight = 0.0;
                    String curPP = null;
                    for (VsdxShape.VsdxTextPart part : parts) {
                        double curValue;
                        RectTextLine.PartTextLine lastPart;
                        if (part.cp != null && !part.cp.isEmpty()) {
                            curCharacter = shape.getCharacter(part.cp);
                        }
                        boolean newParagraph = false;
                        if (part.pp != null && !part.pp.isEmpty()) {
                            curParagraph = shape.getParagraph(part.pp);
                            newParagraph = !part.pp.equals(curPP);
                            curPP = part.pp;
                        }
                        if (part.newLine || newParagraph || curLine == null) {
                            curLine = new RectTextLine();
                            curLine.Text = "";
                            l.Par.Lines.add(curLine);
                            if (curParagraph == null) {
                                curParagraph = shapeParagraph;
                            }
                            assert (curParagraph != null);
                            curLine.paragraphLine = new RectTextLine.ParagraphLine();
                            double currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
                            curLine.paragraphLine.firstIndent = currentScale * VsdxReader.inchToMM(curParagraph.IndFirst, shape);
                            curLine.paragraphLine.leftIndent = currentScale * VsdxReader.inchToMM(curParagraph.IndLeft, shape);
                            curLine.paragraphLine.rightIndent = currentScale * VsdxReader.inchToMM(curParagraph.IndRight, shape);
                            curLine.paragraphLine.spaceBefore = currentScale * VsdxReader.inchToMM(curParagraph.SpBefore, shape);
                            curLine.paragraphLine.spaceAfter = currentScale * VsdxReader.inchToMM(curParagraph.SpAfter, shape);
                            curLineSpacing = VsdxUtils.convertDouble(curParagraph.SpLine, shape);
                            if (curLineSpacing < 0.0) {
                                curLine.paragraphLine.lineSpacing = curLineSpacing;
                            }
                            switch (SchemeUtils.convertInt(curParagraph.HorzAlign)) {
                                case 3: {
                                    curLine.paragraphLine.align = (byte)3;
                                    break;
                                }
                                case 0: {
                                    curLine.paragraphLine.align = 0;
                                    break;
                                }
                                case 2: {
                                    curLine.paragraphLine.align = 1;
                                    break;
                                }
                                default: {
                                    curLine.paragraphLine.align = (byte)2;
                                }
                            }
                        }
                        assert (curLine != null);
                        RectTextLine.PartTextLine partLine = new RectTextLine.PartTextLine();
                        if (curCharacter == null) {
                            curCharacter = shapeCharacter;
                        }
                        assert (curCharacter != null);
                        partLine.fontName = curCharacter.Font;
                        curFontHeight = VsdxUtils.convertDouble(curCharacter.Size, shape);
                        double currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
                        partLine.fontHeight = this.roundWithTol(currentScale * SchemeUtils.inchToMM(curFontHeight), 0.1, false);
                        byte lFontStyle = (byte)VsdxUtils.convertDouble(curCharacter.Style, shape);
                        partLine.fontStyle = 0;
                        if ((lFontStyle & 1) == 1) {
                            partLine.fontStyle = (byte)(partLine.fontStyle | 1);
                        }
                        if ((lFontStyle & 2) == 2) {
                            partLine.fontStyle = (byte)(partLine.fontStyle | 2);
                        }
                        if ((lFontStyle & 4) == 4) {
                            partLine.fontStyle = (byte)(partLine.fontStyle | 4);
                        }
                        if ("1".equals(curCharacter.DoubleULine)) {
                            partLine.fontStyle = (byte)(partLine.fontStyle | 4);
                        }
                        if ("1".equals(curCharacter.Strikethru) || "1".equals(curCharacter.DoubleStrikethrough)) {
                            partLine.fontStyle = (byte)(partLine.fontStyle | 8);
                        }
                        if ("1".equals(curCharacter.Pos)) {
                            partLine.ssScript = (byte)2;
                        } else if ("2".equals(curCharacter.Pos)) {
                            partLine.ssScript = 1;
                        }
                        partLine.fontColor = shape.parseColor(curCharacter.Color);
                        if (partLine.fontColor == null) {
                            PhxLayer curLayer = this.layers.get(this.currentLayerID);
                            partLine.fontColor = curLayer == null ? null : curLayer.bColor;
                        }
                        SetTextBlockProps.accept(null);
                        curLine.Text = curLine.Text + curCharacter.applyCase(part.text);
                        partLine.fontBgColor = fontBgColor;
                        RectTextLine.PartTextLine partTextLine = lastPart = curLine.Parts.isEmpty() ? null : curLine.Parts.get(curLine.Parts.size() - 1);
                        if (lastPart != null && partLine.sameFont(lastPart) && !"\t".equals(lastPart.text) && !"\t".equals(part.text)) {
                            lastPart.text = lastPart.text + curCharacter.applyCase(part.text);
                            continue;
                        }
                        partLine.text = curCharacter.applyCase(part.text);
                        curLine.Parts.add(partLine);
                        if (!(curLineSpacing > 0.0) || !(curFontHeight > 0.0) || !((curValue = -curLineSpacing / curFontHeight) < curLine.paragraphLine.lineSpacing)) continue;
                        curLine.paragraphLine.lineSpacing = curValue;
                    }
                    l.Par.Lines.applyFontToLines();
                    return true;
                };
                l.FontName = shapeCharacter.Font;
                l.FontSize = VsdxUtils.convertDouble(shapeCharacter.Size, shape);
                l.FontStyle = (byte)VsdxUtils.convertDouble(shapeCharacter.Style, shape);
                l.fStyle = 0;
                if ((l.FontStyle & 1) == 1) {
                    l.fStyle = (byte)(l.fStyle | 1);
                }
                if ((l.FontStyle & 2) == 2) {
                    l.fStyle = (byte)(l.fStyle | 2);
                }
                if ((l.FontStyle & 4) == 4) {
                    l.fStyle = (byte)(l.fStyle | 4);
                }
                if ("1".equals(shapeCharacter.Strikethru)) {
                    l.fStyle = (byte)(l.fStyle | 8);
                }
                l.FontScale = VsdxUtils.convertDouble(shapeCharacter.FontScale, shape);
                l.FontColor = this.currentLayerColor ? null : shape.parseColor(shapeCharacter.Color);
                assert (shapeParagraph != null);
                l.HorzAlign = SchemeUtils.convertInt(shapeParagraph.HorzAlign);
                l.VertAlign = SchemeUtils.convertInt(shape.VerticalAlign);
                l.IsSingle = singleText && !local;
                boolean bl2 = l.CalcTextPos = l.IsRoot || l.Att == null || !canInscribe;
                if (l.IsTextTransformRow) {
                    if (!l.CalcTextPos) {
                        l.CalcTextPos = shape.hasControlSection;
                    }
                    if (!l.CalcTextPos) {
                        boolean bl3 = l.CalcTextPos = !CheckTextInscribe.test(asPar);
                    }
                    if (!l.CalcTextPos) {
                        l.CalcTextPos = parent != null && parent.TransProps != null && (!SchemeUtils.isEqual(parent.TransProps.CenterX, 0.0) || !SchemeUtils.isEqual(parent.TransProps.CenterY, 0.0));
                    }
                }
                boolean bl4 = asTextShape = textBg != null;
                if (asTextShape && (l.CalcTextPos || l.Att == null || "Callout".equals(shape.msvStructureType)) && l.IsSingle && !l.IsTextTransformRow) {
                    asTextShape = false;
                }
                if (!asPar) {
                    l.Att = asTextShape ? new EmbeddedText() : new AttributeDef();
                    l.Att.setCaption("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 " + this.getNextAttIdx(parent));
                    l.Par = l.Att;
                } else {
                    l.Par = asTextShape ? new EmbeddedText() : new Paragraph();
                    l.Att = null;
                }
                l.Par.AutoSize = false;
                l.Par.setEngine(this.engine);
                l.Par.ID = Core.generateId();
                if (shape.avesID == 0.0) {
                    shape.avesID = l.Par.ID;
                }
                VsdxReader.convertEffects(shape, l.Par);
                this.pageShapes.put(l.Par.ID, l.Par);
                double currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
                l.FontHeight = this.roundWithTol(currentScale * SchemeUtils.inchToMM(l.FontSize), 0.1, false);
                if (l.FontHeight > 0.0) {
                    l.Par.lfHeight = l.FontHeight;
                }
                if (l.FontScale >= 0.01 && l.FontScale <= 6.0) {
                    l.Par.WidthScale = l.FontScale;
                }
                if ((spLine = VsdxUtils.convertDouble(shapeParagraph.SpLine, shape)) < 0.0) {
                    l.Par.LineSpacing = spLine;
                } else if (spLine > 0.0 && l.FontSize > 0.0) {
                    l.Par.LineSpacing = -spLine / l.FontSize;
                }
                l.Par.Lines = new Paragraph.Lines();
                l.Par.Lines.Engine = this.engine;
                if (l.FontName != null) {
                    l.Par.Lines.FontName = l.FontName;
                }
                l.Par.Lines.FontSize = SchemeUtils.inchToPT(l.FontSize);
                l.Par.Lines.FontStyle = l.fStyle;
                l.Par.Lines.FontColor = l.FontColor;
                VsdxCharacter c0 = shape.getCharacter("0");
                if (c0 == null) {
                    c0 = shape.Character;
                }
                if (c0 != null && (transparency = VsdxUtils.convertDouble(c0.ColorTrans, shape)) > 0.0) {
                    l.Par.TransparentText = (int)(255.0 * transparency);
                }
                switch (l.HorzAlign) {
                    case 3: {
                        l.Par.Align = (byte)3;
                        break;
                    }
                    case 0: {
                        l.Par.Align = 0;
                        break;
                    }
                    case 2: {
                        l.Par.Align = 1;
                        break;
                    }
                    default: {
                        l.Par.Align = (byte)2;
                    }
                }
                switch (l.VertAlign) {
                    case 0: {
                        l.Par.VertAlign = 0;
                        break;
                    }
                    case 2: {
                        l.Par.VertAlign = 1;
                        break;
                    }
                    default: {
                        l.Par.VertAlign = 2;
                    }
                }
                if (l.Att != null) {
                    l.Att.setInvisible(shape.isHideText());
                }
                l.Par.LayerID = this.currentLayerID;
                boolean bl5 = l.IsRoot = parent == null;
                if (l.IsRoot && !asTextShape) {
                    int bgType = l.Att == null ? 223 : 225;
                    l.SchemeObject = new SchemeObject(l.Par.ID, bgType);
                    l.SchemeObject.setOrder(this.orderIndex++);
                } else if (asTextShape) {
                    assert (textBg != null);
                    assert (l.Par instanceof EmbeddedText);
                    textBg.EmbeddedText = (EmbeddedText)l.Par;
                } else {
                    assert (parent != null);
                    if (parent.Objects == null) {
                        parent.Objects = new ArrayList();
                    }
                    parent.Objects.add(l.Par);
                }
                boolean bl6 = hasRelationships = shape.Relationships != null && !shape.Relationships.isEmpty();
                if (l.Att == null && hasRelationships && !this.containerObjects.containsKey(shape.ID)) {
                    this.containerObjects.put(shape.ID, l.Par);
                    this.containerObjectsByName.put(shape.Name, l.Par);
                }
                try {
                    boolean hasTransform = false;
                    if (l.CalcTextPos || l.Att == null || "Callout".equals(shape.msvStructureType)) {
                        if (!SetVsdxLines.getAsBoolean()) {
                            SetLines.accept(false);
                        }
                        l.Par.SideX = l.TextWidth;
                        l.Par.SideY = l.TextHeight;
                        l.CenterShift = new BaseGraphic.RealPoint();
                        if (l.IsSingle && !l.IsTextTransformRow) {
                            VsdxReader.transformBG(shape, l.Par, l.Size, parentSize, l.CenterShift);
                        } else {
                            boolean attrAndHasGeometry;
                            BaseGraphic.RealPoint pin = shape.getPin();
                            BaseGraphic.RealPoint locPin = shape.getLocPin();
                            BaseGraphic.RealPoint size = shape.getShapeSize();
                            double shapeAngle = VsdxUtils.convertDouble(shape.Angle, shape);
                            boolean flipX = shape.isFlipX();
                            boolean flipY = shape.isFlipY();
                            BaseGraphic.RealPoint txtPin = shape.getTxtPin();
                            BaseGraphic.RealPoint txtLocPin = shape.getTxtLocPin();
                            BaseGraphic.RealPoint txtSize = shape.getTxtSize();
                            double angle = VsdxUtils.convertDouble(shape.TxtAngle, shape);
                            boolean asParOrSingle = asPar || l.IsSingle;
                            boolean hasShapeAngle = !SchemeUtils.isEqual(shapeAngle, 0.0);
                            boolean hasTxtAngle = !SchemeUtils.isEqual(angle, 0.0);
                            hasTransform = l.IsTextTransformRow && (!SchemeUtils.isEqual(pin, txtPin) || !SchemeUtils.isEqual(locPin, txtLocPin) || !SchemeUtils.isEqual(size, txtSize));
                            hasTransform = hasTransform && (hasShapeAngle || hasTxtAngle);
                            boolean hasParentAngle = parent != null && parent.TransProps != null && !SchemeUtils.isEqual(parent.TransProps.Angle, 0.0);
                            boolean bl7 = attrAndHasGeometry = !asPar && shape.getVisiblePaths().size() > 0 && l.IsTextTransformRow;
                            if (hasTransform) {
                                BaseGraphic.RealPoint txtP = new BaseGraphic.RealPoint(txtSize.X / 2.0, txtSize.Y / 2.0);
                                txtP.X += SchemeUtils.mmToInch(l.CenterShift.X);
                                txtP.Y -= SchemeUtils.mmToInch(l.CenterShift.Y);
                                BaseGraphic.RealPoint txtP1 = this.transformPoint(txtPin, txtLocPin, angle, false, false, txtP);
                                if (asParOrSingle) {
                                    txtP1.Y = -txtP1.Y;
                                    txtP1 = this.transformPoint(pin, locPin, shapeAngle, flipX, flipY, txtP1);
                                } else {
                                    BaseGraphic.RealRect rect;
                                    if (attrAndHasGeometry && parent != null && (rect = shape.calcGeometriesRect()) != null) {
                                        parent.minMaxPt(true, true);
                                        double parentW = SchemeUtils.mmToInch(parent.MaxPtX - parent.MinPtX);
                                        double shiftX = (size.X - parentW) / 2.0 - rect.Left;
                                        txtP1.X += shiftX;
                                        double rectCY = (rect.Top + rect.Bottom) / 2.0;
                                        double shiftY = Math.abs(rectCY);
                                        txtP1.Y = rectCY < 0.0 ? txtP1.Y + (shiftY < 0.0 ? -Math.abs(shiftY) : Math.abs(shiftY -= size.Y / 2.0)) : (txtP1.Y -= Math.abs(shiftY += size.Y / 2.0));
                                    }
                                    txtP1.X -= size.X / 2.0;
                                    if (!SchemeUtils.isEqual(size.Y, 0.0)) {
                                        txtP1.Y += size.Y / 2.0;
                                    }
                                }
                                l.Par.OrgX = SchemeUtils.inchToMM(txtP1.X);
                                l.Par.OrgY = SchemeUtils.inchToMM(txtP1.Y);
                                if (parentSize != null) {
                                    l.Par.OrgX += -0.5 * parentSize.X;
                                    l.Par.OrgY += 0.5 * parentSize.Y;
                                }
                                if (l.Par.TransProps == null) {
                                    l.Par.TransProps = new TransformProps();
                                }
                                l.Par.TransProps.CenterX = 0.0;
                                l.Par.TransProps.CenterY = 0.0;
                                int signAngle = 1;
                                if (flipX ^ flipY) {
                                    signAngle = -1;
                                }
                                l.Par.TransProps.Angle = asParOrSingle || !hasParentAngle ? SchemeUtils.convertAngle(angle * (double)signAngle + shapeAngle) : SchemeUtils.convertAngle((double)signAngle * angle);
                            } else {
                                l.LocPinX = VsdxReader.inchToMM(shape.LocPinX, shape);
                                l.LocPinY = VsdxReader.inchToMM(shape.LocPinY, shape);
                                l.PinX = 0.0;
                                l.PinY = 0.0;
                                l.ParentCenter = new BaseGraphic.RealPoint();
                                if (!local) {
                                    l.PinX = VsdxReader.inchToMM(shape.PinX, shape);
                                    l.PinY = VsdxReader.inchToMM(shape.PinY, shape);
                                }
                                if (!l.IsRoot) {
                                    assert (parent != null);
                                    l.ParentCenter = parent.TransProps == null ? new BaseGraphic.RealPoint() : new BaseGraphic.RealPoint(parent.TransProps.CenterX, parent.TransProps.CenterY);
                                }
                                int signAngle = 1;
                                if (flipX ^ flipY) {
                                    signAngle = -1;
                                }
                                l.Angle = asParOrSingle || !hasParentAngle ? SchemeUtils.convertAngle(angle * (double)signAngle + shapeAngle) : SchemeUtils.convertAngle((double)signAngle * angle);
                                l.Center = new BaseGraphic.RealPoint(l.CenterShift);
                                if (l.Par.TransProps == null) {
                                    l.Par.TransProps = new TransformProps();
                                }
                                if (Math.abs(l.Angle) < BaseGraphic.FloatTolerance) {
                                    l.Center = new BaseGraphic.RealPoint(l.Center.X + l.Par.TransProps.CenterX, l.Center.Y + l.Par.TransProps.CenterY);
                                }
                                l.Par.OrgX = l.PinX - l.LocPinX + l.TextX - 0.5 * parentSize.X - l.ParentCenter.X - l.Center.X - blockShift.X;
                                l.Par.OrgY = -(l.PinY - l.LocPinY + l.TextY - 0.5 * parentSize.Y) - l.ParentCenter.Y - l.Center.Y - blockShift.Y;
                                if (shape.isFlipY() && !asTextShape) {
                                    l.Par.OrgY += l.TextHeight;
                                }
                                if (l.Par.TransProps.CenterX != l.Center.X || l.Par.TransProps.CenterY != l.Center.Y) {
                                    l.Par.TransProps.CenterX = l.Center.X;
                                    l.Par.TransProps.CenterY = l.Center.Y;
                                }
                                if (l.Par.TransProps.Angle != l.Angle) {
                                    l.Par.TransProps.Angle = l.Angle;
                                }
                            }
                        }
                    } else {
                        l.Att.Inscribe = true;
                        if (!SetVsdxLines.getAsBoolean()) {
                            SetLines.accept(false);
                        }
                        l.Par.SideX = l.TextWidth;
                        l.Par.SideY = l.TextHeight;
                        double angle = VsdxUtils.convertDouble(shape.TxtAngle, shape);
                        if (!SchemeUtils.isEqual(angle, 0.0)) {
                            boolean flipX = shape.isFlipX();
                            boolean flipY = shape.isFlipY();
                            int signAngle = 1;
                            if (flipX ^ flipY) {
                                signAngle = -1;
                            }
                            if (l.Par.TransProps == null) {
                                l.Par.TransProps = new TransformProps();
                            }
                            l.Par.TransProps.Angle = SchemeUtils.convertAngle((double)signAngle * angle);
                            l.Att.Inscribe = false;
                        }
                    }
                    if (asTextShape) {
                        assert (textBg != null);
                        if (asPar || !textBg.equals(parent)) {
                            textBg.EmbeddedText.OrgX -= textBg.OrgX;
                            textBg.EmbeddedText.OrgY -= textBg.OrgY;
                            if (textBg.TransProps != null) {
                                if (textBg.EmbeddedText.TransProps == null) {
                                    textBg.EmbeddedText.TransProps = new TransformProps();
                                }
                                double shapeAngle = VsdxReader.convertAngle(shape.Angle, shape);
                                textBg.EmbeddedText.TransProps.Angle -= shapeAngle;
                                BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint(textBg.TransProps.CenterX, textBg.TransProps.CenterY);
                                if (hasTransform) {
                                    p2 = SchemeUtils.rotatePoint(p2.X, p2.Y, shapeAngle);
                                }
                                textBg.EmbeddedText.OrgX -= p2.X;
                                textBg.EmbeddedText.OrgY -= p2.Y;
                            }
                        }
                    }
                    if (!shape.InvalidConverting) break block101;
                    if (parent == null || parent.Objects == null) break block102;
                    parent.Objects.remove(l.Par);
                }
                catch (Throwable throwable) {
                    if (shape.InvalidConverting) {
                        if (parent != null && parent.Objects != null) {
                            parent.Objects.remove(l.Par);
                        }
                    } else {
                        if (l.IsRoot && l.SchemeObject != null) {
                            this.pageObjects.add(l.SchemeObject);
                        }
                        if (asPar || shape.getVisiblePaths().empty()) {
                            this.convertGluePoints(shape, l.Par, parent == null, false);
                        }
                        if (!local) {
                            DoubleList entry = this.visioShapesHash.get(shape.ID);
                            if (entry == null) {
                                entry = new DoubleList(2);
                                this.visioShapesHash.put(shape.ID, entry);
                            }
                            entry.add(l.Par.ID);
                        }
                    }
                    throw throwable;
                }
                break block102;
            }
            if (l.IsRoot && l.SchemeObject != null) {
                this.pageObjects.add(l.SchemeObject);
            }
            if (asPar || shape.getVisiblePaths().empty()) {
                this.convertGluePoints(shape, l.Par, parent == null, false);
            }
            if (!local) {
                DoubleList entry = this.visioShapesHash.get(shape.ID);
                if (entry == null) {
                    entry = new DoubleList(2);
                    this.visioShapesHash.put(shape.ID, entry);
                }
                entry.add(l.Par.ID);
            }
        }
    }

    private void addTextToMaster(VsdxShape shape, GraphicBlock parent) {
        BaseGraphic bg;
        if (shape == null || parent == null || parent.Objects == null || parent.Objects.isEmpty()) {
            return;
        }
        if (shape.InvalidConverting) {
            return;
        }
        for (BaseGraphic bg2 : parent.Objects) {
            if (!(bg2 instanceof AttributeDef)) continue;
            return;
        }
        if (parent.Objects.size() == 1 && (bg = parent.Objects.get(0)) instanceof Polyline && !(bg instanceof Polygon) && !(bg instanceof Region) && ((Polyline)bg).getVerticesCount() <= 4) {
            return;
        }
        AttributeDef lAtt = new AttributeDef();
        VsdxCharacter shapeCharacter = shape.getCharacter(shape.PreferredCharacterIX);
        String lFontName = shapeCharacter.Font;
        double lFontSize = VsdxUtils.convertDouble(shapeCharacter.Size, shape);
        byte lFontStyle = (byte)VsdxUtils.convertDouble(shapeCharacter.Style, shape);
        byte lfStyle = 0;
        if ((lFontStyle & 1) == 1) {
            lfStyle = (byte)(lfStyle | 1);
        }
        if ((lFontStyle & 2) == 2) {
            lfStyle = (byte)(lfStyle | 2);
        }
        if ((lFontStyle & 4) == 4) {
            lfStyle = (byte)(lfStyle | 4);
        }
        if ("1".equals(shapeCharacter.Strikethru)) {
            lfStyle = (byte)(lfStyle | 8);
        }
        double lFontScale = VsdxUtils.convertDouble(shapeCharacter.FontScale, shape);
        Color lFontColor = this.currentLayerColor ? null : shape.parseColor(shapeCharacter.Color);
        lAtt.setCaption("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 1");
        lAtt.setEngine(this.engine);
        lAtt.ID = Core.generateId();
        double currentScale = this.isEmbeddingsVsdx ? this.koefScale : this.currentPageScale;
        double lFontHeight = this.roundWithTol(currentScale * SchemeUtils.inchToMM(lFontSize), 0.1, false);
        if (lFontHeight > 0.0) {
            lAtt.lfHeight = lFontHeight;
        }
        if (lFontScale >= 0.01 && lFontScale <= 6.0) {
            lAtt.WidthScale = lFontScale;
        }
        lAtt.Lines = new Paragraph.Lines();
        lAtt.Lines.Engine = this.engine;
        if (lFontName != null) {
            lAtt.Lines.FontName = lFontName;
        }
        lAtt.Lines.FontSize = SchemeUtils.inchToPT(lFontSize);
        lAtt.Lines.FontStyle = lfStyle;
        lAtt.Lines.FontColor = lFontColor;
        lAtt.Align = (byte)2;
        lAtt.LayerID = this.currentLayerID;
        boolean isTextTransformRow = shape.hasTextTransform();
        BaseGraphic.RealPoint lSize = shape.getShapeSizeMM();
        BaseGraphic.RealPoint lTextSize = isTextTransformRow ? new BaseGraphic.RealPoint(VsdxReader.inchToMM(shape.TxtWidth, shape), VsdxReader.inchToMM(shape.TxtHeight, shape)) : new BaseGraphic.RealPoint(lSize);
        RectTextLine line = new RectTextLine();
        line.Text = " ";
        lAtt.Lines.add(line);
        lAtt.Lines.applyFontToLines();
        double lAttSideY = lAtt.WidthScale * (lAtt.lfHeight > 0.0 ? 1.3 * lAtt.lfHeight : 5.0);
        line.SideX = lAtt.SideX = lAttSideY / 2.0;
        line.SideY = lAtt.SideY;
        if (isTextTransformRow) {
            lAtt.genDistRadius(true);
            double lTextPinX = VsdxUtils.convertDouble(shape.TxtPinX, shape);
            double lTextPinY = VsdxUtils.convertDouble(shape.TxtPinY, shape);
            double lTextLocX = VsdxUtils.convertDouble(shape.TxtLocPinX, shape);
            double lTextLocY = VsdxUtils.convertDouble(shape.TxtLocPinY, shape);
            double lTextX = SchemeUtils.inchToMM(lTextPinX - lTextLocX) + 0.5 * lTextSize.X;
            double lTextY = SchemeUtils.inchToMM(lTextPinY - lTextLocY) + 0.5 * lTextSize.Y;
            VsdxUtils.VsdxTransformProps props = VsdxUtils.getTransformPropsMM(shape, lSize, null, false);
            AffineTransform TM = props.genTransform(true, true, true, true);
            double[] pt = new double[]{lTextX - 0.5 * lSize.X, -lTextY + 0.5 * lSize.Y};
            pt = SchemeEngine.MulPointsTM(TM, pt);
            pt[0] = pt[0] - parent.OrgX;
            pt[1] = pt[1] - parent.OrgY;
            BiPredicate<Double, Double> SnapToParent = (PtX, PtY) -> {
                double lOrgY;
                int lAxis = (int)(Math.round(props.Angle / 90.0) % 4L);
                lAtt.OrgX = PtX;
                boolean lHorz = lAxis == 0 || lAxis == 2;
                double lMinPtX = parent.MinPtX;
                double lMinPtY = parent.MinPtY;
                double lMaxPtX = parent.MaxPtX;
                double lMaxPtY = parent.MaxPtY;
                double lSidesX = lMaxPtX - lMinPtX;
                double lSidesY = lMaxPtY - lMinPtY;
                if (lHorz) {
                    double tol = 1.0E-6;
                    if (tol + Math.abs(PtY) < 0.5 * lSidesY && tol + lAttSideY < lSidesY && tol + lAttSideY < lSidesX) {
                        return false;
                    }
                    double d = lOrgY = PtY < 0.0 ? -0.5 * lSidesY - lAttSideY : 0.5 * lSidesY;
                    if (lAxis == 2) {
                        lOrgY += lAttSideY;
                    }
                } else {
                    lOrgY = 0.5 * lAtt.SideX;
                    if (lAxis == 1) {
                        lOrgY = -lOrgY;
                    }
                }
                lAtt.OrgY = lOrgY;
                if (lAxis != 0) {
                    if (lAtt.TransProps == null) {
                        lAtt.TransProps = new TransformProps();
                    }
                    lAtt.TransProps.Angle = lAxis * 90;
                }
                return true;
            };
            if (!SnapToParent.test(pt[0], pt[1])) {
                lAtt.Inscribe = true;
            }
        } else {
            lAtt.Inscribe = true;
        }
        if (lAtt.Inscribe) {
            lAtt.AutoSize = false;
        }
        parent.Objects.add(lAtt);
    }

    private static BufferedImage getTransformedImage(BufferedImage image, double scaleX, double scaleY, double tX, double tY) {
        if (image == null) {
            return null;
        }
        AffineTransform transform = new AffineTransform();
        if (scaleX != 1.0 || scaleY != 1.0) {
            transform.scale(scaleX, scaleY);
        }
        if (tX != 0.0 || tY != 0.0) {
            transform.translate(tX, tY);
        }
        AffineTransformOp op = new AffineTransformOp(transform, 2);
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        op.filter(image, result);
        return result;
    }

    private PhxImage convertBitmapShape(VsdxShape shape, BaseGraphic.RealPoint sizeShape) {
        String message;
        boolean needTransform;
        if (shape == null || shape.foreignData == null) {
            return null;
        }
        byte[] bytes = shape.foreignData.getRawData();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        double imgWidth = VsdxReader.inchToMM(shape.ImgWidth, shape);
        double imgHeight = VsdxReader.inchToMM(shape.ImgHeight, shape);
        if (imgWidth == 0.0 || imgHeight == 0.0) {
            return null;
        }
        double imgOffsetX = VsdxReader.inchToMM(shape.ImgOffsetX, shape);
        double imgOffsetY = VsdxReader.inchToMM(shape.ImgOffsetY, shape);
        assert (sizeShape != null);
        BiPredicate<Double, Double> IsEqual = (v1, v2) -> Double.compare(v1, v2) == 0;
        PhxImage image = new PhxImage();
        image.setEngine(this.engine);
        boolean bl = needTransform = !IsEqual.test(sizeShape.X, 0.0) && !IsEqual.test(sizeShape.Y, 0.0) && !IsEqual.test(imgWidth, 0.0) && !IsEqual.test(imgHeight, 0.0) && (!IsEqual.test(imgWidth, sizeShape.X) || !IsEqual.test(imgHeight, sizeShape.Y) || IsEqual.test(imgWidth, sizeShape.X) && !IsEqual.test(imgOffsetX, 0.0) || IsEqual.test(imgHeight, sizeShape.Y) && !IsEqual.test(imgOffsetY, 0.0));
        if (!needTransform) {
            String imageType = shape.foreignData.hasAttribute("CompressionType") ? shape.foreignData.getAttribute("CompressionType") : "BMP";
            boolean bl2 = image.StoreImage = "JPEG".equalsIgnoreCase(imageType) || "JPG".equalsIgnoreCase(imageType) || "PNG".equalsIgnoreCase(imageType);
            if (image.StoreImage) {
                image.Content = bytes;
            }
        }
        BufferedImage bmp = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            bmp = ImageIO.read(inputStream);
        }
        catch (IOException ex) {
            message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438";
            Core.logger.error(message, ex);
            this.putStateLog(message + ": " + ex.getMessage());
        }
        if (bmp == null) {
            return null;
        }
        bmp = SchemeUtils.transformImageToABGR(bmp);
        if (needTransform) {
            if (imgOffsetX < 0.0) {
                image.LeftCropPercentage = -imgOffsetX / imgWidth;
            }
            if (sizeShape.X - imgOffsetX < imgWidth) {
                image.RightCropPercentage = 1.0 - (sizeShape.X - imgOffsetX) / imgWidth;
            }
            if (imgOffsetX > 0.0) {
                sizeShape.X -= imgOffsetX;
                image.OrgX += imgOffsetX;
                if (sizeShape.X > imgWidth) {
                    sizeShape.X = imgWidth;
                }
            } else if (sizeShape.X - imgOffsetX > imgWidth) {
                sizeShape.X = imgWidth + imgOffsetX;
            }
            if (imgOffsetY < 0.0) {
                image.BottomCropPercentage = -imgOffsetY / imgHeight;
            }
            if (sizeShape.Y - imgOffsetY < imgHeight) {
                image.TopCropPercentage = 1.0 - (sizeShape.Y - imgOffsetY) / imgHeight;
            }
            if (imgOffsetY > 0.0) {
                sizeShape.Y -= imgOffsetY;
                image.OrgY -= imgOffsetY;
                if (sizeShape.Y > imgHeight) {
                    sizeShape.Y = imgHeight;
                }
            } else if (sizeShape.Y - imgOffsetY > imgHeight) {
                sizeShape.Y = imgHeight + imgOffsetY;
            }
        }
        if (bmp != null) {
            image.Bmp = SchemeUtils.getImagePixels24(bmp);
            image.BmpHeight = bmp.getHeight();
            image.BmpWidth = bmp.getWidth();
            if (image.Bmp != null) {
                image.ImageSize = image.Bmp.length;
            }
            if (image.Content == null) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)bmp, "PNG", outputStream);
                    outputStream.flush();
                    image.Content = outputStream.toByteArray();
                    image.StoreImage = image.Content.length > 0;
                }
                catch (Exception ex) {
                    message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0438";
                    Core.logger.error(message, ex);
                    this.putStateLog(message + ": " + ex.getMessage());
                }
            }
        }
        image.SideX = sizeShape.X;
        image.SideY = sizeShape.Y;
        image.initClipPoints();
        return image;
    }

    private BufferedImage correctShiftCut(BufferedImage image, int offX, int offY, int cutW, int cutH) {
        if (image == null) {
            return null;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        if (offX >= 0 && offY >= 0 && w >= cutW && h >= cutH) {
            return image;
        }
        int[] imgPixels = image.getRGB(0, 0, w, h, null, 0, w);
        int[] pixels = new int[cutW * cutH];
        Arrays.fill(pixels, -1);
        BufferedImage result = new BufferedImage(cutW, cutH, image.getType());
        int shiftX = offX < 0 ? -offX : 0;
        int shiftY = offY < 0 ? -offY : 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                pixels[(y + shiftY) * cutW + x + shiftX] = imgPixels[y * w + x];
            }
        }
        result.setRGB(0, 0, cutW, cutH, pixels, 0, cutW);
        return result;
    }

    private void rotateWithoutChildren(GraphicBlock block, double angle) {
        int cnt;
        if (angle == 0.0) {
            return;
        }
        assert (block != null);
        BiFunction<BaseGraphic.RealPoint, Double, BaseGraphic.RealPoint> rotatePoint = (p, a) -> {
            double x = p.X;
            double y = p.Y;
            double modV = Math.sqrt(x * x + y * y);
            double angV = Math.abs(x) <= BaseGraphic.FloatTolerance ? (y >= 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan(y / Math.abs(x));
            if (x < 0.0) {
                angV = Math.PI - angV;
            }
            x = modV * Math.cos(angV += a * Math.PI / 180.0);
            y = modV * Math.sin(angV);
            return new BaseGraphic.RealPoint(x, y);
        };
        if (block.TransProps == null) {
            block.TransProps = new TransformProps();
        }
        int n = cnt = block.Objects == null ? 0 : block.Objects.size();
        for (int i = 0; i < cnt; ++i) {
            BaseGraphic obj = block.Objects.get(i);
            if (obj.TransProps == null) {
                obj.TransProps = new TransformProps();
            }
            obj.TransProps.Angle -= angle;
            if (!(Math.abs(obj.OrgX) > BaseGraphic.FloatTolerance) && !(Math.abs(obj.OrgY) > BaseGraphic.FloatTolerance)) continue;
            BaseGraphic.RealPoint p2 = rotatePoint.apply(new BaseGraphic.RealPoint(obj.OrgX, obj.OrgY), -angle);
            obj.OrgX = p2.X;
            obj.OrgY = p2.Y;
        }
        block.minMaxPt(false, true);
        block.TransProps.Angle += angle;
    }

    private boolean emptyText(String text) {
        return text == null || text.replaceAll("\\s+", "").isEmpty();
    }

    public static BaseGraphic.RealPoint calcTextSize(Font font, String text) {
        BaseGraphic.RealPoint p = new BaseGraphic.RealPoint();
        if (font != null && text != null && !text.isEmpty()) {
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Rectangle2D stringBounds = font.getStringBounds(text, frc);
            p.X = stringBounds.getWidth();
            p.Y = stringBounds.getHeight();
        }
        return p;
    }

    public void setUserId(double userId) {
        this.userId = userId;
        this.modifiedTime = DateTime.currentDateTime();
    }

    private void updateModifiedInfo(SchemeObject obj) {
        obj.setLastModUser(this.userId);
        obj.setLastModTime(this.modifiedTime);
        obj.setRevision(1);
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    public void setImportHiddenPaths(boolean value) {
        this.importHiddenPaths = value;
    }

    public void setImportFromOldFormat() {
        this.isFromOldFormat = true;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateInstruction(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateInstruction(value);
    }

    private void putStateLog(String value) {
        if (this.stateHost == null) {
            return;
        }
        try {
            this.stateHost.putRequestStateLog(value);
        }
        catch (Exception ex) {
            Core.logger.error("", ex);
        }
    }

    private void putStateProgressMin(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMin(value);
    }

    private void putStateProgressMax(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMax(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    private String printStackTrace(Exception e) {
        assert (e != null);
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        printWriter.flush();
        return writer.toString();
    }

    private void logError(VsdxShape shape, Exception e) {
        if (this.cntErrors >= 0) {
            if (this.cntErrors > 0) {
                Object message = e instanceof NumberFormatException ? "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0432 \u0447\u0438\u0441\u043b\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f Visio" : "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435 \u0444\u0438\u0433\u0443\u0440\u044b";
                message = (String)message + (String)(shape.ID == null || shape.ID.isEmpty() ? ": " : " (Shape ID=" + shape.ID + "): ");
                this.putStateLog((String)message + e.toString());
                Core.logger.error((String)message, e);
            } else {
                String message = "\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0432\u044b\u0432\u043e\u0434\u0430 \u043e\u0448\u0438\u0431\u043e\u043a...\n";
                this.putStateLog(message);
                Core.logger.error(message);
            }
            --this.cntErrors;
        }
    }

    private void transformPrimitive(AffineTransform tm, BaseGraphic bg) {
        assert (tm != null);
        assert (bg != null);
        double[] point = new double[2];
        if (bg instanceof GraphicBlock) {
            GraphicBlock block = (GraphicBlock)bg;
            point[0] = block.MinPtX;
            point[1] = block.MinPtY;
            point = SchemeEngine.MulPointsTM(tm, point);
            block.MinPtX = point[0];
            block.MinPtY = point[1];
            point[0] = block.MaxPtX;
            point[1] = block.MaxPtY;
            point = SchemeEngine.MulPointsTM(tm, point);
            block.MaxPtX = point[0];
            block.MaxPtY = point[1];
        }
        if (bg.GluePoints != null) {
            for (BaseGraphic.GluePoint p : bg.GluePoints) {
                point[0] = p.ptX;
                point[1] = p.ptY;
                point = SchemeEngine.MulPointsTM(tm, point);
                p.ptX = point[0];
                p.ptY = point[1];
            }
        }
    }

    private GraphicBlock convertEmbeddingsVsdx(VsdxShape shape, double layerId) throws Exception {
        assert (shape != null);
        VsdxReader reader = new VsdxReader();
        if (shape.foreignData.getRawFormat() == VsdxForeignData.OleFormat.VSD) {
            reader.isFromOldFormat = true;
        }
        reader.isEmbeddingsVsdx = true;
        return reader.importEmbeddingsVsdx(shape, shape.foreignData.getRawData(), layerId);
    }

    private GraphicBlock importEmbeddingsVsdx(VsdxShape rootShape, byte[] content, double newLayerId) throws Exception {
        VsdxPage p;
        this.contentType = CONTENT_TYPE.VSDX;
        Vsdx vsdx = this.parseVsdx(content, true);
        if (vsdx == null || vsdx.pages == null || vsdx.pages.isEmpty()) {
            return null;
        }
        this.scheme = new Scheme();
        this.engine = new SchemeEngine(this.scheme);
        this.engine.InitTmpProps();
        this.scheme.primInsFlags = 0;
        this.currentPageLayerID = newLayerId;
        String pId = vsdx.currentPage;
        ArrayList<VsdxPage> currentPages = new ArrayList<VsdxPage>();
        while (pId != null && !pId.isEmpty() && (p = vsdx.pageById(pId)) != null) {
            currentPages.add(0, p);
            pId = p.BackPage;
        }
        if (currentPages.isEmpty()) {
            currentPages.add(vsdx.pages.get(0));
        }
        this.createBorderPage((VsdxPage)currentPages.get(currentPages.size() - 1));
        HashSet<String> layerNames = new HashSet<String>();
        this.layers = new HashMap<Double, PhxLayer>();
        this.primsHash = new HashMap<String, Double>();
        this.cntErrors = 100;
        GraphicBlock result = new GraphicBlock();
        result.setEngine(this.engine);
        result.Objects = new ArrayList();
        int generateId = 1000;
        boolean hasScale = false;
        for (VsdxPage page : currentPages) {
            int cnt;
            int j;
            this.visioShapesHash = new HashMap<String, DoubleList>();
            this.pageObjects = new DoubleHash();
            this.pageShapes = new HashMap<Double, BaseGraphic>();
            this.parents = new HashMap<Double, Double>();
            this.containerObjects = new HashMap<String, BaseGraphic>();
            this.containerShapes = new HashMap<String, VsdxShape>();
            double pageScale = VsdxUtils.convertDouble(page.PageScale, null);
            double drawingScale = VsdxUtils.convertDouble(page.DrawingScale, null);
            this.currentPageScale = Math.abs(drawingScale) > BaseGraphic.FloatTolerance && Math.abs(pageScale) > BaseGraphic.FloatTolerance ? Math.abs(drawingScale / pageScale) : 1.0;
            double objectW = rootShape.foreignData.getObjectWidth() * 25.4;
            double objectH = rootShape.foreignData.getObjectHeight() * 25.4;
            if (SchemeUtils.isEqual(objectW, 0.0, 1.0E-6)) {
                objectW = VsdxReader.inchToMM(rootShape.ImgWidth, rootShape);
            }
            if (SchemeUtils.isEqual(objectH, 0.0, 1.0E-6)) {
                objectH = VsdxReader.inchToMM(rootShape.ImgHeight, rootShape);
            }
            BaseGraphic.RealPoint shapeSizeMM = rootShape.getShapeSizeMM();
            if (!SchemeUtils.isEqual(objectW, 0.0, 1.0E-6) && !SchemeUtils.isEqual(shapeSizeMM.X, 0.0, 1.0E-6)) {
                this.koefScaleX = shapeSizeMM.X / objectW;
            }
            if (!SchemeUtils.isEqual(objectH, 0.0, 1.0E-6) && !SchemeUtils.isEqual(shapeSizeMM.Y, 0.0, 1.0E-6)) {
                this.koefScaleY = shapeSizeMM.Y / objectH;
            }
            this.koefScale = Math.min(this.koefScaleX, this.koefScaleY);
            hasScale = !SchemeUtils.isEqual(this.currentPageScale, 1.0, 1.0E-6) && !SchemeUtils.isEqual(this.currentPageScale, 0.0, 1.0E-6);
            double pageId = generateId++;
            double layerId = generateId++;
            this.layerIDs = new HashMap<String, Double>();
            this.layerColors = new HashMap<String, String>();
            this.shapeConnects = new HashMap<String, List<ConnectToInfo>>();
            PhxLayer phxLayer = new PhxLayer();
            phxLayer.ID = layerId;
            String name = VsdxReader.updateName(page.Name, layerNames);
            layerNames.add(name);
            this.layers.put(layerId, phxLayer);
            phxLayer.setCaption(name);
            if (vsdx.styles != null) {
                VsdxStyle textStyle;
                VsdxStyle fillStyle;
                VsdxStyle lineStyle;
                VsdxStyle vsdxStyle = lineStyle = page.LineStyle == null || page.LineStyle.isEmpty() ? null : vsdx.styles.get(page.LineStyle);
                if (lineStyle != null && lineStyle.cellValues != null) {
                    boolean transp = "1".equals(lineStyle.cellValues.get("LineColorTrans"));
                    if (lineStyle.cellValues.containsKey("LinePattern")) {
                        phxLayer.PenPattern = VsdxUtils.convertLineStyle(lineStyle.cellValues.get("LinePattern"), transp);
                    }
                    if (lineStyle.cellValues.containsKey("LineColor")) {
                        phxLayer.pColor = vsdx.parseColor(lineStyle.cellValues.get("LineColor"));
                    }
                    if (lineStyle.cellValues.containsKey("LineWeight")) {
                        phxLayer.lWidth = this.roundWithTol(Math.abs(this.currentPageScale * VsdxReader.inchToMM(lineStyle.cellValues.get("LineWeight"), null)), 0.1, true);
                    }
                }
                VsdxStyle vsdxStyle2 = fillStyle = page.FillStyle == null || page.FillStyle.isEmpty() ? null : vsdx.styles.get(page.FillStyle);
                if (fillStyle != null && fillStyle.cellValues != null) {
                    boolean transp = "1".equals(fillStyle.cellValues.get("FillForegndTrans"));
                    if (fillStyle.cellValues.containsKey("FillPattern")) {
                        phxLayer.BrushPattern = VsdxUtils.convertFillStyle(fillStyle.cellValues.get("FillPattern"), transp);
                    }
                    if (fillStyle.cellValues.containsKey("FillForegnd")) {
                        phxLayer.bColor = vsdx.parseColor(fillStyle.cellValues.get("FillForegnd"));
                    }
                    if (fillStyle.cellValues.containsKey("FillBkgnd")) {
                        phxLayer.BkColor = vsdx.parseColor(fillStyle.cellValues.get("FillBkgnd"));
                    }
                }
                VsdxStyle vsdxStyle3 = textStyle = page.TextStyle == null || page.TextStyle.isEmpty() ? null : vsdx.styles.get(page.TextStyle);
                if (textStyle != null && textStyle.characterValues != null && textStyle.characterValues.containsKey("Color")) {
                    phxLayer.FontColor = vsdx.parseColor(textStyle.characterValues.get("Color"));
                }
            }
            phxLayer.PageId = pageId;
            int countLayers = page.layers == null ? 0 : page.layers.size();
            for (j = 0; j < countLayers; ++j) {
                boolean isPageLayer;
                VsdxLayer layer = page.layers.get(j);
                if (layer.Name == null || layer.Name.isEmpty()) {
                    layer.Name = "Layer Row=" + layer.ID;
                }
                if (isPageLayer = SchemeUtils.isEqual(layer.Name, page.Name)) {
                    layerId = this.currentPageLayerID;
                    phxLayer = this.layers.get(layerId);
                } else {
                    layerId = generateId++;
                    phxLayer = new PhxLayer();
                }
                this.layerIDs.put(layer.ID, layerId);
                this.layerColors.put(layer.ID, layer.Color);
                phxLayer.bColor = phxLayer.pColor = vsdx.parseColor(layer.Color);
                phxLayer.FontColor = phxLayer.pColor;
                phxLayer.BkColor = Color.WHITE;
                phxLayer.Visible = layer.Visible;
                boolean bl = phxLayer.Selectable = !layer.Lock;
                if (isPageLayer) continue;
                double transparency = VsdxUtils.convertDouble(layer.ColorTrans, null);
                if (transparency > 0.0) {
                    phxLayer.TransparentBorder = phxLayer.Transparent = (int)(255.0 * transparency);
                }
                phxLayer.ID = layerId;
                if (pageId > 1.0) {
                    phxLayer.PageId = pageId;
                }
                name = VsdxReader.updateName(layer.Name, layerNames);
                layerNames.add(name);
                this.layers.put(layerId, phxLayer);
                phxLayer.setCaption(name);
            }
            int n = cnt = page.shapes == null ? 0 : page.shapes.size();
            for (j = 0; j < cnt; ++j) {
                VsdxShape shape = page.shapes.get(j);
                if (shape == null) continue;
                VsdxTheme.getTheme(page, shape).ifPresentOrElse(shapeTheme -> {
                    shape.applyStyles(true);
                    int varColor = SchemeUtils.convertInt(page.VariationColorIndex);
                    shapeTheme.applyStyleToShape(shape, varColor);
                }, () -> shape.applyStyles(false));
                try {
                    this.convertVsdxShape(shape, result, true, false, false, 0, new BaseGraphic.RealPoint());
                    continue;
                }
                catch (Exception e) {
                    this.logError(shape, e);
                }
            }
            this.initContainers();
            this.pageShapes.forEach((id, s) -> {
                s.LayerID = newLayerId;
            });
            layerNames.clear();
        }
        result.calcOrgAndAjust(BaseGraphic.NO_POINT, true);
        if (result.TransProps == null) {
            result.TransProps = new TransformProps();
        }
        if (!SchemeUtils.isEqual(this.koefScaleX, 1.0, 1.0E-6)) {
            result.TransProps.ScaleX = this.koefScaleX;
        }
        if (!SchemeUtils.isEqual(this.koefScaleY, 1.0, 1.0E-6)) {
            result.TransProps.ScaleY = this.koefScaleY;
        }
        if (hasScale) {
            result.TransProps.ScaleX /= this.currentPageScale;
            result.TransProps.ScaleY /= this.currentPageScale;
        }
        return result;
    }

    private void createBorderPage(VsdxPage page) {
        if (page == null) {
            return;
        }
        if (page.shapes == null) {
            page.shapes = new ArrayList<VsdxShape>();
        }
        VsdxShape shape = new VsdxShape(page.vsdx, null, page);
        page.shapes.add(shape);
        shape.geometries = new ArrayList<VsdxGeometry>();
        double w = VsdxUtils.convertDouble(page.PageWidth, null);
        double h = VsdxUtils.convertDouble(page.PageHeight, null);
        VsdxGeometry geom = VsdxGeometry.createBorderGeometry(shape, 0.0, 0.0, w, h);
        shape.geometries.add(geom);
        shape.LineColorTrans = "1.0";
    }

    private boolean enableEmbeddedText(BaseGraphic bg, GraphicBlock parent) {
        if (bg == null) {
            return false;
        }
        if (this.currentPrimitiveBlock != null && parent != null && this.currentPrimitiveBlock.ID == parent.ID) {
            return false;
        }
        return !(bg instanceof Paragraph) && (!(bg instanceof GraphicBlock) || ((GraphicBlock)bg).SourceID == 0.0) && !(bg instanceof Container) && !(bg instanceof Table) && !(bg instanceof Dimension) && !(bg instanceof Guide);
    }

    private static class AddGPParams {
        public final boolean polyline;
        public final int vertIdx;
        public final int contactNumber;
        public final double ptX;
        public final double ptY;

        public AddGPParams(boolean polyline, int vertIdx, int contactNumber, double ptX, double ptY) {
            this.polyline = polyline;
            this.vertIdx = vertIdx;
            this.contactNumber = contactNumber;
            this.ptX = ptX;
            this.ptY = ptY;
        }
    }

    private static class AddStyleGlueChildParams {
        public final int shapeType;
        public final BaseGraphic shape;
        public final boolean noFill;
        public final boolean noLine;

        public AddStyleGlueChildParams(BaseGraphic shape, int shapeType, boolean noFill, boolean noLine) {
            this.shape = shape;
            this.shapeType = shapeType;
            this.noFill = noFill;
            this.noLine = noLine;
        }
    }

    public static class AddPolyParams {
        public final Polyline poly;
        public final boolean noFill;
        public final boolean noLine;
        public final BaseGraphic.RealPoints pts;

        public AddPolyParams(Polyline poly, boolean noFill, boolean noLine, BaseGraphic.RealPoints pts) {
            this.poly = poly;
            this.noFill = noFill;
            this.noLine = noLine;
            this.pts = pts;
        }
    }

    private static class ConvertTextLocal {
        String Text;
        String FontName;
        Paragraph Par;
        AttributeDef Att;
        int VertAlign;
        int HorzAlign;
        Color FontColor;
        boolean IsRoot;
        boolean IsSingle;
        boolean Empty;
        double FontSize;
        double FontHeight;
        double FontScale;
        double BlockMargin;
        double TxtBlkLeftMargin;
        double TxtBlkRightMargin;
        double TxtBlkTopMargin;
        double TxtBlkBottomMargin;
        byte FontStyle;
        byte fStyle;
        double PinX;
        double PinY;
        double LocPinX;
        double LocPinY;
        double TextX;
        double TextY;
        double TextPinX;
        double TextPinY;
        double TextLocX;
        double TextLocY;
        double TextWidth;
        double TextHeight;
        double Angle;
        boolean IsTextTransformRow;
        boolean CalcTextPos;
        BaseGraphic.RealPoint ParentCenter;
        BaseGraphic.RealPoint Size;
        BaseGraphic.RealPoint CenterShift;
        BaseGraphic.RealPoint Center;
        SchemeObject SchemeObject;

        private ConvertTextLocal() {
        }
    }

    private static class ConvertShapeLocal {
        ArrayList<BaseGraphic> schemeObjects;
        int AddCount;
        int AddIdx;
        boolean IsPolylines;
        boolean GPDone;
        String ShapeId;
        int FirstShapeIdx;

        private ConvertShapeLocal() {
        }
    }

    private static class ConnectToInfo {
        String shapeTo;
        int gluePointIdx = -1;
        String gluePointName;

        private ConnectToInfo() {
        }

        public static ConnectToInfo findInList(List<ConnectToInfo> list, String shape) {
            if (list != null && shape != null && !shape.isEmpty()) {
                for (ConnectToInfo info : list) {
                    if (!shape.equals(info.shapeTo)) continue;
                    return info;
                }
            }
            return null;
        }
    }

    static enum CONTENT_TYPE {
        VSSX,
        VSDX;

    }
}

