/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.adt.collections.IntegerList;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.converters.odg.OdgParser;
import inform.agent.schemes.converters.odg.content.OdgFigure;
import inform.agent.schemes.converters.odg.content.evaluator.OdgExpressionEvaluator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class OdgEnhancedGeometry {
    public OdgFigure figure;
    private int[] drawTextAreas;
    private String type;
    private int drawPathStretchpointX;
    private int drawPathStretchpointY;
    private List<Point> spectialPointList;
    private List<OdgCommand> drawListOdgCommand;
    private LinkedHashMap<String, Integer> formulaValue;
    private LinkedHashMap<String, Double> drawModifiers;
    private boolean mirrorHorizontal = false;
    private boolean mirrorVertical = false;
    private boolean isSvgZoneEmpty = false;

    public OdgEnhancedGeometry() {
    }

    public OdgEnhancedGeometry(Element element, OdgFigure figure) {
        String[] arr;
        String[] splitValues;
        this.figure = figure;
        this.formulaValue = new LinkedHashMap();
        this.spectialPointList = new ArrayList<Point>();
        if (element.hasAttribute("draw:type")) {
            this.type = element.getAttribute("draw:type");
        }
        if (element.hasAttribute("draw:path-stretchpoint-x")) {
            this.drawPathStretchpointX = Integer.parseInt(element.getAttribute("draw:path-stretchpoint-x"));
        }
        if (element.hasAttribute("draw:path-stretchpoint-y")) {
            this.drawPathStretchpointY = Integer.parseInt(element.getAttribute("draw:path-stretchpoint-y"));
        }
        if (element.hasAttribute("svg:viewBox")) {
            String svgViewBox = element.getAttribute("svg:viewBox");
            splitValues = svgViewBox.split(" ");
            this.getFigure().svgViewBox[0] = Integer.parseInt(splitValues[0]);
            this.getFigure().svgViewBox[1] = Integer.parseInt(splitValues[1]);
            this.getFigure().svgViewBox[2] = Integer.parseInt(splitValues[2]);
            this.getFigure().svgViewBox[3] = Integer.parseInt(splitValues[3]);
        }
        if (element.hasAttribute("drawooo:sub-view-size")) {
            if (this.getFigure().svgViewBox[2] == 0 && this.getFigure().svgViewBox[3] == 0) {
                this.isSvgZoneEmpty = true;
            }
            String subViewSize = element.getAttribute("drawooo:sub-view-size");
            splitValues = subViewSize.split(" ");
            this.getFigure().svgViewBox[2] = Integer.parseInt(splitValues[0]);
            this.getFigure().svgViewBox[3] = Integer.parseInt(splitValues[1]);
        }
        if (element.hasAttribute("draw:modifiers")) {
            this.drawModifiers = new LinkedHashMap();
            arr = element.getAttribute("draw:modifiers").split(" ");
            for (int i = 0; i < arr.length; ++i) {
                double value = Double.parseDouble(arr[i]);
                this.drawModifiers.put("$" + i, value);
            }
        }
        if (element.hasChildNodes()) {
            LinkedHashMap<String, String> nameFormulaMap = new LinkedHashMap<String, String>();
            List<Element> elements = OdgParser.getChildElements(element);
            for (Element el : elements) {
                if (!el.getTagName().equals("draw:equation")) continue;
                nameFormulaMap.put(el.getAttribute("draw:name"), el.getAttribute("draw:formula"));
            }
            try {
                this.formulaParsing(nameFormulaMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (element.hasAttribute("draw:enhanced-path")) {
            String attribute = element.hasAttribute("drawooo:enhanced-path") ? element.getAttribute("drawooo:enhanced-path") : element.getAttribute("draw:enhanced-path");
            String[] arr2 = this.getArray(attribute);
            this.drawListOdgCommand = new ArrayList<OdgCommand>();
            this.drawListOdgCommand = this.pathParsing(arr2);
        }
        if (element.hasAttribute("draw:mirror-vertical")) {
            this.mirrorVertical = Boolean.parseBoolean(element.getAttribute("draw:mirror-vertical"));
        }
        if (element.hasAttribute("draw:mirror-horizontal")) {
            this.mirrorHorizontal = Boolean.parseBoolean(element.getAttribute("draw:mirror-horizontal"));
        }
        if (element.hasAttribute("draw:glue-points")) {
            String drawGluePoints = element.getAttribute("draw:glue-points");
            String[] splitValues2 = drawGluePoints.split(" ");
            for (int i = 0; i < splitValues2.length - 1; i += 2) {
                Integer firstValue = splitValues2[i].contains("?") ? this.formulaValue.get(splitValues2[i].substring(1)) : Integer.valueOf(Integer.parseInt(splitValues2[i]));
                Integer secondValue = splitValues2[i + 1].contains("?") ? this.formulaValue.get(splitValues2[i + 1].substring(1)) : Integer.valueOf(Integer.parseInt(splitValues2[i + 1]));
                assert (firstValue != null && secondValue != null);
                this.spectialPointList.add(new Point(firstValue.intValue(), secondValue.intValue()));
            }
        }
        if (element.hasAttribute("draw:text-areas")) {
            arr = element.getAttribute("draw:text-areas").split(" ");
            this.drawTextAreas = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                Integer firstValue = arr[i].contains("?") ? this.formulaValue.get(arr[i].substring(1)) : Integer.valueOf(Integer.parseInt(arr[i]));
                assert (firstValue != null);
                this.drawTextAreas[i] = firstValue;
            }
        }
    }

    public String[] getArray(String value) {
        String[] arr = value.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].contains("?f")) continue;
            arr[i] = String.valueOf(this.formulaValue.get(arr[i].substring(1)));
        }
        return arr;
    }

    public boolean isMirrorHorizontal() {
        return this.mirrorHorizontal;
    }

    public boolean isMirrorVertical() {
        return this.mirrorVertical;
    }

    public LinkedHashMap<String, Double> getDrawModifiers() {
        return this.drawModifiers;
    }

    public String getType() {
        return this.type;
    }

    public int[] getDrawTextAreas() {
        return this.drawTextAreas;
    }

    public boolean hasTextArea() {
        return this.getDrawTextAreas() != null;
    }

    public List<Point> getSpectialPointList() {
        return this.spectialPointList;
    }

    public int getDrawPathStretchpointX() {
        return this.drawPathStretchpointX;
    }

    public List<OdgCommand> getDrawListOdgCommand() {
        return this.drawListOdgCommand;
    }

    public int getDrawPathStretchpointY() {
        return this.drawPathStretchpointY;
    }

    public OdgFigure getFigure() {
        return this.figure;
    }

    public List<OdgCommand> pathParsing(String[] arr) {
        ArrayList<OdgCommand> listOdgCommand = new ArrayList<OdgCommand>();
        String currentCommand = arr[0];
        for (int i = 0; i < arr.length; ++i) {
            OdgCommand oc = new OdgCommand();
            switch (arr[i]) {
                case "M": 
                case "L": 
                case "C": 
                case "X": 
                case "Y": {
                    oc.pointTo = new Point(arr[i + 1], arr[i + 2]);
                    currentCommand = arr[i];
                    i += 2;
                    break;
                }
                case "Z": 
                case "N": 
                case "F": 
                case "S": 
                case "I": {
                    currentCommand = arr[i];
                    break;
                }
                case "T": 
                case "U": {
                    int j;
                    for (j = i; j < i + 6; ++j) {
                        oc.angleEllipse.add(Integer.parseInt(arr[j + 1]));
                    }
                    if (arr[i].equals("U")) {
                        oc.pointTo = new Point(arr[i + 1], arr[i + 2]);
                    }
                    currentCommand = arr[i];
                    i += 6;
                    break;
                }
                case "A": 
                case "B": 
                case "W": 
                case "V": {
                    int j;
                    for (j = i; j < i + 8; j += 2) {
                        oc.arcEllipse.add(new Point(arr[j + 1], arr[j + 2]));
                    }
                    if (arr[i].equals("B") || arr[i].equals("V")) {
                        oc.pointTo = new Point(arr[i + 1], arr[i + 2]);
                    }
                    currentCommand = arr[i];
                    i += 8;
                    break;
                }
                case "Q": 
                case "G": {
                    int j;
                    for (j = i; j < i + 4; ++j) {
                        oc.angleEllipse.add(Integer.parseInt(arr[j + 1]));
                    }
                    currentCommand = arr[i];
                    i += 4;
                    break;
                }
                default: {
                    int j;
                    assert (currentCommand != null);
                    if (currentCommand.equals("X") || currentCommand.equals("Y") || currentCommand.equals("L") || currentCommand.equals("C") || currentCommand.equals("S")) {
                        oc.pointTo = new Point(arr[i], arr[i + 1]);
                        ++i;
                    }
                    if (!currentCommand.equals("G") && !currentCommand.equals("Q")) break;
                    for (j = i; j < i + 4; ++j) {
                        oc.angleEllipse.add(Integer.parseInt(arr[j]));
                    }
                    i += 3;
                }
            }
            oc.nameCommand = currentCommand;
            listOdgCommand.add(oc);
        }
        return listOdgCommand;
    }

    public List<OdgCommand> svgParsing(String[] arr) {
        this.drawListOdgCommand = new ArrayList<OdgCommand>();
        String currentCommand = arr[0];
        int counter = 0;
        int current = 0;
        for (int i = 0; i < arr.length; ++i) {
            OdgCommand oc = new OdgCommand();
            block12 : switch (arr[i]) {
                case "M": 
                case "m": 
                case "L": 
                case "C": {
                    currentCommand = arr[i];
                    oc.pointTo = new Point(arr[i + 1], arr[i + 2]);
                    i += 2;
                    break;
                }
                case "h": {
                    currentCommand = arr[i];
                    Point lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                    oc.pointTo = new Point(lastPoint.getX() + Double.parseDouble(arr[i + 1]), lastPoint.getY());
                    ++i;
                    break;
                }
                case "v": {
                    currentCommand = arr[i];
                    Point lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                    oc.pointTo = new Point(lastPoint.getX(), lastPoint.getY() + Double.parseDouble(arr[i + 1]));
                    ++i;
                    break;
                }
                case "l": 
                case "c": {
                    currentCommand = arr[i];
                    Point lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                    oc.pointTo = new Point(lastPoint.getX() + Double.parseDouble(arr[i + 1]), lastPoint.getY() + Double.parseDouble(arr[i + 2]));
                    current = this.drawListOdgCommand.size() - 1;
                    counter = 1;
                    i += 2;
                    break;
                }
                case "z": {
                    currentCommand = arr[i];
                    break;
                }
                case "s": {
                    currentCommand = "s";
                    Point prevLastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 2)).pointTo;
                    Point lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                    int xPrev = (int)prevLastPoint.getX();
                    int yPrev = (int)prevLastPoint.getY();
                    int xLast = (int)lastPoint.getX();
                    int yLast = (int)lastPoint.getY();
                    int coordX = Math.abs(xPrev - xLast);
                    int coordY = Math.abs(yPrev - yLast);
                    int x = xPrev > xLast ? xLast - coordX : xLast + coordX;
                    int y = yPrev > yLast ? yLast - coordY : yLast + coordY;
                    OdgCommand command = new OdgCommand();
                    command.nameCommand = "S";
                    command.pointTo = new Point(x, y);
                    this.drawListOdgCommand.add(command);
                    OdgCommand command2 = new OdgCommand();
                    command2.nameCommand = "S";
                    command2.pointTo = new Point((double)xLast + Double.parseDouble(arr[i + 1]), (double)yLast + Double.parseDouble(arr[i + 2]));
                    this.drawListOdgCommand.add(command2);
                    oc.pointTo = new Point((double)xLast + Double.parseDouble(arr[i + 3]), (double)yLast + Double.parseDouble(arr[i + 4]));
                    i += 4;
                    break;
                }
                default: {
                    int y;
                    int x;
                    int coordY;
                    int coordX;
                    int yLast;
                    int xLast;
                    int yPrev;
                    int xPrev;
                    Point prevLastPoint;
                    Point lastPoint;
                    assert (currentCommand != null);
                    switch (currentCommand) {
                        case "C": 
                        case "L": {
                            oc.pointTo = new Point(arr[i], arr[i + 1]);
                            ++i;
                            break block12;
                        }
                        case "h": {
                            lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                            oc.pointTo = new Point(lastPoint.getX() + Double.parseDouble(arr[i]), lastPoint.getY());
                            break block12;
                        }
                        case "v": {
                            lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                            oc.pointTo = new Point(lastPoint.getX(), lastPoint.getY() + Double.parseDouble(arr[i]));
                            break block12;
                        }
                        case "l": {
                            lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                            oc.pointTo = new Point(lastPoint.getX() + Double.parseDouble(arr[i]), lastPoint.getY() + Double.parseDouble(arr[i + 1]));
                            ++i;
                            break block12;
                        }
                        case "c": {
                            if (counter % 3 == 0) {
                                current = this.drawListOdgCommand.size() - 1;
                            }
                            lastPoint = this.drawListOdgCommand.get((int)current).pointTo;
                            oc.pointTo = new Point(lastPoint.getX() + Double.parseDouble(arr[i]), lastPoint.getY() + Double.parseDouble(arr[i + 1]));
                            ++counter;
                            ++i;
                            break block12;
                        }
                        case "s": {
                            currentCommand = "s";
                            prevLastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 2)).pointTo;
                            lastPoint = this.drawListOdgCommand.get((int)(this.drawListOdgCommand.size() - 1)).pointTo;
                            xPrev = (int)prevLastPoint.getX();
                            yPrev = (int)prevLastPoint.getY();
                            xLast = (int)lastPoint.getX();
                            yLast = (int)lastPoint.getY();
                            coordX = Math.abs(xPrev - xLast);
                            coordY = Math.abs(yPrev - yLast);
                            x = xPrev > xLast ? xLast - coordX : xLast + coordX;
                            y = yPrev > yLast ? yLast - coordY : yLast + coordY;
                            OdgCommand command3 = new OdgCommand();
                            command3.nameCommand = "S";
                            command3.pointTo = new Point(x, y);
                            this.drawListOdgCommand.add(command3);
                            OdgCommand command4 = new OdgCommand();
                            command4.nameCommand = "S";
                            command4.pointTo = new Point((double)xLast + Double.parseDouble(arr[i]), (double)yLast + Double.parseDouble(arr[i + 1]));
                            this.drawListOdgCommand.add(command4);
                            oc.pointTo = new Point((double)xLast + Double.parseDouble(arr[i + 2]), (double)yLast + Double.parseDouble(arr[i + 3]));
                            i += 3;
                        }
                    }
                }
            }
            oc.nameCommand = currentCommand.toUpperCase();
            this.drawListOdgCommand.add(oc);
        }
        return this.drawListOdgCommand;
    }

    private void formulaParsing(LinkedHashMap<String, String> hashMap) throws Exception {
        OdgExpressionEvaluator evaluator = new OdgExpressionEvaluator(this);
        for (Map.Entry<String, String> mas : hashMap.entrySet()) {
            StringBuilder build = new StringBuilder(mas.getValue());
            String prefix = "?f";
            int startIndex = mas.getValue().indexOf(prefix);
            while (startIndex != -1) {
                int endIndex;
                for (endIndex = startIndex + prefix.length(); endIndex < mas.getValue().length() && Character.isDigit(mas.getValue().charAt(endIndex)); ++endIndex) {
                }
                String value = mas.getValue().substring(startIndex + 1, endIndex);
                build.replace(startIndex, endIndex, "(" + hashMap.get(value) + ")");
                hashMap.replace(mas.getKey(), build.toString());
                startIndex = mas.getValue().indexOf(prefix);
            }
            String expression = evaluator.evaluateExpression(mas.getValue());
            String revert = String.valueOf(Double.parseDouble(expression));
            hashMap.replace(mas.getKey(), revert);
        }
        for (Map.Entry<String, String> mas : hashMap.entrySet()) {
            String key = mas.getKey();
            this.formulaValue.put(key, (int)Double.parseDouble(hashMap.get(key)));
        }
    }

    public boolean isSvgZoneEmpty() {
        return this.isSvgZoneEmpty;
    }

    public static class Point {
        double x;
        double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point(String x, String y) {
            this.x = Double.parseDouble(x);
            this.y = Double.parseDouble(y);
        }

        public BaseGraphic.RealPoint asRealPoint() {
            BaseGraphic.RealPoint point = new BaseGraphic.RealPoint();
            point.X = this.x;
            point.Y = this.y;
            return point;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    public static class OdgCommand {
        public String nameCommand;
        public Point pointTo;
        public List<Point> arcEllipse = new ArrayList<Point>();
        public IntegerList angleEllipse = new IntegerList(10);
    }
}

