/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.OdgGraphicObject;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import org.w3c.dom.Element;

public class OdgLine
extends OdgGraphicObject {
    protected double svgX1;
    protected double svgY1;
    protected double svgX2;
    protected double svgY2;

    OdgLine(Element element) {
        super(element);
        if (element.hasAttribute("svg:x1")) {
            String nodeX = element.getAttribute("svg:x1");
            this.svgX1 = OdgUtils.parseSizeValue(nodeX);
        }
        if (element.hasAttribute("svg:y1")) {
            String nodeY = element.getAttribute("svg:y1");
            this.svgY1 = OdgUtils.parseSizeValue(nodeY);
        }
        if (element.hasAttribute("svg:x2")) {
            String nodeHeight = element.getAttribute("svg:x2");
            this.svgX2 = OdgUtils.parseSizeValue(nodeHeight);
        }
        if (element.hasAttribute("svg:y2")) {
            String nodeWidth = element.getAttribute("svg:y2");
            this.svgY2 = OdgUtils.parseSizeValue(nodeWidth);
        }
        double x = this.getSvgX2() - this.getSvgX1();
        double y = this.getSvgY2() - this.getSvgY1();
        this.rotateAngle = 360.0 - SchemeUtils.convertAngle(Math.atan2(y, x));
    }

    @Override
    public OdgEnhancedGeometry getGeometry() {
        return null;
    }

    @Override
    public boolean hasGeometry() {
        return false;
    }

    public double getSvgX1() {
        return this.svgX1 * 10.0;
    }

    public double getSvgY1() {
        return this.svgY1 * 10.0;
    }

    public double getSvgX2() {
        return this.svgX2 * 10.0;
    }

    public double getSvgY2() {
        return this.svgY2 * 10.0;
    }
}

