/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.GradientPattern;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.converters.odg.content.OdgParentStyle;
import inform.agent.schemes.converters.odg.content.OdgProperties;
import inform.agent.schemes.converters.odg.content.OdgUtils;
import java.awt.geom.AffineTransform;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class OdgStyleGraphicsProperties
extends OdgProperties {
    public OdgStyleGraphicsProperties(BaseShape shape, PhxLayer layer) {
        this(shape, layer, 1.0);
    }

    public OdgStyleGraphicsProperties(BaseShape shape, PhxLayer layer, double scale) {
        this.shape = shape;
        boolean isShowbackground = true;
        this.styles.put("draw:fill-color", "#ffffff");
        this.styles.put("svg:stroke-color", "#000000");
        this.styles.put("svg:stroke-linecap", "butt");
        this.styles.put("svg:stroke-width", "0cm");
        this.styles.put("svg:stroke-opacity", "100%");
        this.styles.put("draw:opacity", "100%");
        this.styles.put("draw:image-opacity", "100%");
        this.styles.put("draw:marker-start-width", "0.2cm");
        this.styles.put("draw:marker-end-width", "0.2cm");
        this.styles.put("draw:marker-start", "");
        this.styles.put("draw:marker-end", "");
        this.styles.put("draw:textarea-vertical-align", "top");
        this.styles.put("draw:textarea-horizontal-align", "left");
        this.styles.put("draw:luminance", "0%");
        this.styles.put("draw:contrast", "0%");
        this.styles.put("draw:gamma", "100%");
        this.styles.put("draw:line-distance", "0cm");
        this.styles.put("draw:start-guide", "0cm");
        this.styles.put("draw:end-guide", "0cm");
        this.styles.put("draw:auto-grow-width", "false");
        this.styles.put("draw:auto-grow-height", "false");
        this.styles.put("draw:fill", "solid");
        this.styles.put("draw:stroke", "solid");
        if (shape instanceof Image) {
            this.styles.replace("draw:fill", "none");
            this.styles.replace("draw:stroke", "none");
            if (shape instanceof PhxImage) {
                PhxImage image = (PhxImage)shape;
                this.styles.replace("draw:luminance", OdgUtils.asPercent((image.Brightness - 50.0) * 2.0));
                this.styles.replace("draw:contrast", OdgUtils.asPercent((image.Contrast - 50.0) * 2.0));
                this.styles.replace("draw:gamma", OdgUtils.asPercent(image.Gamma * 100.0));
            }
        }
        if (shape instanceof Paragraph || shape.emText() && shape.EmbeddedText.Inscribe) {
            Paragraph paragraph;
            Paragraph paragraph2 = paragraph = shape.EmbeddedText == null ? (Paragraph)shape : shape.EmbeddedText;
            if (!shape.emText()) {
                isShowbackground = paragraph.ShowBackground;
            }
            if (paragraph.VertAlign != 0) {
                String vertAlign;
                switch (paragraph.VertAlign) {
                    default: {
                        vertAlign = "top";
                        break;
                    }
                    case 1: {
                        vertAlign = "bottom";
                        break;
                    }
                    case 2: {
                        vertAlign = "middle";
                    }
                }
                this.styles.put("draw:textarea-vertical-align", vertAlign);
            }
            if (paragraph.Align != 0) {
                String vert;
                switch (paragraph.Align) {
                    default: {
                        vert = "left";
                        break;
                    }
                    case 1: {
                        vert = "right";
                        break;
                    }
                    case 2: {
                        vert = "center";
                    }
                }
                this.styles.put("draw:textarea-horizontal-align", vert);
            }
            if (paragraph.AutoSize) {
                this.styles.put("draw:auto-grow-width", "true");
            }
            if (paragraph.containsParagraphLine()) {
                this.styles.remove("draw:textarea-horizontal-align");
            }
            if (shape.emText() && shape.EmbeddedText.Inscribe) {
                this.correctSides(paragraph);
            }
            this.styles.put("fo:min-width", OdgUtils.asStringWithCentimeter(paragraph.SideX));
            this.styles.put("fo:min-height", OdgUtils.asStringWithCentimeter(paragraph.SideY));
            this.styles.put("fo:padding-top", OdgUtils.asStringWithCentimeter(paragraph.TopMargin * scale));
            this.styles.put("fo:padding-bottom", OdgUtils.asStringWithCentimeter(paragraph.BottomMargin * scale));
            this.styles.put("fo:padding-left", OdgUtils.asStringWithCentimeter(paragraph.LeftMargin * scale));
            this.styles.put("fo:padding-right", OdgUtils.asStringWithCentimeter(paragraph.RightMargin * scale));
        }
        if (shape instanceof Image) {
            return;
        }
        if (shape instanceof Polyline) {
            Polyline polyline = (Polyline)shape;
            if (polyline.StartVisArrowType != 0) {
                String drawMarkerStart = this.markerOut(polyline.StartVisArrowType);
                this.styles.put("draw:marker-start", drawMarkerStart);
            }
            if (polyline.EndVisArrowType != 0) {
                String drawMarkerEnd = this.markerOut(polyline.EndVisArrowType);
                this.styles.put("draw:marker-end", drawMarkerEnd);
            }
            if (polyline.StartVisArrowSize != 0.0) {
                polyline.StartVisArrowSize *= scale;
                this.styles.put("draw:marker-start-width", OdgUtils.asStringWithCentimeter(polyline.StartVisArrowSize));
            }
            if (polyline.EndVisArrowSize != 0.0) {
                polyline.EndVisArrowSize *= scale;
                this.styles.put("draw:marker-end-width", OdgUtils.asStringWithCentimeter(polyline.EndVisArrowSize));
            }
        }
        if (!isShowbackground) {
            if (shape instanceof AttributeDef) {
                shape.BrushPattern = 1;
            }
            shape.BkColor = null;
            shape.pColor = null;
            shape.bColor = null;
            layer.BkColor = null;
            layer.pColor = null;
            layer.bColor = null;
            layer.Transparent = 0;
            layer.TransparentBorder = 0;
            layer.PenPattern = -1;
            this.styles.put("draw:stroke", "none");
        }
        if (shape.bColor != null) {
            this.styles.put("draw:fill-color", OdgUtils.getColor(shape.bColor));
        } else if (layer.bColor != null) {
            shape.bColor = layer.bColor;
            this.styles.put("draw:fill-color", OdgUtils.getColor(shape.bColor));
        } else if (shape instanceof Paragraph) {
            this.styles.put("draw:fill", "none");
        }
        if (shape.pColor != null) {
            this.styles.put("svg:stroke-color", OdgUtils.getColor(shape.pColor));
        } else if (layer.pColor != null) {
            shape.pColor = layer.pColor;
            this.styles.put("svg:stroke-color", OdgUtils.getColor(shape.pColor));
        }
        if (shape.BkColor == null && layer.BkColor != null) {
            shape.BkColor = layer.BkColor;
        }
        if (shape.lWidth != -1.0) {
            double lWidth = shape.lWidth > 0.0 ? shape.lWidth : 0.0;
            this.styles.put("svg:stroke-width", OdgUtils.asStringWithCentimeter(lWidth * scale));
        } else if (layer.lWidth != -1.0) {
            shape.lWidth = layer.lWidth;
            double lWidth = shape.lWidth > 0.0 ? shape.lWidth : 0.0;
            this.styles.put("svg:stroke-width", OdgUtils.asStringWithCentimeter(lWidth * scale));
        }
        if (shape.LineCap != 0) {
            switch (shape.LineCap) {
                case 1: {
                    this.styles.put("svg:stroke-linecap", "round");
                    break;
                }
                case 2: {
                    this.styles.put("svg:stroke-linecap", "square");
                }
            }
        }
        if (shape.Transparent == 255 || layer.Transparent == 255) {
            this.styles.put("draw:fill", "none");
        } else if (shape.Transparent == 0) {
            this.styles.put("draw:opacity", OdgUtils.asStringWithPercent(layer.Transparent));
        } else {
            this.styles.put("draw:opacity", OdgUtils.asStringWithPercent(shape.Transparent));
        }
        if (shape.TransparentBorder == 0) {
            this.styles.put("svg:stroke-opacity", OdgUtils.asStringWithPercent(layer.TransparentBorder));
        } else {
            this.styles.put("svg:stroke-opacity", OdgUtils.asStringWithPercent(shape.TransparentBorder));
        }
        if (shape.PenPattern != -1 || layer.PenPattern != -1) {
            if (shape.PenPattern == -1) {
                shape.PenPattern = layer.PenPattern;
            }
            block12 : switch (shape.PenPattern) {
                case 5: {
                    this.styles.put("draw:stroke", "none");
                    break;
                }
                case 0: {
                    this.styles.put("draw:stroke", "solid");
                    break;
                }
                default: {
                    this.styles.put("draw:stroke", "dash");
                    switch (shape.PenPattern) {
                        case 1: {
                            this.styles.put("draw:stroke-dash", "Dash");
                            break block12;
                        }
                        case 2: {
                            this.styles.put("draw:stroke-dash", "Dot");
                            break block12;
                        }
                        case 3: {
                            this.styles.put("draw:stroke-dash", "Dash_20_Dot");
                            break block12;
                        }
                        case 4: {
                            this.styles.put("draw:stroke-dash", "Dash_20_Dot_20_Dot");
                        }
                    }
                }
            }
        }
        if (shape.BrushPattern == -1) {
            if (layer.BrushPattern == 1) {
                this.styles.put("draw:fill", "none");
            } else if (layer.BrushPattern != 0) {
                shape.BrushPattern = layer.BrushPattern;
                this.checkGradient(shape);
            }
        } else if (shape.BrushPattern == 1) {
            this.styles.put("draw:fill", "none");
        } else if (shape.BrushPattern != -1 && layer.BrushPattern != -1 && (shape.BrushPattern != 0 || layer.BrushPattern != 0)) {
            this.checkGradient(shape);
        }
    }

    public OdgStyleGraphicsProperties(Element element, OdgParentStyle parentStyle) {
        String style;
        String value;
        Set<String> parentAttrs = null;
        if (parentStyle != null && parentStyle.style != null) {
            OdgProperties properties = parentStyle.style.getStyleProperty();
            parentAttrs = properties.styles.keySet();
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:fill-color")) {
            this.styles.put("draw:fill-color", "#729fcf");
        }
        if (parentAttrs == null || !parentAttrs.contains("svg:stroke-color")) {
            this.styles.put("svg:stroke-color", "#3465a4");
        }
        if (parentAttrs == null || !parentAttrs.contains("svg:stroke-linecap")) {
            this.styles.put("svg:stroke-linecap", "1");
        }
        if (parentAttrs == null || !parentAttrs.contains("svg:stroke-width")) {
            this.styles.put("svg:stroke-width", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("svg:stroke-opacity")) {
            this.styles.put("svg:stroke-opacity", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:opacity")) {
            this.styles.put("draw:opacity", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:stroke")) {
            this.styles.put("draw:stroke", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:image-opacity")) {
            this.styles.put("draw:image-opacity", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:marker-start-width")) {
            this.styles.put("draw:marker-start-width", "0.2");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:marker-end-width")) {
            this.styles.put("draw:marker-end-width", "0.2");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:marker-start")) {
            this.styles.put("draw:marker-start", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:marker-end")) {
            this.styles.put("draw:marker-end", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:textarea-vertical-align")) {
            this.styles.put("draw:textarea-vertical-align", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:textarea-horizontal-align")) {
            this.styles.put("draw:textarea-horizontal-align", "-1");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:luminance")) {
            this.styles.put("draw:luminance", "50");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:contrast")) {
            this.styles.put("draw:contrast", "50");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:contrast")) {
            this.styles.put("draw:contrast", "1");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:line-distance")) {
            this.styles.put("draw:line-distance", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:start-guide")) {
            this.styles.put("draw:start-guide", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("draw:end-guide")) {
            this.styles.put("draw:end-guide", "0");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:padding-top")) {
            this.styles.put("fo:padding-top", "1.25");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:padding-bottom")) {
            this.styles.put("fo:padding-bottom", "1.25");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:padding-left")) {
            this.styles.put("fo:padding-left", "2.5");
        }
        if (parentAttrs == null || !parentAttrs.contains("fo:padding-right")) {
            this.styles.put("fo:padding-right", "2.5");
        }
        if (element.hasAttribute("draw:fill-color")) {
            this.styles.put("draw:fill-color", element.getAttribute("draw:fill-color"));
        }
        if (element.hasAttribute("svg:stroke-color")) {
            this.styles.put("svg:stroke-color", element.getAttribute("svg:stroke-color"));
        }
        if (element.hasAttribute("draw:fill")) {
            String drawFill = element.getAttribute("draw:fill");
            this.styles.put("draw:fill", drawFill);
            if (drawFill.equals("gradient")) {
                this.styles.put("draw:fill-gradient-name", element.getAttribute("draw:fill-gradient-name"));
            }
        }
        if (element.hasAttribute("svg:stroke-opacity")) {
            value = element.getAttribute("svg:stroke-opacity");
            int svgStrokeOpacity = (int)(255.0 * (100.0 - OdgUtils.parsePercentValue(value)) / 100.0);
            this.styles.put("svg:stroke-opacity", String.valueOf(svgStrokeOpacity));
        }
        if (element.hasAttribute("draw:opacity")) {
            value = element.getAttribute("draw:opacity");
            int opacity = (int)(255.0 * (100.0 - OdgUtils.parsePercentValue(value)) / 100.0);
            this.styles.put("draw:opacity", String.valueOf(opacity));
        }
        if (element.hasAttribute("svg:stroke-width")) {
            value = element.getAttribute("svg:stroke-width");
            String svgStrokeWidth = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("svg:stroke-width", svgStrokeWidth);
        }
        if (element.hasAttribute("svg:stroke-linecap")) {
            value = element.getAttribute("svg:stroke-linecap");
            int svgStrokeLinecap = value.equals("round") ? 1 : (value.equals("square") ? 2 : 0);
            this.styles.put("svg:stroke-linecap", String.valueOf(svgStrokeLinecap));
        }
        if (element.hasAttribute("draw:stroke")) {
            style = element.getAttribute("draw:stroke");
            int drawStroke = 0;
            block4 : switch (style) {
                case "none": {
                    drawStroke = 5;
                    break;
                }
                case "dash": {
                    String drawStrokeDash;
                    switch (drawStrokeDash = element.getAttribute("draw:stroke-dash")) {
                        case "Dot": 
                        case "Long_20_Dot": {
                            drawStroke = 2;
                            break block4;
                        }
                        case "Dash_20_Dot": 
                        case "Double_20_Dash_20_Dot": {
                            drawStroke = 3;
                            break block4;
                        }
                        case "Dash_20_Dot_20_Dot": {
                            drawStroke = 4;
                            break block4;
                        }
                    }
                    drawStroke = 1;
                    break;
                }
            }
            this.styles.put("draw:stroke", String.valueOf(drawStroke));
        }
        if (element.hasAttribute("draw:marker-start")) {
            style = element.getAttribute("draw:marker-start");
            int drawMarkerStart = this.markerOut(style);
            this.styles.put("draw:marker-start", String.valueOf(drawMarkerStart));
        }
        if (element.hasAttribute("draw:marker-end")) {
            style = element.getAttribute("draw:marker-end");
            int drawMarkerEnd = this.markerOut(style);
            this.styles.put("draw:marker-end", String.valueOf(drawMarkerEnd));
        }
        if (element.hasAttribute("draw:marker-start-width")) {
            value = element.getAttribute("draw:marker-start-width");
            this.styles.put("draw:marker-start-width", this.markerWidthOut(value));
        }
        if (element.hasAttribute("draw:marker-end-width")) {
            value = element.getAttribute("draw:marker-end-width");
            this.styles.put("draw:marker-end-width", this.markerWidthOut(value));
        }
        if (element.hasAttribute("draw:textarea-vertical-align")) {
            value = element.getAttribute("draw:textarea-vertical-align");
            int drawTextareaVerticalAlign = 0;
            switch (value) {
                case "top": {
                    break;
                }
                case "bottom": {
                    drawTextareaVerticalAlign = 1;
                    break;
                }
                case "middle": {
                    drawTextareaVerticalAlign = 2;
                }
            }
            this.styles.put("draw:textarea-vertical-align", String.valueOf(drawTextareaVerticalAlign));
        }
        if (element.hasAttribute("draw:textarea-horizontal-align")) {
            value = element.getAttribute("draw:textarea-horizontal-align");
            int drawTextareaHorizontalAlign = 0;
            switch (value) {
                case "left": {
                    break;
                }
                case "right": {
                    drawTextareaHorizontalAlign = 1;
                    break;
                }
                case "center": {
                    drawTextareaHorizontalAlign = 2;
                    break;
                }
                default: {
                    drawTextareaHorizontalAlign = -1;
                }
            }
            this.styles.put("draw:textarea-horizontal-align", String.valueOf(drawTextareaHorizontalAlign));
        }
        if (element.hasAttribute("draw:luminance")) {
            value = element.getAttribute("draw:luminance");
            int drawLuminance = (int)(OdgUtils.parsePercentValue(value) / 2.0 + 50.0);
            this.styles.put("draw:luminance", String.valueOf(drawLuminance));
        }
        if (element.hasAttribute("draw:contrast")) {
            value = element.getAttribute("draw:contrast");
            int drawContrast = (int)(OdgUtils.parsePercentValue(value) / 2.0 + 50.0);
            this.styles.put("draw:contrast", String.valueOf(drawContrast));
        }
        if (element.hasAttribute("draw:gamma")) {
            value = element.getAttribute("draw:gamma");
            double drawGamma = OdgUtils.parsePercentValue(value) / 100.0;
            if (drawGamma > 9.7) {
                drawGamma = 9.7;
            }
            this.styles.put("draw:gamma", String.valueOf(drawGamma));
        }
        if (element.hasAttribute("draw:image-opacity")) {
            value = element.getAttribute("draw:image-opacity");
            int drawImageOpacity = (int)(255.0 * (100.0 - OdgUtils.parsePercentValue(value)) / 100.0);
            this.styles.put("draw:image-opacity", String.valueOf(drawImageOpacity));
        }
        if (element.hasAttribute("draw:line-distance")) {
            value = element.getAttribute("draw:line-distance");
            String drawLineDistance = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("draw:line-distance", drawLineDistance);
        }
        if (element.hasAttribute("draw:start-guide")) {
            value = element.getAttribute("draw:start-guide");
            String drawStartGuide = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("draw:start-guide", drawStartGuide);
        }
        if (element.hasAttribute("draw:end-guide")) {
            value = element.getAttribute("draw:end-guide");
            String drawEndGuide = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("draw:end-guide", drawEndGuide);
        }
        if (element.hasAttribute("fo:padding-top")) {
            value = element.getAttribute("fo:padding-top");
            String foPaddingTop = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("fo:padding-top", foPaddingTop);
        }
        if (element.hasAttribute("fo:padding-bottom")) {
            value = element.getAttribute("fo:padding-bottom");
            String foPaddingBottom = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("fo:padding-bottom", foPaddingBottom);
        }
        if (element.hasAttribute("fo:padding-left")) {
            value = element.getAttribute("fo:padding-left");
            String foPaddingLeft = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("fo:padding-left", foPaddingLeft);
        }
        if (element.hasAttribute("fo:padding-right")) {
            value = element.getAttribute("fo:padding-right");
            String foPaddingRight = String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
            this.styles.put("fo:padding-right", foPaddingRight);
        }
        if (element.hasAttribute("fo:clip")) {
            value = element.getAttribute("fo:clip");
            this.styles.put("fo:clip", value);
        }
    }

    private int markerOut(String style) {
        int drawMarker = 0;
        switch (style) {
            case "": {
                break;
            }
            case "Triangle_20_unfilled": {
                drawMarker = 1;
                break;
            }
            case "Arrow": {
                drawMarker = 3;
                break;
            }
            case "Line_20_short": 
            case "Dimension_20_Line": {
                drawMarker = 5;
                break;
            }
            case "Half_20_Circle": 
            case "Circle": {
                drawMarker = 7;
                break;
            }
            case "Half_20_Circle_20_unfilled": 
            case "Circle_20_unfilled": {
                drawMarker = 8;
                break;
            }
            case "Dimension_20_Lines": {
                drawMarker = 9;
                break;
            }
            case "Square": {
                drawMarker = 10;
                break;
            }
            case "Square_20_unfilled": {
                drawMarker = 11;
                break;
            }
            case "Reversed_20_Arrow": {
                drawMarker = 12;
                break;
            }
            case "Arrowheads_20_18": {
                drawMarker = 18;
                break;
            }
            case "CF_20_One": {
                drawMarker = 19;
                break;
            }
            case "CF_20_Many": {
                drawMarker = 20;
                break;
            }
            case "Square_20_45": 
            case "Diamond": {
                drawMarker = 21;
                break;
            }
            case "Square_20_45_20_unfilled": 
            case "Diamond_20_unfilled": {
                drawMarker = 22;
                break;
            }
            case "CF_20_Only_20_One": {
                drawMarker = 25;
                break;
            }
            case "CF_20_Zero_20_One": {
                drawMarker = 26;
                break;
            }
            case "CF_20_Zero_20_Many": {
                drawMarker = 27;
                break;
            }
            case "CF_20_Many_20_One": {
                drawMarker = 28;
                break;
            }
            default: {
                drawMarker = 17;
            }
        }
        return drawMarker;
    }

    private String markerOut(int type) {
        String drawMarker;
        switch (type) {
            case 1: {
                drawMarker = "Triangle_20_unfilled";
                break;
            }
            case 3: {
                drawMarker = "Arrow";
                break;
            }
            case 5: {
                drawMarker = "Dimension_20_Line";
                break;
            }
            case 7: {
                drawMarker = "Circle";
                break;
            }
            case 8: {
                drawMarker = "Circle_20_unfilled";
                break;
            }
            case 9: {
                drawMarker = "Dimension_20_Lines";
                break;
            }
            case 10: {
                drawMarker = "Square";
                break;
            }
            case 11: {
                drawMarker = "Square_20_unfilled";
                break;
            }
            case 12: {
                drawMarker = "Reversed_20_Arrow";
                break;
            }
            case 18: {
                drawMarker = "Arrowheads_20_18";
                break;
            }
            case 19: {
                drawMarker = "CF_20_One";
                break;
            }
            case 20: {
                drawMarker = "CF_20_Many";
                break;
            }
            case 21: {
                drawMarker = "Square_20_45";
                break;
            }
            case 22: {
                drawMarker = "Square_20_45_20_unfilled";
                break;
            }
            case 25: {
                drawMarker = "CF_20_Only_20_One";
                break;
            }
            case 26: {
                drawMarker = "CF_20_Zero_20_One";
                break;
            }
            case 27: {
                drawMarker = "CF_20_Zero_20_Many";
                break;
            }
            case 28: {
                drawMarker = "CF_20_Many_20_One";
                break;
            }
            default: {
                drawMarker = "";
            }
        }
        return drawMarker;
    }

    private String markerWidthOut(String value) {
        return value.equals("") ? "0.2" : String.valueOf(OdgUtils.parseSizeValue(value) * 10.0);
    }

    public boolean hasAttributes(String attr) {
        for (Map.Entry map : this.styles.entrySet()) {
            String key = (String)map.getKey();
            if (!key.equals(attr)) continue;
            return true;
        }
        return false;
    }

    public boolean isGradientPattern(int typePattern) {
        for (GradientPattern pattern : GradientPattern.values()) {
            if (typePattern != pattern.getValue()) continue;
            return true;
        }
        return false;
    }

    public void checkGradient(BaseShape shape) {
        if (this.isGradientPattern(shape.BrushPattern)) {
            this.styles.put("draw:fill", "gradient");
        } else if (shape.BrushPattern == 0) {
            this.styles.put("draw:fill-color", OdgUtils.getColor(shape.bColor));
        }
    }

    public void correctSides(Paragraph paragraph) {
        BaseGraphic parentGB = paragraph.ParentGB;
        if (parentGB instanceof GraphicBlock) {
            GraphicBlock gb = (GraphicBlock)parentGB;
            paragraph.SideX = gb.MaxPtX - gb.MinPtX;
            paragraph.SideY = gb.MaxPtY - gb.MinPtY;
        } else if (parentGB instanceof Rectangle) {
            Rectangle rect = (Rectangle)parentGB;
            paragraph.SideX = rect.SideX;
            paragraph.SideY = rect.SideY;
        } else {
            Spline spline;
            SchemeEngine engine;
            BaseGraphic.RealRect rr = parentGB.getMinMaxRect();
            if (parentGB instanceof Spline && (engine = (spline = (Spline)parentGB).getEngine()) != null) {
                AffineTransform tm = engine.GTM;
                double[] pts = SchemeEngine.MulPointsTM(tm, spline.calcPoints());
                rr = SchemeUtils.getMinMaxPts(pts);
            }
            paragraph.SideX = rr.Right - rr.Left;
            paragraph.SideY = rr.Bottom - rr.Top;
        }
    }
}

