/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content;

import java.awt.Color;

public class OdgUtils {
    public static final double CM_TO_PT = 28.3465;
    public static final double PT_TO_CM = 0.3527;
    public static final double TABLE = 0.62240969;

    public static double parseSizeValue(String value) {
        return Double.parseDouble(value.substring(0, value.indexOf("cm")));
    }

    public static double parsePercentValue(String value) {
        return Double.parseDouble(value.substring(0, value.indexOf("%")));
    }

    public static double parseParagraphValue(String value) {
        return Double.parseDouble(value.substring(0, value.indexOf("pt")));
    }

    public static double asCentimeters(double millimeter) {
        return millimeter / 10.0;
    }

    public static double asMillimeters(double centimeters) {
        return centimeters * 10.0;
    }

    public static Color asColor(String value) {
        if (value == null || value.equals("transparent")) {
            return null;
        }
        return Color.decode(value);
    }

    public static int asInteger(String value) {
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static String asString(Number number) {
        return String.valueOf(number);
    }

    public static String asStringWithPoint(double value) {
        if (value == -1.0) {
            value = 0.1;
        }
        double num = OdgUtils.asCentimeters(value);
        return String.valueOf(num * 28.3465).concat("pt");
    }

    public static String asStringWithCentimeter(double value) {
        if (value == -1.0) {
            value = 0.0;
        }
        double num = OdgUtils.asCentimeters(value);
        return String.valueOf(num).concat("cm");
    }

    public static String asPercent(double value) {
        return String.valueOf(value).concat("%");
    }

    public static String asStringWithPercent(double value) {
        int percent = (int)Math.ceil(100.0 - value / 255.0 * 100.0);
        return String.valueOf(percent).concat("%");
    }

    public static String getColor(Color color) {
        return color == null ? "#000000" : String.format("#%06x", color.getRGB() & 0xFFFFFF);
    }

    public static String getColorGradient(Color color) {
        return color == null ? "#FFFFFF" : String.format("#%06x", color.getRGB() & 0xFFFFFF);
    }

    public static double asDouble(String value) {
        if (value == null) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public static byte asByte(String value) {
        if (value == null) {
            return 0;
        }
        return Byte.parseByte(value);
    }

    public static boolean asBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

