/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.content.evaluator;

import inform.agent.schemes.converters.odg.content.OdgEnhancedGeometry;
import inform.agent.schemes.converters.odg.content.evaluator.AbstractSyntaxTreeNode;
import inform.agent.schemes.converters.odg.content.evaluator.OdgExpressionTokenizer;
import inform.agent.schemes.converters.odg.content.evaluator.Token;
import java.util.ArrayList;
import java.util.Arrays;

public class OdgExpressionParser {
    private Token currentToken;
    private final OdgExpressionTokenizer oet;
    private final OdgEnhancedGeometry geometry;

    public OdgExpressionParser(OdgExpressionTokenizer oet, OdgEnhancedGeometry geometry) throws Exception {
        this.oet = oet;
        this.geometry = geometry;
        this.currentToken = oet.nextToken();
    }

    private Token skipToken(Token.Type ... types) throws Exception {
        Token current = this.currentToken;
        if (types.length != 0 && !this.isOfType(types)) {
            throw new Exception("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0442\u043e\u043a\u0435\u043d\u0430 (" + current.type.toString() + "), \u043e\u0436\u0438\u0434\u0430\u043b\u0441\u044f: " + types[0].toString());
        }
        this.currentToken = this.oet.nextToken();
        return current;
    }

    public AbstractSyntaxTreeNode parseExpression() throws Exception {
        AbstractSyntaxTreeNode left = this.calcMultiplication();
        while (this.isOfType(Token.Type.Addition, Token.Type.Subtraction)) {
            Token op = this.skipToken(Token.Type.Addition, Token.Type.Subtraction);
            AbstractSyntaxTreeNode right = this.calcMultiplication();
            left = new AbstractSyntaxTreeNode.AstElementaryOperationNode(op.value.charAt(0), left, right);
        }
        return left;
    }

    private AbstractSyntaxTreeNode calcMultiplication() throws Exception {
        AbstractSyntaxTreeNode left = this.basicOperand();
        while (this.isOfType(Token.Type.Multiplication, Token.Type.Division)) {
            Token op = this.skipToken(Token.Type.Multiplication, Token.Type.Division);
            AbstractSyntaxTreeNode right = this.basicOperand();
            left = new AbstractSyntaxTreeNode.AstElementaryOperationNode(op.value.charAt(0), left, right);
        }
        return left;
    }

    private AbstractSyntaxTreeNode calcAddition() throws Exception {
        AbstractSyntaxTreeNode left = this.calcMultiplication();
        while (this.isOfType(Token.Type.Addition, Token.Type.Subtraction)) {
            Token op = this.skipToken(Token.Type.Addition, Token.Type.Subtraction);
            AbstractSyntaxTreeNode right = this.calcMultiplication();
            left = new AbstractSyntaxTreeNode.AstElementaryOperationNode(op.value.charAt(0), left, right);
        }
        return left;
    }

    private AbstractSyntaxTreeNode basicOperand() throws Exception {
        if (this.isOfType(Token.Type.Negative)) {
            Token op = this.skipToken(Token.Type.Negative);
            AbstractSyntaxTreeNode right = this.calcMultiplication();
            return new AbstractSyntaxTreeNode.AstElementaryOperationNode(op.value.charAt(0), null, right);
        }
        if (this.isOfType(Token.Type.OpeningBracket)) {
            this.skipToken(Token.Type.OpeningBracket);
            AbstractSyntaxTreeNode expr = this.calcExpression();
            this.skipToken(Token.Type.ClosingBracket);
            return expr;
        }
        if (this.isOfType(Token.Type.Number)) {
            Token num = this.skipToken(Token.Type.Number);
            return new AbstractSyntaxTreeNode.AstNumberNode(Double.parseDouble(num.value));
        }
        if (this.isOfType(Token.Type.Subtraction)) {
            this.skipToken(Token.Type.Subtraction);
            if (this.isOfType(Token.Type.Number)) {
                Token number = this.skipToken(Token.Type.Number);
                return new AbstractSyntaxTreeNode.AstNumberNode(0.0 - Double.parseDouble(number.value));
            }
            if (this.isOfType(Token.Type.Dollar)) {
                Token dollar = this.skipToken(Token.Type.Dollar);
                Token number = this.skipToken(Token.Type.Number);
                Double value = this.geometry.getDrawModifiers().get(dollar.value + number);
                assert (value != null);
                return new AbstractSyntaxTreeNode.AstNumberNode(value);
            }
            if (this.isOfType(Token.Type.OpeningBracket)) {
                this.skipToken(Token.Type.OpeningBracket);
                AbstractSyntaxTreeNode expr = this.calcExpression();
                this.skipToken(Token.Type.ClosingBracket);
                return expr;
            }
        }
        if (this.isOfType(Token.Type.Dollar)) {
            Token dollar = this.skipToken(Token.Type.Dollar);
            Token number = this.skipToken(Token.Type.Number);
            Double value = this.geometry.getDrawModifiers().get(dollar.value + number);
            if (value != null) {
                return new AbstractSyntaxTreeNode.AstNumberNode(value);
            }
            return new AbstractSyntaxTreeNode.AstNumberNode(0.0);
        }
        if (this.isOfType(Token.Type.Function)) {
            Token function = this.skipToken(Token.Type.Function);
            this.skipToken(Token.Type.OpeningBracket);
            ArrayList<AbstractSyntaxTreeNode> functionArguments = new ArrayList<AbstractSyntaxTreeNode>();
            functionArguments.add(this.calcExpression());
            while (this.isOfType(Token.Type.Comma)) {
                this.skipToken(Token.Type.Comma);
                functionArguments.add(this.calcExpression());
            }
            this.skipToken(Token.Type.ClosingBracket);
            return new AbstractSyntaxTreeNode.AstFunctionCallNode(function.value, functionArguments);
        }
        if (this.isOfType(Token.Type.Variable)) {
            Token token = this.skipToken(Token.Type.Variable);
            return new AbstractSyntaxTreeNode.AstConstNode(token.value, this.geometry);
        }
        if (this.isOfType(Token.Type.Multiplication)) {
            return new AbstractSyntaxTreeNode.AstNumberNode(1.0);
        }
        throw new Exception("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
    }

    private AbstractSyntaxTreeNode calcExpression() throws Exception {
        return this.calcAddition();
    }

    private boolean isOfType(Token.Type ... types) {
        return Arrays.stream(types).filter(t -> t == this.currentToken.type).findFirst().orElse(null) != null;
    }
}

