/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeUtils;
import inform.agent.scripts.crypto.CryptoUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfDraw;
import org.apache.poi.hemf.record.emf.HemfFill;
import org.apache.poi.hemf.record.emf.HemfMisc;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.hwmf.record.HwmfBitmapDib;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfDraw;
import org.apache.poi.hwmf.record.HwmfMapMode;
import org.apache.poi.hwmf.record.HwmfMisc;
import org.apache.poi.hwmf.record.HwmfPenStyle;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfTernaryRasterOp;
import org.apache.poi.hwmf.record.HwmfWindowing;
import org.apache.poi.hwmf.usermodel.HwmfPicture;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.Units;

public class EmfReader {
    private static final byte[] EMF_SIGNATURE = new byte[]{32, 69, 77, 70};
    private static int HEADER_SIGNATURE = 40;
    private final SchemeEngine engine;
    private static int MIN_PIXELS_PNG = 24;
    private static int MAX_PIXELS = 4096;
    private static int MIN_PIXELS = 256;
    public static int DEFAULT_PIXELS = 1024;

    public static void main(String[] args) {
        InnerEmfReader.infoEmfFiles(args[0]);
    }

    public EmfReader(SchemeEngine engine) {
        this.engine = engine;
    }

    public static boolean isEmf(byte[] data) {
        if (data == null || data.length <= 84) {
            return false;
        }
        for (int i = 0; i < EMF_SIGNATURE.length; ++i) {
            if (EMF_SIGNATURE[i] == data[HEADER_SIGNATURE + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isWmf(byte[] data) {
        if (data == null || data.length <= 18) {
            return false;
        }
        HwmfPicture wmf = null;
        try {
            wmf = new HwmfPicture((InputStream)new ByteArrayInputStream(data));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wmf != null;
    }

    public boolean parseEmf(GraphicBlock parent, byte[] data) {
        HemfGraphics g;
        Graphics2D ctx;
        BufferedImage bufImg;
        int height;
        int width;
        Dimension2D dim;
        if (!EmfReader.isEmf(data) || parent == null) {
            return false;
        }
        if (parent.Objects == null) {
            parent.Objects = new ArrayList();
        }
        EmfPicture emf = new EmfPicture(data);
        emf.splitRecords();
        if (emf.hasImage) {
            dim = emf.getSize();
            width = Units.pointsToPixel((double)dim.getWidth());
            height = Units.pointsToPixel((double)dim.getHeight());
            bufImg = new BufferedImage(width, height, 2);
            ctx = bufImg.createGraphics();
            g = emf.initGraphics(ctx, new Rectangle2D.Double(0.0, 0.0, width, height));
            for (HemfRecord r : emf.getImageRecords()) {
                try {
                    g.draw(r);
                }
                catch (RuntimeException runtimeException) {}
            }
            ctx.dispose();
            PhxImage image = new PhxImage();
            image.setEngine(this.engine);
            image.Bmp = SchemeUtils.getImagePixels24(bufImg);
            image.BmpHeight = bufImg.getHeight();
            image.BmpWidth = bufImg.getWidth();
            if (image.Bmp != null) {
                image.ImageSize = image.Bmp.length;
            }
            image.SideX = 1.0;
            image.SideY = 1.0;
            parent.Objects.add(image);
        }
        if (emf.hasPrimitives) {
            dim = emf.getSize();
            width = Units.pointsToPixel((double)dim.getWidth());
            height = Units.pointsToPixel((double)dim.getHeight());
            bufImg = new BufferedImage(width, height, 2);
            ctx = bufImg.createGraphics();
            g = emf.initGraphics(ctx, new Rectangle2D.Double(0.0, 0.0, width, height));
            for (HemfRecord r : emf.getPrimitiveRecords()) {
                try {
                    HemfRecordType type = r.getEmfRecordType();
                    switch (type) {
                        case polygon: 
                        case polygon16: {
                            this.drawPolygon(parent, g, ctx, r);
                            break;
                        }
                        case polyPolygon: 
                        case polyPolygon16: {
                            this.drawPolyPolygon(parent, g, ctx, r);
                            break;
                        }
                        case strokePath: {
                            this.drawPath(parent, g, ctx, r, false);
                            break;
                        }
                        case strokeAndFillPath: 
                        case fillPath: {
                            this.drawPath(parent, g, ctx, r, true);
                            break;
                        }
                    }
                    g.draw(r);
                }
                catch (RuntimeException runtimeException) {}
            }
            ctx.dispose();
        }
        return !parent.Objects.isEmpty();
    }

    private PhxImage createImage(BufferedImage bufImg) {
        PhxImage image = new PhxImage();
        image.setEngine(this.engine);
        image.BmpHeight = bufImg.getHeight();
        image.BmpWidth = bufImg.getWidth();
        if (image.BmpHeight * image.BmpWidth > MIN_PIXELS_PNG) {
            try {
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufImg, "PNG", content);
                content.flush();
                if (content.size() > 0) {
                    image.Content = content.toByteArray();
                    image.StoreImage = image.Content != null && image.Content.length > 0;
                    image.Bmp = new byte[]{0};
                }
            }
            catch (Exception e) {
                Core.logger.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 BufferedImage \u0432 PNG", e);
            }
        }
        if (image.Bmp == null) {
            image.Bmp = SchemeUtils.getImagePixels24(bufImg);
        }
        if (image.Bmp != null) {
            image.ImageSize = image.Bmp.length;
        }
        image.SideX = 1.0;
        image.SideY = 1.0;
        return image;
    }

    public PhxImage parseEmfImage(byte[] data) throws IOException {
        int max;
        if (!EmfReader.isEmf(data)) {
            return null;
        }
        HemfPictureFix emf = new HemfPictureFix(new ByteArrayInputStream(data));
        Dimension2D dim = emf.getSize();
        int width = Units.pointsToPixel((double)dim.getWidth());
        int height = Units.pointsToPixel((double)dim.getHeight());
        double scale = 1.0;
        if (width > MAX_PIXELS || height > MAX_PIXELS) {
            max = Math.max(width, height);
            scale = (double)max / (double)MAX_PIXELS;
            if (scale != 0.0) {
                width = (int)((double)width / scale);
                height = (int)((double)height / scale);
            }
        } else if (width < MIN_PIXELS && height < MIN_PIXELS && (max = Math.max(width, height)) > 0) {
            scale = (double)max / (double)MIN_PIXELS;
            width = (int)((double)width / scale);
            height = (int)((double)height / scale);
        }
        BufferedImage bufImg = new BufferedImage(width, height, 2);
        Graphics2D g = bufImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint((RenderingHints.Key)Drawable.EMF_FORCE_HEADER_BOUNDS, true);
        emf.draw(g, new Rectangle2D.Double(0.0, 0.0, width, height));
        g.dispose();
        return this.createImage(bufImg);
    }

    public PhxImage parseWmfImage(byte[] data, int defWidth, int defHeight) throws IOException {
        double scale;
        int max;
        if (!EmfReader.isWmf(data)) {
            return null;
        }
        HwmfPictureFix wmf = new HwmfPictureFix(new ByteArrayInputStream(data));
        Dimension2D dim = wmf.getSize();
        int width = Units.pointsToPixel((double)dim.getWidth());
        int height = Units.pointsToPixel((double)dim.getHeight());
        if (width == 0 || height == 0) {
            width = defWidth;
            height = defHeight;
        }
        if (width > MAX_PIXELS || height > MAX_PIXELS) {
            max = Math.max(width, height);
            scale = (double)max / (double)MAX_PIXELS;
            if (scale != 0.0) {
                width = (int)((double)width / scale);
                height = (int)((double)height / scale);
            }
        } else if (width < MIN_PIXELS && height < MIN_PIXELS && (max = Math.max(width, height)) > 0) {
            scale = (double)MIN_PIXELS / (double)max;
            width = (int)((double)width * scale);
            height = (int)((double)height * scale);
        }
        BufferedImage bufImg = new BufferedImage(width, height, 2);
        Graphics2D g = bufImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint((RenderingHints.Key)Drawable.EMF_FORCE_HEADER_BOUNDS, true);
        wmf.draw(g, new Rectangle2D.Double(0.0, 0.0, width, height));
        g.dispose();
        return this.createImage(bufImg);
    }

    private static double diff(Rectangle2D bounds, Rectangle2D target) {
        double d = 0.0;
        for (int i = 0; i < 4; ++i) {
            Function<Rectangle2D, Double> fx = i < 2 ? RectangularShape::getMinX : RectangularShape::getMaxX;
            Function<Rectangle2D, Double> fy = i % 2 == 0 ? RectangularShape::getMinY : RectangularShape::getMaxY;
            d += Point2D.distanceSq(fx.apply(bounds), fy.apply(bounds), fx.apply(target), fy.apply(target));
        }
        return d;
    }

    private static boolean isClosedPath(double[] points) {
        assert (points != null);
        assert (points.length > 3);
        double tolerance = 1.0E-6;
        return SchemeUtils.isEqual(points[0], points[points.length - 2], tolerance) && SchemeUtils.isEqual(points[1], points[points.length - 1], tolerance);
    }

    private void drawPolygon(GraphicBlock parent, HemfGraphics graphics, Graphics2D context, HemfRecord record) {
        if (record instanceof HwmfDraw.WmfPolygon) {
            HwmfDraw.WmfPolygon r = (HwmfDraw.WmfPolygon)record;
            List<double[]> listPoints = EmfReader.getShapePoints(r.getPoly());
            if (listPoints.isEmpty()) {
                return;
            }
            DoubleList polygonPoints = new DoubleList(2);
            IntegerList polygonCounts = new IntegerList(2);
            listPoints.forEach(points -> {
                Arrays.stream(points).forEach(p -> polygonPoints.add(p));
                polygonCounts.add(((double[])points).length / 2);
            });
            if (polygonPoints.empty()) {
                return;
            }
            Polygon poly = new Polygon();
            poly.setEngine(this.engine);
            poly.Points = polygonPoints.toArray();
            poly.Counts = polygonCounts.toArray();
            this.applyShapeStyle(graphics, context, poly, true);
            parent.Objects.add(poly);
        }
    }

    private void drawPath(GraphicBlock parent, HemfGraphics graphics, Graphics2D context, HemfRecord record, boolean fill) {
        if (record instanceof HemfDraw.EmfStrokePath) {
            HemfDrawProperties props = graphics.getProperties();
            Path2D path = (Path2D)props.getPath().clone();
            if (fill) {
                path.closePath();
            }
            path.setWindingRule(props.getWindingRule());
            DoubleList polygonPoints = new DoubleList(2);
            IntegerList polygonCounts = new IntegerList(2);
            ArrayList polylinePoints = new ArrayList();
            List<double[]> listPoints = EmfReader.getShapePoints(path);
            listPoints.forEach(points -> {
                if (fill && EmfReader.isClosedPath(points)) {
                    Arrays.stream(points).forEach(p -> polygonPoints.add(p));
                    polygonCounts.add(((double[])points).length / 2);
                } else {
                    polylinePoints.add(points);
                }
            });
            if (!polygonPoints.empty()) {
                Polygon poly = new Polygon();
                poly.setEngine(this.engine);
                poly.Points = polygonPoints.toArray();
                poly.Counts = polygonCounts.toArray();
                this.applyShapeStyle(graphics, context, poly, true);
                parent.Objects.add(poly);
            }
            int cnt = polylinePoints.size();
            for (int i = 0; i < cnt; ++i) {
                Polyline poly = new Polyline();
                poly.setEngine(this.engine);
                poly.Points = (double[])polylinePoints.get(i);
                this.applyShapeStyle(graphics, context, poly, false);
                parent.Objects.add(poly);
            }
        }
    }

    private void drawPolyPolygon(GraphicBlock parent, HemfGraphics graphics, Graphics2D context, HemfRecord record) {
        if (record instanceof HwmfDraw.WmfPolyPolygon) {
            HwmfDraw.WmfPolyPolygon r = (HwmfDraw.WmfPolyPolygon)record;
            DoubleList polygonPoints = new DoubleList(2);
            IntegerList polygonCounts = new IntegerList(2);
            for (Shape poly : r.getPolyList()) {
                List<double[]> listPoints = EmfReader.getShapePoints(poly);
                listPoints.forEach(points -> {
                    Arrays.stream(points).forEach(p -> polygonPoints.add(p));
                    polygonCounts.add(((double[])points).length / 2);
                });
            }
            Polygon poly = new Polygon();
            poly.setEngine(this.engine);
            poly.Points = polygonPoints.toArray();
            poly.Counts = polygonCounts.toArray();
            this.applyShapeStyle(graphics, context, poly, true);
            parent.Objects.add(poly);
        }
    }

    private void applyShapeStyle(HemfGraphics graphics, Graphics2D context, BaseShape shape, boolean fill) {
        HemfDrawProperties properties = graphics.getProperties();
        HwmfPenStyle penStyle = properties.getPenStyle();
        HwmfPenStyle.HwmfLineDash lineDash = penStyle.getLineDash();
        shape.pColor = properties.getPenColor().getColor();
        shape.lWidth = penStyle.isGeometric() ? -1.0 : properties.getPenWidth();
        switch (lineDash) {
            case NULL: {
                shape.PenPattern = -1;
                break;
            }
            case SOLID: {
                shape.PenPattern = 0;
                break;
            }
            case DASH: {
                shape.PenPattern = 1;
                break;
            }
            case DOT: {
                shape.PenPattern = 2;
                break;
            }
            case DASHDOT: {
                shape.PenPattern = 3;
                break;
            }
            case DASHDOTDOT: {
                shape.PenPattern = 4;
                break;
            }
            default: {
                shape.PenPattern = 0;
            }
        }
        if (!fill) {
            return;
        }
        shape.bColor = properties.getBrushColor().getColor();
        HwmfBrushStyle brushStyle = properties.getBrushStyle();
        switch (brushStyle) {
            case BS_NULL: {
                shape.BrushPattern = 1;
                break;
            }
            case BS_SOLID: {
                shape.BrushPattern = 0;
                break;
            }
            default: {
                shape.BrushPattern = 0;
            }
        }
    }

    private static List<double[]> getShapePoints(Shape shape) {
        assert (shape != null);
        ArrayList<double[]> result = new ArrayList<double[]>();
        double[] coords = new double[6];
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        BaseGraphic.RealPoints points = new BaseGraphic.RealPoints();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(coords)) {
                case 0: {
                    if (points.size() > 1) {
                        result.add(points.getPoints());
                    }
                    points.clear();
                    points.add(new BaseGraphic.RealPoint(coords[0], coords[1]));
                    break;
                }
                case 1: {
                    points.add(new BaseGraphic.RealPoint(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    double d3;
                    double d2;
                    assert (!points.isEmpty());
                    BaseGraphic.RealPoint p1 = (BaseGraphic.RealPoint)points.get(points.size() - 1);
                    BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint(coords[0], coords[1]);
                    BaseGraphic.RealPoint p3 = new BaseGraphic.RealPoint(coords[2], coords[3]);
                    double d1 = SchemeUtils.distance(p1, p2);
                    if (!(d1 + (d2 = SchemeUtils.distance(p2, p3)) + (d3 = SchemeUtils.distance(p1, p3)) > BaseGraphic.FloatTolerance)) break;
                    int sides = (int)(90.0 / (d1 + d2 + d3) * d3);
                    BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToQuadBezArc(p1, p2, p3, sides);
                    points.addAll(sidesToArc);
                    break;
                }
                case 3: {
                    assert (!points.isEmpty());
                    BaseGraphic.RealPoint p1 = (BaseGraphic.RealPoint)points.get(points.size() - 1);
                    BaseGraphic.RealPoint p2 = new BaseGraphic.RealPoint(coords[0], coords[1]);
                    BaseGraphic.RealPoint p3 = new BaseGraphic.RealPoint(coords[2], coords[3]);
                    BaseGraphic.RealPoint p4 = new BaseGraphic.RealPoint(coords[4], coords[5]);
                    double d1 = SchemeUtils.distance(p1, p2);
                    double d2 = SchemeUtils.distance(p2, p3);
                    double d3 = SchemeUtils.distance(p3, p4);
                    double d4 = SchemeUtils.distance(p1, p4);
                    if (!(d1 + d2 + d3 > BaseGraphic.FloatTolerance)) break;
                    int sides = (int)(90.0 / (d1 + d2 + d3 + d4) * (d2 + d4));
                    BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToCubeBezArc(p1, p2, p3, p4, sides);
                    points.addAll(sidesToArc);
                    break;
                }
            }
            pathIterator.next();
        }
        if (points.size() > 1) {
            result.add(points.getPoints());
        }
        return result;
    }

    private static class EmfPicture
    extends HemfPicture {
        private List<HemfRecord> imageRecords;
        private List<HemfRecord> primitiveRecords;
        private boolean hasPrimitives = false;
        private boolean hasImage = false;

        EmfPicture(byte[] content) {
            super((InputStream)new ByteArrayInputStream(content));
        }

        HemfGraphics initGraphics(Graphics2D ctx, Rectangle2D graphicsBounds) {
            Rectangle2D b;
            ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ctx.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ctx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            ctx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            Rectangle2D emfBounds = this.getHeader().getBoundsRectangle();
            Rectangle2D.Double winBounds = new Rectangle2D.Double(-1.0, -1.0, 0.0, 0.0);
            Rectangle2D.Double viewBounds = new Rectangle2D.Double(-1.0, -1.0, 0.0, 0.0);
            Rectangle2D.Double recBounds = new Rectangle2D.Double();
            this.getInnerBounds(winBounds, viewBounds, recBounds);
            Boolean forceHeader = (Boolean)ctx.getRenderingHint((RenderingHints.Key)Drawable.EMF_FORCE_HEADER_BOUNDS);
            if (forceHeader == null) {
                forceHeader = false;
            }
            if (forceHeader.booleanValue()) {
                b = emfBounds;
            } else if (((RectangularShape)recBounds).isEmpty()) {
                b = !((RectangularShape)viewBounds).isEmpty() ? viewBounds : (!((RectangularShape)winBounds).isEmpty() ? winBounds : emfBounds);
            } else {
                Optional<Rectangle2D> result = Stream.of(emfBounds, winBounds, viewBounds).min(Comparator.comparingDouble(r -> EmfReader.diff(r, recBounds)));
                if (result.isPresent()) {
                    b = result.get();
                } else {
                    throw new IllegalStateException("Failed to create Rectangle2D for drawing");
                }
            }
            ctx.translate(graphicsBounds.getCenterX(), graphicsBounds.getCenterY());
            ctx.scale(graphicsBounds.getWidth() / b.getWidth(), graphicsBounds.getHeight() / b.getHeight());
            ctx.translate(-b.getCenterX(), -b.getCenterY());
            return new HemfGraphics(ctx, b);
        }

        private void splitRecords() {
            this.imageRecords = new ArrayList<HemfRecord>();
            this.primitiveRecords = new ArrayList<HemfRecord>();
            for (HemfRecord r : super.getRecords()) {
                HemfRecordType recordType = r.getEmfRecordType();
                switch (recordType) {
                    case polygon: 
                    case polygon16: 
                    case polyPolygon: 
                    case polyPolygon16: 
                    case strokePath: 
                    case strokeAndFillPath: 
                    case fillPath: 
                    case polyBezier: 
                    case polyline: 
                    case polyBezierTo: 
                    case polylineTo: 
                    case polyPolyline: 
                    case setMoveToEx: 
                    case anglearc: 
                    case ellipse: 
                    case rectangle: 
                    case roundRect: 
                    case arc: 
                    case chord: 
                    case pie: 
                    case lineTo: 
                    case arcTo: 
                    case polyDraw: 
                    case beginPath: 
                    case endPath: 
                    case flattenPath: 
                    case widenPath: 
                    case selectClipPath: 
                    case abortPath: 
                    case extTextOutA: 
                    case extTextOutW: 
                    case polyBezier16: 
                    case polyline16: 
                    case polyBezierTo16: 
                    case polylineTo16: 
                    case polyPolyline16: 
                    case polyDraw16: 
                    case polytextouta: 
                    case polytextoutw: 
                    case smalltextout: {
                        this.hasPrimitives = true;
                        this.primitiveRecords.add(r);
                        break;
                    }
                    case setPixelV: 
                    case bitBlt: 
                    case stretchBlt: 
                    case setDiBitsToDevice: 
                    case stretchDiBits: {
                        this.hasImage = true;
                        this.imageRecords.add(r);
                        break;
                    }
                    case header: 
                    case setWindowExtEx: 
                    case setWindowOrgEx: 
                    case setViewportExtEx: 
                    case setViewportOrgEx: 
                    case setBrushOrgEx: 
                    case eof: 
                    case setMapperFlags: 
                    case setMapMode: 
                    case setBkMode: 
                    case setPolyfillMode: 
                    case setRop2: 
                    case setStretchBltMode: 
                    case setTextAlign: 
                    case setcoloradjustment: 
                    case setTextColor: 
                    case setBkColor: 
                    case setOffsetClipRgn: 
                    case setmetargn: 
                    case setExcludeClipRect: 
                    case setIntersectClipRect: 
                    case scaleViewportExtEx: 
                    case scaleWindowExtEx: 
                    case saveDc: 
                    case restoreDc: 
                    case setWorldTransform: 
                    case modifyWorldTransform: 
                    case selectObject: 
                    case createPen: 
                    case createBrushIndirect: 
                    case deleteobject: 
                    case selectPalette: 
                    case createPalette: 
                    case setPaletteEntries: 
                    case resizePalette: 
                    case realizePalette: 
                    case extFloodFill: 
                    case setarcdirection: 
                    case setMiterLimit: 
                    case closeFigure: 
                    case comment: 
                    case fillRgn: 
                    case frameRgn: 
                    case invertRgn: 
                    case paintRgn: 
                    case extSelectClipRgn: 
                    case maskblt: 
                    case plgblt: 
                    case extCreateFontIndirectW: 
                    case createMonoBrush: 
                    case createDibPatternBrushPt: 
                    case extCreatePen: 
                    case seticmmode: 
                    case createcolorspace: 
                    case setcolorspace: 
                    case deletecolorspace: 
                    case glsrecord: 
                    case glsboundedrecord: 
                    case pixelformat: 
                    case drawescape: 
                    case extescape: 
                    case forceufimapping: 
                    case namedescape: 
                    case colorcorrectpalette: 
                    case seticmprofilea: 
                    case seticmprofilew: 
                    case alphaBlend: 
                    case setlayout: 
                    case transparentblt: 
                    case gradientfill: 
                    case setlinkdufis: 
                    case settextjustification: 
                    case colormatchtargetw: 
                    case createcolorspacew: {
                        this.imageRecords.add(r);
                        this.primitiveRecords.add(r);
                        break;
                    }
                }
            }
        }

        public List<HemfRecord> getImageRecords() {
            if (this.imageRecords == null) {
                this.splitRecords();
            }
            return this.imageRecords;
        }

        public List<HemfRecord> getPrimitiveRecords() {
            if (this.primitiveRecords == null) {
                this.splitRecords();
            }
            return this.primitiveRecords;
        }

        public List<HemfRecord> getAllRecords() {
            return super.getRecords();
        }
    }

    public static class InnerEmfReader {
        private static int HEADER_SIZE = 4;
        private static int HEADER_RECORDS = 52;
        private static final int EMR_HEADER = 1;
        private static final int EMR_POLYBEZIER = 2;
        private static final int EMR_POLYGON = 3;
        private static final int EMR_POLYLINE = 4;
        private static final int EMR_POLYBEZIERTO = 5;
        private static final int EMR_POLYLINETO = 6;
        private static final int EMR_POLYPOLYLINE = 7;
        private static final int EMR_POLYPOLYGON = 8;
        private static final int EMR_SETWINDOWEXTEX = 9;
        private static final int EMR_SETWINDOWORGEX = 10;
        private static final int EMR_SETVIEWPORTEXTEX = 11;
        private static final int EMR_SETVIEWPORTORGEX = 12;
        private static final int EMR_SETBRUSHORGEX = 13;
        private static final int EMR_EOF = 14;
        private static final int EMR_SETPIXELV = 15;
        private static final int EMR_SETMAPPERFLAGS = 16;
        private static final int EMR_SETMAPMODE = 17;
        private static final int EMR_SETBKMODE = 18;
        private static final int EMR_SETPOLYFILLMODE = 19;
        private static final int EMR_SETROP2 = 20;
        private static final int EMR_SETSTRETCHBLTMODE = 21;
        private static final int EMR_SETTEXTALIGN = 22;
        private static final int EMR_SETCOLORADJUSTMENT = 23;
        private static final int EMR_SETTEXTCOLOR = 24;
        private static final int EMR_SETBKCOLOR = 25;
        private static final int EMR_OFFSETCLIPRGN = 26;
        private static final int EMR_MOVETOEX = 27;
        private static final int EMR_SETMETARGN = 28;
        private static final int EMR_EXCLUDECLIPRECT = 29;
        private static final int EMR_INTERSECTCLIPRECT = 30;
        private static final int EMR_SCALEVIEWPORTEXTEX = 31;
        private static final int EMR_SCALEWINDOWEXTEX = 32;
        private static final int EMR_SAVEDC = 33;
        private static final int EMR_RESTOREDC = 34;
        private static final int EMR_SETWORLDTRANSFORM = 35;
        private static final int EMR_MODIFYWORLDTRANSFORM = 36;
        private static final int EMR_SELECTOBJECT = 37;
        private static final int EMR_CREATEPEN = 38;
        private static final int EMR_CREATEBRUSHINDIRECT = 39;
        private static final int EMR_DELETEOBJECT = 40;
        private static final int EMR_ANGLEARC = 41;
        private static final int EMR_ELLIPSE = 42;
        private static final int EMR_RECTANGLE = 43;
        private static final int EMR_ROUNDRECT = 44;
        private static final int EMR_ARC = 45;
        private static final int EMR_CHORD = 46;
        private static final int EMR_PIE = 47;
        private static final int EMR_SELECTPALETTE = 48;
        private static final int EMR_CREATEPALETTE = 49;
        private static final int EMR_SETPALETTEENTRIES = 50;
        private static final int EMR_RESIZEPALETTE = 51;
        private static final int EMR_REALIZEPALETTE = 52;
        private static final int EMR_EXTFLOODFILL = 53;
        private static final int EMR_LINETO = 54;
        private static final int EMR_ARCTO = 55;
        private static final int EMR_POLYDRAW = 56;
        private static final int EMR_SETARCDIRECTION = 57;
        private static final int EMR_SETMITERLIMIT = 58;
        private static final int EMR_BEGINPATH = 59;
        private static final int EMR_ENDPATH = 60;
        private static final int EMR_CLOSEFIGURE = 61;
        private static final int EMR_FILLPATH = 62;
        private static final int EMR_STROKEANDFILLPATH = 63;
        private static final int EMR_STROKEPATH = 64;
        private static final int EMR_FLATTENPATH = 65;
        private static final int EMR_WIDENPATH = 66;
        private static final int EMR_SELECTCLIPPATH = 67;
        private static final int EMR_ABORTPATH = 68;
        private static final int EMR_GDICOMMENT = 70;
        private static final int EMR_FILLRGN = 71;
        private static final int EMR_FRAMERGN = 72;
        private static final int EMR_INVERTRGN = 73;
        private static final int EMR_PAINTRGN = 74;
        private static final int EMR_EXTSELECTCLIPRGN = 75;
        private static final int EMR_BITBLT = 76;
        private static final int EMR_STRETCHBLT = 77;
        private static final int EMR_MASKBLT = 78;
        private static final int EMR_PLGBLT = 79;
        private static final int EMR_SETDIBITSTODEVICE = 80;
        private static final int EMR_STRETCHDIBITS = 81;
        private static final int EMR_EXTCREATEFONTINDIRECTW = 82;
        private static final int EMR_EXTTEXTOUTA = 83;
        private static final int EMR_EXTTEXTOUTW = 84;
        private static final int EMR_POLYBEZIER16 = 85;
        private static final int EMR_POLYGON16 = 86;
        private static final int EMR_POLYLINE16 = 87;
        private static final int EMR_POLYBEZIERTO16 = 88;
        private static final int EMR_POLYLINETO16 = 89;
        private static final int EMR_POLYPOLYLINE16 = 90;
        private static final int EMR_POLYPOLYGON16 = 91;
        private static final int EMR_POLYDRAW16 = 92;
        private static final int EMR_CREATEMONOBRUSH = 93;
        private static final int EMR_CREATEDIBPATTERNBRUSHPT = 94;
        private static final int EMR_EXTCREATEPEN = 95;
        private static final int EMR_POLYTEXTOUTA = 96;
        private static final int EMR_POLYTEXTOUTW = 97;
        private static final int EMR_SETICMMODE = 98;
        private static final int EMR_CREATECOLORSPACE = 99;
        private static final int EMR_SETCOLORSPACE = 100;
        private static final int EMR_DELETECOLORSPACE = 101;
        private static final int EMR_GLSRECORD = 102;
        private static final int EMR_GLSBOUNDEDRECORD = 103;
        private static final int EMR_PIXELFORMAT = 104;
        private static final int EMR_DRAWESCAPE = 105;
        private static final int EMR_EXTESCAPE = 106;
        private static final int EMR_SMALLTEXTOUT = 108;
        private static final int EMR_FORCEUFIMAPPING = 109;
        private static final int EMR_NAMEDESCAPE = 110;
        private static final int EMR_COLORCORRECTPALETTE = 111;
        private static final int EMR_SETICMPROFILEA = 112;
        private static final int EMR_SETICMPROFILEW = 113;
        private static final int EMR_ALPHABLEND = 114;
        private static final int EMR_SETLAYOUT = 115;
        private static final int EMR_TRANSPARENTBLT = 116;
        private static final int EMR_GRADIENTFILL = 118;
        private static final int EMR_SETLINKEDUFIS = 119;
        private static final int EMR_SETTEXTJUSTIFICATION = 120;
        private static final int EMR_COLORMATCHTOTARGETW = 121;
        private static final int EMR_CREATECOLORSPACEW = 122;
        private static final int EMR_LAST = 122;
        private static final String[] FUNCTION_NANES = new String[123];
        private static final int WHITE_BRUSH = Integer.MIN_VALUE;
        private static final int LTGRAY_BRUSH = -2147483647;
        private static final int GRAY_BRUSH = -2147483646;
        private static final int DKGRAY_BRUSH = -2147483645;
        private static final int BLACK_BRUSH = -2147483644;
        private static final int NULL_BRUSH = -2147483643;
        private static final int WHITE_PEN = -2147483642;
        private static final int BLACK_PEN = -2147483641;
        private static final int NULL_PEN = -2147483640;
        private static final int OEM_FIXED_FONT = -2147483638;
        private static final int ANSI_FIXED_FONT = -2147483637;
        private static final int ANSI_VAR_FONT = -2147483636;
        private static final int SYSTEM_FONT = -2147483635;
        private static final int DEVICE_DEFAULT_FONT = -2147483634;
        private static final int DEFAULT_PALETTE = -2147483633;
        private static final int SYSTEM_FIXED_FONT = -2147483632;
        private static final int DEFAULT_GUI_FONT = -2147483631;
        private static final int DC_BRUSH = -2147483630;
        private static final int DC_PEN = -2147483629;
        private static final int BS_SOLID = 0;
        private static final int BS_NULL = 1;
        private static final int BS_HATCHED = 2;
        private static final int BS_PATTERN = 3;
        private static final int BS_INDEXED = 4;
        private static final int BS_DIBPATTERN = 5;
        private static final int BS_DIBPATTERNPT = 6;
        private static final int BS_PATTERN8X8 = 7;
        private static final int BS_DIBPATTERN8X8 = 8;
        private static final int BS_MONOPATTERN = 9;
        private static final int HS_SOLIDCLR = 6;
        private static final int HS_DITHEREDCLR = 7;
        private static final int HS_SOLIDTEXTCLR = 8;
        private static final int HS_DITHEREDTEXTCLR = 9;
        private static final int HS_SOLIDBKCLR = 10;
        private static final int HS_DITHEREDBKCLR = 11;
        private static final int PS_SOLID = 0;
        private static final int PS_DASH = 1;
        private static final int PS_DOT = 2;
        private static final int PS_DASHDOT = 3;
        private static final int PS_DASHDOTDOT = 4;
        private static final int PS_NULL = 5;
        private static final int PS_INSIDEFRAME = 6;
        private static final int PS_USERSTYLE = 7;
        private static final int PS_ALTERNATE = 8;
        private static final int PS_STYLE_MASK = 15;
        private static final int PS_ENDCAP_ROUND = 0;
        private static final int PS_ENDCAP_SQUARE = 256;
        private static final int PS_ENDCAP_FLAT = 512;
        private static final int PS_ENDCAP_MASK = 3840;
        private static final int PS_JOIN_ROUND = 0;
        private static final int PS_JOIN_BEVEL = 4096;
        private static final int PS_JOIN_MITER = 8192;
        private static final int PS_JOIN_MASK = 61440;
        private static final int PS_COSMETIC = 0;
        private static final int PS_GEOMETRIC = 65536;
        private static final int PS_TYPE_MASK = 983040;
        private static final int TRANSPARENT = 1;
        private static final int OPAQUE = 2;
        private static final int ALTERNATE = 1;
        private static final int WINDING = 2;
        private final List<double[]> currentPaths = new ArrayList<double[]>();
        private final BaseGraphic.RealPoints currentPath = new BaseGraphic.RealPoints();
        private final SchemeEngine engine;
        private PhxImage phxImage = null;
        Map<Integer, DeviceContext> globalObjects = new HashMap<Integer, DeviceContext>();
        DeviceContext dc = new DeviceContext();

        public InnerEmfReader(SchemeEngine engine) {
            this.engine = engine;
        }

        private Color readColor(byte[] data, int offset) {
            if (data != null && 0 <= offset && offset + 2 < data.length) {
                int r = Byte.toUnsignedInt(data[offset]);
                int g = Byte.toUnsignedInt(data[offset + 1]);
                int b = Byte.toUnsignedInt(data[offset + 2]);
                return new Color(r, g, b);
            }
            return new Color(0, 0, 0);
        }

        private BaseGraphic.RealRect readBounds(byte[] data, int offset) {
            assert (data != null);
            assert (data.length >= offset + 16);
            BaseGraphic.RealRect bounds = new BaseGraphic.RealRect();
            bounds.Left = LittleEndian.getInt(data, offset);
            bounds.Top = LittleEndian.getInt(data, offset + 4);
            bounds.Right = LittleEndian.getInt(data, offset + 8);
            bounds.Bottom = LittleEndian.getInt(data, offset + 12);
            return bounds;
        }

        private void addChild(GraphicBlock parent, BaseShape shape) {
            assert (parent != null);
            assert (shape != null);
            assert (parent.Objects != null);
            this.applyStyle(shape);
            parent.Objects.add(shape);
        }

        private BaseGraphic.RealPoint readPoint(byte[] data, int offset) {
            assert (data != null);
            assert (data.length >= 8);
            int x = LittleEndian.getInt(data, offset);
            int y = LittleEndian.getInt(data, offset += 4);
            offset += 4;
            return new BaseGraphic.RealPoint(x, y);
        }

        private BaseGraphic.RealPoints readPoints(byte[] data, int offset, int cnt) {
            assert (data != null);
            assert (data.length >= cnt * 8);
            BaseGraphic.RealPoints points = new BaseGraphic.RealPoints();
            for (int i = 0; i < cnt; ++i) {
                int x = LittleEndian.getInt(data, offset);
                int y = LittleEndian.getInt(data, offset += 4);
                offset += 4;
                points.add(new BaseGraphic.RealPoint(x, y));
            }
            return points;
        }

        private BaseGraphic.RealPoints readPoints16(byte[] data, int offset, int cnt) {
            assert (data != null);
            assert (data.length >= cnt * 4);
            BaseGraphic.RealPoints points = new BaseGraphic.RealPoints();
            for (int i = 0; i < cnt; ++i) {
                short x = LittleEndian.getShort(data, offset);
                short y = LittleEndian.getShort(data, offset += 2);
                offset += 2;
                points.add(new BaseGraphic.RealPoint(x, y));
            }
            return points;
        }

        private void applyStyle(BaseShape shape) {
            if (this.dc == null) {
                return;
            }
            switch (this.dc.brushStyle) {
                case 0: {
                    shape.bColor = this.dc.brushColor;
                    shape.BrushPattern = 0;
                    break;
                }
                case 1: {
                    shape.BrushPattern = 1;
                    break;
                }
                case 2: {
                    break;
                }
            }
            int penStyle = this.dc.penStyle & 0xF;
            boolean isCosmetic = (this.dc.penStyle & 0xF0000) != 0;
            shape.lWidth = isCosmetic ? -1.0 : (double)this.dc.penWidth;
            shape.pColor = this.dc.penColor;
            switch (penStyle) {
                case 5: {
                    shape.PenPattern = -1;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    shape.PenPattern = penStyle;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    shape.PenPattern = 5;
                }
            }
        }

        private void applyCurrentPaths(GraphicBlock parent, boolean fill) {
            int i;
            if (!this.currentPath.isEmpty()) {
                this.currentPaths.add(this.currentPath.getPoints());
                this.currentPath.clear();
            }
            if (this.currentPaths.isEmpty()) {
                return;
            }
            int counts = this.currentPaths.size();
            DoubleList polygonPoints = new DoubleList(2);
            IntegerList polygonCounts = new IntegerList(2);
            ArrayList<double[]> polylinePoints = new ArrayList<double[]>();
            for (i = 0; i < counts; ++i) {
                double[] points = this.currentPaths.get(i);
                if (points == null || points.length < 4) continue;
                if (this.isClosedPath(points)) {
                    Arrays.stream(points).forEach(p -> polygonPoints.add(p));
                    polygonCounts.add(points.length);
                    continue;
                }
                polylinePoints.add(points);
            }
            if (!polygonPoints.empty()) {
                Polygon poly = new Polygon();
                poly.setEngine(this.engine);
                poly.Counts = polygonCounts.toArray();
                poly.Points = polygonPoints.toArray();
                this.addChild(parent, poly);
            }
            int cnt = polylinePoints.size();
            for (i = 0; i < cnt; ++i) {
                Polyline poly = new Polyline();
                poly.setEngine(this.engine);
                poly.Points = (double[])polylinePoints.get(i);
                this.addChild(parent, poly);
            }
            this.currentPaths.clear();
        }

        private void parsePolygon(GraphicBlock parent, byte[] data, int offset) {
            assert (parent != null);
            assert (LittleEndian.getInt(data, offset) == 3);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 28);
            int cnt = LittleEndian.getInt(data, offset + 24);
            assert (size == 28 + cnt * 8);
            BaseGraphic.RealPoints points = this.readPoints(data, offset + 28, cnt);
            if (points.isEmpty()) {
                return;
            }
            Polygon poly = new Polygon();
            poly.setEngine(this.engine);
            poly.Points = points.getPoints();
            poly.Counts = new int[]{poly.Points.length};
            this.addChild(parent, poly);
        }

        private void parsePolygon16(GraphicBlock parent, byte[] data, int offset) {
            assert (parent != null);
            assert (LittleEndian.getInt(data, offset) == 86);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 28);
            int cnt = LittleEndian.getInt(data, offset + 24);
            assert (size == 28 + cnt * 4);
            BaseGraphic.RealPoints points = this.readPoints16(data, offset + 28, cnt);
            if (points.isEmpty()) {
                return;
            }
            Polygon poly = new Polygon();
            poly.setEngine(this.engine);
            poly.Points = points.getPoints();
            poly.Counts = new int[]{poly.Points.length};
            this.addChild(parent, poly);
        }

        private void parsePolyPolygon(GraphicBlock parent, byte[] data, int offset) {
            assert (parent != null);
            assert (LittleEndian.getInt(data, offset) == 8);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 28);
            int cntCounts = LittleEndian.getInt(data, offset + 24);
            if (cntCounts == 0) {
                return;
            }
            Polygon poly = new Polygon();
            poly.setEngine(this.engine);
            poly.Counts = new int[cntCounts];
            assert (size >= 28 + cntCounts * 4);
            int cntPoints = 0;
            offset += 32;
            for (int i = 0; i < cntCounts; ++i) {
                int cnt;
                poly.Counts[i] = cnt = LittleEndian.getInt(data, offset);
                offset += 4;
                cntPoints += cnt;
            }
            assert (size == 32 + cntCounts * 4 + cntPoints * 8);
            BaseGraphic.RealPoints points = this.readPoints(data, offset, cntPoints);
            assert (!points.isEmpty());
            poly.Points = points.getPoints();
            this.addChild(parent, poly);
        }

        private void parsePolyPolygon16(GraphicBlock parent, byte[] data, int offset) {
            assert (parent != null);
            assert (LittleEndian.getInt(data, offset) == 91);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 28);
            int cntCounts = LittleEndian.getInt(data, offset + 24);
            if (cntCounts == 0) {
                return;
            }
            Polygon poly = new Polygon();
            poly.setEngine(this.engine);
            poly.Counts = new int[cntCounts];
            assert (size >= 28 + cntCounts * 4);
            int cntPoints = 0;
            offset += 32;
            for (int i = 0; i < cntCounts; ++i) {
                int cnt;
                poly.Counts[i] = cnt = LittleEndian.getInt(data, offset);
                offset += 4;
                cntPoints += cnt;
            }
            assert (size == 32 + cntCounts * 4 + cntPoints * 4);
            BaseGraphic.RealPoints points = this.readPoints16(data, offset, cntPoints);
            assert (!points.isEmpty());
            poly.Points = points.getPoints();
            this.addChild(parent, poly);
        }

        static HwmfBitmapDib readBitmap(byte[] data, int cbHeader, int offBmi, int cbBmi, int offBits, int cbBits) throws IOException {
            HwmfBitmapDib bitmap = null;
            if (offBmi == 0) {
                return bitmap;
            }
            if (cbBmi == 0 || cbBits == 0) {
                return null;
            }
            int undefinedSpace = offBits - cbHeader - cbBmi;
            assert (undefinedSpace >= 0);
            int dibSize = cbBmi + cbBits;
            if (undefinedSpace > 0) {
                int max = dibSize;
                for (int i = cbBmi; i < max; ++i) {
                    data[i] = data[i + undefinedSpace];
                }
            }
            if ((bitmap = new HwmfBitmapDib()).init(new LittleEndianInputStream((InputStream)new ByteArrayInputStream(data)), dibSize) > 0) {
                return bitmap;
            }
            return null;
        }

        private void parseExtTextOutW(GraphicBlock parent, byte[] data, int offset) {
            assert (parent != null);
            assert (LittleEndian.getInt(data, offset) == 84);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 80);
        }

        private void parseStretchDIB(GraphicBlock parent, byte[] data, int offset) {
            assert (parent != null);
            assert (LittleEndian.getInt(data, offset) == 81);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 80);
            int offBmiSrc = LittleEndian.getInt(data, offset + 48);
            int cbBmiSrc = LittleEndian.getInt(data, offset + 52);
            int offBitsSrc = LittleEndian.getInt(data, offset + 56);
            int cbBitsSrc = LittleEndian.getInt(data, offset + 60);
            byte[] bitmapBuffer = Arrays.copyOfRange(data, offset + 80, offset + size);
            try {
                HwmfBitmapDib bitmap = InnerEmfReader.readBitmap(bitmapBuffer, 80, offBmiSrc, cbBmiSrc, offBitsSrc, cbBitsSrc);
                if (bitmap == null) {
                    return;
                }
                BufferedImage bmp = bitmap.getImage();
                if (bmp == null) {
                    return;
                }
                bmp = SchemeUtils.transformImageToABGR(bmp);
                PhxImage image = new PhxImage();
                image.setEngine(this.engine);
                image.Bmp = SchemeUtils.getImagePixels24(bmp);
                image.BmpHeight = bmp.getHeight();
                image.BmpWidth = bmp.getWidth();
                if (image.Bmp != null) {
                    image.ImageSize = image.Bmp.length;
                }
                image.SideX = 1.0;
                image.SideY = 1.0;
                this.phxImage = image;
            }
            catch (IOException ex) {
                Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b EMR_STRETCHDIBITS", ex);
            }
        }

        private void parseMoveToEx(byte[] data, int offset) {
            assert (LittleEndian.getInt(data, offset) == 27);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size == 16);
            if (!this.currentPath.isEmpty()) {
                this.currentPaths.add(this.currentPath.getPoints());
                this.currentPath.clear();
            }
            this.currentPath.addAll(this.readPoints(data, offset + 8, 1));
        }

        private void addBezierToPath(BaseGraphic.RealPoints points) {
            assert (points != null && !points.isEmpty());
            assert (!this.currentPath.isEmpty());
            int cnt = points.size() / 3;
            for (int i = 0; i < cnt; ++i) {
                BaseGraphic.RealPoint p1 = (BaseGraphic.RealPoint)this.currentPath.get(this.currentPath.size() - 1);
                int idx = i * 3;
                BaseGraphic.RealPoint p2 = (BaseGraphic.RealPoint)points.get(idx);
                BaseGraphic.RealPoint p3 = (BaseGraphic.RealPoint)points.get(idx + 1);
                BaseGraphic.RealPoint p4 = (BaseGraphic.RealPoint)points.get(idx + 2);
                double d1 = SchemeUtils.distance(p1, p2);
                double d2 = SchemeUtils.distance(p2, p3);
                double d3 = SchemeUtils.distance(p3, p4);
                double d4 = SchemeUtils.distance(p1, p4);
                if (!(d1 + d2 + d3 > BaseGraphic.FloatTolerance)) continue;
                int sides = (int)(90.0 / (d1 + d2 + d3 + d4) * (d2 + d4));
                BaseGraphic.RealPoints sidesToArc = SchemeUtils.sidesToCubeBezArc(p1, p2, p3, p4, sides);
                this.currentPath.addAll(sidesToArc);
            }
        }

        private void parseLineTo(byte[] data, int offset) {
            assert (LittleEndian.getInt(data, offset) == 54);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size == 16);
            BaseGraphic.RealPoint point = this.readPoint(data, offset + 8);
            this.currentPath.add(point);
        }

        private void parsePolyBezierTo(byte[] data, int offset) {
            assert (LittleEndian.getInt(data, offset) == 5);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 28);
            int cntPoints = LittleEndian.getInt(data, offset + 24);
            BaseGraphic.RealPoints points = this.readPoints(data, offset + 28, cntPoints);
            this.addBezierToPath(points);
        }

        private void parsePolyBezierTo16(byte[] data, int offset) {
            assert (LittleEndian.getInt(data, offset) == 88);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size >= 28);
            int cntPoints = LittleEndian.getInt(data, offset + 24);
            BaseGraphic.RealPoints points = this.readPoints16(data, offset + 28, cntPoints);
            this.addBezierToPath(points);
        }

        private void selectObject(byte[] data, int offset) {
            int type = LittleEndian.getInt(data, offset);
            assert (type == 37 || type == 48);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size == 12);
            int obj = LittleEndian.getInt(data, offset + 8);
            DeviceContext ctx = this.globalObjects.get(obj);
            if (ctx == null) {
                ctx = DeviceContext.systemObjects.get(obj);
            }
            if (ctx != null) {
                this.dc.applyObject(ctx);
            }
        }

        private void deleteObject(byte[] data, int offset) {
            int type = LittleEndian.getInt(data, offset);
            assert (type == 40);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size == 12);
            int obj = LittleEndian.getInt(data, offset + 8);
            this.globalObjects.remove(obj);
        }

        private void createBrushInDirect(byte[] data, int offset) {
            int type = LittleEndian.getInt(data, offset);
            assert (type == 39);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size == 24);
            int objId = LittleEndian.getInt(data, offset + 8);
            int style = LittleEndian.getInt(data, offset + 12);
            Color color = this.readColor(data, offset + 16);
            int hatch = LittleEndian.getInt(data, offset + 20);
            this.globalObjects.put(objId, DeviceContext.createBrushObject(style, color, hatch));
        }

        private void createPen(byte[] data, int offset) {
            int type = LittleEndian.getInt(data, offset);
            assert (type == 38);
            int size = LittleEndian.getInt(data, offset + 4);
            assert (size == 28);
            int objId = LittleEndian.getInt(data, offset + 8);
            int style = LittleEndian.getInt(data, offset + 12);
            int width = LittleEndian.getInt(data, offset + 16);
            Color color = this.readColor(data, offset + 24);
            this.globalObjects.put(objId, DeviceContext.createPenObject(style, color, width));
        }

        public boolean parseEmf(GraphicBlock parent, byte[] data) {
            int size;
            if (!EmfReader.isEmf(data) || parent == null) {
                return false;
            }
            if (parent.Objects == null) {
                parent.Objects = new ArrayList();
            }
            block25: for (int offset = 0; offset < data.length; offset += size) {
                int type = LittleEndian.getInt(data, offset);
                size = LittleEndian.getInt(data, offset + 4);
                switch (type) {
                    case 1: {
                        continue block25;
                    }
                    case 86: {
                        this.parsePolygon16(parent, data, offset);
                        continue block25;
                    }
                    case 8: {
                        this.parsePolyPolygon(parent, data, offset);
                        continue block25;
                    }
                    case 91: {
                        this.parsePolyPolygon16(parent, data, offset);
                        continue block25;
                    }
                    case 59: {
                        this.currentPath.clear();
                        this.currentPaths.clear();
                        continue block25;
                    }
                    case 64: {
                        this.applyCurrentPaths(parent, false);
                        continue block25;
                    }
                    case 63: {
                        this.applyCurrentPaths(parent, true);
                        continue block25;
                    }
                    case 27: {
                        this.parseMoveToEx(data, offset);
                        continue block25;
                    }
                    case 54: {
                        this.parseLineTo(data, offset);
                        continue block25;
                    }
                    case 5: {
                        this.parsePolyBezierTo(data, offset);
                        continue block25;
                    }
                    case 88: {
                        this.parsePolyBezierTo16(data, offset);
                        continue block25;
                    }
                    case 37: 
                    case 48: {
                        this.selectObject(data, offset);
                        continue block25;
                    }
                    case 40: {
                        this.deleteObject(data, offset);
                        continue block25;
                    }
                    case 25: {
                        continue block25;
                    }
                    case 24: {
                        continue block25;
                    }
                    case 18: {
                        continue block25;
                    }
                    case 19: {
                        continue block25;
                    }
                    case 39: {
                        this.createBrushInDirect(data, offset);
                        continue block25;
                    }
                    case 38: {
                        this.createPen(data, offset);
                        continue block25;
                    }
                    case 95: {
                        continue block25;
                    }
                    case 13: {
                        continue block25;
                    }
                    case 81: {
                        this.parseStretchDIB(parent, data, offset);
                        continue block25;
                    }
                    case 84: {
                        this.parseExtTextOutW(parent, data, offset);
                        continue block25;
                    }
                }
            }
            if (this.phxImage != null) {
                parent.Objects.add(0, this.phxImage);
            }
            return !parent.Objects.isEmpty();
        }

        private boolean isClosedPath(double[] points) {
            assert (points != null);
            assert (points.length > 3);
            double tolerance = 1.0E-6;
            return SchemeUtils.isEqual(points[0], points[points.length - 2], tolerance) && SchemeUtils.isEqual(points[1], points[points.length - 1], tolerance);
        }

        private static void infoEmfFiles(String path) {
            File[] fileArray;
            File dir = new File(path);
            if (!dir.exists()) {
                return;
            }
            if (dir.isDirectory()) {
                fileArray = dir.listFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = dir;
            }
            File[] listFiles = fileArray;
            if (listFiles == null) {
                return;
            }
            HashMap<Integer, Integer> totals = new HashMap<Integer, Integer>();
            for (File f : listFiles) {
                if (f == null || !f.exists()) continue;
                String n = f.getName();
                System.out.println("======================================= " + n);
                try {
                    byte[] data = Files.readAllBytes(f.toPath());
                    Map<Integer, Integer> info = InnerEmfReader.infoEmf(data);
                    System.out.println("--------------------------------------- ");
                    if (info == null) continue;
                    for (Map.Entry<Integer, Integer> entry : info.entrySet()) {
                        Integer type = entry.getKey();
                        int cnt = entry.getValue();
                        System.out.println("            " + type + " [" + InnerEmfReader.getFunctionName(type) + "] : " + cnt);
                        int sum = cnt;
                        if (totals.containsKey(type)) {
                            sum += ((Integer)totals.get(type)).intValue();
                        }
                        totals.put(type, sum);
                    }
                }
                catch (IOException ex) {
                    Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 EMF", ex);
                }
            }
            System.out.println("*** TOTALS ***");
            for (Integer type : totals.keySet()) {
                System.out.println("   " + type + " [" + InnerEmfReader.getFunctionName(type) + "] : " + totals.get(type));
            }
        }

        private static String getFunctionName(int type) {
            if (type < 0 || type >= FUNCTION_NANES.length) {
                return "";
            }
            return FUNCTION_NANES[type];
        }

        private static Map<Integer, Integer> infoEmf(byte[] data) {
            if (!EmfReader.isEmf(data)) {
                return null;
            }
            HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
            int offset = 0;
            while (offset < data.length) {
                int o = offset;
                int type = LittleEndian.getInt(data, offset);
                int size = LittleEndian.getInt(data, offset + 4);
                byte[] params = size > 8 ? Arrays.copyOfRange(data, offset + 8, offset + size) : null;
                System.out.println("  offset=" + o + "  type=" + type + "  size=" + size + "  [ " + InnerEmfReader.getFunctionName(type) + " ]  params: " + CryptoUtils.bytesToHex(params, ','));
                offset += size;
                int cnt = 0;
                if (result.containsKey(type)) {
                    cnt = (Integer)result.get(type);
                }
                result.put(type, cnt + 1);
            }
            if (offset != data.length) {
                throw new InformException(" ERROR (offset != data.length)    offset=" + offset + "  data.length=" + data.length);
            }
            return result;
        }

        static {
            InnerEmfReader.FUNCTION_NANES[1] = "EMR_HEADER";
            InnerEmfReader.FUNCTION_NANES[2] = "EMR_POLYBEZIER";
            InnerEmfReader.FUNCTION_NANES[3] = "EMR_POLYGON";
            InnerEmfReader.FUNCTION_NANES[4] = "EMR_POLYLINE";
            InnerEmfReader.FUNCTION_NANES[5] = "EMR_POLYBEZIERTO";
            InnerEmfReader.FUNCTION_NANES[6] = "EMR_POLYLINETO";
            InnerEmfReader.FUNCTION_NANES[7] = "EMR_POLYPOLYLINE";
            InnerEmfReader.FUNCTION_NANES[8] = "EMR_POLYPOLYGON";
            InnerEmfReader.FUNCTION_NANES[9] = "EMR_SETWINDOWEXTEX";
            InnerEmfReader.FUNCTION_NANES[10] = "EMR_SETWINDOWORGEX";
            InnerEmfReader.FUNCTION_NANES[11] = "EMR_SETVIEWPORTEXTEX";
            InnerEmfReader.FUNCTION_NANES[12] = "EMR_SETVIEWPORTORGEX";
            InnerEmfReader.FUNCTION_NANES[13] = "EMR_SETBRUSHORGEX";
            InnerEmfReader.FUNCTION_NANES[14] = "EMR_EOF";
            InnerEmfReader.FUNCTION_NANES[15] = "EMR_SETPIXELV";
            InnerEmfReader.FUNCTION_NANES[16] = "EMR_SETMAPPERFLAGS";
            InnerEmfReader.FUNCTION_NANES[17] = "EMR_SETMAPMODE";
            InnerEmfReader.FUNCTION_NANES[18] = "EMR_SETBKMODE";
            InnerEmfReader.FUNCTION_NANES[19] = "EMR_SETPOLYFILLMODE";
            InnerEmfReader.FUNCTION_NANES[20] = "EMR_SETROP2";
            InnerEmfReader.FUNCTION_NANES[21] = "EMR_SETSTRETCHBLTMODE";
            InnerEmfReader.FUNCTION_NANES[22] = "EMR_SETTEXTALIGN";
            InnerEmfReader.FUNCTION_NANES[23] = "EMR_SETCOLORADJUSTMENT";
            InnerEmfReader.FUNCTION_NANES[24] = "EMR_SETTEXTCOLOR";
            InnerEmfReader.FUNCTION_NANES[25] = "EMR_SETBKCOLOR";
            InnerEmfReader.FUNCTION_NANES[26] = "EMR_OFFSETCLIPRGN";
            InnerEmfReader.FUNCTION_NANES[27] = "EMR_MOVETOEX";
            InnerEmfReader.FUNCTION_NANES[28] = "EMR_SETMETARGN";
            InnerEmfReader.FUNCTION_NANES[29] = "EMR_EXCLUDECLIPRECT";
            InnerEmfReader.FUNCTION_NANES[30] = "EMR_INTERSECTCLIPRECT";
            InnerEmfReader.FUNCTION_NANES[31] = "EMR_SCALEVIEWPORTEXTEX";
            InnerEmfReader.FUNCTION_NANES[32] = "EMR_SCALEWINDOWEXTEX";
            InnerEmfReader.FUNCTION_NANES[33] = "EMR_SAVEDC";
            InnerEmfReader.FUNCTION_NANES[34] = "EMR_RESTOREDC";
            InnerEmfReader.FUNCTION_NANES[35] = "EMR_SETWORLDTRANSFORM";
            InnerEmfReader.FUNCTION_NANES[36] = "EMR_MODIFYWORLDTRANSFORM";
            InnerEmfReader.FUNCTION_NANES[37] = "EMR_SELECTOBJECT";
            InnerEmfReader.FUNCTION_NANES[38] = "EMR_CREATEPEN";
            InnerEmfReader.FUNCTION_NANES[39] = "EMR_CREATEBRUSHINDIRECT";
            InnerEmfReader.FUNCTION_NANES[40] = "EMR_DELETEOBJECT";
            InnerEmfReader.FUNCTION_NANES[41] = "EMR_ANGLEARC";
            InnerEmfReader.FUNCTION_NANES[42] = "EMR_ELLIPSE";
            InnerEmfReader.FUNCTION_NANES[43] = "EMR_RECTANGLE";
            InnerEmfReader.FUNCTION_NANES[44] = "EMR_ROUNDRECT";
            InnerEmfReader.FUNCTION_NANES[45] = "EMR_ARC";
            InnerEmfReader.FUNCTION_NANES[46] = "EMR_CHORD";
            InnerEmfReader.FUNCTION_NANES[47] = "EMR_PIE";
            InnerEmfReader.FUNCTION_NANES[48] = "EMR_SELECTPALETTE";
            InnerEmfReader.FUNCTION_NANES[49] = "EMR_CREATEPALETTE";
            InnerEmfReader.FUNCTION_NANES[50] = "EMR_SETPALETTEENTRIES";
            InnerEmfReader.FUNCTION_NANES[51] = "EMR_RESIZEPALETTE";
            InnerEmfReader.FUNCTION_NANES[52] = "EMR_REALIZEPALETTE";
            InnerEmfReader.FUNCTION_NANES[53] = "EMR_EXTFLOODFILL";
            InnerEmfReader.FUNCTION_NANES[54] = "EMR_LINETO";
            InnerEmfReader.FUNCTION_NANES[55] = "EMR_ARCTO";
            InnerEmfReader.FUNCTION_NANES[56] = "EMR_POLYDRAW";
            InnerEmfReader.FUNCTION_NANES[57] = "EMR_SETARCDIRECTION";
            InnerEmfReader.FUNCTION_NANES[58] = "EMR_SETMITERLIMIT";
            InnerEmfReader.FUNCTION_NANES[59] = "EMR_BEGINPATH";
            InnerEmfReader.FUNCTION_NANES[60] = "EMR_ENDPATH";
            InnerEmfReader.FUNCTION_NANES[61] = "EMR_CLOSEFIGURE";
            InnerEmfReader.FUNCTION_NANES[62] = "EMR_FILLPATH";
            InnerEmfReader.FUNCTION_NANES[63] = "EMR_STROKEANDFILLPATH";
            InnerEmfReader.FUNCTION_NANES[64] = "EMR_STROKEPATH";
            InnerEmfReader.FUNCTION_NANES[65] = "EMR_FLATTENPATH";
            InnerEmfReader.FUNCTION_NANES[66] = "EMR_WIDENPATH";
            InnerEmfReader.FUNCTION_NANES[67] = "EMR_SELECTCLIPPATH";
            InnerEmfReader.FUNCTION_NANES[68] = "EMR_ABORTPATH";
            InnerEmfReader.FUNCTION_NANES[69] = "";
            InnerEmfReader.FUNCTION_NANES[70] = "EMR_GDICOMMENT";
            InnerEmfReader.FUNCTION_NANES[71] = "EMR_FILLRGN";
            InnerEmfReader.FUNCTION_NANES[72] = "EMR_FRAMERGN";
            InnerEmfReader.FUNCTION_NANES[73] = "EMR_INVERTRGN";
            InnerEmfReader.FUNCTION_NANES[74] = "EMR_PAINTRGN";
            InnerEmfReader.FUNCTION_NANES[75] = "EMR_EXTSELECTCLIPRGN";
            InnerEmfReader.FUNCTION_NANES[76] = "EMR_BITBLT";
            InnerEmfReader.FUNCTION_NANES[77] = "EMR_STRETCHBLT";
            InnerEmfReader.FUNCTION_NANES[78] = "EMR_MASKBLT";
            InnerEmfReader.FUNCTION_NANES[79] = "EMR_PLGBLT";
            InnerEmfReader.FUNCTION_NANES[80] = "EMR_SETDIBITSTODEVICE";
            InnerEmfReader.FUNCTION_NANES[81] = "EMR_STRETCHDIBITS";
            InnerEmfReader.FUNCTION_NANES[82] = "EMR_EXTCREATEFONTINDIRECTW";
            InnerEmfReader.FUNCTION_NANES[83] = "EMR_EXTTEXTOUTA";
            InnerEmfReader.FUNCTION_NANES[84] = "EMR_EXTTEXTOUTW";
            InnerEmfReader.FUNCTION_NANES[85] = "EMR_POLYBEZIER16";
            InnerEmfReader.FUNCTION_NANES[86] = "EMR_POLYGON16";
            InnerEmfReader.FUNCTION_NANES[87] = "EMR_POLYLINE16";
            InnerEmfReader.FUNCTION_NANES[88] = "EMR_POLYBEZIERTO16";
            InnerEmfReader.FUNCTION_NANES[89] = "EMR_POLYLINETO16";
            InnerEmfReader.FUNCTION_NANES[90] = "EMR_POLYPOLYLINE16";
            InnerEmfReader.FUNCTION_NANES[91] = "EMR_POLYPOLYGON16";
            InnerEmfReader.FUNCTION_NANES[92] = "EMR_POLYDRAW16";
            InnerEmfReader.FUNCTION_NANES[93] = "EMR_CREATEMONOBRUSH";
            InnerEmfReader.FUNCTION_NANES[94] = "EMR_CREATEDIBPATTERNBRUSHPT";
            InnerEmfReader.FUNCTION_NANES[95] = "EMR_EXTCREATEPEN";
            InnerEmfReader.FUNCTION_NANES[96] = "EMR_POLYTEXTOUTA";
            InnerEmfReader.FUNCTION_NANES[97] = "EMR_POLYTEXTOUTW";
            InnerEmfReader.FUNCTION_NANES[98] = "EMR_SETICMMODE";
            InnerEmfReader.FUNCTION_NANES[99] = "EMR_CREATECOLORSPACE";
            InnerEmfReader.FUNCTION_NANES[100] = "EMR_SETCOLORSPACE";
            InnerEmfReader.FUNCTION_NANES[101] = "EMR_DELETECOLORSPACE";
            InnerEmfReader.FUNCTION_NANES[102] = "EMR_GLSRECORD";
            InnerEmfReader.FUNCTION_NANES[103] = "EMR_GLSBOUNDEDRECORD";
            InnerEmfReader.FUNCTION_NANES[104] = "EMR_PIXELFORMAT";
            InnerEmfReader.FUNCTION_NANES[105] = "EMR_DRAWESCAPE";
            InnerEmfReader.FUNCTION_NANES[106] = "EMR_EXTESCAPE";
            InnerEmfReader.FUNCTION_NANES[107] = "";
            InnerEmfReader.FUNCTION_NANES[108] = "EMR_SMALLTEXTOUT";
            InnerEmfReader.FUNCTION_NANES[109] = "EMR_FORCEUFIMAPPING";
            InnerEmfReader.FUNCTION_NANES[110] = "EMR_NAMEDESCAPE";
            InnerEmfReader.FUNCTION_NANES[111] = "EMR_COLORCORRECTPALETTE";
            InnerEmfReader.FUNCTION_NANES[112] = "EMR_SETICMPROFILEA";
            InnerEmfReader.FUNCTION_NANES[113] = "EMR_SETICMPROFILEW";
            InnerEmfReader.FUNCTION_NANES[114] = "EMR_ALPHABLEND";
            InnerEmfReader.FUNCTION_NANES[115] = "EMR_SETLAYOUT";
            InnerEmfReader.FUNCTION_NANES[116] = "EMR_TRANSPARENTBLT";
            InnerEmfReader.FUNCTION_NANES[117] = "";
            InnerEmfReader.FUNCTION_NANES[118] = "EMR_GRADIENTFILL";
            InnerEmfReader.FUNCTION_NANES[119] = "EMR_SETLINKEDUFIS";
            InnerEmfReader.FUNCTION_NANES[120] = "EMR_SETTEXTJUSTIFICATION";
            InnerEmfReader.FUNCTION_NANES[121] = "EMR_COLORMATCHTOTARGETW";
            InnerEmfReader.FUNCTION_NANES[122] = "EMR_CREATECOLORSPACEW";
        }

        private static class DeviceContext {
            private static final Map<Integer, DeviceContext> systemObjects = new HashMap<Integer, DeviceContext>();
            private final ObjectType type;
            Color brushColor = Color.white;
            int brushStyle = 1;
            int brushHatch;
            Color penColor = Color.black;
            int penStyle = 5;
            int penWidth;

            private DeviceContext(ObjectType type) {
                this.type = type;
            }

            DeviceContext() {
                this(ObjectType.ALL);
            }

            static DeviceContext createBrushObject(int style, Color color, int hatch) {
                DeviceContext ctx = new DeviceContext(ObjectType.BRUSH);
                ctx.applyBrush(style, color, hatch);
                return ctx;
            }

            static DeviceContext createPenObject(int style, Color color, int width) {
                DeviceContext ctx = new DeviceContext(ObjectType.PEN);
                ctx.applyPen(style, color, width);
                return ctx;
            }

            private void applyBrush(int style, Color color, int hatch) {
                this.brushStyle = style;
                this.brushColor = color;
                this.brushHatch = hatch;
            }

            private void applyPen(int style, Color color, int width) {
                this.penStyle = style;
                this.penColor = color;
                this.penWidth = width;
            }

            private void applyObject(DeviceContext ctx) {
                if (ctx == null) {
                    return;
                }
                switch (ctx.type) {
                    case ALL: {
                        this.applyBrush(ctx.brushStyle, ctx.brushColor, ctx.brushHatch);
                        this.applyPen(ctx.penStyle, ctx.penColor, ctx.penWidth);
                        break;
                    }
                    case BRUSH: {
                        this.applyBrush(ctx.brushStyle, ctx.brushColor, ctx.brushHatch);
                        break;
                    }
                    case PEN: {
                        this.applyPen(ctx.penStyle, ctx.penColor, ctx.penWidth);
                    }
                }
            }

            static {
                systemObjects.put(Integer.MIN_VALUE, DeviceContext.createBrushObject(0, Color.white, 0));
                systemObjects.put(-2147483647, DeviceContext.createBrushObject(0, Color.lightGray, 0));
                systemObjects.put(-2147483646, DeviceContext.createBrushObject(0, Color.gray, 0));
                systemObjects.put(-2147483645, DeviceContext.createBrushObject(0, Color.darkGray, 0));
                systemObjects.put(-2147483644, DeviceContext.createBrushObject(0, Color.black, 0));
                systemObjects.put(-2147483643, DeviceContext.createBrushObject(0, null, 0));
                systemObjects.put(-2147483642, DeviceContext.createPenObject(0, Color.white, 0));
                systemObjects.put(-2147483641, DeviceContext.createPenObject(0, Color.black, 0));
                systemObjects.put(-2147483640, DeviceContext.createPenObject(5, null, 0));
            }

            private static enum ObjectType {
                ALL,
                BRUSH,
                PEN;

            }
        }
    }

    private static class HemfPictureFix
    extends HemfPicture {
        HemfPictureFix(InputStream is) {
            super(is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics2D ctx, Rectangle2D graphicsBounds) {
            Shape clip = ctx.getClip();
            AffineTransform at = ctx.getTransform();
            try {
                Rectangle2D b;
                Rectangle2D emfBounds = this.getHeader().getBoundsRectangle();
                ReluctantRectangle2D winBounds = new ReluctantRectangle2D();
                ReluctantRectangle2D viewBounds = new ReluctantRectangle2D();
                Rectangle2D.Double recBounds = new Rectangle2D.Double();
                this.getInnerBounds(winBounds, viewBounds, recBounds);
                Boolean forceHeader = (Boolean)ctx.getRenderingHint((RenderingHints.Key)Drawable.EMF_FORCE_HEADER_BOUNDS);
                if (forceHeader == null) {
                    forceHeader = false;
                }
                if (forceHeader.booleanValue()) {
                    b = emfBounds;
                } else if (((RectangularShape)recBounds).isEmpty()) {
                    b = !((RectangularShape)viewBounds).isEmpty() ? viewBounds : (!((RectangularShape)winBounds).isEmpty() ? winBounds : emfBounds);
                } else {
                    Optional<Rectangle2D> result = Stream.of(emfBounds, winBounds, viewBounds).min(Comparator.comparingDouble(r -> EmfReader.diff(r, recBounds)));
                    if (result.isPresent()) {
                        b = result.get();
                    } else {
                        throw new IllegalStateException("Failed to create Rectangle2D for drawing");
                    }
                }
                ctx.translate(graphicsBounds.getCenterX(), graphicsBounds.getCenterY());
                ctx.scale(graphicsBounds.getWidth() / b.getWidth(), graphicsBounds.getHeight() / b.getHeight());
                ctx.translate(-b.getCenterX(), -b.getCenterY());
                HemfGraphics g = new HemfGraphics(ctx, b);
                int idx = 0;
                for (HemfRecord r2 : this.getRecords()) {
                    try {
                        HemfMisc.EmfSetMapMode setMapMode;
                        HwmfMapMode mapMode;
                        if (r2 instanceof HemfMisc.EmfSetMapMode && (mapMode = (setMapMode = (HemfMisc.EmfSetMapMode)r2).getMapMode()) == HwmfMapMode.MM_ISOTROPIC) continue;
                        if (r2 instanceof HemfFill.EmfAlphaBlend) {
                            HemfDrawProperties prop = g.getProperties();
                            Map map = ((HemfFill.EmfAlphaBlend)r2).getGenericProperties();
                            Supplier f = (Supplier)map.get("bitmap");
                            Object obj = f == null ? null : f.get();
                            HwmfBitmapDib bitmap = obj instanceof HwmfBitmapDib ? (HwmfBitmapDib)obj : null;
                            f = (Supplier)map.get("destRect");
                            obj = f == null ? null : f.get();
                            Rectangle2D dstBounds = obj instanceof Rectangle2D ? (Rectangle2D)obj : null;
                            f = (Supplier)map.get("srcRect");
                            obj = f == null ? null : f.get();
                            Rectangle2D srcBounds = obj instanceof Rectangle2D ? (Rectangle2D)obj : null;
                            prop.setRasterOp3(HwmfTernaryRasterOp.SRCAND);
                            if (bitmap != null && bitmap.isValid()) {
                                BufferedImage bi = bitmap.getImage(prop.getPenColor().getColor(), prop.getBackgroundColor().getColor(), prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.TRANSPARENT);
                                g.drawImage(bi, srcBounds, dstBounds);
                            } else if (dstBounds != null && !dstBounds.isEmpty()) {
                                g.drawImage((ImageRenderer)null, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), dstBounds);
                            }
                        } else {
                            g.draw(r2);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    ++idx;
                }
            }
            finally {
                ctx.setTransform(at);
                ctx.setClip(clip);
            }
        }

        private static class ReluctantRectangle2D
        extends Rectangle2D.Double {
            private boolean offsetSet = false;
            private boolean rangeSet = false;

            public ReluctantRectangle2D() {
                super(-1.0, -1.0, 0.0, 0.0);
            }

            @Override
            public void setRect(double x, double y, double w, double h) {
                if (this.offsetSet && this.rangeSet) {
                    return;
                }
                super.setRect(this.offsetSet ? this.x : x, this.offsetSet ? this.y : y, this.rangeSet ? this.width : w, this.rangeSet ? this.height : h);
                this.offsetSet |= x != -1.0 || y != -1.0;
                this.rangeSet |= w != 0.0 || h != 0.0;
            }

            @Override
            public boolean isEmpty() {
                return ReluctantRectangle2D.isEmpty(this);
            }

            public static boolean isEmpty(Rectangle2D r) {
                double w = Math.rint(r.getWidth());
                double h = Math.rint(r.getHeight());
                return w <= 0.0 || h <= 0.0 || r.getX() == -1.0 && r.getY() == -1.0 || w == 1.0 && h == 1.0;
            }
        }
    }

    private static class HwmfPictureFix
    extends HwmfPicture {
        public HwmfPictureFix(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public Rectangle2D getInnnerBounds() {
            Rectangle2D rect = super.getInnnerBounds();
            if (rect != null) {
                return rect;
            }
            HwmfWindowing.WmfSetWindowOrg wOrg = null;
            HwmfWindowing.WmfSetWindowExt wExt = null;
            for (HwmfRecord r : this.getRecords()) {
                if (r instanceof HwmfWindowing.WmfSetWindowOrg) {
                    wOrg = (HwmfWindowing.WmfSetWindowOrg)r;
                } else if (r instanceof HwmfWindowing.WmfSetWindowExt) {
                    wExt = (HwmfWindowing.WmfSetWindowExt)r;
                }
                if (wExt == null) continue;
                return new Rectangle2D.Double(wOrg == null ? 0.0 : wOrg.getX(), wOrg == null ? 0.0 : wOrg.getY(), wExt.getSize().getWidth(), wExt.getSize().getHeight());
            }
            return null;
        }
    }
}

