/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxAction {
    private String name;
    private String menu;
    private String actionValue;
    private String actionFormula;
    private String checked;
    private String checkedFormula;
    private String disabled;
    private String readOnly;
    private String invisible;
    private String invisibleFormula;

    public VsdxAction() {
    }

    public VsdxAction(Element contents) {
        this.name = contents.getAttribute("N");
        NodeList cells = contents.getChildNodes();
        block16: for (int i = 0; i < cells.getLength(); ++i) {
            Element cell;
            if (cells.item(i).getNodeType() != 1 || !(cell = (Element)cells.item(i)).hasAttribute("V")) continue;
            String value = cell.getAttribute("V");
            switch (cell.getAttribute("N")) {
                case "Menu": {
                    this.menu = value;
                    continue block16;
                }
                case "Action": {
                    this.actionValue = value;
                    this.actionFormula = VsdxUtils.validateFunction(cell.getAttribute("F"));
                    continue block16;
                }
                case "Checked": {
                    this.checked = value;
                    this.checkedFormula = VsdxUtils.validateFunction(cell.getAttribute("F"));
                    continue block16;
                }
                case "Disabled": {
                    this.disabled = value;
                    continue block16;
                }
                case "ReadOnly": {
                    continue block16;
                }
                case "Invisible": {
                    this.invisible = value;
                    this.invisibleFormula = VsdxUtils.validateFunction(cell.getAttribute("F"));
                }
            }
        }
    }

    public void applyProperties(VsdxAction action) {
        if (action == null) {
            return;
        }
        if (action.name != null) {
            this.name = action.name;
        }
        if (action.menu != null) {
            this.menu = action.menu;
        }
        if (action.actionValue != null) {
            this.actionValue = action.actionValue;
        }
        if (action.actionFormula != null) {
            this.actionFormula = action.actionFormula;
        }
        if (action.checked != null) {
            this.checked = action.checked;
        }
        if (action.checkedFormula != null) {
            this.checkedFormula = action.checkedFormula;
        }
        if (action.disabled != null) {
            this.disabled = action.disabled;
        }
        if (action.readOnly != null) {
            this.readOnly = action.readOnly;
        }
        if (action.invisible != null) {
            this.invisible = action.invisible;
        }
        if (action.invisibleFormula != null) {
            this.invisibleFormula = action.invisibleFormula;
        }
    }

    public String getActionFormula() {
        return this.actionFormula;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public String getCheckedFormula() {
        return this.checkedFormula;
    }

    public String getName() {
        return this.name;
    }

    public boolean doesAffectProperties() {
        return this.doesFormulaAffectShapeProperties(this.actionFormula) || this.doesFormulaAffectShapeProperties(this.checkedFormula) || this.doesFormulaAffectShapeProperties(this.invisibleFormula);
    }

    private boolean doesFormulaAffectShapeProperties(String formula) {
        int outerPropsCount;
        if (formula == null) {
            return false;
        }
        int propsCount = formula.toLowerCase().split("prop.").length - 1;
        return propsCount - (outerPropsCount = formula.toLowerCase().split("!prop.").length - 1) > 0;
    }

    public String getMenu() {
        return this.menu;
    }

    public String getChecked() {
        return this.checked;
    }

    public boolean isEnabled() {
        return !"1".equals(this.disabled);
    }

    public boolean isVisible() {
        return !"1".equals(this.invisible);
    }

    public boolean isGroup() {
        return "No Formula".equals(this.actionFormula);
    }
}

